/*
 * Decompiled with CFR 0.152.
 */
package io.github.strikerrocker.vt.tweaks;

import io.github.strikerrocker.vt.base.Feature;
import java.util.Random;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.monster.CreeperEntity;
import net.minecraft.entity.monster.ZombieEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class MobsBurnInDaylight
extends Feature {
    private ForgeConfigSpec.BooleanValue babyZombieBurnInDaylight;
    private ForgeConfigSpec.BooleanValue creeperBurnInDaylight;

    @Override
    public void setupConfig(ForgeConfigSpec.Builder builder) {
        this.babyZombieBurnInDaylight = builder.translation("config.vanillatweaks:babyZombieBurnInDaylight").comment("Want baby zombies to burn by the light of the day?").define("babyZombieBurnInDaylight", true);
        this.creeperBurnInDaylight = builder.translation("config.vanillatweaks:creeperBurnInDaylight").comment("Want creeper's to burn in daylight?").define("creeperBurnInDaylight", true);
    }

    @Override
    public boolean usesEvents() {
        return true;
    }

    @SubscribeEvent
    public void onLivingUpdate(LivingEvent.LivingUpdateEvent event) {
        LivingEntity livingEntity = event.getEntityLiving();
        if (!livingEntity.field_70170_p.field_72995_K) {
            World world = livingEntity.field_70170_p;
            if ((livingEntity instanceof CreeperEntity && ((Boolean)this.creeperBurnInDaylight.get()).booleanValue() || livingEntity instanceof ZombieEntity && livingEntity.func_70631_g_() && ((Boolean)this.babyZombieBurnInDaylight.get()).booleanValue()) && world.func_72935_r()) {
                float brightness = livingEntity.func_70013_c();
                Random random = world.field_73012_v;
                BlockPos blockPos = new BlockPos(livingEntity.field_70165_t, (double)Math.round(livingEntity.field_70163_u), livingEntity.field_70161_v);
                if ((double)brightness > 0.5 && (double)(random.nextFloat() * 30.0f) < ((double)brightness - 0.4) * 2.0 && world.func_175710_j(blockPos)) {
                    ItemStack itemstack = livingEntity.func_184582_a(EquipmentSlotType.HEAD);
                    boolean setFire = true;
                    if (!itemstack.func_190926_b()) {
                        setFire = true;
                        if (itemstack.func_77984_f()) {
                            itemstack.func_196085_b(itemstack.func_77952_i() + random.nextInt(2));
                            if (itemstack.func_77952_i() >= itemstack.func_77958_k()) {
                                livingEntity.func_184201_a(EquipmentSlotType.HEAD, ItemStack.field_190927_a);
                            }
                        }
                    }
                    if (setFire) {
                        livingEntity.func_70015_d(10);
                    }
                }
            }
        }
    }
}

