/*
 * Decompiled with CFR 0.152.
 */
package io.github.strikerrocker.vt.tweaks;

import io.github.strikerrocker.vt.base.Feature;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.BushBlock;
import net.minecraft.block.LilyPadBlock;
import net.minecraft.block.SugarCaneBlock;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.HoeItem;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class Sickle
extends Feature {
    private ForgeConfigSpec.BooleanValue hoeActsAsSickle;

    private static boolean canHarvest(BlockState state) {
        Block block = state.func_177230_c();
        return block instanceof BushBlock && !(block instanceof LilyPadBlock) || block instanceof SugarCaneBlock;
    }

    @Override
    public void setupConfig(ForgeConfigSpec.Builder builder) {
        this.hoeActsAsSickle = builder.translation("config.vanillatweaks:hoeActsAsSickle").comment("Want hoe to act like a sickle?").define("hoeActsAsSickle", true);
    }

    @Override
    public boolean usesEvents() {
        return true;
    }

    @SubscribeEvent
    public void onBlockBreak(BlockEvent.BreakEvent event) {
        PlayerEntity player = event.getPlayer();
        World world = player.func_130014_f_();
        ItemStack stack = player.func_184614_ca();
        if (!stack.func_190926_b() && stack.func_77973_b() instanceof HoeItem && Sickle.canHarvest(event.getState()) && ((Boolean)this.hoeActsAsSickle.get()).booleanValue()) {
            int range = 1;
            if (stack.func_77973_b() == Items.field_151012_L) {
                ++range;
            }
            for (int i = -range; i < range + 1; ++i) {
                for (int k = -range; k < range + 1; ++k) {
                    BlockPos pos;
                    BlockState state;
                    if (i == 0 && k == 0 || !Sickle.canHarvest(state = world.func_180495_p(pos = event.getPos().func_177982_a(i, 0, k)))) continue;
                    Block block = state.func_177230_c();
                    if (block.canHarvestBlock(state, (IBlockReader)world, pos, player)) {
                        block.func_180657_a(world, player, pos, state, world.func_175625_s(pos), stack);
                    }
                    world.func_175656_a(pos, Blocks.field_150350_a.func_176223_P());
                    world.func_184133_a(player, player.func_180425_c(), state.getSoundType((IWorldReader)world, pos, (Entity)player).func_185845_c(), SoundCategory.BLOCKS, 1.0f, 1.0f);
                }
            }
            stack.func_222118_a(1, (LivingEntity)player, playerEntity -> playerEntity.func_213334_d(playerEntity.func_184600_cs()));
        }
    }
}

