/*
 * Decompiled with CFR 0.152.
 */
package io.github.strikerrocker.vt.tweaks;

import io.github.strikerrocker.vt.base.Feature;
import net.minecraft.block.Blocks;
import net.minecraft.block.WetSpongeBlock;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.Fluids;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class SquishySponges
extends Feature {
    private ForgeConfigSpec.BooleanValue squishySponge;

    private static void turnIntoWater(World worldIn, BlockPos pos) {
        if (worldIn.field_73011_w.func_177500_n()) {
            worldIn.func_175656_a(pos, Blocks.field_150350_a.func_176223_P());
        } else {
            worldIn.func_180501_a(pos, Fluids.field_204546_a.func_207188_f().func_206883_i(), 11);
        }
    }

    @Override
    public boolean usesEvents() {
        return true;
    }

    @Override
    public void setupConfig(ForgeConfigSpec.Builder builder) {
        this.squishySponge = builder.translation("config.vanillatweaks:squishySponge").comment("Do you want to neglect fall damage and get water spilled when you fall on a wet sponge?").define("squishySponge", true);
    }

    @SubscribeEvent
    public void onLivingFall(LivingFallEvent event) {
        World world = event.getEntity().func_130014_f_();
        LivingEntity entity = event.getEntityLiving();
        BlockPos pos = entity.func_180425_c().func_177977_b();
        if (entity instanceof PlayerEntity && ((Boolean)this.squishySponge.get()).booleanValue() && world.func_180495_p(pos).func_177230_c() instanceof WetSpongeBlock) {
            SquishySponges.turnIntoWater(world, pos.func_177972_a(Direction.Plane.HORIZONTAL.func_179518_a(world.field_73012_v)));
            world.func_175656_a(pos, Blocks.field_150360_v.func_176223_P());
            event.setCanceled(true);
        }
    }
}

