/*
 * Decompiled with CFR 0.152.
 */
package io.github.strikerrocker.vt.tweaks.sit;

import io.github.strikerrocker.vt.base.Feature;
import io.github.strikerrocker.vt.tweaks.sit.SitEntity;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.SlabBlock;
import net.minecraft.block.StairsBlock;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntityType;
import net.minecraft.state.IProperty;
import net.minecraft.state.properties.Half;
import net.minecraft.state.properties.SlabType;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.entity.EntityMountEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ObjectHolder;

public class Sit
extends Feature {
    @ObjectHolder(value="vanillatweaks:entity_sit")
    public static final EntityType<SitEntity> SIT_ENTITY_TYPE = null;
    private ForgeConfigSpec.BooleanValue enableSit;

    @Override
    public void setupConfig(ForgeConfigSpec.Builder builder) {
        this.enableSit = builder.translation("config.vanillatweaks:enableSit").comment("Want to be able to sit on slabs and stairs?").define("enableSit", true);
    }

    @Override
    public boolean usesEvents() {
        return true;
    }

    @SubscribeEvent
    public void onRightClickBlock(PlayerInteractEvent.RightClickBlock event) {
        if (!event.getWorld().field_72995_K && ((Boolean)this.enableSit.get()).booleanValue()) {
            World world = event.getWorld();
            BlockPos pos = event.getPos();
            BlockState state = world.func_180495_p(pos);
            Block block = world.func_180495_p(pos).func_177230_c();
            BlockState blockAbove = world.func_180495_p(pos.func_177984_a());
            if ((block instanceof SlabBlock || block instanceof StairsBlock) && !SitEntity.OCCUPIED.containsKey(pos) && event.getPlayer().func_184614_ca().func_190926_b()) {
                if (!blockAbove.func_177230_c().isAir(blockAbove, (IBlockReader)world, pos.func_177984_a())) {
                    return;
                }
                if (block instanceof SlabBlock && (!state.func_196959_b((IProperty)SlabBlock.field_196505_a) || state.func_177229_b((IProperty)SlabBlock.field_196505_a) != SlabType.BOTTOM)) {
                    return;
                }
                if (block instanceof StairsBlock && (!state.func_196959_b((IProperty)StairsBlock.field_176308_b) || state.func_177229_b((IProperty)StairsBlock.field_176308_b) != Half.BOTTOM)) {
                    return;
                }
                SitEntity sit = new SitEntity(world, pos);
                world.func_217376_c((Entity)sit);
                event.getPlayer().func_184220_m((Entity)sit);
            }
        }
    }

    @SubscribeEvent
    public void onEntityMount(EntityMountEvent event) {
        Entity entity;
        if (event.isDismounting() && (entity = event.getEntityBeingMounted()) instanceof SitEntity) {
            entity.func_70106_y();
            SitEntity.OCCUPIED.remove(entity.func_180425_c());
        }
    }

    @SubscribeEvent
    public void onBlockBreak(BlockEvent.BreakEvent event) {
        if (SitEntity.OCCUPIED.containsKey(event.getPos())) {
            SitEntity.OCCUPIED.get(event.getPos()).func_70106_y();
            SitEntity.OCCUPIED.remove(event.getPos());
        }
    }

    @Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
    public static class RegistryEvents {
        @SubscribeEvent
        public static void registerEntities(RegistryEvent.Register<EntityType<?>> event) {
            event.getRegistry().register(EntityType.Builder.func_220322_a(SitEntity::new, (EntityClassification)EntityClassification.MISC).setCustomClientFactory((spawnEntity, world) -> (SitEntity)SIT_ENTITY_TYPE.func_200721_a(world)).setTrackingRange(256).setUpdateInterval(20).func_220321_a(1.0E-4f, 1.0E-4f).func_206830_a("vanillatweaks:entity_sit").setRegistryName(new ResourceLocation("vanillatweaks", "entity_sit")));
        }
    }
}

