/*
 * Decompiled with CFR 0.152.
 */
package io.github.strikerrocker.vt.world.selfplanting;

import io.github.strikerrocker.vt.VanillaTweaks;
import io.github.strikerrocker.vt.base.Feature;
import io.github.strikerrocker.vt.world.selfplanting.ISelfPlanting;
import io.github.strikerrocker.vt.world.selfplanting.SelfPlanting;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.Direction;
import net.minecraft.util.EntityPredicates;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class CapabilitySelfPlanting
extends Feature {
    private static final LazyOptional<ISelfPlanting> holder = LazyOptional.of(SelfPlanting::new);
    @CapabilityInject(value=ISelfPlanting.class)
    private static Capability<ISelfPlanting> CAPABILITY_PLANTING = null;
    private ForgeConfigSpec.BooleanValue selfPlanting;

    @Override
    public boolean usesEvents() {
        return true;
    }

    @Override
    public void setupConfig(ForgeConfigSpec.Builder builder) {
        this.selfPlanting = builder.translation("config.vanillatweaks:selfPlanting").comment("Want seeds to auto-plant themselves when broken?").define("selfPlanting", true);
    }

    @Override
    public void setup() {
        VanillaTweaks.LOGGER.info("Registering self planting capability");
        CapabilityManager.INSTANCE.register(ISelfPlanting.class, (Capability.IStorage)new Capability.IStorage<ISelfPlanting>(){

            public INBT writeNBT(Capability<ISelfPlanting> capability, ISelfPlanting instance, Direction side) {
                CompoundNBT compound = new CompoundNBT();
                compound.func_74768_a("MinSteadyTicks", instance.getMinSteadyTicks());
                compound.func_74768_a("SteadyTicks", instance.getSteadyTicks());
                return compound;
            }

            public void readNBT(Capability<ISelfPlanting> capability, ISelfPlanting instance, Direction side, INBT nbt) {
                CompoundNBT compound = (CompoundNBT)nbt;
                instance.setMinSteadyTicks(compound.func_74762_e("MinSteadyTicks"));
                instance.setSteadyTicks(compound.func_74762_e("SteadyTicks"));
            }
        }, SelfPlanting::new);
    }

    @SubscribeEvent
    public void attachCapabilityEntity(AttachCapabilitiesEvent<Entity> event) {
        if (event.getObject() instanceof ItemEntity) {
            event.addCapability(new ResourceLocation("vanillatweaks", "planting"), new ICapabilityProvider(){

                @Nonnull
                public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
                    return CAPABILITY_PLANTING.orEmpty(cap, holder);
                }
            });
        }
    }

    @SubscribeEvent
    public void onWorldTick(TickEvent.WorldTickEvent event) {
        if (((Boolean)this.selfPlanting.get()).booleanValue() && !event.world.func_201670_d()) {
            ServerWorld world = (ServerWorld)event.world;
            for (Entity entity : world.func_217482_a(EntityType.field_200765_E, EntityPredicates.field_94557_a)) {
                entity.getCapability(CAPABILITY_PLANTING).ifPresent(iSelfPlanting -> iSelfPlanting.handlePlantingLogic((ItemEntity)entity));
            }
        }
    }
}

