/*
 * Decompiled with CFR 0.152.
 */
package noppes.vc.blocks;

import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import noppes.vc.CommonUtils;
import noppes.vc.blocks.BlockBasicContainer;
import noppes.vc.blocks.tiles.TileBigSign;
import noppes.vc.blocks.tiles.TileTombstone;
import noppes.vc.constants.GuiType;

public class BlockTombstone
extends BlockBasicContainer {
    public static final PropertyInteger DAMAGE = PropertyInteger.func_177719_a((String)"damage", (int)0, (int)6);
    public static final AxisAlignedBB AABB1 = new AxisAlignedBB(0.0, 0.0, (double)0.3f, 1.0, 1.0, (double)0.7f);
    public static final AxisAlignedBB AABB2 = new AxisAlignedBB((double)0.3f, 0.0, 0.0, (double)0.7f, 1.0, 1.0);

    public BlockTombstone() {
        super(Material.field_151576_e);
        this.func_149672_a(SoundType.field_185851_d);
    }

    public int func_176201_c(IBlockState state) {
        return this.func_180651_a(state);
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)DAMAGE, (Comparable)Integer.valueOf(meta));
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{DAMAGE});
    }

    public int func_180651_a(IBlockState state) {
        return (Integer)state.func_177229_b((IProperty)DAMAGE);
    }

    public boolean func_180639_a(World par1World, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (par1World.field_72995_K) {
            return false;
        }
        ItemStack currentItem = player.field_71071_by.func_70448_g();
        if (currentItem.func_77973_b().func_77658_a().equals("item.npcwand")) {
            TileBigSign tile = (TileBigSign)par1World.func_175625_s(pos);
            if (tile.func_145832_p() >= 2) {
                return false;
            }
            tile.canEdit = true;
            CommonUtils.OpenGui(player, GuiType.BIG_SIGN, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
            return true;
        }
        return false;
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase entity, ItemStack stack) {
        world.func_180501_a(pos, state.func_177226_a((IProperty)DAMAGE, (Comparable)Integer.valueOf(stack.func_77952_i())), 2);
        int l = MathHelper.func_76128_c((double)((double)(entity.field_70177_z * (float)this.maxRotation() / 360.0f) + 0.5)) & this.maxRotation() - 1;
        TileTombstone tile = (TileTombstone)world.func_175625_s(pos);
        tile.rotation = l %= this.maxRotation();
        if (entity instanceof EntityPlayer && !world.field_72995_K && stack.func_77952_i() < 2) {
            CommonUtils.OpenGui((EntityPlayer)entity, GuiType.BIG_SIGN, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
        }
    }

    public int maxRotation() {
        return 4;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        TileEntity tileentity = world.func_175625_s(pos);
        if (!(tileentity instanceof TileTombstone)) {
            return super.func_185496_a(state, world, pos);
        }
        TileTombstone tile = (TileTombstone)tileentity;
        if (tile.rotation % 2 == 0) {
            return AABB1;
        }
        return AABB2;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public void func_149666_a(Item par1, CreativeTabs par2CreativeTabs, NonNullList<ItemStack> par3List) {
        par3List.add((Object)new ItemStack(par1, 1, 0));
        par3List.add((Object)new ItemStack(par1, 1, 1));
        par3List.add((Object)new ItemStack(par1, 1, 2));
    }

    public TileEntity func_149915_a(World var1, int var2) {
        return new TileTombstone();
    }
}

