/*
 * Decompiled with CFR 0.152.
 */
package noppes.vc.blocks;

import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import noppes.vc.CommonUtils;
import noppes.vc.blocks.BlockBasicContainer;
import noppes.vc.blocks.tiles.TileWallBanner;

public class BlockWallBanner
extends BlockBasicContainer {
    public static final PropertyInteger DAMAGE = PropertyInteger.func_177719_a((String)"damage", (int)0, (int)6);
    public int renderId = -1;
    public static final AxisAlignedBB AABB0 = new AxisAlignedBB(0.0, 0.0, (double)0.7f, 1.0, 1.0, 1.0);
    public static final AxisAlignedBB AABB1 = new AxisAlignedBB(0.0, 0.0, 0.0, (double)0.3f, 1.0, 1.0);
    public static final AxisAlignedBB AABB2 = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, (double)0.3f);
    public static final AxisAlignedBB AABB3 = new AxisAlignedBB((double)0.7f, 0.0, 0.0, 1.0, 1.0, 1.0);

    public BlockWallBanner() {
        super(Material.field_151576_e);
    }

    public boolean func_180639_a(World par1World, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        ItemStack item = player.func_184586_b(hand);
        if (item.func_190926_b() || par1World.field_72995_K) {
            return false;
        }
        TileWallBanner tile = (TileWallBanner)par1World.func_175625_s(pos);
        if (tile.canEdit()) {
            return true;
        }
        if (item.func_77973_b() != Items.field_151100_aR) {
            return false;
        }
        int color = EnumDyeColor.func_176764_b((int)item.func_77952_i()).func_176767_b();
        if (tile.color != color) {
            CommonUtils.ConsumeItemStack(1, player);
            tile.color = color;
            tile.func_70296_d();
            par1World.func_184138_a(pos, state, state, 3);
        }
        return true;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        TileEntity tileentity = world.func_175625_s(pos);
        if (!(tileentity instanceof TileWallBanner)) {
            return super.func_185496_a(state, world, pos);
        }
        TileWallBanner tile = (TileWallBanner)tileentity;
        if (tile.rotation == 0) {
            return AABB0;
        }
        if (tile.rotation == 2) {
            return AABB2;
        }
        if (tile.rotation == 3) {
            return AABB3;
        }
        if (tile.rotation == 1) {
            return AABB1;
        }
        return super.func_185496_a(state, world, pos);
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase entity, ItemStack stack) {
        world.func_180501_a(pos, state.func_177226_a((IProperty)DAMAGE, (Comparable)Integer.valueOf(stack.func_77952_i())), 2);
        int l = MathHelper.func_76128_c((double)((double)(entity.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3;
        TileWallBanner tile = (TileWallBanner)world.func_175625_s(pos);
        tile.rotation = l %= 4;
        tile.color = 15 - stack.func_77952_i();
        tile.time = System.currentTimeMillis();
        if (entity instanceof EntityPlayer && world.field_72995_K) {
            ((EntityPlayer)entity).func_146105_b((ITextComponent)new TextComponentTranslation("availability.editIcon", new Object[0]), true);
        }
    }

    public AxisAlignedBB func_180640_a(IBlockState state, World world, BlockPos pos) {
        return new AxisAlignedBB(pos, pos);
    }

    public boolean func_176205_b(IBlockAccess world, BlockPos pos) {
        return true;
    }

    public void func_149666_a(Item par1, CreativeTabs par2CreativeTabs, NonNullList<ItemStack> par3List) {
        par3List.add((Object)new ItemStack(par1, 1, 0));
        par3List.add((Object)new ItemStack(par1, 1, 1));
        par3List.add((Object)new ItemStack(par1, 1, 2));
        par3List.add((Object)new ItemStack(par1, 1, 3));
        par3List.add((Object)new ItemStack(par1, 1, 4));
    }

    public int func_176201_c(IBlockState state) {
        return this.func_180651_a(state);
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)DAMAGE, (Comparable)Integer.valueOf(meta));
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{DAMAGE});
    }

    public int func_180651_a(IBlockState state) {
        return (Integer)state.func_177229_b((IProperty)DAMAGE);
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.INVISIBLE;
    }

    public TileEntity func_149915_a(World var1, int var2) {
        return new TileWallBanner();
    }
}

