/*
 * Decompiled with CFR 0.152.
 */
package noppes.vc.client.gui;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import noppes.vc.VCRecipes;
import noppes.vc.shared.gui.GuiBasic;
import noppes.vc.shared.gui.GuiButtonNextPage;
import noppes.vc.shared.gui.GuiButtonNop;
import noppes.vc.shared.gui.GuiLabel;

@SideOnly(value=Side.CLIENT)
public class GuiRecipes
extends GuiBasic {
    private static final ResourceLocation resource = new ResourceLocation("variedcommodities", "textures/gui/slot.png");
    private static final ResourceLocation FURNACE_GUI_TEXTURES = new ResourceLocation("textures/gui/container/furnace.png");
    private int page = 0;
    private boolean npcRecipes = true;
    private GuiLabel label;
    private GuiButtonNop left;
    private GuiButtonNop right;
    private List<VCRecipes.RecipeContainer> recipes = new ArrayList<VCRecipes.RecipeContainer>();

    public GuiRecipes() {
        this.ySize = 182;
        this.xSize = 256;
        this.setBackground("recipes.png");
        this.closeOnEsc = true;
        this.recipes = VCRecipes.List;
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        this.addLabel(new GuiLabel(0, "Recipe List", this.guiLeft + 5, this.guiTop + 5));
        this.label = new GuiLabel(1, "", this.guiLeft + 5, this.guiTop + 168);
        this.addLabel(this.label);
        this.left = new GuiButtonNextPage(1, this.guiLeft + 150, this.guiTop + 164, true);
        this.addButton(this.left);
        this.right = new GuiButtonNextPage(2, this.guiLeft + 80, this.guiTop + 164, false);
        this.addButton(this.right);
        this.updateButton();
    }

    private void updateButton() {
        this.right.field_146124_l = this.page > 0;
        this.right.field_146125_m = this.right.field_146124_l;
        this.left.field_146124_l = this.page + 1 < MathHelper.func_76123_f((float)((float)this.recipes.size() / 4.0f));
        this.left.field_146125_m = this.left.field_146124_l;
    }

    @Override
    protected void func_146284_a(GuiButton button) {
        if (!button.field_146124_l) {
            return;
        }
        if (button == this.right) {
            --this.page;
        }
        if (button == this.left) {
            ++this.page;
        }
        this.updateButton();
    }

    @Override
    public void func_73863_a(int xMouse, int yMouse, float f) {
        int y;
        int x;
        VCRecipes.RecipeContainer recipe;
        int index;
        int i;
        super.func_73863_a(xMouse, yMouse, f);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.field_71446_o.func_110577_a(resource);
        RenderHelper.func_74520_c();
        GlStateManager.func_179140_f();
        GlStateManager.func_179091_B();
        GlStateManager.func_179142_g();
        GlStateManager.func_179145_e();
        this.label.label = this.page + 1 + "/" + MathHelper.func_76123_f((float)((float)this.recipes.size() / 4.0f));
        this.label.x = this.guiLeft + (256 - Minecraft.func_71410_x().field_71466_p.func_78256_a(this.label.label)) / 2;
        for (i = 0; i < 4 && (index = i + this.page * 4) < this.recipes.size(); ++i) {
            recipe = this.recipes.get(index);
            x = this.guiLeft + 5 + i / 2 * 126;
            y = this.guiTop + 15 + i % 2 * 76;
            this.drawItem(recipe.output(), x + 98, y + 28, xMouse, yMouse);
            x += (72 - recipe.width * 18) / 2;
            y += (72 - recipe.height * 18) / 2;
            if (recipe.isFurnace()) {
                // empty if block
            }
            List<ItemStack> input = recipe.input();
            for (int j = 0; j < input.size(); ++j) {
                ItemStack item = input.get(j);
                int x2 = x + j % recipe.width * 18;
                int y2 = y + j / recipe.width * 18;
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                this.field_146297_k.field_71446_o.func_110577_a(resource);
                this.func_73729_b(x2, y2, 0, 0, 18, 18);
                if (item == null || item.func_190926_b()) continue;
                this.drawItem(item, x2 + 1, y2 + 1, xMouse, yMouse);
            }
        }
        GlStateManager.func_179145_e();
        GlStateManager.func_179126_j();
        RenderHelper.func_74519_b();
        for (i = 0; i < 4 && (index = i + this.page * 4) < this.recipes.size(); ++i) {
            recipe = this.recipes.get(index);
            x = this.guiLeft + 5 + i / 2 * 126;
            y = this.guiTop + 15 + i % 2 * 76;
            this.drawOverlay(recipe.output(), x + 98, y + 22, xMouse, yMouse);
            x += (72 - recipe.width * 18) / 2;
            y += (72 - recipe.height * 18) / 2;
            for (int j = 0; j < recipe.width; ++j) {
                for (int k = 0; k < recipe.height; ++k) {
                    int l = j + k * recipe.width;
                    ItemStack item = recipe.input().get(l);
                    if (item == null || item.func_190926_b()) continue;
                    this.drawOverlay(item, x + j * 18 + 1, y + k * 18 + 1, xMouse, yMouse);
                }
            }
        }
    }

    private void drawItem(ItemStack item, int x, int y, int xMouse, int yMouse) {
        if (Item.func_150898_a((Block)Blocks.field_150325_L) != Items.field_190931_a && item.func_77952_i() == Short.MAX_VALUE) {
            item = item.func_77946_l();
            item.func_77964_b(0);
        }
        GlStateManager.func_179094_E();
        this.field_146296_j.field_77023_b = 100.0f;
        this.field_146296_j.func_180450_b(item, x, y);
        this.field_146296_j.func_175030_a(this.field_146289_q, item, x, y);
        this.field_146296_j.field_77023_b = 0.0f;
        GlStateManager.func_179121_F();
    }

    private void drawOverlay(ItemStack item, int x, int y, int xMouse, int yMouse) {
        if (this.func_146978_c(x - this.guiLeft, y - this.guiTop, 16, 16, xMouse, yMouse)) {
            this.func_146285_a(item, xMouse, yMouse);
        }
    }

    protected boolean func_146978_c(int p_146978_1_, int p_146978_2_, int p_146978_3_, int p_146978_4_, int p_146978_5_, int p_146978_6_) {
        int k1 = this.guiLeft;
        int l1 = this.guiTop;
        return (p_146978_5_ -= k1) >= p_146978_1_ - 1 && p_146978_5_ < p_146978_1_ + p_146978_3_ + 1 && (p_146978_6_ -= l1) >= p_146978_2_ - 1 && p_146978_6_ < p_146978_2_ + p_146978_4_ + 1;
    }

    @Override
    public void save() {
    }
}

