/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.yungsapi.criteria;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.level.levelgen.feature.StructureFeature;
import org.jetbrains.annotations.Nullable;

public class SafeStructureLocationPredicate {
    private final StructureFeature<?> structure;

    public SafeStructureLocationPredicate(StructureFeature<?> structure) {
        this.structure = structure;
    }

    public boolean matches(ServerLevel serverLevel, double x, double y, double z) {
        return this.matches(serverLevel, (float)x, (float)y, (float)z);
    }

    public boolean matches(ServerLevel serverLevel, float x, float y, float z) {
        BlockPos blockpos = new BlockPos((double)x, (double)y, (double)z);
        return this.structure != null && serverLevel.m_46749_(blockpos) && serverLevel.m_8595_().m_186613_(blockpos, this.structure).m_73603_();
    }

    public JsonElement serializeToJson() {
        JsonObject jsonObject = new JsonObject();
        if (this.structure != null) {
            jsonObject.addProperty("feature", this.structure.m_67098_());
        }
        return jsonObject;
    }

    public static SafeStructureLocationPredicate fromJson(@Nullable JsonElement jsonElement) {
        if (jsonElement != null && !jsonElement.isJsonNull()) {
            JsonObject jsonObject = GsonHelper.m_13918_((JsonElement)jsonElement, (String)"location");
            StructureFeature structure = jsonObject.has("feature") ? (StructureFeature)Registry.f_122841_.m_7745_(new ResourceLocation(GsonHelper.m_13906_((JsonObject)jsonObject, (String)"feature"))) : null;
            return new SafeStructureLocationPredicate(structure);
        }
        return new SafeStructureLocationPredicate(null);
    }
}

