/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.yungsapi.json;

import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import com.yungnickyoung.minecraft.yungsapi.YungsApi;
import java.io.IOException;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;

public class ItemAdapter
extends TypeAdapter<Item> {
    public Item read(JsonReader reader) throws IOException {
        if (reader.peek() == JsonToken.NULL) {
            reader.nextNull();
            return null;
        }
        return ItemAdapter.resolveItem(reader.nextString());
    }

    public void write(JsonWriter writer, Item item) throws IOException {
        if (item == null) {
            writer.nullValue();
            return;
        }
        String itemString = String.valueOf(item);
        writer.value(itemString);
    }

    public static Item resolveItem(String itemString) {
        Item item;
        try {
            item = (Item)Registry.f_122827_.m_7745_(new ResourceLocation(itemString));
        }
        catch (Exception e) {
            YungsApi.LOGGER.error("JSON: Unable to read item '{}': {}", (Object)itemString, (Object)e.toString());
            YungsApi.LOGGER.error("Using air instead...");
            return Items.f_41852_;
        }
        return item;
    }
}

