/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.yungsapi.world.jigsaw;

import com.mojang.datafixers.util.Pair;
import com.yungnickyoung.minecraft.yungsapi.YungsApiCommon;
import com.yungnickyoung.minecraft.yungsapi.mixin.accessor.StructureTemplatePoolAccessor;
import com.yungnickyoung.minecraft.yungsapi.util.BoxOctree;
import com.yungnickyoung.minecraft.yungsapi.world.jigsaw.assembler.JigsawStructureAssembler;
import com.yungnickyoung.minecraft.yungsapi.world.jigsaw.piece.YungJigsawPoolElement;
import com.yungnickyoung.minecraft.yungsapi.world.structure.context.StructureContext;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_156;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_2470;
import net.minecraft.class_2794;
import net.minecraft.class_2902;
import net.minecraft.class_2919;
import net.minecraft.class_2960;
import net.minecraft.class_3195;
import net.minecraft.class_3341;
import net.minecraft.class_3485;
import net.minecraft.class_3499;
import net.minecraft.class_3777;
import net.minecraft.class_3784;
import net.minecraft.class_3785;
import net.minecraft.class_3790;
import net.minecraft.class_5321;
import net.minecraft.class_5455;
import net.minecraft.class_5539;
import net.minecraft.class_5819;
import net.minecraft.class_6626;
import net.minecraft.class_6880;

public class JigsawManager {
    public static Optional<class_3195.class_7150> assembleJigsawStructure(class_3195.class_7149 generationContext, class_6880<class_3785> startPool, Optional<class_2960> startJigsawNameOptional, int maxDepth, class_2338 locatePos, boolean useExpansionHack, Optional<class_2902.class_2903> projectStartToHeightmap, int maxDistanceFromCenter, Optional<Integer> maxY, Optional<Integer> minY) {
        class_5455 registryAccess = generationContext.comp_561();
        class_2794 chunkGenerator = generationContext.comp_562();
        class_3485 structureManager = generationContext.comp_565();
        class_5539 levelHeightAccessor = generationContext.comp_569();
        class_2919 worldgenRandom = generationContext.comp_566();
        class_2378 registry = registryAccess.method_30530(class_2378.field_25917);
        Optional<class_3790> startPieceOptional = JigsawManager.getStartPiece(startPool, startJigsawNameOptional, locatePos, structureManager, (class_5819)worldgenRandom);
        if (startPieceOptional.isEmpty()) {
            return Optional.empty();
        }
        class_3790 startPiece = startPieceOptional.get();
        class_2338 startingPosOffset = locatePos.method_10059((class_2382)startPiece.method_16648());
        class_3341 pieceBoundingBox = startPiece.method_14935();
        int bbCenterX = (pieceBoundingBox.method_35418() + pieceBoundingBox.method_35415()) / 2;
        int bbCenterZ = (pieceBoundingBox.method_35420() + pieceBoundingBox.method_35417()) / 2;
        int bbCenterY = projectStartToHeightmap.map(types -> locatePos.method_10264() + chunkGenerator.method_20402(bbCenterX, bbCenterZ, types, levelHeightAccessor, generationContext.comp_564())).orElseGet(() -> startPiece.method_16648().method_10264());
        int adjustedPieceCenterY = bbCenterY + startingPosOffset.method_10264();
        int yAdjustment = pieceBoundingBox.method_35416() + startPiece.method_16646();
        startPiece.method_14922(0, bbCenterY - yAdjustment, 0);
        class_238 aABB = new class_238((double)(bbCenterX - maxDistanceFromCenter), (double)(adjustedPieceCenterY - maxDistanceFromCenter), (double)(bbCenterZ - maxDistanceFromCenter), (double)(bbCenterX + maxDistanceFromCenter + 1), (double)(adjustedPieceCenterY + maxDistanceFromCenter + 1), (double)(bbCenterZ + maxDistanceFromCenter + 1));
        BoxOctree maxStructureBounds = new BoxOctree(aABB);
        maxStructureBounds.addBox(class_238.method_19316((class_3341)pieceBoundingBox));
        return Optional.of(new class_3195.class_7150(new class_2338(bbCenterX, adjustedPieceCenterY, bbCenterZ), structurePiecesBuilder -> {
            if (maxDepth <= 0) {
                return;
            }
            JigsawStructureAssembler assembler = new JigsawStructureAssembler(new JigsawStructureAssembler.Settings().poolRegistry((class_2378<class_3785>)registry).maxDepth(maxDepth).chunkGenerator(chunkGenerator).structureTemplateManager(structureManager).randomState(generationContext.comp_564()).rand((class_5819)worldgenRandom).maxY(maxY).minY(minY).useExpansionHack(useExpansionHack).levelHeightAccessor(levelHeightAccessor));
            assembler.assembleStructure(startPiece, maxStructureBounds);
            assembler.addAllPiecesToStructureBuilder((class_6626)structurePiecesBuilder);
        }));
    }

    private static Optional<class_3790> getStartPiece(class_6880<class_3785> startPoolHolder, Optional<class_2960> startJigsawNameOptional, class_2338 locatePos, class_3485 structureTemplateManager, class_5819 rand) {
        int chosenPieceWeight;
        class_3785 startPool = (class_3785)startPoolHolder.comp_349();
        ObjectArrayList candidatePoolElements = new ObjectArrayList(((StructureTemplatePoolAccessor)startPool).getRawTemplates());
        class_156.method_43028((ObjectArrayList)candidatePoolElements, (class_5819)rand);
        class_2470 rotation = class_2470.method_16548((class_5819)rand);
        for (int totalWeightSum = candidatePoolElements.stream().mapToInt(Pair::getSecond).reduce(0, Integer::sum); candidatePoolElements.size() > 0 && totalWeightSum > 0; totalWeightSum -= chosenPieceWeight) {
            StructureContext ctx;
            YungJigsawPoolElement yungElement;
            class_2338 anchorPos;
            Pair chosenPoolElementPair = null;
            for (Pair candidatePiecePair : candidatePoolElements) {
                YungJigsawPoolElement yungElement2;
                class_3784 candidatePiece = (class_3784)candidatePiecePair.getFirst();
                if (!(candidatePiece instanceof YungJigsawPoolElement) || !(yungElement2 = (YungJigsawPoolElement)candidatePiece).isPriorityPiece()) continue;
                chosenPoolElementPair = candidatePiecePair;
                break;
            }
            if (chosenPoolElementPair == null) {
                Pair candidatePiecePair;
                int chosenWeight = rand.method_43048(totalWeightSum) + 1;
                candidatePiecePair = candidatePoolElements.iterator();
                while (candidatePiecePair.hasNext()) {
                    Pair candidate = (Pair)candidatePiecePair.next();
                    if ((chosenWeight -= ((Integer)candidate.getSecond()).intValue()) > 0) continue;
                    chosenPoolElementPair = candidate;
                    break;
                }
            }
            class_3784 chosenPoolElement = (class_3784)chosenPoolElementPair.getFirst();
            chosenPieceWeight = (Integer)chosenPoolElementPair.getSecond();
            if (chosenPoolElement == class_3777.field_16663) {
                return Optional.empty();
            }
            if (startJigsawNameOptional.isPresent()) {
                class_2960 name = startJigsawNameOptional.get();
                Optional<class_2338> optional = JigsawManager.getPosOfJigsawBlockWithName(chosenPoolElement, name, locatePos, rotation, structureTemplateManager, rand);
                if (optional.isEmpty()) {
                    YungsApiCommon.LOGGER.error("No starting jigsaw with Name {} found in start pool {}", (Object)name, (Object)((class_5321)startPoolHolder.method_40230().get()).method_29177());
                    return Optional.empty();
                }
                anchorPos = optional.get();
            } else {
                anchorPos = locatePos;
            }
            class_2338 startingPosOffset = anchorPos.method_10059((class_2382)locatePos);
            class_2338 adjustedStartPos = locatePos.method_10059((class_2382)startingPosOffset);
            if (chosenPoolElement instanceof YungJigsawPoolElement && !(yungElement = (YungJigsawPoolElement)chosenPoolElement).passesConditions(ctx = new StructureContext.Builder().structureTemplateManager(structureTemplateManager).pos(adjustedStartPos).rotation(rotation).depth(0).random(rand).build())) {
                candidatePoolElements.remove((Object)chosenPoolElementPair);
                continue;
            }
            return Optional.of(new class_3790(structureTemplateManager, chosenPoolElement, adjustedStartPos, chosenPoolElement.method_19308(), rotation, chosenPoolElement.method_16628(structureTemplateManager, adjustedStartPos, rotation)));
        }
        return Optional.empty();
    }

    private static Optional<class_2338> getPosOfJigsawBlockWithName(class_3784 structurePoolElement, class_2960 name, class_2338 startPos, class_2470 rotation, class_3485 structureTemplateManager, class_5819 rand) {
        List shuffledJigsawBlocks = structurePoolElement.method_16627(structureTemplateManager, startPos, rotation, rand);
        for (class_3499.class_3501 jigsawBlockInfo : shuffledJigsawBlocks) {
            class_2960 jigsawBlockName = class_2960.method_12829((String)jigsawBlockInfo.field_15595.method_10558("name"));
            if (!name.equals((Object)jigsawBlockName)) continue;
            return Optional.of(jigsawBlockInfo.field_15597);
        }
        return Optional.empty();
    }
}

