/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.yungsapi.world.structure.terrainadaptation.beardifier;

import com.yungnickyoung.minecraft.yungsapi.mixin.accessor.BeardifierAccessor;
import com.yungnickyoung.minecraft.yungsapi.world.structure.YungJigsawStructure;
import com.yungnickyoung.minecraft.yungsapi.world.structure.jigsaw.element.YungJigsawPoolElement;
import com.yungnickyoung.minecraft.yungsapi.world.structure.terrainadaptation.EnhancedTerrainAdaptation;
import com.yungnickyoung.minecraft.yungsapi.world.structure.terrainadaptation.beardifier.EnhancedBeardifierData;
import com.yungnickyoung.minecraft.yungsapi.world.structure.terrainadaptation.beardifier.EnhancedBeardifierRigid;
import com.yungnickyoung.minecraft.yungsapi.world.structure.terrainadaptation.beardifier.EnhancedJigsawJunction;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectListIterator;
import java.util.List;
import net.minecraft.class_1923;
import net.minecraft.class_3341;
import net.minecraft.class_3443;
import net.minecraft.class_3449;
import net.minecraft.class_3780;
import net.minecraft.class_3784;
import net.minecraft.class_3785;
import net.minecraft.class_3790;
import net.minecraft.class_5138;
import net.minecraft.class_5817;
import net.minecraft.class_6910;

public class EnhancedBeardifierHelper {
    public static class_5817 forStructuresInChunk(class_5138 structureManager, class_1923 chunkPos, class_5817 original) {
        ObjectArrayList enhancedBeardifierRigidList = new ObjectArrayList(10);
        ObjectArrayList enhancedJunctionList = new ObjectArrayList(10);
        int chunkMinBlockX = chunkPos.method_8326();
        int chunkMinBlockZ = chunkPos.method_8328();
        List structureStarts = structureManager.method_41035(chunkPos, structure -> structure instanceof YungJigsawStructure);
        for (class_3449 structureStart : structureStarts) {
            EnhancedTerrainAdaptation structureTerrainAdaptation = ((YungJigsawStructure)structureStart.method_16656()).enhancedTerrainAdaptation;
            int kernelRadius = structureTerrainAdaptation.getKernelRadius();
            for (class_3443 structurePiece2 : structureStart.method_14963()) {
                YungJigsawPoolElement yungElement;
                class_3790 poolPiece;
                class_3784 class_37842;
                if (!(structurePiece2 instanceof class_3790) || !((class_37842 = (poolPiece = (class_3790)structurePiece2).method_16644()) instanceof YungJigsawPoolElement) || !(yungElement = (YungJigsawPoolElement)class_37842).getEnhancedTerrainAdaptation().isPresent()) continue;
                kernelRadius = Math.max(kernelRadius, yungElement.getEnhancedTerrainAdaptation().get().getKernelRadius());
            }
            int maxKernelRadius = kernelRadius;
            if (maxKernelRadius <= 0) continue;
            List<class_3443> nearbyPieces = structureStart.method_14963().stream().filter(structurePiece -> structurePiece.method_16654(chunkPos, maxKernelRadius)).toList();
            for (class_3443 nearbyPiece : nearbyPieces) {
                if (nearbyPiece instanceof class_3790) {
                    YungJigsawPoolElement yungElement;
                    class_3790 poolElementPiece = (class_3790)nearbyPiece;
                    class_3785.class_3786 projection = poolElementPiece.method_16644().method_16624();
                    EnhancedTerrainAdaptation pieceTerrainAdaptation = structureTerrainAdaptation;
                    class_3784 class_37843 = poolElementPiece.method_16644();
                    if (class_37843 instanceof YungJigsawPoolElement && (yungElement = (YungJigsawPoolElement)class_37843).getEnhancedTerrainAdaptation().isPresent()) {
                        pieceTerrainAdaptation = yungElement.getEnhancedTerrainAdaptation().get();
                    }
                    if (pieceTerrainAdaptation == EnhancedTerrainAdaptation.NONE) continue;
                    int pieceKernelRadius = pieceTerrainAdaptation.getKernelRadius();
                    if (projection == class_3785.class_3786.field_16687) {
                        enhancedBeardifierRigidList.add((Object)new EnhancedBeardifierRigid(poolElementPiece.method_14935(), pieceTerrainAdaptation, poolElementPiece.method_16646()));
                    }
                    for (class_3780 jigsawJunction : poolElementPiece.method_16645()) {
                        int sourceX = jigsawJunction.method_16610();
                        int sourceZ = jigsawJunction.method_16609();
                        if (sourceX <= chunkMinBlockX - pieceKernelRadius || sourceZ <= chunkMinBlockZ - pieceKernelRadius || sourceX >= chunkMinBlockX + 15 + pieceKernelRadius || sourceZ >= chunkMinBlockZ + 15 + pieceKernelRadius) continue;
                        enhancedJunctionList.add((Object)new EnhancedJigsawJunction(jigsawJunction, pieceTerrainAdaptation));
                    }
                    continue;
                }
                if (structureTerrainAdaptation == EnhancedTerrainAdaptation.NONE) continue;
                enhancedBeardifierRigidList.add((Object)new EnhancedBeardifierRigid(nearbyPiece.method_14935(), structureTerrainAdaptation, 0));
            }
        }
        class_5817 newBeardifier = new class_5817(((BeardifierAccessor)original).getPieceIterator(), ((BeardifierAccessor)original).getJunctionIterator());
        ((EnhancedBeardifierData)newBeardifier).setEnhancedRigidIterator((ObjectListIterator<EnhancedBeardifierRigid>)enhancedBeardifierRigidList.iterator());
        ((EnhancedBeardifierData)newBeardifier).setEnhancedJunctionIterator((ObjectListIterator<EnhancedJigsawJunction>)enhancedJunctionList.iterator());
        return newBeardifier;
    }

    public static double computeDensity(class_6910.class_6912 ctx, double density, EnhancedBeardifierData data) {
        int x = ctx.comp_371();
        int y = ctx.comp_372();
        int z = ctx.comp_373();
        while (data.getEnhancedRigidIterator() != null && data.getEnhancedRigidIterator().hasNext()) {
            EnhancedBeardifierRigid rigid = (EnhancedBeardifierRigid)data.getEnhancedRigidIterator().next();
            class_3341 pieceBoundingBox = rigid.pieceBoundingBox();
            int adjustedPieceMinY = pieceBoundingBox.method_35416();
            EnhancedTerrainAdaptation pieceTerrainAdaptation = rigid.pieceTerrainAdaptation();
            int xDistanceToBoundingBox = Math.max(0, Math.max(pieceBoundingBox.method_35415() - x, x - pieceBoundingBox.method_35418()));
            int yDistanceToBoundingBox = Math.max(0, Math.max(adjustedPieceMinY - y, y - pieceBoundingBox.method_35419()));
            int zDistanceToBoundingBox = Math.max(0, Math.max(pieceBoundingBox.method_35417() - z, z - pieceBoundingBox.method_35420()));
            int yDistanceToAdjustedPieceBottom = y - adjustedPieceMinY;
            double densityFactor = 0.0;
            if (pieceTerrainAdaptation != EnhancedTerrainAdaptation.NONE) {
                densityFactor = pieceTerrainAdaptation.computeDensityFactor(xDistanceToBoundingBox, yDistanceToBoundingBox, zDistanceToBoundingBox, yDistanceToAdjustedPieceBottom) * 0.8;
            }
            density += densityFactor;
        }
        data.getEnhancedRigidIterator().back(Integer.MAX_VALUE);
        while (data.getEnhancedJunctionIterator() != null && data.getEnhancedJunctionIterator().hasNext()) {
            EnhancedJigsawJunction enhancedJigsawJunction = (EnhancedJigsawJunction)data.getEnhancedJunctionIterator().next();
            class_3780 jigsawJunction = enhancedJigsawJunction.jigsawJunction();
            EnhancedTerrainAdaptation pieceTerrainAdaptation = enhancedJigsawJunction.pieceTerrainAdaptation();
            int xDistanceToJunction = x - jigsawJunction.method_16610();
            int yDistanceToJunction = y - jigsawJunction.method_16611();
            int zDistanceToJunction = z - jigsawJunction.method_16609();
            density += pieceTerrainAdaptation.computeDensityFactor(xDistanceToJunction, yDistanceToJunction, zDistanceToJunction, yDistanceToJunction) * 0.4;
        }
        data.getEnhancedJunctionIterator().back(Integer.MAX_VALUE);
        return density;
    }
}

