/*
 * Decompiled with CFR 0.152.
 */
package bspkrs.armorstatushud;

import bspkrs.armorstatushud.ConfigElement;
import bspkrs.armorstatushud.HUDElement;
import bspkrs.armorstatushud.fml.Reference;
import bspkrs.client.util.ColorThreshold;
import bspkrs.util.CommonUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiChat;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.common.FMLLog;
import org.apache.logging.log4j.Level;
import org.lwjgl.opengl.GL11;

public class ArmorStatusHUD {
    private static final String DEFAULT_COLOR_LIST = "100,f; 80,7; 60,e; 40,6; 25,c; 10,4";
    private static final boolean enabledDefault = true;
    public static boolean enabled = true;
    private static String alignModeDefault;
    public static String alignMode;
    private static String listModeDefault;
    public static String listMode;
    private static boolean enableItemNameDefault;
    public static boolean enableItemName;
    private static boolean showDamageOverlayDefault;
    public static boolean showDamageOverlay;
    private static boolean showItemCountDefault;
    public static boolean showItemCount;
    private static String damageColorListDefault;
    public static String damageColorList;
    private static String damageDisplayTypeDefault;
    public static String damageDisplayType;
    private static String damageThresholdTypeDefault;
    public static String damageThresholdType;
    private static boolean showItemDamageDefault;
    public static boolean showItemDamage;
    private static boolean showArmorDamageDefault;
    public static boolean showArmorDamage;
    private static boolean showMaxDamageDefault;
    public static boolean showMaxDamage;
    private static boolean showEquippedItemDefault;
    public static boolean showEquippedItem;
    private static int xOffsetDefault;
    public static int xOffset;
    private static int yOffsetDefault;
    public static int yOffset;
    private static int yOffsetBottomCenterDefault;
    public static int yOffsetBottomCenter;
    private static boolean applyXOffsetToCenterDefault;
    public static boolean applyXOffsetToCenter;
    private static boolean applyYOffsetToMiddleDefault;
    public static boolean applyYOffsetToMiddle;
    private static boolean showInChatDefault;
    public static boolean showInChat;
    static float zLevel;
    private static ScaledResolution scaledResolution;
    static final List<ColorThreshold> colorList;
    private static List<HUDElement> elements;
    private static Pattern colorListPattern;

    public static void initConfig(File file) {
        if (!CommonUtils.isObfuscatedEnv()) {
            // empty if block
        }
        Reference.config = new Configuration(file);
        ArmorStatusHUD.syncConfig();
    }

    public static void syncConfig() {
        String ctgyGen = "general";
        Reference.config.load();
        Reference.config.setCategoryComment(ctgyGen, "ATTENTION: Editing this file manually is no longer necessary. \nType the command '/armorstatus config' without the quotes in-game to modify these settings.");
        Reference.config.setCategoryRequiresWorldRestart(ctgyGen, false);
        ArrayList<String> orderedKeys = new ArrayList<String>(ConfigElement.values().length);
        enabled = Reference.config.getBoolean(ConfigElement.ENABLED.key(), ctgyGen, true, ConfigElement.ENABLED.desc(), ConfigElement.ENABLED.languageKey());
        orderedKeys.add(ConfigElement.ENABLED.key());
        alignMode = Reference.config.getString(ConfigElement.ALIGN_MODE.key(), ctgyGen, alignModeDefault, ConfigElement.ALIGN_MODE.desc(), ConfigElement.ALIGN_MODE.validStrings(), ConfigElement.ALIGN_MODE.languageKey());
        orderedKeys.add(ConfigElement.ALIGN_MODE.key());
        listMode = Reference.config.getString(ConfigElement.LIST_MODE.key(), ctgyGen, listModeDefault, ConfigElement.LIST_MODE.desc(), ConfigElement.LIST_MODE.validStrings(), ConfigElement.LIST_MODE.languageKey());
        orderedKeys.add(ConfigElement.LIST_MODE.key());
        enableItemName = Reference.config.getBoolean(ConfigElement.ENABLE_ITEM_NAME.key(), ctgyGen, enableItemNameDefault, ConfigElement.ENABLE_ITEM_NAME.desc(), ConfigElement.ENABLE_ITEM_NAME.languageKey());
        orderedKeys.add(ConfigElement.ENABLE_ITEM_NAME.key());
        showDamageOverlay = Reference.config.getBoolean(ConfigElement.SHOW_DAMAGE_OVERLAY.key(), ctgyGen, showDamageOverlayDefault, ConfigElement.SHOW_DAMAGE_OVERLAY.desc(), ConfigElement.SHOW_DAMAGE_OVERLAY.languageKey());
        orderedKeys.add(ConfigElement.SHOW_DAMAGE_OVERLAY.key());
        showItemCount = Reference.config.getBoolean(ConfigElement.SHOW_ITEM_COUNT.key(), ctgyGen, showItemCountDefault, ConfigElement.SHOW_ITEM_COUNT.desc(), ConfigElement.SHOW_ITEM_COUNT.languageKey());
        orderedKeys.add(ConfigElement.SHOW_ITEM_COUNT.key());
        showArmorDamage = Reference.config.getBoolean(ConfigElement.SHOW_ARMOR_DAMAGE.key(), ctgyGen, showArmorDamageDefault, ConfigElement.SHOW_ARMOR_DAMAGE.desc(), ConfigElement.SHOW_ARMOR_DAMAGE.languageKey());
        orderedKeys.add(ConfigElement.SHOW_ARMOR_DAMAGE.key());
        showItemDamage = Reference.config.getBoolean(ConfigElement.SHOW_ITEM_DAMAGE.key(), ctgyGen, showItemDamageDefault, ConfigElement.SHOW_ITEM_DAMAGE.desc(), ConfigElement.SHOW_ITEM_DAMAGE.languageKey());
        orderedKeys.add(ConfigElement.SHOW_ITEM_DAMAGE.key());
        showMaxDamage = Reference.config.getBoolean(ConfigElement.SHOW_MAX_DAMAGE.key(), ctgyGen, showMaxDamageDefault, ConfigElement.SHOW_MAX_DAMAGE.desc(), ConfigElement.SHOW_MAX_DAMAGE.languageKey());
        orderedKeys.add(ConfigElement.SHOW_MAX_DAMAGE.key());
        showEquippedItem = Reference.config.getBoolean(ConfigElement.SHOW_EQUIPPED_ITEM.key(), ctgyGen, showEquippedItemDefault, ConfigElement.SHOW_EQUIPPED_ITEM.desc(), ConfigElement.SHOW_EQUIPPED_ITEM.languageKey());
        orderedKeys.add(ConfigElement.SHOW_EQUIPPED_ITEM.key());
        showInChat = Reference.config.getBoolean(ConfigElement.SHOW_IN_CHAT.key(), ctgyGen, showInChatDefault, ConfigElement.SHOW_IN_CHAT.desc(), ConfigElement.SHOW_IN_CHAT.languageKey());
        orderedKeys.add(ConfigElement.SHOW_IN_CHAT.key());
        damageColorList = Reference.config.getString(ConfigElement.DAMAGE_COLOR_LIST.key(), ctgyGen, damageColorListDefault, ConfigElement.DAMAGE_COLOR_LIST.desc(), ConfigElement.DAMAGE_COLOR_LIST.languageKey(), colorListPattern);
        orderedKeys.add(ConfigElement.DAMAGE_COLOR_LIST.key());
        damageDisplayType = Reference.config.getString(ConfigElement.DAMAGE_DISPLAY_TYPE.key(), ctgyGen, damageDisplayTypeDefault, ConfigElement.DAMAGE_DISPLAY_TYPE.desc(), ConfigElement.DAMAGE_DISPLAY_TYPE.validStrings(), ConfigElement.DAMAGE_DISPLAY_TYPE.languageKey());
        orderedKeys.add(ConfigElement.DAMAGE_DISPLAY_TYPE.key());
        damageThresholdType = Reference.config.getString(ConfigElement.DAMAGE_THRESHOLD_TYPE.key(), ctgyGen, damageThresholdTypeDefault, ConfigElement.DAMAGE_THRESHOLD_TYPE.desc(), ConfigElement.DAMAGE_THRESHOLD_TYPE.validStrings(), ConfigElement.DAMAGE_THRESHOLD_TYPE.languageKey());
        orderedKeys.add(ConfigElement.DAMAGE_THRESHOLD_TYPE.key());
        xOffset = Reference.config.getInt(ConfigElement.X_OFFSET.key(), ctgyGen, xOffsetDefault, Integer.MIN_VALUE, Integer.MAX_VALUE, ConfigElement.X_OFFSET.desc(), ConfigElement.X_OFFSET.languageKey());
        orderedKeys.add(ConfigElement.X_OFFSET.key());
        applyXOffsetToCenter = Reference.config.getBoolean(ConfigElement.APPLY_X_OFFSET_TO_CENTER.key(), ctgyGen, applyXOffsetToCenterDefault, ConfigElement.APPLY_X_OFFSET_TO_CENTER.desc(), ConfigElement.APPLY_X_OFFSET_TO_CENTER.languageKey());
        orderedKeys.add(ConfigElement.APPLY_X_OFFSET_TO_CENTER.key());
        yOffset = Reference.config.getInt(ConfigElement.Y_OFFSET.key(), ctgyGen, yOffsetDefault, Integer.MIN_VALUE, Integer.MAX_VALUE, ConfigElement.Y_OFFSET.desc(), ConfigElement.Y_OFFSET.languageKey());
        orderedKeys.add(ConfigElement.Y_OFFSET.key());
        applyYOffsetToMiddle = Reference.config.getBoolean(ConfigElement.APPLY_Y_OFFSET_TO_MIDDLE.key(), ctgyGen, applyYOffsetToMiddleDefault, ConfigElement.APPLY_Y_OFFSET_TO_MIDDLE.desc(), ConfigElement.APPLY_Y_OFFSET_TO_MIDDLE.languageKey());
        orderedKeys.add(ConfigElement.APPLY_Y_OFFSET_TO_MIDDLE.key());
        yOffsetBottomCenter = Reference.config.getInt(ConfigElement.Y_OFFSET_BOTTOM_CENTER.key(), ctgyGen, yOffsetBottomCenterDefault, Integer.MIN_VALUE, Integer.MAX_VALUE, ConfigElement.Y_OFFSET_BOTTOM_CENTER.desc(), ConfigElement.Y_OFFSET_BOTTOM_CENTER.languageKey());
        orderedKeys.add(ConfigElement.Y_OFFSET_BOTTOM_CENTER.key());
        Reference.config.setCategoryPropertyOrder(ctgyGen, orderedKeys);
        Reference.config.save();
        try {
            for (String s : damageColorList.split(";")) {
                String[] ct = s.split(",");
                colorList.add(new ColorThreshold(Integer.valueOf(ct[0].trim()).intValue(), ct[1].trim()));
            }
        }
        catch (Throwable e) {
            FMLLog.log((String)"ArmorStatusHUD", (Level)Level.WARN, (String)("Error encountered parsing damageColorList: " + damageColorList), (Object[])new Object[0]);
            FMLLog.log((String)"ArmorStatusHUD", (Level)Level.WARN, (String)"Reverting to defaultColorList: 100,f; 80,7; 60,e; 40,6; 25,c; 10,4", (Object[])new Object[0]);
            for (String s : DEFAULT_COLOR_LIST.split(";")) {
                String[] ct = s.split(",");
                colorList.add(new ColorThreshold(Integer.valueOf(ct[0].trim()).intValue(), ct[1].trim()));
            }
        }
        Collections.sort(colorList);
    }

    public static boolean onTickInGame(Minecraft mc) {
        if (enabled && (mc.field_71415_G || mc.field_71462_r == null || mc.field_71462_r instanceof GuiChat && showInChat) && !mc.field_71474_y.field_74330_P) {
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            scaledResolution = new ScaledResolution(mc, mc.field_71443_c, mc.field_71440_d);
            ArmorStatusHUD.displayArmorStatus(mc);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
        return true;
    }

    private static int getX(int width) {
        if (alignMode.toLowerCase().contains("center")) {
            return scaledResolution.func_78326_a() / 2 - width / 2 + (applyXOffsetToCenter ? xOffset : 0);
        }
        if (alignMode.toLowerCase().contains("right")) {
            return scaledResolution.func_78326_a() - width - xOffset;
        }
        return xOffset;
    }

    private static int getY(int rowCount, int height) {
        if (alignMode.toLowerCase().contains("middle")) {
            return scaledResolution.func_78328_b() / 2 - rowCount * height / 2 + (applyYOffsetToMiddle ? yOffset : 0);
        }
        if (alignMode.equalsIgnoreCase("bottomleft") || alignMode.equalsIgnoreCase("bottomright")) {
            return scaledResolution.func_78328_b() - rowCount * height - yOffset;
        }
        if (alignMode.equalsIgnoreCase("bottomcenter")) {
            return scaledResolution.func_78328_b() - rowCount * height - yOffsetBottomCenter;
        }
        return yOffset;
    }

    public static boolean playerHasArmorEquipped(EntityPlayer player) {
        return player.field_71071_by.func_70440_f(0) != null || player.field_71071_by.func_70440_f(1) != null || player.field_71071_by.func_70440_f(2) != null || player.field_71071_by.func_70440_f(3) != null;
    }

    public static int countOfDisplayableItems(EntityPlayer player) {
        int i = 0;
        i += ArmorStatusHUD.canDisplayItem(player.field_71071_by.func_70440_f(0)) ? 1 : 0;
        i += ArmorStatusHUD.canDisplayItem(player.field_71071_by.func_70440_f(1)) ? 1 : 0;
        i += ArmorStatusHUD.canDisplayItem(player.field_71071_by.func_70440_f(2)) ? 1 : 0;
        i += ArmorStatusHUD.canDisplayItem(player.field_71071_by.func_70440_f(3)) ? 1 : 0;
        return i += showEquippedItem && ArmorStatusHUD.canDisplayItem(player.func_71045_bC()) ? 1 : 0;
    }

    public static boolean canDisplayItem(ItemStack item) {
        return item != null;
    }

    private static void getHUDElements(Minecraft mc) {
        elements.clear();
        for (int i = 3; i >= -1; --i) {
            ItemStack itemStack = null;
            if (i == -1 && showEquippedItem) {
                itemStack = mc.field_71439_g.func_71045_bC();
            } else if (i != -1) {
                itemStack = mc.field_71439_g.field_71071_by.field_70460_b[i];
            }
            if (itemStack == null) continue;
            elements.add(new HUDElement(itemStack, 16, 16, 2, i > -1));
        }
    }

    private static int getElementsWidth() {
        int r = 0;
        for (HUDElement he : elements) {
            r += he.width();
        }
        return r;
    }

    private static void displayArmorStatus(Minecraft mc) {
        block2: {
            int yOffset;
            block3: {
                ArmorStatusHUD.getHUDElements(mc);
                if (elements.size() <= 0) break block2;
                int n = yOffset = enableItemName ? 18 : 16;
                if (!listMode.equalsIgnoreCase("vertical")) break block3;
                int yBase = ArmorStatusHUD.getY(elements.size(), yOffset);
                for (HUDElement e : elements) {
                    e.renderToHud(alignMode.toLowerCase().contains("right") ? ArmorStatusHUD.getX(0) : ArmorStatusHUD.getX(e.width()), yBase);
                    yBase += yOffset;
                }
                break block2;
            }
            if (!listMode.equalsIgnoreCase("horizontal")) break block2;
            int totalWidth = ArmorStatusHUD.getElementsWidth();
            int yBase = ArmorStatusHUD.getY(1, yOffset);
            int xBase = ArmorStatusHUD.getX(totalWidth);
            int prevX = 0;
            for (HUDElement e : elements) {
                e.renderToHud(xBase + prevX + (alignMode.toLowerCase().contains("right") ? e.width() : 0), yBase);
                prevX += e.width();
            }
        }
    }

    static {
        alignMode = alignModeDefault = "bottomleft";
        listMode = listModeDefault = "horizontal";
        enableItemName = enableItemNameDefault = false;
        showDamageOverlay = showDamageOverlayDefault = true;
        showItemCount = showItemCountDefault = true;
        damageColorList = damageColorListDefault = DEFAULT_COLOR_LIST;
        damageDisplayType = damageDisplayTypeDefault = "value";
        damageThresholdType = damageThresholdTypeDefault = "percent";
        showItemDamage = showItemDamageDefault = true;
        showArmorDamage = showArmorDamageDefault = true;
        showMaxDamage = showMaxDamageDefault = false;
        showEquippedItem = showEquippedItemDefault = true;
        xOffset = xOffsetDefault = 2;
        yOffset = yOffsetDefault = 2;
        yOffsetBottomCenter = yOffsetBottomCenterDefault = 41;
        applyXOffsetToCenter = applyXOffsetToCenterDefault = false;
        applyYOffsetToMiddle = applyYOffsetToMiddleDefault = false;
        showInChat = showInChatDefault = false;
        zLevel = -110.0f;
        colorList = new ArrayList<ColorThreshold>();
        elements = new ArrayList<HUDElement>();
        colorListPattern = Pattern.compile("([0-9]+,[0-9,a-f]{1}(;[ ]*|$))+");
    }
}

