/*
 * Decompiled with CFR 0.152.
 */
package realrender;

import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.AbstractClientPlayer;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.model.ModelPlayer;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.entity.RenderPlayer;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.client.event.RenderHandEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.client.registry.IRenderFactory;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.ModMetadata;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.registry.EntityRegistry;
import org.lwjgl.input.Keyboard;

@Mod(modid="rfpr", name="Real First-Person Render", version="8.1.1", acceptedMinecraftVersions="[1.9.4]")
public class REN {
    public static final String MODID = "rfpr";
    public static final String MODNAME = "Real First-Person Render";
    public static final String MODVER = "8.1.1";
    private static final REN instance = new REN();
    private static boolean itemDebug;
    private static float bodyOffset;
    private static int[] modes;
    private static boolean customItemOverride;
    private static boolean wasF1DownLastTick;
    private static byte currentMode;
    private static byte spawnDelay;
    private static EntityPlayerDummy dummy;
    private static String[] overrideItems;

    @Mod.EventHandler
    public void PreInit(FMLPreInitializationEvent event) {
        this.initModMetadata(event);
        RenderingRegistry.registerEntityRenderingHandler(EntityPlayerDummy.class, (IRenderFactory)new RENRenderingFactory(RenderPlayerDummy.class));
        Configuration config = new Configuration(event.getSuggestedConfigurationFile());
        config.load();
        overrideItems = config.get("general", "OverrideItems", new String[]{"map", "compass", "clock"}, "When these items are held, RFPR will temporally stop rendering.").getStringList();
        itemDebug = config.get("general", "ItemDebug", false, "Change this to true to have the log spit out what item your are holding.  \nUseful to find item names for the override list.").getBoolean();
        bodyOffset = (float)config.get("general", "RenderOffset", "0.35", "How far behind the player the body will render.").getDouble();
        modes = config.get("general", "Modes", new String[]{"111", "110", "011", "000", "001"}, "Mode IDs.  \nFirst number is whether to render arms in 3D or 2D mode.  \nSecond number is whether or not to render the body model.  \nThird number is whether or not to render the HUD.  \nAdd, delete, or change the order as you wish.  \nNOTE: Modes of type 1xx will NOT work with shaders!").getIntList();
        config.save();
    }

    @Mod.EventHandler
    public void Init(FMLInitializationEvent event) {
        MinecraftForge.EVENT_BUS.register((Object)instance);
        EntityRegistry.registerModEntity(EntityPlayerDummy.class, (String)"PlayerDummy", (int)0, (Object)MODID, (int)5, (int)100, (boolean)false);
    }

    private void initModMetadata(FMLPreInitializationEvent event) {
        ModMetadata meta = event.getModMetadata();
        meta.name = MODNAME;
        meta.description = "Small mod that adds in full-body rendering.";
        meta.authorList.clear();
        meta.authorList.add("don_bruce");
        meta.modId = MODID;
        meta.version = MODVER;
        meta.autogenerated = false;
    }

    @SubscribeEvent
    public void on(TickEvent.ClientTickEvent event) {
        if (event.phase.equals((Object)TickEvent.Phase.START)) {
            if (Keyboard.isKeyDown((int)59)) {
                if (!wasF1DownLastTick) {
                    currentMode = currentMode == modes.length - 1 ? (byte)0 : (byte)(currentMode + 1);
                }
                wasF1DownLastTick = true;
            } else {
                wasF1DownLastTick = false;
            }
            Minecraft.func_71410_x().field_71474_y.field_74319_N = modes[currentMode] % 10 != 1;
        }
        customItemOverride = false;
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        if (player != null) {
            if (player.field_71071_by.func_70448_g() != null) {
                for (String itemName : overrideItems) {
                    if (itemDebug) {
                        System.out.println(player.field_71071_by.func_70448_g().func_77977_a().substring(5));
                    }
                    if (!player.field_71071_by.func_70448_g().func_77977_a().substring(5).contains(itemName)) continue;
                    customItemOverride = true;
                    break;
                }
            }
            if (dummy == null) {
                if (spawnDelay == 0) {
                    dummy = new EntityPlayerDummy((World)Minecraft.func_71410_x().field_71441_e);
                    Minecraft.func_71410_x().field_71441_e.func_72838_d((Entity)dummy);
                    dummy.func_70080_a(player.field_70165_t, player.field_70163_u, player.field_70161_v, player.field_70177_z, player.field_70125_A);
                } else {
                    spawnDelay = (byte)(spawnDelay - 1);
                }
            } else if (REN.dummy.field_70170_p.field_73011_w.getDimension() != player.field_70170_p.field_73011_w.getDimension() || dummy.func_70068_e((Entity)player) > 5.0) {
                dummy.func_70106_y();
                dummy = null;
                spawnDelay = (byte)100;
            }
        }
    }

    @SubscribeEvent
    public void on(RenderHandEvent event) {
        event.setCanceled(modes[currentMode] / 100 == 1 && !customItemOverride);
    }

    static {
        currentMode = 0;
        spawnDelay = (byte)100;
    }

    public class RENRenderingFactory
    implements IRenderFactory {
        private final Class<? extends Render> entityRender;

        public RENRenderingFactory(Class<? extends Render> entityRender) {
            this.entityRender = entityRender;
        }

        public Render createRenderFor(RenderManager manager) {
            try {
                return this.entityRender.getConstructor(RenderManager.class).newInstance(manager);
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        }
    }

    public static class RenderPlayerDummy
    extends Render {
        public RenderPlayerDummy(RenderManager renderManager) {
            super(renderManager);
        }

        public void func_76986_a(Entity entity, double x, double y, double z, float yaw, float ticks) {
            if (Minecraft.func_71410_x().field_71474_y.field_74320_O == 0 && modes[currentMode] % 100 >= 10) {
                RenderPlayer render;
                EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
                if (player.func_184613_cA()) {
                    return;
                }
                RenderPlayer playerRenderer = render = (RenderPlayer)this.field_76990_c.func_78713_a((Entity)player);
                ModelPlayer playerModel = playerRenderer.func_177087_b();
                playerModel.field_78116_c.field_78807_k = true;
                playerModel.field_178720_f.field_78807_k = true;
                ItemStack tempStackMain = player.field_71071_by.func_70448_g();
                ItemStack tempStackSecond = player.field_71071_by.field_184439_c[0];
                if (modes[currentMode] / 100 != 1 || customItemOverride && modes[currentMode] % 10 == 1) {
                    player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, null);
                    player.field_71071_by.field_184439_c[0] = null;
                    playerModel.field_178724_i.field_78807_k = true;
                    playerModel.field_178723_h.field_78807_k = true;
                    playerModel.field_178734_a.field_78807_k = true;
                    playerModel.field_178732_b.field_78807_k = true;
                }
                ItemStack helmetStack = player.field_71071_by.field_70460_b[3];
                player.field_71071_by.field_70460_b[3] = null;
                if (player.func_70608_bn()) {
                    playerRenderer.func_76986_a((AbstractClientPlayer)player, player.field_70165_t - entity.field_70165_t + x, player.field_70163_u - entity.field_70163_u + y, player.field_70161_v - entity.field_70161_v + z, player.field_70761_aq, ticks);
                } else {
                    double renderOffset = player.field_70760_ar - (player.field_70760_ar - player.field_70761_aq) * ticks;
                    playerRenderer.func_76986_a((AbstractClientPlayer)player, player.field_70165_t - entity.field_70165_t + x + (double)bodyOffset * Math.sin(Math.toRadians(renderOffset)), player.field_70163_u - entity.field_70163_u + y, player.field_70161_v - entity.field_70161_v + z - (double)bodyOffset * Math.cos(Math.toRadians(renderOffset)), (float)renderOffset, ticks);
                }
                player.field_71071_by.field_70460_b[3] = helmetStack;
                playerModel.field_78116_c.field_78807_k = false;
                playerModel.field_178720_f.field_78807_k = false;
                if (modes[currentMode] / 100 != 1 || customItemOverride && modes[currentMode] % 10 == 1) {
                    player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, tempStackMain);
                    player.field_71071_by.field_184439_c[0] = tempStackSecond;
                    playerModel.field_178724_i.field_78807_k = false;
                    playerModel.field_178723_h.field_78807_k = false;
                    playerModel.field_178734_a.field_78807_k = false;
                    playerModel.field_178732_b.field_78807_k = false;
                }
            }
        }

        protected ResourceLocation func_110775_a(Entity entity) {
            return null;
        }
    }

    public class EntityPlayerDummy
    extends Entity {
        public EntityPlayerDummy(World world) {
            super(world);
            this.field_70158_ak = true;
            this.func_70105_a(0.0f, 2.0f);
        }

        public void func_70071_h_() {
            EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
            dummy.func_70080_a(player.field_70165_t, player.field_70163_u, player.field_70161_v, player.field_70177_z, player.field_70125_A);
        }

        protected void func_70088_a() {
        }

        protected void func_70037_a(NBTTagCompound p_70037_1_) {
        }

        protected void func_70014_b(NBTTagCompound p_70014_1_) {
        }
    }
}

