/*
 * Decompiled with CFR 0.152.
 */
package net.fybertech.redstonepaste;

import java.util.List;
import java.util.Random;
import net.fybertech.redstonepaste.RedstonePasteMod;
import net.fybertech.redstonepaste.RedstonePasteUtils;
import net.fybertech.redstonepaste.TileEntityRedstonePaste;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.BlockRedstoneRepeater;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemSlab;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockRedstonePaste
extends BlockContainer {
    private boolean pasteProvidesPower;
    public static boolean rayTracing;
    public static int rayTracing2;

    protected BlockRedstonePaste() {
        super(Material.field_151594_q);
        this.func_149647_a(CreativeTabs.field_78028_d);
        this.func_149663_c("redstonepaste");
        rayTracing = false;
        rayTracing2 = -1;
        this.func_149711_c(-1.0f);
        this.pasteProvidesPower = true;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public int func_176211_b(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        return this.func_180656_a(blockState, blockAccess, pos, side);
    }

    private boolean pasteConnectedTo_OnFace(int[] terpfaces, int dir, int face) {
        return this.pasteConnectedTo_OnFace(terpfaces, dir, face, true);
    }

    private boolean pasteConnectedTo_OnFace(int[] terpfaces, int dir, int face, boolean includefaces) {
        switch (dir) {
            case 1: {
                if (terpfaces[1] > 0 && face == 1 && includefaces) {
                    return true;
                }
                if ((terpfaces[2] & 2) > 0 && face == 2) {
                    return true;
                }
                if ((terpfaces[3] & 2) > 0 && face == 3) {
                    return true;
                }
                if ((terpfaces[4] & 2) > 0 && face == 4) {
                    return true;
                }
                if ((terpfaces[5] & 2) <= 0 || face != 5) break;
                return true;
            }
            case 0: {
                if (terpfaces[0] > 0 && face == 0 && includefaces) {
                    return true;
                }
                if ((terpfaces[2] & 1) > 0 && face == 2) {
                    return true;
                }
                if ((terpfaces[3] & 1) > 0 && face == 3) {
                    return true;
                }
                if ((terpfaces[4] & 1) > 0 && face == 4) {
                    return true;
                }
                if ((terpfaces[5] & 1) <= 0 || face != 5) break;
                return true;
            }
            case 2: {
                if (terpfaces[2] > 0 && face == 2 && includefaces) {
                    return true;
                }
                if ((terpfaces[0] & 1) > 0 && face == 0) {
                    return true;
                }
                if ((terpfaces[1] & 1) > 0 && face == 1) {
                    return true;
                }
                if ((terpfaces[4] & 4) > 0 && face == 4) {
                    return true;
                }
                if ((terpfaces[5] & 4) <= 0 || face != 5) break;
                return true;
            }
            case 3: {
                if (terpfaces[3] > 0 && face == 3 && includefaces) {
                    return true;
                }
                if ((terpfaces[0] & 2) > 0 && face == 0) {
                    return true;
                }
                if ((terpfaces[1] & 2) > 0 && face == 1) {
                    return true;
                }
                if ((terpfaces[4] & 8) > 0 && face == 4) {
                    return true;
                }
                if ((terpfaces[5] & 8) <= 0 || face != 5) break;
                return true;
            }
            case 4: {
                if (terpfaces[4] > 0 && face == 4 && includefaces) {
                    return true;
                }
                if ((terpfaces[0] & 4) > 0 && face == 0) {
                    return true;
                }
                if ((terpfaces[1] & 4) > 0 && face == 1) {
                    return true;
                }
                if ((terpfaces[2] & 4) > 0 && face == 2) {
                    return true;
                }
                if ((terpfaces[3] & 4) <= 0 || face != 3) break;
                return true;
            }
            case 5: {
                if (terpfaces[5] > 0 && face == 5 && includefaces) {
                    return true;
                }
                if ((terpfaces[0] & 8) > 0 && face == 0) {
                    return true;
                }
                if ((terpfaces[1] & 8) > 0 && face == 1) {
                    return true;
                }
                if ((terpfaces[2] & 8) > 0 && face == 2) {
                    return true;
                }
                if ((terpfaces[3] & 8) <= 0 || face != 3) break;
                return true;
            }
            case -1: {
                return true;
            }
        }
        return false;
    }

    private boolean pasteConnectedTo(int[] terpfaces, int dir) {
        switch (dir) {
            case 1: {
                if (terpfaces[1] > 0) {
                    return true;
                }
                if ((terpfaces[2] & 2) > 0) {
                    return true;
                }
                if ((terpfaces[3] & 2) > 0) {
                    return true;
                }
                if ((terpfaces[4] & 2) > 0) {
                    return true;
                }
                if ((terpfaces[5] & 2) <= 0) break;
                return true;
            }
            case 0: {
                if (terpfaces[0] > 0) {
                    return true;
                }
                if ((terpfaces[2] & 1) > 0) {
                    return true;
                }
                if ((terpfaces[3] & 1) > 0) {
                    return true;
                }
                if ((terpfaces[4] & 1) > 0) {
                    return true;
                }
                if ((terpfaces[5] & 1) <= 0) break;
                return true;
            }
            case 2: {
                if (terpfaces[2] > 0) {
                    return true;
                }
                if ((terpfaces[0] & 1) > 0) {
                    return true;
                }
                if ((terpfaces[1] & 1) > 0) {
                    return true;
                }
                if ((terpfaces[4] & 4) > 0) {
                    return true;
                }
                if ((terpfaces[5] & 4) <= 0) break;
                return true;
            }
            case 3: {
                if (terpfaces[3] > 0) {
                    return true;
                }
                if ((terpfaces[0] & 2) > 0) {
                    return true;
                }
                if ((terpfaces[1] & 2) > 0) {
                    return true;
                }
                if ((terpfaces[4] & 8) > 0) {
                    return true;
                }
                if ((terpfaces[5] & 8) <= 0) break;
                return true;
            }
            case 4: {
                if (terpfaces[4] > 0) {
                    return true;
                }
                if ((terpfaces[0] & 4) > 0) {
                    return true;
                }
                if ((terpfaces[1] & 4) > 0) {
                    return true;
                }
                if ((terpfaces[2] & 4) > 0) {
                    return true;
                }
                if ((terpfaces[3] & 4) <= 0) break;
                return true;
            }
            case 5: {
                if (terpfaces[5] > 0) {
                    return true;
                }
                if ((terpfaces[0] & 8) > 0) {
                    return true;
                }
                if ((terpfaces[1] & 8) > 0) {
                    return true;
                }
                if ((terpfaces[2] & 8) > 0) {
                    return true;
                }
                if ((terpfaces[3] & 8) <= 0) break;
                return true;
            }
            case -1: {
                return true;
            }
        }
        return false;
    }

    public static int repeaterDirectionToWorldDirection(int face, int data) {
        data &= 3;
        switch (face) {
            case 0: 
            case 1: {
                switch (data) {
                    case 0: {
                        return 3;
                    }
                    case 1: {
                        return 4;
                    }
                    case 2: {
                        return 2;
                    }
                    case 3: {
                        return 5;
                    }
                }
                break;
            }
            case 2: 
            case 3: {
                switch (data) {
                    case 0: {
                        return 1;
                    }
                    case 1: {
                        return 4;
                    }
                    case 2: {
                        return 0;
                    }
                    case 3: {
                        return 5;
                    }
                }
                break;
            }
            case 4: 
            case 5: {
                switch (data) {
                    case 0: {
                        return 1;
                    }
                    case 1: {
                        return 2;
                    }
                    case 2: {
                        return 0;
                    }
                    case 3: {
                        return 3;
                    }
                }
            }
        }
        return -1;
    }

    public int func_180656_a(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        int opposite;
        int par2 = pos.func_177958_n();
        int par3 = pos.func_177956_o();
        int par4 = pos.func_177952_p();
        int par5 = side.ordinal();
        TileEntity te = blockAccess.func_175625_s(pos);
        if (!(te instanceof TileEntityRedstonePaste)) {
            return 0;
        }
        int powerout = 0;
        TileEntityRedstonePaste terp = (TileEntityRedstonePaste)te;
        if (par5 >= 0 && par5 <= 5) {
            int oppositeFace = Facing.oppositeSide[par5];
            if (terp.facetype[oppositeFace] == 0 && terp.faces[oppositeFace] > 0) {
                powerout = terp.facedata[oppositeFace];
            }
            for (int dir = 0; dir < 6; ++dir) {
                if (dir == par5 || dir == oppositeFace || terp.facetype[dir] != 0 || terp.faces[dir] == 0 || terp.facedata[dir] <= powerout || !this.pasteConnectedTo_OnFace(terp.faces, oppositeFace, dir, false)) continue;
                powerout = terp.facedata[dir];
            }
        }
        if (par5 >= 0 && par5 <= 5 && blockAccess.func_180495_p(new BlockPos(par2 + Facing.offsetsXForSide[opposite = Facing.oppositeSide[par5]], par3 + Facing.offsetsYForSide[opposite], par4 + Facing.offsetsZForSide[opposite])).func_177230_c() == Blocks.field_150488_af) {
            --powerout;
        }
        boolean foundRepeater = false;
        for (int n = 0; n < 6; ++n) {
            int comparatorpower;
            if (par5 == -1) continue;
            int opposite2 = Facing.oppositeSide[par5];
            int worlddir = BlockRedstonePaste.repeaterDirectionToWorldDirection(n, terp.facedata[n]);
            if (worlddir != opposite2) continue;
            if (terp.facetype[n] == 2) {
                if ((terp.facedata[n] & 4) <= 0) continue;
                powerout = 15;
                foundRepeater = true;
                continue;
            }
            if (terp.facetype[n] != 3 || (comparatorpower = (terp.facedata[n] & 0x78) >> 3) <= 0) continue;
            powerout = comparatorpower;
            foundRepeater = true;
        }
        if (powerout < 0) {
            powerout = 0;
        }
        if (powerout > 15) {
            powerout = 15;
        }
        return !this.pasteProvidesPower && !foundRepeater ? 0 : powerout;
    }

    public static void notifyNeighborCube(World world, int x, int y, int z, Block block) {
        BlockPos pos = new BlockPos(x, y, z);
        BlockPos up = pos.func_177984_a();
        BlockPos down = pos.func_177984_a();
        BlockPos west = pos.func_177976_e();
        BlockPos east = pos.func_177974_f();
        world.func_180496_d(pos, block);
        world.func_180496_d(down, block);
        world.func_180496_d(up, block);
        world.func_180496_d(pos.func_177978_c(), block);
        world.func_180496_d(pos.func_177968_d(), block);
        world.func_180496_d(west, block);
        world.func_180496_d(east, block);
        world.func_180496_d(up.func_177978_c(), block);
        world.func_180496_d(up.func_177968_d(), block);
        world.func_180496_d(down.func_177978_c(), block);
        world.func_180496_d(down.func_177968_d(), block);
        world.func_180496_d(west.func_177977_b(), block);
        world.func_180496_d(west.func_177984_a(), block);
        world.func_180496_d(west.func_177978_c(), block);
        world.func_180496_d(west.func_177968_d(), block);
        world.func_180496_d(east.func_177977_b(), block);
        world.func_180496_d(east.func_177984_a(), block);
        world.func_180496_d(east.func_177978_c(), block);
        world.func_180496_d(east.func_177968_d(), block);
    }

    private void dropPasteFace(World world, int x, int y, int z, int faceclicked) {
        BlockPos pos = new BlockPos(x, y, z);
        TileEntityRedstonePaste terp = (TileEntityRedstonePaste)world.func_175625_s(pos);
        if (terp == null) {
            return;
        }
        int face = terp.faces[faceclicked];
        int pieces = 0;
        if ((face & 1) > 0) {
            ++pieces;
        }
        if ((face & 2) > 0) {
            ++pieces;
        }
        if ((face & 4) > 0) {
            ++pieces;
        }
        if ((face & 8) > 0) {
            ++pieces;
        }
        terp.faces[faceclicked] = 0;
        ItemStack stack = new ItemStack((Block)this, pieces);
        this.dropBlockAsItem(world, x, y, z, stack);
        IBlockState state = world.func_180495_p(pos);
        if (!BlockRedstonePaste.destroyBlockIfEmpty(world, new BlockPos(x, y, z))) {
            world.func_184138_a(pos, state, state, 3);
        }
        BlockRedstonePaste.notifyNeighborCube(world, x, y, z, (Block)RedstonePasteMod.instance.blockRedstonePaste);
    }

    private void dropBlockAsItem(World worldIn, int x, int y, int z, ItemStack stack) {
        if (!worldIn.field_72995_K && !worldIn.restoringBlockSnapshots) {
            BlockRedstonePaste.func_180635_a((World)worldIn, (BlockPos)new BlockPos(x, y, z), (ItemStack)stack);
        }
    }

    private void dropFace(World world, int x, int y, int z, int faceclicked) {
        BlockPos pos = new BlockPos(x, y, z);
        TileEntityRedstonePaste terp = (TileEntityRedstonePaste)world.func_175625_s(pos);
        if (terp == null) {
            return;
        }
        switch (terp.facetype[faceclicked]) {
            case 0: {
                int face = terp.faces[faceclicked];
                int pieces = 0;
                if ((face & 1) > 0) {
                    ++pieces;
                }
                if ((face & 2) > 0) {
                    ++pieces;
                }
                if ((face & 4) > 0) {
                    ++pieces;
                }
                if ((face & 8) > 0) {
                    ++pieces;
                }
                terp.faces[faceclicked] = 0;
                ItemStack stack = new ItemStack((Block)this, pieces);
                this.dropBlockAsItem(world, x, y, z, stack);
                break;
            }
            case 2: {
                terp.facetype[faceclicked] = 0;
                terp.facedata[faceclicked] = 0;
                ItemStack stack = new ItemStack(RedstonePasteMod.instance.itemStickyRepeater, 1);
                this.dropBlockAsItem(world, x, y, z, stack);
                break;
            }
            case 3: {
                terp.facetype[faceclicked] = 0;
                terp.facedata[faceclicked] = 0;
                ItemStack stack = new ItemStack(RedstonePasteMod.instance.itemStickyComparator, 1);
                this.dropBlockAsItem(world, x, y, z, stack);
            }
        }
        terp.func_70296_d();
        if (!BlockRedstonePaste.destroyBlockIfEmpty(world, pos)) {
            IBlockState state = world.func_180495_p(pos);
            world.func_184138_a(pos, state, state, 3);
        }
        BlockRedstonePaste.notifyNeighborCube(world, x, y, z, (Block)RedstonePasteMod.instance.blockRedstonePaste);
    }

    public boolean getWeakChanges(IBlockAccess world, BlockPos pos) {
        return true;
    }

    private void neighborChange(World par1World, int par2, int par3, int par4) {
        TileEntity te;
        if (!par1World.field_72995_K && (te = par1World.func_175625_s(new BlockPos(par2, par3, par4))) != null && te instanceof TileEntityRedstonePaste) {
            TileEntityRedstonePaste terp = (TileEntityRedstonePaste)te;
            boolean repeaterActive = false;
            for (int n = 0; n < 6; ++n) {
                int x = par2 + Facing.offsetsXForSide[n];
                int y = par3 + Facing.offsetsYForSide[n];
                int z = par4 + Facing.offsetsZForSide[n];
                boolean solid = par1World.isSideSolid(new BlockPos(x, y, z), EnumFacing.values()[n].func_176734_d());
                if (!solid && terp.faces[n] > 0) {
                    this.dropPasteFace(par1World, par2, par3, par4, n);
                }
                if (!solid && terp.facetype[n] == 2) {
                    this.dropFace(par1World, par2, par3, par4, n);
                }
                if (solid || terp.facetype[n] != 3) continue;
                this.dropFace(par1World, par2, par3, par4, n);
            }
            this.propagateSignal(par1World, par2, par3, par4);
        }
    }

    public void onNeighborChange(IBlockAccess world, BlockPos pos, BlockPos neighbor) {
        Block block = world.func_180495_p(pos).func_177230_c();
        if (block == this) {
            TileEntity te = world.func_175625_s(pos);
            if (te == null) {
                return;
            }
            World w = world.func_175625_s(pos).func_145831_w();
            if (w == null) {
                return;
            }
            this.neighborChange(w, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
        }
    }

    public void func_176204_a(World worldIn, BlockPos pos, IBlockState state, Block neighborBlock) {
        this.neighborChange(worldIn, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
        super.func_176204_a(worldIn, pos, state, neighborBlock);
    }

    private int getMaxCurrentStrength(World par1World, int par2, int par3, int par4, int par5, int dir) {
        BlockPos blockPos = new BlockPos(par2, par3, par4);
        IBlockState blockState = par1World.func_180495_p(blockPos);
        Block bID = blockState.func_177230_c();
        if (bID == RedstonePasteMod.instance.blockRedstonePaste) {
            int pwr = this.func_180656_a(blockState, (IBlockAccess)par1World, blockPos, EnumFacing.values()[dir]);
            return pwr > par5 ? pwr : par5;
        }
        if (bID == Blocks.field_150488_af && (dir == -1 || dir >= 2)) {
            int pwr = bID.func_176201_c(par1World.func_180495_p(new BlockPos(par2, par3, par4)));
            return pwr > par5 ? pwr : par5;
        }
        return par5;
    }

    private int isBlockProvidingPowerTo_NoWire(World world, int par1, int par2, int par3, int par4) {
        BlockPos blockPos = new BlockPos(par1, par2, par3);
        IBlockState state = world.func_180495_p(blockPos);
        Block i1 = state.func_177230_c();
        if (i1 == Blocks.field_150488_af) {
            return 0;
        }
        return i1 == null || i1 == Blocks.field_150350_a ? 0 : i1.func_176211_b(state, (IBlockAccess)world, blockPos, EnumFacing.values()[par4]);
    }

    private int getBlockPowerInput_NoWire(World world, int par1, int par2, int par3) {
        int b0 = 0;
        int l = Math.max(b0, this.isBlockProvidingPowerTo_NoWire(world, par1, par2 - 1, par3, 0));
        if (l >= 15) {
            return l;
        }
        if ((l = Math.max(l, this.isBlockProvidingPowerTo_NoWire(world, par1, par2 + 1, par3, 1))) >= 15) {
            return l;
        }
        if ((l = Math.max(l, this.isBlockProvidingPowerTo_NoWire(world, par1, par2, par3 - 1, 2))) >= 15) {
            return l;
        }
        if ((l = Math.max(l, this.isBlockProvidingPowerTo_NoWire(world, par1, par2, par3 + 1, 3))) >= 15) {
            return l;
        }
        if ((l = Math.max(l, this.isBlockProvidingPowerTo_NoWire(world, par1 - 1, par2, par3, 4))) >= 15) {
            return l;
        }
        return (l = Math.max(l, this.isBlockProvidingPowerTo_NoWire(world, par1 + 1, par2, par3, 5))) >= 15 ? l : l;
    }

    private int getIndirectPowerLevelTo_NoWire(World par1World, int par1, int par2, int par3, int par4) {
        if (par1World.func_175677_d(new BlockPos(par1, par2, par3), false)) {
            return this.getBlockPowerInput_NoWire(par1World, par1, par2, par3);
        }
        BlockPos pos = new BlockPos(par1, par2, par3);
        IBlockState state = par1World.func_180495_p(pos);
        Block i1 = state.func_177230_c();
        if (i1 == this || i1 == Blocks.field_150488_af) {
            return 0;
        }
        return i1 == null || i1 == Blocks.field_150350_a ? 0 : i1.func_180656_a(state, (IBlockAccess)par1World, pos, EnumFacing.values()[par4]);
    }

    public void func_180650_b(World worldIn, BlockPos pos, IBlockState state, Random rand) {
        int newdata;
        int repeaterinput;
        int dir;
        TileEntity te = worldIn.func_175625_s(pos);
        if (te == null || !(te instanceof TileEntityRedstonePaste)) {
            return;
        }
        TileEntityRedstonePaste terp = (TileEntityRedstonePaste)te;
        for (dir = 0; dir < 6; ++dir) {
            if (terp.facetype[dir] != 2 || this.isRepeaterLocked((IBlockAccess)worldIn, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p())) continue;
            repeaterinput = this.getRepeaterInput(worldIn, dir, terp.facedata[dir], pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
            boolean repeaterActive = (terp.facedata[dir] & 4) > 1;
            int previousdata = terp.facedata[dir];
            newdata = terp.facedata[dir];
            newdata = repeaterinput > 0 ? (newdata |= 4) : (newdata &= 0xFFFFFFFB);
            if (!repeaterActive) {
                int[] delays = new int[]{2, 4, 6, 8};
                int delay = delays[((newdata |= 4) & 0x18) >> 3];
                worldIn.func_175654_a(pos, (Block)this, delay, -1);
            }
            if (previousdata == newdata) continue;
            terp.facedata[dir] = newdata;
            worldIn.func_184138_a(pos, state, state, 3);
            BlockRedstonePaste.notifyNeighborCube(worldIn, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), (Block)RedstonePasteMod.instance.blockRedstonePaste);
        }
        for (dir = 0; dir < 6; ++dir) {
            if (terp.facetype[dir] != 3) continue;
            repeaterinput = this.getRepeaterInput(worldIn, dir, terp.facedata[dir], pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), true);
            int sideinput = this.getSideInput(worldIn, dir, terp.facedata[dir], pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
            int comparatormode = (terp.facedata[dir] & 4) >> 2;
            if (comparatormode == 0) {
                if (repeaterinput < sideinput) {
                    repeaterinput = 0;
                }
            } else if ((repeaterinput -= sideinput) < 0) {
                repeaterinput = 0;
            }
            int previousdata = newdata = terp.facedata[dir];
            newdata &= 0xFFFFFF87;
            if (previousdata == (newdata |= repeaterinput << 3)) continue;
            terp.facedata[dir] = newdata;
            worldIn.func_184138_a(pos, state, state, 3);
            BlockRedstonePaste.notifyNeighborCube(worldIn, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), (Block)RedstonePasteMod.instance.blockRedstonePaste);
        }
    }

    boolean isRepeaterLocked(IBlockAccess world, int x, int y, int z) {
        TileEntityRedstonePaste terp = (TileEntityRedstonePaste)world.func_175625_s(new BlockPos(x, y, z));
        if (terp == null) {
            return false;
        }
        int repeaterFace = -1;
        for (int n = 0; n < 6; ++n) {
            if (terp.facetype[n] != 2) continue;
            repeaterFace = n;
            break;
        }
        if (repeaterFace == -1) {
            return false;
        }
        int repeaterDir = terp.facedata[repeaterFace] & 3;
        int worlddir = BlockRedstonePaste.repeaterDirectionToWorldDirection(repeaterFace, terp.facedata[repeaterFace]);
        int worldside = BlockRedstonePaste.repeaterDirectionToWorldDirection(repeaterFace, terp.facedata[repeaterFace] + 1);
        for (int n = 0; n < 2; ++n) {
            int worlddir2;
            TileEntityRedstonePaste terp2;
            int z2;
            int y2;
            int currentside = n == 0 ? worldside : EnumFacing.values()[worldside].func_176734_d().ordinal();
            int x2 = x + EnumFacing.values()[currentside].func_82601_c();
            Block bID = world.func_180495_p(new BlockPos(x2, y2 = y + EnumFacing.values()[currentside].func_96559_d(), z2 = z + EnumFacing.values()[currentside].func_82599_e())).func_177230_c();
            if (bID == Blocks.field_150416_aS && repeaterFace == 0) {
                boolean metadir = false;
                int metaworlddir = 0;
                EnumFacing facing = (EnumFacing)world.func_180495_p(new BlockPos(x2, y2, z2)).func_177229_b((IProperty)BlockRedstoneRepeater.field_185512_D);
                metaworlddir = facing.ordinal();
                if (currentside != metaworlddir) continue;
                return true;
            }
            if (bID != this || (terp2 = (TileEntityRedstonePaste)world.func_175625_s(new BlockPos(x2, y2, z2))) == null || terp2.facetype[repeaterFace] != 2 || (terp2.facedata[repeaterFace] & 4) == 0 || (worlddir2 = BlockRedstonePaste.repeaterDirectionToWorldDirection(repeaterFace, terp2.facedata[repeaterFace])) == -1 || currentside != EnumFacing.values()[worlddir2].func_176734_d().ordinal()) continue;
            return true;
        }
        return false;
    }

    private int getRepeaterInput(World world, int dir, int facedata, int x, int y, int z) {
        return this.getRepeaterInput2(world, dir, BlockRedstonePaste.repeaterDirectionToWorldDirection(dir, facedata), x, y, z, false);
    }

    private int getRepeaterInput(World world, int dir, int facedata, int x, int y, int z, boolean isComparator) {
        return this.getRepeaterInput2(world, dir, BlockRedstonePaste.repeaterDirectionToWorldDirection(dir, facedata), x, y, z, isComparator);
    }

    private int getRepeaterInput2(World world, int dir, int worlddir, int x, int y, int z, boolean isComparator) {
        int oppositeSide = Facing.oppositeSide[worlddir];
        int newx = x + EnumFacing.values()[oppositeSide].func_82601_c();
        int newy = y + EnumFacing.values()[oppositeSide].func_96559_d();
        int newz = z + EnumFacing.values()[oppositeSide].func_82599_e();
        int repeaterinput = 0;
        BlockPos newPos = new BlockPos(newx, newy, newz);
        IBlockState newState = world.func_180495_p(newPos);
        Block bID = newState.func_177230_c();
        if (bID != this) {
            Block b = bID;
            if (b != null && b.func_149740_M(newState) && isComparator) {
                repeaterinput = b.func_180641_l(newState, world, newPos);
            } else {
                repeaterinput = world.func_175651_c(newPos, EnumFacing.values()[oppositeSide]);
                repeaterinput = this.getMaxCurrentStrength(world, newx, newy, newz, repeaterinput, oppositeSide);
            }
        } else {
            TileEntityRedstonePaste terp2 = (TileEntityRedstonePaste)world.func_175625_s(newPos);
            if (terp2 != null) {
                int worlddir2;
                if (terp2.facetype[dir] == 0) {
                    repeaterinput = this.getPasteStrengthToDir_OnFace(terp2, worlddir, dir);
                } else if (terp2.facetype[dir] == 2) {
                    int worlddir22 = BlockRedstonePaste.repeaterDirectionToWorldDirection(dir, terp2.facedata[dir]);
                    if (worlddir22 == worlddir && (terp2.facedata[dir] & 4) > 0) {
                        repeaterinput = 15;
                    }
                } else if (terp2.facetype[dir] == 3 && (worlddir2 = BlockRedstonePaste.repeaterDirectionToWorldDirection(dir, terp2.facedata[dir])) == worlddir) {
                    repeaterinput = (terp2.facedata[dir] & 0x78) >> 3;
                }
            }
        }
        return repeaterinput;
    }

    private int getSideInput(World world, int dir, int facedata, int x, int y, int z) {
        TileEntityRedstonePaste terp = (TileEntityRedstonePaste)world.func_175625_s(new BlockPos(x, y, z));
        if (terp == null) {
            return 0;
        }
        int repeaterFace = -1;
        for (int n = 0; n < 6; ++n) {
            if (terp.facetype[n] != 3) continue;
            repeaterFace = n;
            break;
        }
        if (repeaterFace == -1) {
            return 0;
        }
        int repeaterDir = terp.facedata[repeaterFace] & 3;
        int worlddir = BlockRedstonePaste.repeaterDirectionToWorldDirection(repeaterFace, terp.facedata[repeaterFace]);
        int worldside = BlockRedstonePaste.repeaterDirectionToWorldDirection(repeaterFace, terp.facedata[repeaterFace] + 1);
        int sideinput = 0;
        for (int n = 0; n < 2; ++n) {
            int currentside = n == 0 ? worldside : Facing.oppositeSide[worldside];
            int x2 = x + EnumFacing.values()[currentside].func_82601_c();
            int y2 = y + EnumFacing.values()[currentside].func_96559_d();
            int z2 = z + EnumFacing.values()[currentside].func_82599_e();
            int thisinput = this.getRepeaterInput2(world, dir, EnumFacing.values()[currentside].func_176734_d().ordinal(), x, y, z, true);
            if (thisinput <= sideinput) continue;
            sideinput = thisinput;
        }
        return sideinput;
    }

    private int getPasteStrengthToDir_OnFace(TileEntityRedstonePaste terp, int dir, int face) {
        int powerout = 0;
        if (terp.facetype[dir] == 0 && terp.faces[dir] > 0) {
            powerout = terp.facedata[dir];
        }
        if (this.pasteConnectedTo_OnFace(terp.faces, dir, face, false)) {
            powerout = Math.max(powerout, terp.facedata[face]);
        }
        return powerout;
    }

    private void propagateSignal(World world, int x, int y, int z) {
        int dir;
        int repeaterinput;
        int dir2;
        boolean power = false;
        int indirectpower = 0;
        int newstrength = 0;
        int outstrength = 0;
        BlockPos blockPos = new BlockPos(x, y, z);
        TileEntityRedstonePaste terp = (TileEntityRedstonePaste)world.func_175625_s(blockPos);
        if (terp == null) {
            return;
        }
        for (dir2 = 0; dir2 < 6; ++dir2) {
            if (terp.facetype[dir2] != 2 || this.isRepeaterLocked((IBlockAccess)world, x, y, z)) continue;
            repeaterinput = this.getRepeaterInput(world, dir2, terp.facedata[dir2], x, y, z);
            int previousdata = terp.facedata[dir2];
            int newdata = terp.facedata[dir2];
            newdata = repeaterinput > 0 ? (newdata |= 4) : (newdata &= 0xFFFFFFFB);
            int[] delays = new int[]{2, 4, 6, 8};
            int delay = delays[(newdata & 0x18) >> 3];
            if (previousdata == newdata || world.func_175691_a(blockPos, (Block)this)) continue;
            world.func_175654_a(blockPos, (Block)this, delay, -1);
        }
        for (dir2 = 0; dir2 < 6; ++dir2) {
            if (terp.facetype[dir2] != 3) continue;
            repeaterinput = this.getRepeaterInput(world, dir2, terp.facedata[dir2], x, y, z, true);
            int sideinput = this.getSideInput(world, dir2, terp.facedata[dir2], x, y, z);
            int comparatormode = (terp.facedata[dir2] & 4) >> 2;
            if (comparatormode == 0) {
                if (repeaterinput < sideinput) {
                    repeaterinput = 0;
                }
            } else if ((repeaterinput -= sideinput) < 0) {
                repeaterinput = 0;
            }
            int previousdata = terp.facedata[dir2];
            int newdata = terp.facedata[dir2];
            newdata &= 0xFFFFFF87;
            int delay = 2;
            if (previousdata == (newdata |= repeaterinput << 3) || world.func_175691_a(blockPos, (Block)this)) continue;
            world.func_175654_a(blockPos, (Block)this, delay, -1);
        }
        boolean facestrengthchanged = false;
        NeighborBlock[] neighbors = new NeighborBlock[6];
        for (dir = 0; dir < 6; ++dir) {
            int newx = x + Facing.offsetsXForSide[dir];
            int newy = y + Facing.offsetsYForSide[dir];
            int newz = z + Facing.offsetsZForSide[dir];
            neighbors[dir] = new NeighborBlock(world, newx, newy, newz);
        }
        for (dir = 0; dir < 6; ++dir) {
            if (terp.facetype[dir] != 0 || terp.faces[dir] == 0) continue;
            newstrength = 0;
            indirectpower = 0;
            NeighborBlock neighbor = neighbors[dir];
            if (neighbor.blockID != this) {
                indirectpower = neighbor.getMaxIndirectPower(indirectpower, Facing.oppositeSide[dir]);
                newstrength = neighbor.getMaxPower(newstrength, Facing.oppositeSide[dir]);
            }
            for (int thisdir = 0; thisdir < 6; ++thisdir) {
                int worlddir;
                if (thisdir == dir || thisdir == Facing.oppositeSide[dir] || !this.pasteConnectedTo_OnFace(terp.faces, thisdir, dir, false)) continue;
                if (this.pasteConnectedTo_OnFace(terp.faces, dir, thisdir, false)) {
                    newstrength = Math.max(newstrength, terp.facedata[thisdir]);
                }
                if (neighbors[thisdir].blockID != this) {
                    indirectpower = neighbors[thisdir].getMaxIndirectPower(indirectpower, Facing.oppositeSide[thisdir]);
                    newstrength = neighbors[thisdir].getMaxPower(newstrength, Facing.oppositeSide[thisdir]);
                    continue;
                }
                TileEntityRedstonePaste terp2 = neighbors[thisdir].terp;
                if (terp2.facetype[dir] == 0) {
                    newstrength = Math.max(newstrength, this.getPasteStrengthToDir_OnFace(terp2, Facing.oppositeSide[thisdir], dir));
                    continue;
                }
                if (terp2.facetype[dir] == 2) {
                    worlddir = BlockRedstonePaste.repeaterDirectionToWorldDirection(dir, terp2.facedata[dir]);
                    if (worlddir != Facing.oppositeSide[thisdir] || (terp2.facedata[dir] & 4) <= 0) continue;
                    indirectpower = 15;
                    continue;
                }
                if (terp2.facetype[dir] != 3 || (worlddir = BlockRedstonePaste.repeaterDirectionToWorldDirection(dir, terp2.facedata[dir])) != Facing.oppositeSide[thisdir]) continue;
                indirectpower = Math.max(indirectpower, (terp2.facedata[dir] & 0x78) >> 3);
            }
            for (int dir22 = 0; dir22 < 6; ++dir22) {
                TileEntityRedstonePaste terp2;
                int sidez;
                int sidey;
                int sidex;
                if (dir22 == dir || dir22 == Facing.oppositeSide[dir] || world.func_175677_d(new BlockPos(neighbors[dir22].x, neighbors[dir22].y, neighbors[dir22].z), false) || !this.pasteConnectedTo_OnFace(terp.faces, dir22, dir) || world.func_180495_p(new BlockPos(sidex = neighbor.x + Facing.offsetsXForSide[dir22], sidey = neighbor.y + Facing.offsetsYForSide[dir22], sidez = neighbor.z + Facing.offsetsZForSide[dir22])).func_177230_c() != this || (terp2 = (TileEntityRedstonePaste)world.func_175625_s(new BlockPos(sidex, sidey, sidez))) == null || !this.pasteConnectedTo_OnFace(terp2.faces, Facing.oppositeSide[dir], Facing.oppositeSide[dir22])) continue;
                newstrength = Math.max(newstrength, this.getPasteStrengthToDir_OnFace(terp2, Facing.oppositeSide[dir], Facing.oppositeSide[dir22]));
            }
            outstrength = newstrength > indirectpower ? newstrength - 1 : indirectpower;
            if (outstrength < 0) {
                outstrength = 0;
            }
            if (outstrength > 15) {
                outstrength = 15;
            }
            if (terp.facedata[dir] == outstrength) continue;
            terp.facedata[dir] = outstrength;
            facestrengthchanged = true;
        }
        if (facestrengthchanged) {
            IBlockState state = world.func_180495_p(blockPos);
            world.func_184138_a(blockPos, state, state, 3);
            BlockRedstonePaste.notifyNeighborCube(world, x, y, z, (Block)RedstonePasteMod.instance.blockRedstonePaste);
        }
    }

    public boolean func_149744_f(IBlockState state) {
        return this.pasteProvidesPower;
    }

    public boolean canConnectRedstone(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing face) {
        int side = face == null ? -1 : face.ordinal();
        TileEntity te = world.func_175625_s(pos);
        if (te != null && te instanceof TileEntityRedstonePaste) {
            boolean powerout = false;
            TileEntityRedstonePaste terp = (TileEntityRedstonePaste)te;
            if (terp.facetype[0] == 2) {
                int worldside;
                int worlddir = BlockRedstonePaste.repeaterDirectionToWorldDirection(0, terp.facedata[0]);
                int n = worldside = side == -1 ? 1 : side;
                return worlddir == worldside || Facing.oppositeSide[worlddir] == worldside;
            }
            if (terp.facetype[0] == 3) {
                return true;
            }
            switch (side) {
                case 3: {
                    if ((terp.faces[0] & 1) != 1) break;
                    powerout = true;
                    break;
                }
                case 2: {
                    if ((terp.faces[0] & 2) != 2) break;
                    powerout = true;
                    break;
                }
                case 5: {
                    if ((terp.faces[0] & 4) != 4) break;
                    powerout = true;
                    break;
                }
                case 4: {
                    if ((terp.faces[0] & 8) != 8) break;
                    powerout = true;
                }
            }
            return powerout;
        }
        return false;
    }

    public void func_180663_b(World worldIn, BlockPos pos, IBlockState state) {
        super.func_180663_b(worldIn, pos, state);
        if (!worldIn.field_72995_K) {
            BlockRedstonePaste.notifyNeighborCube(worldIn, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), (Block)RedstonePasteMod.instance.blockRedstonePaste);
        }
    }

    public int func_149745_a(Random par1Random) {
        return 0;
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return null;
    }

    public boolean func_176200_f(IBlockAccess worldIn, BlockPos pos) {
        return BlockRedstonePaste.getPasteObjectCount(worldIn, pos) == 0;
    }

    public boolean func_176193_a(World worldIn, BlockPos pos, EnumFacing side, ItemStack stack) {
        return super.func_176193_a(worldIn, pos, side, stack);
    }

    public boolean func_176196_c(World worldIn, BlockPos pos) {
        return worldIn.func_180495_p(pos).func_177230_c().func_176200_f((IBlockAccess)worldIn, pos);
    }

    public void func_185477_a(IBlockState state, World worldIn, BlockPos pos, AxisAlignedBB mask, List<AxisAlignedBB> list, Entity collidingEntity) {
        TileEntity te = worldIn.func_175625_s(pos);
        if (te != null && te instanceof TileEntityRedstonePaste) {
            TileEntityRedstonePaste terp = (TileEntityRedstonePaste)te;
            boolean fullBlock = false;
            for (int n = 0; n < 6; ++n) {
                if (terp.facetype[n] != 1) continue;
                fullBlock = true;
            }
            if (fullBlock) {
                super.func_185477_a(state, worldIn, pos, mask, list, collidingEntity);
            }
        }
    }

    private AxisAlignedBB getBlockBoundsForSide(World world, BlockPos pos, int side) {
        TileEntity te = world.func_175625_s(pos);
        if (te != null && te instanceof TileEntityRedstonePaste) {
            TileEntityRedstonePaste terp = (TileEntityRedstonePaste)te;
            boolean fullBlock = false;
            for (int n = 0; n < 6; ++n) {
                if (terp.facetype[n] != 1 || rayTracing2 != -1 && rayTracing2 != n) continue;
                switch (n) {
                    case 0: {
                        return new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.5, 1.0);
                    }
                    case 1: {
                        return new AxisAlignedBB(0.0, 0.5, 0.0, 1.0, 1.0, 1.0);
                    }
                    case 2: {
                        return new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 0.5);
                    }
                    case 3: {
                        return new AxisAlignedBB(0.0, 0.0, 0.5, 1.0, 1.0, 1.0);
                    }
                    case 4: {
                        return new AxisAlignedBB(0.0, 0.0, 0.0, 0.5, 1.0, 1.0);
                    }
                    case 5: {
                        return new AxisAlignedBB(0.5, 0.0, 0.0, 1.0, 1.0, 1.0);
                    }
                }
            }
        }
        if (rayTracing) {
            return new AxisAlignedBB(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
        }
        float x1 = 0.0f;
        float x2 = 0.0f;
        float y1 = 0.0f;
        float y2 = 0.0f;
        float z1 = 0.0f;
        float z2 = 0.0f;
        float thickness = 0.0625f;
        thickness = 1.0E-4f;
        if (rayTracing2 >= 0 && rayTracing2 <= 5) {
            switch (rayTracing2) {
                case 0: {
                    x1 = 0.0f;
                    x2 = 1.0f;
                    y1 = 0.0f;
                    y2 = thickness;
                    z1 = 0.0f;
                    z2 = 1.0f;
                    break;
                }
                case 1: {
                    x1 = 0.0f;
                    x2 = 1.0f;
                    y1 = 1.0f - thickness;
                    y2 = 1.0f;
                    z1 = 0.0f;
                    z2 = 1.0f;
                    break;
                }
                case 2: {
                    x1 = 0.0f;
                    x2 = 1.0f;
                    y1 = 0.0f;
                    y2 = 1.0f;
                    z1 = 0.0f;
                    z2 = thickness;
                    break;
                }
                case 3: {
                    x1 = 0.0f;
                    x2 = 1.0f;
                    y1 = 0.0f;
                    y2 = 1.0f;
                    z1 = 1.0f - thickness;
                    z2 = 1.0f;
                    break;
                }
                case 4: {
                    x1 = 0.0f;
                    x2 = thickness;
                    y1 = 0.0f;
                    y2 = 1.0f;
                    z1 = 0.0f;
                    z2 = 1.0f;
                    break;
                }
                case 5: {
                    x1 = 1.0f - thickness;
                    x2 = 1.0f;
                    y1 = 0.0f;
                    y2 = 1.0f;
                    z1 = 0.0f;
                    z2 = 1.0f;
                }
            }
            return new AxisAlignedBB((double)x1, (double)y1, (double)z1, (double)x2, (double)y2, (double)z2);
        }
        return new AxisAlignedBB(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
    }

    public RayTraceResult func_180636_a(IBlockState blockState, World worldIn, BlockPos pos, Vec3d start, Vec3d end) {
        TileEntity te = worldIn.func_175625_s(pos);
        if (te == null || !(te instanceof TileEntityRedstonePaste)) {
            return null;
        }
        TileEntityRedstonePaste terp = (TileEntityRedstonePaste)te;
        RayTraceResult shortestmop = null;
        double shortestdistance = 0.0;
        Vec3d xyzVec = new Vec3d((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p());
        for (int f = 0; f < 6; ++f) {
            if (terp.faces[f] < 1 && terp.facetype[f] == 0) continue;
            rayTracing2 = f;
            RayTraceResult mop = this.func_185503_a(pos, start, end, this.getBlockBoundsForSide(worldIn, pos, f));
            rayTracing2 = -1;
            if (mop == null) continue;
            double distance = mop.field_72307_f.func_72438_d(start);
            mop.subHit = terp.facetype[f];
            if (!(distance <= shortestdistance) && shortestmop != null) continue;
            shortestmop = mop;
            shortestdistance = distance;
        }
        if (shortestmop != null) {
            return shortestmop;
        }
        return null;
    }

    public static RayTraceResult getMovingObjectPositionFromPlayer(World par1World, EntityPlayer par2EntityPlayer, boolean par3) {
        float f = 1.0f;
        float f1 = par2EntityPlayer.field_70127_C + (par2EntityPlayer.field_70125_A - par2EntityPlayer.field_70127_C) * f;
        float f2 = par2EntityPlayer.field_70126_B + (par2EntityPlayer.field_70177_z - par2EntityPlayer.field_70126_B) * f;
        double d0 = par2EntityPlayer.field_70169_q + (par2EntityPlayer.field_70165_t - par2EntityPlayer.field_70169_q) * (double)f;
        double d1 = par2EntityPlayer.field_70167_r + (par2EntityPlayer.field_70163_u - par2EntityPlayer.field_70167_r) * (double)f + (double)par2EntityPlayer.func_70047_e();
        double d2 = par2EntityPlayer.field_70166_s + (par2EntityPlayer.field_70161_v - par2EntityPlayer.field_70166_s) * (double)f;
        double d3 = 5.0;
        if (par2EntityPlayer instanceof EntityPlayerMP) {
            d3 = ((EntityPlayerMP)par2EntityPlayer).field_71134_c.getBlockReachDistance();
            if (par2EntityPlayer.func_70093_af()) {
                d1 -= 0.08;
            }
        }
        Vec3d vec3 = new Vec3d(d0, d1, d2);
        float f3 = MathHelper.func_76134_b((float)(-f2 * ((float)Math.PI / 180) - (float)Math.PI));
        float f4 = MathHelper.func_76126_a((float)(-f2 * ((float)Math.PI / 180) - (float)Math.PI));
        float f5 = -MathHelper.func_76134_b((float)(-f1 * ((float)Math.PI / 180)));
        float f6 = MathHelper.func_76126_a((float)(-f1 * ((float)Math.PI / 180)));
        float f7 = f4 * f5;
        float f8 = f3 * f5;
        Vec3d vec31 = vec3.func_72441_c((double)f7 * d3, (double)f6 * d3, (double)f8 * d3);
        return par1World.func_72901_a(vec3, vec31, par3);
    }

    public static int getPasteBlockType(World world, EntityPlayer player) {
        RayTraceResult mop = BlockRedstonePaste.getMovingObjectPositionFromPlayer(world, player, true);
        if (mop == null) {
            return -1;
        }
        return mop.subHit;
    }

    public static boolean destroyBlockIfEmpty(World world, BlockPos pos) {
        int pasteobjects = BlockRedstonePaste.getPasteObjectCount((IBlockAccess)world, pos);
        if (pasteobjects == 0) {
            world.func_175713_t(pos);
            world.func_175698_g(pos);
            return true;
        }
        return false;
    }

    public void func_180649_a(World worldIn, BlockPos pos, EntityPlayer playerIn) {
        if (worldIn.field_72995_K) {
            return;
        }
        int pasteBlockType = BlockRedstonePaste.getPasteBlockType(worldIn, playerIn);
        if (pasteBlockType == 1) {
            return;
        }
        RayTraceResult mop = RedstonePasteUtils.traceBlockExit(playerIn, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
        if (mop == null) {
            return;
        }
        if (pasteBlockType == 2) {
            TileEntity te = worldIn.func_175625_s(pos);
            if (te == null || !(te instanceof TileEntityRedstonePaste)) {
                return;
            }
            TileEntityRedstonePaste terp = (TileEntityRedstonePaste)te;
            terp.faces[mop.field_178784_b.ordinal()] = 0;
            terp.facetype[mop.field_178784_b.ordinal()] = 0;
            terp.facedata[mop.field_178784_b.ordinal()] = 0;
            if (!BlockRedstonePaste.destroyBlockIfEmpty(worldIn, pos)) {
                IBlockState state = worldIn.func_180495_p(pos);
                worldIn.func_184138_a(pos, state, state, 3);
            }
            if (!playerIn.field_71075_bZ.field_75098_d) {
                ItemStack dropstack = new ItemStack(RedstonePasteMod.instance.itemStickyRepeater, 1, 0);
                this.dropBlockAsItem(worldIn, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), dropstack);
                worldIn.func_175718_b(2001, pos, Block.func_149682_b((Block)this));
            }
            BlockRedstonePaste.notifyNeighborCube(worldIn, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), (Block)this);
            return;
        }
        if (pasteBlockType == 3) {
            TileEntity te = worldIn.func_175625_s(pos);
            if (te == null || !(te instanceof TileEntityRedstonePaste)) {
                return;
            }
            TileEntityRedstonePaste terp = (TileEntityRedstonePaste)te;
            terp.faces[mop.field_178784_b.ordinal()] = 0;
            terp.facetype[mop.field_178784_b.ordinal()] = 0;
            terp.facedata[mop.field_178784_b.ordinal()] = 0;
            if (!BlockRedstonePaste.destroyBlockIfEmpty(worldIn, pos)) {
                IBlockState state = worldIn.func_180495_p(pos);
                worldIn.func_184138_a(pos, state, state, 3);
            }
            if (!playerIn.field_71075_bZ.field_75098_d) {
                ItemStack dropstack = new ItemStack(RedstonePasteMod.instance.itemStickyComparator, 1, 0);
                this.dropBlockAsItem(worldIn, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), dropstack);
                worldIn.func_175718_b(2001, pos, Block.func_149682_b((Block)this));
            }
            BlockRedstonePaste.notifyNeighborCube(worldIn, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), (Block)this);
            return;
        }
        int faceclicked = -1;
        faceclicked = mop.field_178784_b.ordinal();
        double hitX = mop.field_72307_f.field_72450_a - (double)mop.func_178782_a().func_177958_n();
        double hitY = mop.field_72307_f.field_72448_b - (double)mop.func_178782_a().func_177956_o();
        double hitZ = mop.field_72307_f.field_72449_c - (double)mop.func_178782_a().func_177952_p();
        int segmentclicked = -1;
        if (faceclicked == 0 || faceclicked == 1) {
            segmentclicked = RedstonePasteUtils.testSegmentHit(hitX, hitZ);
        } else if (faceclicked == 2 || faceclicked == 3) {
            segmentclicked = RedstonePasteUtils.testSegmentHit(hitX, hitY);
        } else if (faceclicked == 4 || faceclicked == 5) {
            segmentclicked = RedstonePasteUtils.testSegmentHit(hitZ, hitY);
        }
        if (playerIn.func_70093_af()) {
            switch (segmentclicked) {
                case 1: {
                    segmentclicked |= 2;
                    break;
                }
                case 2: {
                    segmentclicked |= 1;
                    break;
                }
                case 4: {
                    segmentclicked |= 8;
                    break;
                }
                case 8: {
                    segmentclicked |= 4;
                }
            }
        }
        if (segmentclicked < 1) {
            return;
        }
        TileEntity te = worldIn.func_175625_s(pos);
        if (te == null || !(te instanceof TileEntityRedstonePaste)) {
            return;
        }
        TileEntityRedstonePaste terp = (TileEntityRedstonePaste)te;
        int[] segmentvalues = new int[]{1, 2, 4, 8};
        int segmentsdropped = 0;
        for (int seg = 0; seg < 4; ++seg) {
            if ((segmentclicked & segmentvalues[seg]) == 0 || (terp.faces[faceclicked] & segmentvalues[seg]) <= 0) continue;
            ++segmentsdropped;
            int n = faceclicked;
            terp.faces[n] = terp.faces[n] & ~segmentvalues[seg];
        }
        if (segmentsdropped > 0) {
            int x = pos.func_177958_n();
            int y = pos.func_177956_o();
            int z = pos.func_177952_p();
            ItemStack stack = new ItemStack((Block)this, segmentsdropped);
            if (!playerIn.field_71075_bZ.field_75098_d) {
                this.dropBlockAsItem(worldIn, x, y, z, stack);
                worldIn.func_175718_b(2001, pos, Block.func_149682_b((Block)this));
            }
            if (!BlockRedstonePaste.destroyBlockIfEmpty(worldIn, pos)) {
                IBlockState state = worldIn.func_180495_p(pos);
                worldIn.func_184138_a(pos, state, state, 3);
            }
            BlockRedstonePaste.notifyNeighborCube(worldIn, x, y, z, (Block)RedstonePasteMod.instance.blockRedstonePaste);
        }
    }

    public static int getPasteObjectCount(IBlockAccess world, BlockPos pos) {
        Block bID = world.func_180495_p(pos).func_177230_c();
        if (bID != RedstonePasteMod.instance.blockRedstonePaste) {
            return 0;
        }
        TileEntity te = world.func_175625_s(pos);
        if (te == null || !(te instanceof TileEntityRedstonePaste)) {
            return 0;
        }
        return BlockRedstonePaste.getPasteObjectCount((TileEntityRedstonePaste)te);
    }

    public static int getPasteObjectCount(TileEntityRedstonePaste terp) {
        if (terp == null) {
            return 0;
        }
        int pasteobjects = 0;
        for (int n = 0; n < 6; ++n) {
            if (terp.facetype[n] == 0 && terp.faces[n] > 0) {
                ++pasteobjects;
            }
            if (terp.facetype[n] <= 0) continue;
            ++pasteobjects;
        }
        return pasteobjects;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(IBlockState state, World worldIn, BlockPos pos, Random rand) {
        TileEntity te = worldIn.func_175625_s(pos);
        if (te == null || !(te instanceof TileEntityRedstonePaste)) {
            return;
        }
        TileEntityRedstonePaste terp = (TileEntityRedstonePaste)te;
        for (int side = 0; side < 6; ++side) {
            int l = terp.facedata[side];
            int facetype = terp.facetype[side];
            if (facetype == 0 && (terp.faces[side] == 0 || l == 0) || facetype != 0 && facetype != 2 || facetype == 2 && (terp.facedata[side] & 4) == 0) continue;
            double d0 = (double)pos.func_177958_n() + 0.5 + ((double)rand.nextFloat() - 0.5) * 0.2;
            double d1 = (double)pos.func_177956_o() + 0.5 + ((double)rand.nextFloat() - 0.5) * 0.2;
            double d2 = (double)pos.func_177952_p() + 0.5 + ((double)rand.nextFloat() - 0.5) * 0.2;
            float offset = 0.0625f;
            if (facetype == 2) {
                offset = (float)((double)offset + 0.2);
                l = 15;
            }
            switch (side) {
                case 0: {
                    d1 = (float)pos.func_177956_o() + offset;
                    break;
                }
                case 1: {
                    d1 = (float)pos.func_177956_o() + (1.0f - offset);
                    break;
                }
                case 2: {
                    d2 = (float)pos.func_177952_p() + offset;
                    break;
                }
                case 3: {
                    d2 = (float)pos.func_177952_p() + (1.0f - offset);
                    break;
                }
                case 4: {
                    d0 = (float)pos.func_177958_n() + offset;
                    break;
                }
                case 5: {
                    d0 = (float)pos.func_177958_n() + (1.0f - offset);
                }
            }
            float f = (float)l / 15.0f;
            float f1 = f * 0.6f + 0.4f;
            float f2 = f * f * 0.7f - 0.5f;
            float f3 = f * f * 0.6f - 0.7f;
            if (f2 < 0.0f) {
                f2 = 0.0f;
            }
            if (f3 < 0.0f) {
                f3 = 0.0f;
            }
            worldIn.func_175688_a(EnumParticleTypes.REDSTONE, d0, d1, d2, (double)f1, (double)f2, (double)f3, new int[0]);
        }
    }

    public boolean removedByPlayer(IBlockState state, World world, BlockPos pos, EntityPlayer player, boolean willHarvest) {
        if (world.field_72995_K) {
            return false;
        }
        int pasteBlockType = BlockRedstonePaste.getPasteBlockType(world, player);
        if (pasteBlockType == 1) {
            this.removeSlab(world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), !player.field_71075_bZ.field_75098_d);
            BlockRedstonePaste.destroyBlockIfEmpty(world, pos);
            world.func_184138_a(pos, state, state, 3);
            BlockRedstonePaste.notifyNeighborCube(world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), (Block)RedstonePasteMod.instance.blockRedstonePaste);
        } else {
            this.func_180649_a(world, pos, player);
        }
        return false;
    }

    private void removeSlab(World world, int x, int y, int z, boolean dropItem) {
        TileEntityRedstonePaste te = (TileEntityRedstonePaste)world.func_175625_s(new BlockPos(x, y, z));
        if (te == null) {
            return;
        }
        int slabData = 0;
        for (int n = 0; n < 6; ++n) {
            if (te.facetype[n] != 1) continue;
            slabData = te.facedata[n];
            te.facetype[n] = 0;
            te.facedata[n] = 0;
            if (!dropItem) continue;
            Block slabID = Block.func_149729_e((int)(slabData & 0xFFFF));
            int damage = slabData >> 16;
            ItemStack dropstack = new ItemStack(slabID.func_180660_a(slabID.func_176203_a(damage), null, 1), 1, damage);
            this.dropBlockAsItem(world, x, y, z, dropstack);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_176225_a(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        return true;
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, ItemStack heldItem, EnumFacing side, float hitX, float hitY, float hitZ) {
        Block bID = state.func_177230_c();
        if (bID != this) {
            return super.func_180639_a(worldIn, pos, state, playerIn, hand, heldItem, side, hitX, hitY, hitZ);
        }
        TileEntity te = worldIn.func_175625_s(pos);
        if (te == null || !(te instanceof TileEntityRedstonePaste) || playerIn == null) {
            return super.func_180639_a(worldIn, pos, state, playerIn, hand, heldItem, side, hitX, hitY, hitZ);
        }
        TileEntityRedstonePaste terp = (TileEntityRedstonePaste)te;
        boolean isHoldingSlab = heldItem != null && heldItem.func_77973_b() instanceof ItemSlab;
        int pasteBlockType = BlockRedstonePaste.getPasteBlockType(worldIn, playerIn);
        if (pasteBlockType == 2) {
            if (!isHoldingSlab) {
                int repeaterface = 0;
                for (int n = 0; n < 6; ++n) {
                    if (terp.facetype[n] != 2) continue;
                    repeaterface = n;
                    break;
                }
                int delay = (terp.facedata[repeaterface] & 0x18) >> 3;
                ++delay;
                delay &= 3;
                if (!worldIn.field_72995_K) {
                    int n = repeaterface;
                    terp.facedata[n] = terp.facedata[n] & 0xFFFFFFE7;
                    int n2 = repeaterface;
                    terp.facedata[n2] = terp.facedata[n2] | delay << 3;
                }
                worldIn.func_184138_a(pos, state, state, 3);
                BlockRedstonePaste.notifyNeighborCube(worldIn, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), (Block)this);
                return true;
            }
        } else if (pasteBlockType == 3 && !isHoldingSlab) {
            int comparatorface = 0;
            for (int n = 0; n < 6; ++n) {
                if (terp.facetype[n] != 3) continue;
                comparatorface = n;
                break;
            }
            int toggle = terp.facedata[comparatorface] & 4;
            SoundEvent sound = (SoundEvent)SoundEvent.field_187505_a.func_82594_a((Object)new ResourceLocation("block.comparator.click"));
            worldIn.func_184148_a(playerIn, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, sound, SoundCategory.BLOCKS, 0.3f, toggle > 0 ? 0.4f : 0.55f);
            toggle = ~toggle & 4;
            if (!worldIn.field_72995_K) {
                int n = comparatorface;
                terp.facedata[n] = terp.facedata[n] & 0xFFFFFFFB;
                int n3 = comparatorface;
                terp.facedata[n3] = terp.facedata[n3] | toggle;
            }
            worldIn.func_184138_a(pos, state, state, 3);
            BlockRedstonePaste.notifyNeighborCube(worldIn, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), (Block)this);
            return true;
        }
        if (heldItem == null) {
            return super.func_180639_a(worldIn, pos, state, playerIn, hand, heldItem, side, hitX, hitY, hitZ);
        }
        if (!(heldItem.func_77973_b() instanceof ItemSlab)) {
            return super.func_180639_a(worldIn, pos, state, playerIn, hand, heldItem, side, hitX, hitY, hitZ);
        }
        int pasteFaces = 0;
        int slabFaces = 0;
        int pasteObjects = 0;
        for (int n = 0; n < 6; ++n) {
            if (terp.faces[n] > 0) {
                ++pasteFaces;
            }
            if (terp.facetype[n] == 1) {
                ++slabFaces;
            }
            if (terp.facetype[n] == 0 && terp.faces[n] > 0) {
                ++pasteObjects;
            }
            if (terp.facetype[n] <= 0) continue;
            ++pasteObjects;
        }
        if (pasteObjects > 1) {
            return super.func_180639_a(worldIn, pos, state, playerIn, hand, heldItem, side, hitX, hitY, hitZ);
        }
        if (terp.facetype[side.ordinal()] != 0) {
            return super.func_180639_a(worldIn, pos, state, playerIn, hand, heldItem, side, hitX, hitY, hitZ);
        }
        if (!worldIn.field_72995_K) {
            terp.facetype[side.ordinal()] = 1;
            terp.facedata[side.ordinal()] = Block.func_149682_b((Block)Block.func_149634_a((Item)heldItem.func_77973_b())) | heldItem.func_77952_i() << 16;
            if (!playerIn.field_71075_bZ.field_75098_d) {
                --heldItem.field_77994_a;
            }
        }
        SoundEvent sound = (SoundEvent)SoundEvent.field_187505_a.func_82594_a((Object)new ResourceLocation("block.stone.place"));
        worldIn.func_184148_a(playerIn, (double)((float)pos.func_177958_n() + 0.5f), (double)((float)pos.func_177956_o() + 0.5f), (double)((float)pos.func_177952_p() + 0.5f), sound, SoundCategory.BLOCKS, 1.0f, 1.0f);
        worldIn.func_184138_a(pos, state, state, 3);
        BlockRedstonePaste.notifyNeighborCube(worldIn, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), (Block)this);
        return true;
    }

    public float func_176195_g(IBlockState blockState, World worldIn, BlockPos pos) {
        TileEntity te = worldIn.func_175625_s(pos);
        if (te != null && te instanceof TileEntityRedstonePaste) {
            TileEntityRedstonePaste terp = (TileEntityRedstonePaste)te;
            boolean fullBlock = false;
            for (int n = 0; n < 6; ++n) {
                if (terp.facetype[n] != 1) continue;
                fullBlock = true;
            }
            if (fullBlock) {
                return 0.34f;
            }
        }
        return this.field_149782_v;
    }

    public boolean isSideSolid(IBlockState base_state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        TileEntity te = world.func_175625_s(pos);
        if (te != null && te instanceof TileEntityRedstonePaste) {
            TileEntityRedstonePaste terp = (TileEntityRedstonePaste)te;
            int face = side.ordinal();
            if (face < 0 || face > 5) {
                return false;
            }
            if (terp.facetype[face] == 1) {
                return true;
            }
        }
        return false;
    }

    public static int getSlabFace(World world, int x, int y, int z) {
        Block bID = world.func_180495_p(new BlockPos(x, y, z)).func_177230_c();
        if (bID != RedstonePasteMod.instance.blockRedstonePaste) {
            return -1;
        }
        TileEntity te = world.func_175625_s(new BlockPos(x, y, z));
        if (te == null || !(te instanceof TileEntityRedstonePaste)) {
            return -1;
        }
        TileEntityRedstonePaste terp = (TileEntityRedstonePaste)te;
        int slabFace = -1;
        for (int n = 0; n < 6; ++n) {
            if (terp.facetype[n] != 1) continue;
            slabFace = n;
        }
        return slabFace;
    }

    public static int getRepeaterComparatorFace(World world, int x, int y, int z) {
        Block bID = world.func_180495_p(new BlockPos(x, y, z)).func_177230_c();
        if (bID != RedstonePasteMod.instance.blockRedstonePaste) {
            return -1;
        }
        TileEntity te = world.func_175625_s(new BlockPos(x, y, z));
        if (te == null || !(te instanceof TileEntityRedstonePaste)) {
            return -1;
        }
        TileEntityRedstonePaste terp = (TileEntityRedstonePaste)te;
        int slabFace = -1;
        for (int n = 0; n < 6; ++n) {
            if (terp.facetype[n] == 2) {
                slabFace = n;
            }
            if (terp.facetype[n] != 3) continue;
            slabFace = n;
        }
        return slabFace;
    }

    public int getLightValue(IBlockState state, IBlockAccess world, BlockPos pos) {
        TileEntity te = world.func_175625_s(pos);
        if (te != null && te instanceof TileEntityRedstonePaste) {
            TileEntityRedstonePaste terp = (TileEntityRedstonePaste)te;
            boolean hasSlab = false;
            boolean activeRepeater = false;
            for (int n = 0; n < 6; ++n) {
                if (terp.facetype[n] == 2 && (terp.facedata[n] & 4) > 0) {
                    activeRepeater = true;
                }
                if (terp.facetype[n] != 1) continue;
                hasSlab = true;
            }
            if (!hasSlab && activeRepeater) {
                return 9;
            }
        }
        return 0;
    }

    public TileEntity func_149915_a(World worldIn, int meta) {
        return new TileEntityRedstonePaste();
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    private class NeighborBlock {
        public int x;
        public int y;
        public int z;
        public Block blockID;
        public TileEntityRedstonePaste terp;
        private byte[] strengths = new byte[6];
        private byte[] indirects = new byte[6];
        private NeighborBlock[] neighbors = new NeighborBlock[6];
        private World world;

        public NeighborBlock(World world, int x1, int y1, int z1) {
            this.x = x1;
            this.y = y1;
            this.z = z1;
            this.world = world;
            this.blockID = world.func_180495_p(new BlockPos(this.x, this.y, this.z)).func_177230_c();
            this.terp = null;
            if (this.blockID == RedstonePasteMod.instance.blockRedstonePaste) {
                this.terp = (TileEntityRedstonePaste)world.func_175625_s(new BlockPos(this.x, this.y, this.z));
            }
            for (int n = 0; n < 6; ++n) {
                this.strengths[n] = -1;
                this.indirects[n] = -1;
            }
        }

        public int getMaxPower(int oldpower, int dir) {
            int str = 0;
            if (this.strengths[dir] > -1) {
                str = this.strengths[dir];
            } else {
                str = BlockRedstonePaste.this.getMaxCurrentStrength(this.world, this.x, this.y, this.z, 0, Facing.oppositeSide[dir]);
                this.strengths[dir] = (byte)str;
            }
            return Math.max(oldpower, str);
        }

        public int getMaxIndirectPower(int oldindirect, int dir) {
            int indirect = 0;
            if (this.indirects[dir] > -1) {
                indirect = this.indirects[dir];
            } else {
                BlockRedstonePaste.this.pasteProvidesPower = false;
                indirect = BlockRedstonePaste.this.getIndirectPowerLevelTo_NoWire(this.world, this.x, this.y, this.z, Facing.oppositeSide[dir]);
                BlockRedstonePaste.this.pasteProvidesPower = true;
                this.indirects[dir] = (byte)indirect;
            }
            return Math.max(oldindirect, indirect);
        }

        public NeighborBlock getNeighborBlock(int dir) {
            NeighborBlock newneighbor;
            if (this.neighbors[dir] != null) {
                return this.neighbors[dir];
            }
            int newx = this.x + Facing.offsetsXForSide[dir];
            int newy = this.y + Facing.offsetsYForSide[dir];
            int newz = this.z + Facing.offsetsZForSide[dir];
            this.neighbors[dir] = newneighbor = new NeighborBlock(this.world, newx, newy, newz);
            return newneighbor;
        }
    }

    public static class Direction {
        public static final int[] offsetX = new int[]{0, -1, 0, 1};
        public static final int[] offsetZ = new int[]{1, 0, -1, 0};
        public static final String[] directions = new String[]{"SOUTH", "WEST", "NORTH", "EAST"};
        public static final int[] directionToFacing = new int[]{3, 4, 2, 5};
        public static final int[] facingToDirection = new int[]{-1, -1, 2, 0, 1, 3};
        public static final int[] rotateOpposite = new int[]{2, 3, 0, 1};
        public static final int[] rotateRight = new int[]{1, 2, 3, 0};
        public static final int[] rotateLeft = new int[]{3, 0, 1, 2};
    }

    public static class Facing {
        public static final int[] oppositeSide = new int[]{1, 0, 3, 2, 5, 4};
        public static final int[] offsetsXForSide = new int[]{0, 0, 0, 0, -1, 1};
        public static final int[] offsetsYForSide = new int[]{-1, 1, 0, 0, 0, 0};
        public static final int[] offsetsZForSide = new int[]{0, 0, -1, 1, 0, 0};
    }
}

