/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.wawla.plugins.vanilla;

import java.util.List;
import mcp.mobius.waila.api.IEntityAccessor;
import mcp.mobius.waila.api.IEntityComponentProvider;
import mcp.mobius.waila.api.IPluginConfig;
import mcp.mobius.waila.api.IRegistrar;
import mcp.mobius.waila.api.IServerDataProvider;
import mcp.mobius.waila.api.TooltipPosition;
import net.darkhax.wawla.lib.Feature;
import net.minecraft.entity.AgeableEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.StringUtils;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;

public class FeatureAgeable
extends Feature
implements IEntityComponentProvider,
IServerDataProvider<Entity> {
    private static final ResourceLocation BREEDING_COOLDOWN = new ResourceLocation("wawla", "breeding_cooldown");
    private static final ResourceLocation GROWING_COOLDOWN = new ResourceLocation("wawla", "growing_cooldown");
    private static final ResourceLocation BREEDING_ITEM = new ResourceLocation("wawla", "breeding_item");

    @Override
    public void initialize(IRegistrar hwyla) {
        hwyla.addConfig(BREEDING_COOLDOWN, true);
        hwyla.addConfig(GROWING_COOLDOWN, true);
        hwyla.addConfig(BREEDING_ITEM, true);
        hwyla.registerEntityDataProvider((IServerDataProvider)this, AgeableEntity.class);
        hwyla.registerComponentProvider((IEntityComponentProvider)this, TooltipPosition.BODY, AgeableEntity.class);
    }

    public void appendServerData(CompoundNBT tag, ServerPlayerEntity player, World world, Entity target) {
        if (target instanceof AgeableEntity) {
            tag.func_74768_a("WawlaAnimalAge", ((AgeableEntity)target).func_70874_b());
        }
    }

    public void appendBody(List<ITextComponent> info, IEntityAccessor accessor, IPluginConfig config) {
        if (accessor.getServerData().func_74764_b("WawlaAnimalAge")) {
            int growingAge = accessor.getServerData().func_74762_e("WawlaAnimalAge");
            if (growingAge < 0 && config.get(GROWING_COOLDOWN)) {
                this.addInfo(info, "growingage", StringUtils.func_76337_a((int)Math.abs(growingAge)));
            } else if (growingAge > 0 && config.get(BREEDING_COOLDOWN)) {
                this.addInfo(info, "breedingtime", StringUtils.func_76337_a((int)growingAge));
            }
            if (config.get(BREEDING_ITEM) && growingAge == 0 && accessor.getPlayer() != null && accessor.getEntity() instanceof AnimalEntity) {
                ItemStack heldItem = accessor.getPlayer().func_184614_ca();
                AnimalEntity animal = (AnimalEntity)accessor.getEntity();
                if (!heldItem.func_190926_b() && !animal.func_70631_g_() && animal.func_70877_b(heldItem)) {
                    info.add((ITextComponent)this.getInfoComponent("breedingitem", new Object[0]).func_240699_a_(TextFormatting.YELLOW));
                }
            }
        }
    }
}

