/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.wawla.client;

import java.util.Set;
import net.darkhax.icse.lib.Utilities;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.settings.GameSettings;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.item.Item;
import net.minecraft.item.ItemEnchantedBook;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class TooltipHandler {
    private static final String CATAGORY = "item_tooltips";
    private static boolean showEnchantmentPower = true;
    private static boolean enchantmentDescription = true;
    private static boolean enchantmentMod = true;

    @SubscribeEvent
    public void onItemTooltip(ItemTooltipEvent event) {
        if (event.getEntityPlayer() != null && event.getEntityPlayer().field_70170_p != null && event.getItemStack() != null) {
            Enchantment enchant;
            Set enchants;
            KeyBinding keyBindSneak = Minecraft.func_71410_x().field_71474_y.field_74311_E;
            boolean isShifting = GameSettings.func_100015_a((KeyBinding)keyBindSneak);
            Item item = event.getItemStack().func_77973_b();
            Block block = Block.func_149634_a((Item)item);
            if (item instanceof ItemEnchantedBook && enchantmentDescription && !(enchants = EnchantmentHelper.func_82781_a((ItemStack)event.getItemStack()).keySet()).isEmpty() && (enchant = (Enchantment)enchants.iterator().next()) != null) {
                if (isShifting) {
                    String description = I18n.func_135052_a((String)("description." + enchant.func_77320_a()), (Object[])new Object[0]);
                    if (description.startsWith("description.")) {
                        Utilities.wrapStringToList(I18n.func_135052_a((String)"tooltip.wawla.missingench", (Object[])new Object[]{Utilities.getModName(enchant), description}), 45, false, event.getToolTip());
                    } else {
                        Utilities.wrapStringToList(description, 45, false, event.getToolTip());
                        if (enchantmentMod) {
                            event.getToolTip().add(I18n.func_135052_a((String)"tooltip.wawla.addedby", (Object[])new Object[]{Utilities.getModName(enchant)}));
                        }
                    }
                } else {
                    Utilities.wrapStringToList(I18n.func_135052_a((String)"tooltip.wawla.shiftEnch", (Object[])new Object[]{keyBindSneak.getDisplayName()}), 45, false, event.getToolTip());
                }
            }
            if (block != null && showEnchantmentPower) {
                try {
                    float enchPower = block.getEnchantPowerBonus(event.getEntityPlayer().field_70170_p, BlockPos.field_177992_a);
                    if (enchPower > 0.0f) {
                        event.getToolTip().add(I18n.func_135052_a((String)"tooltip.wawla.enchPower", (Object[])new Object[0]) + ": " + enchPower);
                    }
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
        }
    }

    public static void handleConfigs(Configuration config) {
        showEnchantmentPower = config.getBoolean("enchantmentPower", CATAGORY, true, "When enabled, blocks that contribute to the total bookshelves at an enchantment table will be shown.");
        enchantmentDescription = config.getBoolean("enchantmentDescription", CATAGORY, true, "When enabled, enchantment books can display descriptions about what they do.");
        enchantmentMod = config.getBoolean("enchantmentOwner", CATAGORY, true, "When enabled, shows the name of the mod that added the enchantment.");
    }
}

