/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.wawla.plugins.vanilla.tiles;

import java.util.List;
import net.darkhax.wawla.lib.InfoAccess;
import net.darkhax.wawla.plugins.InfoProvider;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraft.util.StringUtils;
import net.minecraft.world.World;
import net.minecraftforge.common.config.Configuration;

public class PluginFurnace
extends InfoProvider {
    private static boolean enabled = true;
    private static boolean fuel = true;
    private static boolean input = true;
    private static boolean output = true;
    private static boolean burntime = true;

    @Override
    public void addTileInfo(List<String> info, InfoAccess data) {
        if (enabled && data.world.func_175625_s(data.pos) instanceof TileEntityFurnace) {
            int time;
            ItemStack stack;
            if (input && (stack = ItemStack.func_77949_a((NBTTagCompound)data.tag.func_74775_l("InputStack"))) != null && stack.func_77973_b() != null) {
                info.add(I18n.func_135052_a((String)"tooltip.wawla.vanilla.input", (Object[])new Object[0]) + ": " + stack.func_82833_r() + " * " + stack.field_77994_a);
            }
            if (fuel && (stack = ItemStack.func_77949_a((NBTTagCompound)data.tag.func_74775_l("FuelStack"))) != null && stack.func_77973_b() != null) {
                info.add(I18n.func_135052_a((String)"tooltip.wawla.vanilla.fuel", (Object[])new Object[0]) + ": " + stack.func_82833_r() + " * " + stack.field_77994_a);
            }
            if (output && (stack = ItemStack.func_77949_a((NBTTagCompound)data.tag.func_74775_l("OutputStack"))) != null && stack.func_77973_b() != null) {
                info.add(I18n.func_135052_a((String)"tooltip.wawla.vanilla.output", (Object[])new Object[0]) + ": " + stack.func_82833_r() + " * " + stack.field_77994_a);
            }
            if (burntime && (time = data.tag.func_74762_e("BurnTime")) > 0) {
                info.add(I18n.func_135052_a((String)"tooltip.wawla.vanilla.burntime", (Object[])new Object[0]) + ": " + StringUtils.func_76337_a((int)time));
            }
        }
    }

    @Override
    public void writeTileNBT(World world, TileEntity tile, NBTTagCompound tag) {
        if (tile instanceof TileEntityFurnace) {
            TileEntityFurnace furnace = (TileEntityFurnace)tile;
            ItemStack stack = null;
            if (input && (stack = furnace.func_70301_a(0)) != null) {
                InfoProvider.writeStackToTag(stack, "InputStack", tag);
            }
            if (fuel && (stack = furnace.func_70301_a(1)) != null) {
                InfoProvider.writeStackToTag(stack, "FuelStack", tag);
            }
            if (output && (stack = furnace.func_70301_a(2)) != null) {
                InfoProvider.writeStackToTag(stack, "OutputStack", tag);
            }
            tag.func_74768_a("BurnTime", furnace.func_174887_a_(0));
        }
    }

    @Override
    public boolean requireTileSync(World world, TileEntity tile) {
        return enabled && tile instanceof TileEntityFurnace;
    }

    @Override
    public void syncConfig(Configuration config) {
        enabled = config.getBoolean("Furnace", "vanilla_tiles", true, "If this is enabled, the hud will display info about furnaces.");
        fuel = config.getBoolean("Furnace_Fuel", "vanilla_tiles", true, "If this is enabled, the hud will show fuel items in a furnace.");
        input = config.getBoolean("Furnace_Input", "vanilla_tiles", true, "If this is enabled, the hud will show input items in a furnace.");
        output = config.getBoolean("Furnace_Output", "vanilla_tiles", true, "If this is enabled, the hud will show output items in a furnace.");
        burntime = config.getBoolean("Furnace_Burn_Time", "vanilla_tiles", true, "If this is enabled, the hud will show how much longer the furnace will burn.");
    }
}

