/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.wawla.plugins.generic;

import java.util.List;
import net.darkhax.wawla.lib.InfoAccess;
import net.darkhax.wawla.plugins.InfoProvider;
import net.darkhax.wawla.plugins.ProviderType;
import net.darkhax.wawla.plugins.WawlaFeature;
import net.minecraft.block.Block;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;

@WawlaFeature(description="Shows the enchantment power of a block", name="enchpower", type=ProviderType.ITEM_BLOCK)
public class PluginEnchantmentPower
extends InfoProvider {
    @Override
    public void addTileInfo(List<String> info, InfoAccess data) {
        float enchPower = data.block.getEnchantPowerBonus(data.world, data.pos);
        if (enchPower > 0.0f) {
            info.add(I18n.func_135052_a((String)"tooltip.wawla.generic.enchpower", (Object[])new Object[0]) + ": " + enchPower);
        }
    }

    @Override
    public void addItemInfo(List<String> info, ItemStack stack, boolean advanced, EntityPlayer entityPlayer) {
        Block block = Block.func_149634_a((Item)stack.func_77973_b());
        if (block != null) {
            try {
                float enchPower = block.getEnchantPowerBonus(entityPlayer.field_70170_p, BlockPos.field_177992_a);
                if (enchPower > 0.0f) {
                    info.add(I18n.func_135052_a((String)"tooltip.wawla.enchPower", (Object[])new Object[0]) + ": " + enchPower);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

