/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.wawla.plugins.generic;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.darkhax.wawla.config.Configurable;
import net.darkhax.wawla.lib.InfoAccess;
import net.darkhax.wawla.plugins.InfoProvider;
import net.darkhax.wawla.plugins.ProviderType;
import net.darkhax.wawla.plugins.WawlaFeature;
import net.minecraft.block.Block;
import net.minecraft.block.BlockOre;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemTool;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.oredict.OreDictionary;

@WawlaFeature(description="Shows harvestability data", name="harvestable", type=ProviderType.BLOCK)
public class PluginHarvestability
extends InfoProvider {
    private static final Map<String, ItemStack> overrides = new HashMap<String, ItemStack>();
    @Configurable(category="harvestable", description="Limit to only ores?")
    public static boolean oresOnly = true;
    @Configurable(category="harvestable", description="Show if the block is harvestable?")
    public static boolean showHarvestable = true;
    @Configurable(category="harvestable", description="Show the correct tier if the player lacks it?")
    public static boolean showCorrectTier = true;
    @Configurable(category="harvestable", description="Show the correct tool if the player is using the wrong one?")
    public static boolean showCorrectTool = true;

    @Override
    public void addTileInfo(List<String> info, InfoAccess data) {
        boolean isValidBlock;
        IBlockState state = data.world.func_180495_p(data.pos);
        ItemStack heldItem = data.player.func_184614_ca();
        String toolType = this.getEffectiveTool(data.world, data.state, data.pos);
        int blockLevel = data.block.getHarvestLevel(data.state);
        int itemLevel = !heldItem.func_190926_b() && toolType != null && !toolType.isEmpty() ? heldItem.func_77973_b().getHarvestLevel(heldItem, toolType, data.player, state) : 0;
        boolean bl = isValidBlock = oresOnly && this.isOre(new ItemStack(data.block)) || !oresOnly;
        if (isValidBlock && !heldItem.func_190926_b() && heldItem.func_77973_b().getToolClasses(heldItem).contains(toolType)) {
            if (showHarvestable && (blockLevel <= itemLevel || blockLevel == 0)) {
                info.add(I18n.func_135052_a((String)"tooltip.wawla.generic.harvestable", (Object[])new Object[0]) + ": " + InfoProvider.getBooleanForDisplay(true));
            } else {
                if (showHarvestable) {
                    info.add(I18n.func_135052_a((String)"tooltip.wawla.generic.harvestable", (Object[])new Object[0]) + ": " + InfoProvider.getBooleanForDisplay(false));
                }
                if (showCorrectTier) {
                    info.add(I18n.func_135052_a((String)"tooltip.wawla.generic.showtier", (Object[])new Object[0]) + ": " + blockLevel);
                }
            }
        } else if (isValidBlock && toolType != null && showCorrectTool) {
            String translation = I18n.func_135052_a((String)("tooltip.wawla." + toolType), (Object[])new Object[0]);
            info.add(I18n.func_135052_a((String)"tooltip.wawla.generic.tooltype", (Object[])new Object[0]) + ": " + (translation.startsWith("tooltip.wawla.") ? toolType : translation));
        }
    }

    private boolean isOre(ItemStack stack) {
        if (stack.func_190926_b()) {
            return false;
        }
        if (Block.func_149634_a((Item)stack.func_77973_b()) instanceof BlockOre) {
            return true;
        }
        for (int oreID : OreDictionary.getOreIDs((ItemStack)stack)) {
            if (!OreDictionary.getOreName((int)oreID).startsWith("ore")) continue;
            return true;
        }
        return stack.func_82833_r().matches(".*(^|\\s)([oO]re)($|\\s).");
    }

    private String getEffectiveTool(World world, IBlockState state, BlockPos pos) {
        float blockHardness;
        String tool = state.func_177230_c().getHarvestTool(state);
        if ((tool == null || tool.isEmpty()) && (blockHardness = state.func_177230_c().func_176195_g(state, world, pos)) > 0.0f) {
            for (Map.Entry<String, ItemStack> entry : overrides.entrySet()) {
                ItemStack stack = entry.getValue();
                if (!(stack.func_77973_b() instanceof ItemTool) || !(stack.func_77973_b().func_150893_a(stack, state) >= ((ItemTool)stack.func_77973_b()).func_150913_i().func_77998_b())) continue;
                tool = entry.getKey();
                break;
            }
        }
        return tool;
    }

    static {
        overrides.put("pickaxe", new ItemStack(Items.field_151039_o));
        overrides.put("axe", new ItemStack(Items.field_151053_p));
        overrides.put("shovel", new ItemStack(Items.field_151038_n));
    }
}

