/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.wawla.plugins.vanilla;

import java.util.List;
import net.darkhax.wawla.lib.InfoAccess;
import net.darkhax.wawla.plugins.InfoProvider;
import net.darkhax.wawla.plugins.ProviderType;
import net.darkhax.wawla.plugins.WawlaFeature;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.Entity;
import net.minecraft.entity.monster.EntityWitch;
import net.minecraft.entity.monster.EntityZombieVillager;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.VillagerRegistry;

@WawlaFeature(description="Shows info about villager professions", name="professions", type=ProviderType.ENTITY)
public class PluginVillagerTypes
extends InfoProvider {
    @Override
    public void addEntityInfo(List<String> info, InfoAccess data) {
        String career = "";
        if (data.entity instanceof EntityVillager) {
            career = ((EntityVillager)data.entity).getProfessionForge().getRegistryName().func_110623_a();
        } else if (data.entity instanceof EntityZombieVillager) {
            String forgeCareer = data.tag.func_74779_i("WAWLAZombieType");
            career = forgeCareer.isEmpty() ? I18n.func_135052_a((String)"villager.wawla.zombie", (Object[])new Object[0]) : forgeCareer;
        } else if (data.entity instanceof EntityWitch) {
            career = I18n.func_135052_a((String)"villager.wawla.witch", (Object[])new Object[0]);
        }
        if (career != null && !career.isEmpty()) {
            info.add(I18n.func_135052_a((String)"tooltip.wawla.vanilla.career", (Object[])new Object[0]) + ": " + career);
        }
    }

    @Override
    public void writeEntityNBT(World world, Entity entity, NBTTagCompound tag) {
        EntityZombieVillager zombie;
        VillagerRegistry.VillagerProfession type;
        if (entity instanceof EntityZombieVillager && (type = (zombie = (EntityZombieVillager)entity).getForgeProfession()) != null) {
            tag.func_74778_a("WAWLAZombieType", type.getRegistryName().func_110623_a());
        }
    }

    @Override
    public boolean requireEntitySync(World world, Entity entity) {
        return entity instanceof EntityZombieVillager;
    }
}

