/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.wawla.utils;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.darkhax.wawla.lib.Constants;
import net.minecraft.util.Tuple;
import net.minecraftforge.fml.common.discovery.ASMDataTable;

public final class AnnotationUtils {
    private AnnotationUtils() {
        throw new IllegalAccessError("Utility class");
    }

    public static <A extends Annotation> Set<ASMDataTable.ASMData> getData(ASMDataTable table, Class<A> annotation) {
        return table.getAll(annotation.getCanonicalName());
    }

    public static <A extends Annotation> List<Tuple<Class<?>, A>> getAnnotatedClasses(ASMDataTable table, Class<A> annotation) {
        ArrayList classes = new ArrayList();
        for (ASMDataTable.ASMData data : AnnotationUtils.getData(table, annotation)) {
            try {
                Class<?> clazz = Class.forName(data.getClassName());
                if (clazz == null) continue;
                classes.add(new Tuple(clazz, clazz.getAnnotation(annotation)));
            }
            catch (ClassNotFoundException e) {
                Constants.LOG.warn("Could not load " + data.getClassName(), (Throwable)e);
            }
        }
        return classes;
    }

    public static <A extends Annotation> List<Field> getAnnotatedFields(Collection<Class<?>> collection, Class<A> class1) {
        ArrayList<Field> fields = new ArrayList<Field>();
        for (Class<?> clazz : collection) {
            for (Field field : clazz.getFields()) {
                if (!field.isAnnotationPresent(class1)) continue;
                fields.add(field);
            }
        }
        return fields;
    }

    public static <T, A extends Annotation> Map<T, A> getAnnotations(ASMDataTable table, Class<A> annotation, Class<T> instance) {
        HashMap<T, A> map = new HashMap<T, A>();
        for (ASMDataTable.ASMData asmData : AnnotationUtils.getData(table, annotation)) {
            try {
                Class<?> asmClass = Class.forName(asmData.getClassName());
                Class<T> asmInstanceClass = asmClass.asSubclass(instance);
                map.put(asmInstanceClass.newInstance(), asmInstanceClass.getAnnotation(annotation));
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
                Constants.LOG.warn("Could not load " + asmData.getClassName(), (Throwable)e);
            }
        }
        return map;
    }
}

