/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.wawla.plugins.vanilla;

import java.util.List;
import javax.annotation.Nullable;
import mcp.mobius.waila.api.IEntityAccessor;
import mcp.mobius.waila.api.IEntityComponentProvider;
import mcp.mobius.waila.api.IPluginConfig;
import mcp.mobius.waila.api.IRegistrar;
import mcp.mobius.waila.api.TooltipPosition;
import net.darkhax.wawla.lib.Feature;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.merchant.villager.VillagerData;
import net.minecraft.entity.merchant.villager.VillagerEntity;
import net.minecraft.entity.monster.AbstractIllagerEntity;
import net.minecraft.entity.monster.WitchEntity;
import net.minecraft.entity.monster.ZombieVillagerEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public class FeatureVillagerProfession
extends Feature
implements IEntityComponentProvider {
    private static final ResourceLocation ENABLED = new ResourceLocation("wawla", "villager_type");

    @Override
    public void initialize(IRegistrar hwyla) {
        hwyla.addConfig(ENABLED, true);
        hwyla.registerComponentProvider((IEntityComponentProvider)this, TooltipPosition.BODY, VillagerEntity.class);
        hwyla.registerComponentProvider((IEntityComponentProvider)this, TooltipPosition.BODY, ZombieVillagerEntity.class);
        hwyla.registerComponentProvider((IEntityComponentProvider)this, TooltipPosition.BODY, WitchEntity.class);
        hwyla.registerComponentProvider((IEntityComponentProvider)this, TooltipPosition.BODY, AbstractIllagerEntity.class);
    }

    public void appendBody(List<ITextComponent> info, IEntityAccessor accessor, IPluginConfig config) {
        ITextComponent profession;
        if (config.get(ENABLED) && (profession = this.getProfessionName(accessor.getEntity())) != null) {
            this.addInfo(info, "profession", profession);
        }
    }

    @Nullable
    private ITextComponent getProfessionName(Entity entity) {
        if (entity instanceof VillagerEntity) {
            return this.getProfessionName(((VillagerEntity)entity).func_213700_eh());
        }
        if (entity instanceof ZombieVillagerEntity) {
            return this.getProfessionName(((ZombieVillagerEntity)entity).func_213700_eh());
        }
        if (entity instanceof WitchEntity) {
            return this.getProfessionName("witch");
        }
        if (entity instanceof AbstractIllagerEntity) {
            return this.getProfessionName("illager");
        }
        return null;
    }

    @Nullable
    private ITextComponent getProfessionName(VillagerData data) {
        if (data != null) {
            ResourceLocation profName = data.func_221130_b().getRegistryName();
            return new TranslationTextComponent(EntityType.field_200756_av.func_210760_d() + '.' + (!"minecraft".equals(profName.func_110624_b()) ? profName.func_110624_b() + '.' : "") + profName.func_110623_a(), new Object[0]);
        }
        return null;
    }

    @Nullable
    private ITextComponent getProfessionName(String profession) {
        return new TranslationTextComponent(EntityType.field_200756_av.func_210760_d() + ".wawla." + profession, new Object[0]);
    }
}

