/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.icse.client.render;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.mojang.realmsclient.gui.ChatFormatting;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import net.darkhax.icse.ICSE;
import net.darkhax.icse.common.packet.PacketRequestInfo;
import net.darkhax.icse.lib.DataAccess;
import net.darkhax.icse.lib.Utilities;
import net.darkhax.icse.plugins.InfoPlugin;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItemFrame;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EntitySelectors;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class RenderingHandler {
    public static NBTTagCompound dataTag = new NBTTagCompound();
    private static UUID lastEntity;
    private static int lineCount;

    @SubscribeEvent
    public void onOverlayRendered(RenderGameOverlayEvent.Text event) {
        block16: {
            IBlockState state;
            RayTraceResult results;
            Minecraft mc;
            block17: {
                mc = Minecraft.func_71410_x();
                if (mc.field_71474_y.field_74330_P) {
                    return;
                }
                if (event.getType() != RenderGameOverlayEvent.ElementType.TEXT) break block16;
                float distance = mc.field_71442_b.func_78757_d();
                Entity entity = this.getMouseOver(mc, event.getPartialTicks());
                results = this.rayTrace(mc.func_175606_aa(), distance, event.getPartialTicks());
                if (results == null || mc.field_71441_e == null) break block16;
                state = mc.field_71441_e.func_180495_p(results.func_178782_a());
                if (entity == null) break block17;
                if (lastEntity != null && !lastEntity.equals(entity.func_110124_au())) {
                    dataTag = new NBTTagCompound();
                }
                lastEntity = entity.func_110124_au();
                DataAccess info = new DataAccess((World)mc.field_71441_e, (EntityPlayer)mc.field_71439_g, entity, dataTag);
                boolean requireSync = false;
                for (InfoPlugin infoPlugin : ICSE.plugins) {
                    if (!infoPlugin.requireEntitySync((World)mc.field_71441_e, entity)) continue;
                    requireSync = true;
                }
                if (requireSync && mc.field_71439_g.field_70173_aa % 20 == 0) {
                    ICSE.network.sendToServer((IMessage)new PacketRequestInfo(entity.func_110124_au()));
                }
                if (!info.isValidEntity()) break block16;
                for (InfoPlugin infoPlugin : ICSE.plugins) {
                    if (!infoPlugin.requireEntityOverride(info)) continue;
                    info = infoPlugin.overrideEntity(info);
                }
                if (info.isValidEntity()) {
                    lineCount = 0;
                    ArrayList<String> lines = new ArrayList<String>();
                    lines.add(info.entity.func_145748_c_().func_150254_d());
                    for (InfoPlugin provider : ICSE.plugins) {
                        provider.addEntityInfo(lines, info);
                    }
                    lines.add(ChatFormatting.BLUE + "" + ChatFormatting.ITALIC + Utilities.getModName(info.entity));
                    for (String line : lines) {
                        mc.field_71466_p.func_175063_a(line, 10.0f, (float)this.getLineOffset(), 0xFFFFFF);
                    }
                }
                break block16;
            }
            if (state != null && state.func_177230_c() != null) {
                DataAccess info = new DataAccess(results, (World)mc.field_71441_e, (EntityPlayer)mc.field_71439_g, state, results.func_178782_a(), results.field_178784_b, dataTag);
                boolean requireSync = false;
                for (InfoPlugin infoPlugin : ICSE.plugins) {
                    if (!infoPlugin.requireTileSync((World)mc.field_71441_e, mc.field_71441_e.func_175625_s(info.pos))) continue;
                    requireSync = true;
                }
                if (requireSync && mc.field_71439_g.field_70173_aa % 20 == 0) {
                    ICSE.network.sendToServer((IMessage)new PacketRequestInfo(results.func_178782_a()));
                }
                if (info.isValidBlock()) {
                    for (InfoPlugin infoPlugin : ICSE.plugins) {
                        if (!infoPlugin.requireTileOverride(info)) continue;
                        info = infoPlugin.overrideTile(info);
                    }
                    if (info.isValidBlock()) {
                        lineCount = 0;
                        ArrayList lines = new ArrayList();
                        lines.add(info.stack.func_82833_r());
                        for (InfoPlugin provider : ICSE.plugins) {
                            provider.addTileInfo(lines, info);
                        }
                        lines.add(ChatFormatting.BLUE + "" + ChatFormatting.ITALIC + Utilities.getModName(info.stack));
                        Iterator iterator = lines.iterator();
                        while (iterator.hasNext()) {
                            String line = (String)iterator.next();
                            mc.field_71466_p.func_175063_a(line, 10.0f, (float)this.getLineOffset(), 0xFFFFFF);
                        }
                    }
                }
            }
        }
    }

    public int getLineOffset() {
        return ++lineCount * 10;
    }

    public RayTraceResult rayTrace(Entity entity, double distance, float partialTicks) {
        Vec3d vec3 = entity.func_174824_e(partialTicks);
        Vec3d vec31 = entity.func_70676_i(partialTicks);
        Vec3d vec32 = vec3.func_72441_c(vec31.field_72450_a * distance, vec31.field_72448_b * distance, vec31.field_72449_c * distance);
        return entity.field_70170_p.func_72901_a(vec3, vec32, false);
    }

    public Entity getMouseOver(Minecraft mc, float partialTicks) {
        Entity pointedEntity = null;
        Entity entity = mc.func_175606_aa();
        if (entity != null && mc.field_71441_e != null) {
            mc.field_71424_I.func_76320_a("pick");
            mc.field_147125_j = null;
            double d0 = mc.field_71442_b.func_78757_d();
            mc.field_71476_x = entity.func_174822_a(d0, partialTicks);
            double d1 = d0;
            Vec3d vec3d = entity.func_174824_e(partialTicks);
            boolean flag = false;
            if (mc.field_71442_b.func_78749_i()) {
                d0 = 6.0;
                d1 = 6.0;
            } else if (d0 > 3.0) {
                flag = true;
            }
            if (mc.field_71476_x != null) {
                d1 = mc.field_71476_x.field_72307_f.func_72438_d(vec3d);
            }
            Vec3d vec3d1 = entity.func_70676_i(partialTicks);
            Vec3d vec3d2 = vec3d.func_72441_c(vec3d1.field_72450_a * d0, vec3d1.field_72448_b * d0, vec3d1.field_72449_c * d0);
            Vec3d vec3d3 = null;
            float f = 1.0f;
            List list = mc.field_71441_e.func_175674_a(entity, entity.func_174813_aQ().func_72321_a(vec3d1.field_72450_a * d0, vec3d1.field_72448_b * d0, vec3d1.field_72449_c * d0).func_72314_b(1.0, 1.0, 1.0), Predicates.and((Predicate)EntitySelectors.field_180132_d, (Predicate)new Predicate<Entity>(){

                public boolean apply(Entity entity) {
                    return entity != null;
                }
            }));
            double d2 = d1;
            for (int j = 0; j < list.size(); ++j) {
                double d3;
                Entity entity1 = (Entity)list.get(j);
                AxisAlignedBB axisalignedbb = entity1.func_174813_aQ().func_186662_g((double)entity1.func_70111_Y());
                RayTraceResult raytraceresult = axisalignedbb.func_72327_a(vec3d, vec3d2);
                if (axisalignedbb.func_72318_a(vec3d)) {
                    if (!(d2 >= 0.0)) continue;
                    pointedEntity = entity1;
                    vec3d3 = raytraceresult == null ? vec3d : raytraceresult.field_72307_f;
                    d2 = 0.0;
                    continue;
                }
                if (raytraceresult == null || !((d3 = vec3d.func_72438_d(raytraceresult.field_72307_f)) < d2) && d2 != 0.0) continue;
                if (entity1.func_184208_bv() == entity.func_184208_bv() && !entity.canRiderInteract()) {
                    if (d2 != 0.0) continue;
                    pointedEntity = entity1;
                    vec3d3 = raytraceresult.field_72307_f;
                    continue;
                }
                pointedEntity = entity1;
                vec3d3 = raytraceresult.field_72307_f;
                d2 = d3;
            }
            if (pointedEntity != null && flag && vec3d.func_72438_d(vec3d3) > 3.0) {
                pointedEntity = null;
                mc.field_71476_x = new RayTraceResult(RayTraceResult.Type.MISS, vec3d3, (EnumFacing)null, new BlockPos(vec3d3));
            }
            if (pointedEntity != null && (d2 < d1 || mc.field_71476_x == null)) {
                mc.field_71476_x = new RayTraceResult(pointedEntity, vec3d3);
                if (pointedEntity instanceof EntityLivingBase || pointedEntity instanceof EntityItemFrame) {
                    mc.field_147125_j = pointedEntity;
                }
            }
            mc.field_71424_I.func_76319_b();
        }
        return pointedEntity;
    }
}

