/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.wawla.plugins.generic.tiles;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.darkhax.wawla.lib.InfoAccess;
import net.darkhax.wawla.plugins.InfoProvider;
import net.minecraft.block.Block;
import net.minecraft.block.BlockOre;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemTool;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.oredict.OreDictionary;

public class PluginHarvestability
extends InfoProvider {
    private static final Map<String, ItemStack> overrides = new HashMap<String, ItemStack>();
    private static boolean enabled = true;
    private static boolean oresOnly = true;
    private static boolean showHarvestable = true;
    private static boolean showCorrectTier = true;
    private static boolean showCorrectTool = true;

    @Override
    public void addTileInfo(List<String> info, InfoAccess data) {
        boolean isValidBlock;
        if (!enabled) {
            return;
        }
        ItemStack heldItem = data.player.func_184614_ca();
        String toolType = this.getEffectiveTool(data.world, data.state, data.pos);
        int blockLevel = data.block.getHarvestLevel(data.state);
        int itemLevel = heldItem != null ? heldItem.func_77973_b().getHarvestLevel(heldItem, toolType) : 0;
        boolean bl = isValidBlock = oresOnly && this.isOre(new ItemStack(data.block)) || !oresOnly;
        if (isValidBlock && heldItem != null && heldItem.func_77973_b().getToolClasses(heldItem).contains(toolType)) {
            if (showHarvestable && (blockLevel <= itemLevel || blockLevel == 0)) {
                info.add(I18n.func_74838_a((String)"tooltip.wawla.generic.harvestable") + ": " + InfoProvider.getBooleanForDisplay(true));
            } else {
                if (showHarvestable) {
                    info.add(I18n.func_74838_a((String)"tooltip.wawla.generic.harvestable") + ": " + InfoProvider.getBooleanForDisplay(false));
                }
                if (showCorrectTier) {
                    info.add(I18n.func_74838_a((String)"tooltip.wawla.generic.showtier") + ": " + blockLevel);
                }
            }
        } else if (isValidBlock && toolType != null && showCorrectTool) {
            String translation = I18n.func_74838_a((String)("tooltip.wawla." + toolType));
            info.add(I18n.func_74838_a((String)"tooltip.wawla.generic.tooltype") + ": " + (translation.startsWith("tooltip.wawla.") ? toolType : translation));
        }
    }

    @Override
    public void syncConfig(Configuration config) {
        enabled = config.getBoolean("Harvestability", "generic_tiles", true, "If this is enabled, the hud will display information about tool harvestability.");
        oresOnly = config.getBoolean("Harvestability_OnlyOres", "generic_tiles", true, "When enabled, only ore blocks will show harvestability info.");
        showHarvestable = config.getBoolean("Harvestability_Harvestable", "generic_tiles", true, "When enabled, shows if the current tile can be harvested or not.");
        showCorrectTier = config.getBoolean("Harvestability_Tier", "generic_tiles", true, "When enabled, shows the required tool tier, if the correct tool is used, but it is not good enough.");
        showCorrectTool = config.getBoolean("Harvestability_Tool", "generic_tiles", true, "When enabled, shows the required tool, if the correct one is not being held.");
    }

    private boolean isOre(ItemStack stack) {
        if (stack == null || stack.func_77973_b() == null) {
            return false;
        }
        if (Block.func_149634_a((Item)stack.func_77973_b()) instanceof BlockOre) {
            return true;
        }
        for (int oreID : OreDictionary.getOreIDs((ItemStack)stack)) {
            if (!OreDictionary.getOreName((int)oreID).startsWith("ore")) continue;
            return true;
        }
        return stack.func_82833_r().matches(".*(^|\\s)([oO]re)($|\\s).");
    }

    private String getEffectiveTool(World world, IBlockState state, BlockPos pos) {
        float blockHardness;
        String tool = state.func_177230_c().getHarvestTool(state);
        if ((tool == null || tool.isEmpty()) && (blockHardness = state.func_177230_c().func_176195_g(state, world, pos)) > 0.0f) {
            for (Map.Entry<String, ItemStack> entry : overrides.entrySet()) {
                ItemStack stack = entry.getValue();
                if (!(stack.func_77973_b() instanceof ItemTool) || !(stack.func_77973_b().func_150893_a(stack, state) >= ((ItemTool)stack.func_77973_b()).func_150913_i().func_77998_b())) continue;
                tool = entry.getKey();
                break;
            }
        }
        return tool;
    }

    static {
        overrides.put("pickaxe", new ItemStack(Items.field_151039_o));
        overrides.put("axe", new ItemStack(Items.field_151053_p));
        overrides.put("shovel", new ItemStack(Items.field_151038_n));
    }
}

