/*
 * Decompiled with CFR 0.152.
 */
package bspkrs.fml.util;

import java.util.HashMap;
import net.minecraft.client.settings.KeyBinding;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.InputEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;

@SideOnly(value=Side.CLIENT)
public abstract class InputEventListener {
    private static HashMap<KeyBinding, InputEventListener> instances = new HashMap();
    protected KeyBinding keyBinding;
    protected boolean isKeyDown;
    protected boolean allowRepeats;

    public InputEventListener(KeyBinding keyBinding, boolean allowRepeats) {
        this.keyBinding = keyBinding;
        this.allowRepeats = allowRepeats;
        this.isKeyDown = false;
        instances.put(keyBinding, this);
        ClientRegistry.registerKeyBinding((KeyBinding)keyBinding);
    }

    public KeyBinding getKeyBinding() {
        return this.keyBinding;
    }

    @SubscribeEvent
    public void onKeyInputEvent(InputEvent.KeyInputEvent event) {
        this.onInputEvent((InputEvent)event);
    }

    @SubscribeEvent
    public void onMouseInputEvent(InputEvent.MouseInputEvent event) {
        this.onInputEvent((InputEvent)event);
    }

    private void onInputEvent(InputEvent event) {
        boolean state;
        int keyCode = this.keyBinding.func_151463_i();
        boolean bl = state = keyCode < 0 ? Mouse.isButtonDown((int)(keyCode + 100)) : Keyboard.isKeyDown((int)keyCode);
        if (state != this.isKeyDown || state && this.allowRepeats) {
            if (state) {
                this.keyDown(this.keyBinding, state == this.isKeyDown);
            } else {
                this.keyUp(this.keyBinding);
            }
            this.isKeyDown = state;
        }
    }

    public abstract void keyDown(KeyBinding var1, boolean var2);

    public abstract void keyUp(KeyBinding var1);

    public static boolean isRegistered(KeyBinding kb) {
        return instances.containsKey(kb);
    }

    public static void unRegister(KeyBinding kb) {
        if (InputEventListener.isRegistered(kb)) {
            MinecraftForge.EVENT_BUS.unregister((Object)instances.get(kb));
            instances.remove(kb);
        }
    }
}

