/*
 * Decompiled with CFR 0.152.
 */
package bspkrs.util;

import bspkrs.util.CommonUtils;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.registry.GameData;
import net.minecraftforge.fml.common.registry.IForgeRegistryEntry;

public class ItemID {
    public final String id;
    public final int damage;

    public ItemID(String id, int damage) {
        this.id = id;
        this.damage = damage;
    }

    public ItemID(String id) {
        this(id, -1);
    }

    public ItemID(ItemStack itemStack, int damage) {
        this(itemStack.func_77973_b(), damage);
    }

    public ItemID(ItemStack itemStack) {
        this(itemStack.func_77973_b(), -1);
    }

    public ItemID(Item item, int damage) {
        this(GameData.getItemRegistry().getNameForObject((IForgeRegistryEntry)item).toString(), damage);
    }

    public ItemID(Item item) {
        this(GameData.getItemRegistry().getNameForObject((IForgeRegistryEntry)item).toString(), -1);
    }

    public ItemID(String format, String delimiter) {
        String[] parts = format.split(delimiter);
        if (parts.length > 1) {
            this.id = parts[0].trim();
            this.damage = CommonUtils.parseInt(parts[1], -1);
        } else {
            this.id = parts[0].trim();
            this.damage = -1;
        }
    }

    public ItemID clone() {
        return new ItemID(this.id, this.damage);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ItemID)) {
            return false;
        }
        ItemID o = (ItemID)obj;
        if (o.damage == -1 || this.damage == -1) {
            return this.id != null ? this.id.equals(o.id) : o.id == null;
        }
        return this.id != null ? this.id.equals(o.id) && this.damage == o.damage : o.id == null && this.damage == o.damage;
    }

    public int hashCode() {
        return this.id.hashCode() * 31;
    }

    public String toString() {
        return this.damage == -1 ? this.id + "" : this.id + ", " + this.damage;
    }
}

