/*
 * Decompiled with CFR 0.152.
 */
package bspkrs.util.config;

import bspkrs.util.config.Configuration;
import bspkrs.util.config.Property;
import bspkrs.util.config.gui.GuiPropertyList;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.io.BufferedWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

public class ConfigCategory
implements Map<String, Property> {
    private String name;
    private String comment = "";
    private String languagekey;
    private ArrayList<ConfigCategory> children = new ArrayList();
    private Map<String, Property> properties = new TreeMap<String, Property>();
    private int propNumber = 0;
    public final ConfigCategory parent;
    private boolean changed = false;
    private boolean isHotLoadable = false;
    private Class<? extends GuiPropertyList.IGuiConfigListEntry> customEntryClass = null;
    private List<String> propertyOrder = null;

    public ConfigCategory(String name) {
        this(name, null);
    }

    public ConfigCategory(String name, ConfigCategory parent) {
        this.name = name;
        this.parent = parent;
        if (parent != null) {
            parent.children.add(this);
        }
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof ConfigCategory) {
            ConfigCategory cat = (ConfigCategory)obj;
            return this.name.equals(cat.name) && this.children.equals(cat.children);
        }
        return false;
    }

    public String getName() {
        return this.name;
    }

    public String getQualifiedName() {
        return ConfigCategory.getQualifiedName(this.name, this.parent);
    }

    public static String getQualifiedName(String name, ConfigCategory parent) {
        return parent == null ? name : parent.getQualifiedName() + "." + name;
    }

    public ConfigCategory getFirstParent() {
        return this.parent == null ? this : this.parent.getFirstParent();
    }

    public boolean isChild() {
        return this.parent != null;
    }

    public Map<String, Property> getValues() {
        return ImmutableMap.copyOf(this.properties);
    }

    public Property[] getOrderedValuesArray() {
        if (this.propertyOrder != null) {
            ArrayList<Property> list = new ArrayList<Property>();
            for (String s : this.propertyOrder) {
                if (!this.properties.containsKey(s)) continue;
                list.add(this.properties.get(s));
            }
            return list.toArray(new Property[list.size()]);
        }
        return this.properties.values().toArray(new Property[this.properties.size()]);
    }

    public Set<Property> getOrderedValuesSet() {
        if (this.propertyOrder != null) {
            LinkedHashSet<Property> set = new LinkedHashSet<Property>();
            for (String key : this.propertyOrder) {
                if (!this.properties.containsKey(key)) continue;
                set.add(this.properties.get(key));
            }
            return ImmutableSet.copyOf(set);
        }
        return ImmutableSet.copyOf(this.properties.values());
    }

    public ConfigCategory setCustomIGuiConfigListEntryClass(Class<? extends GuiPropertyList.IGuiConfigListEntry> clazz) {
        this.customEntryClass = clazz;
        return this;
    }

    public Class<? extends GuiPropertyList.IGuiConfigListEntry> getCustomIGuiConfigListEntryClass() {
        return this.customEntryClass;
    }

    public ConfigCategory setLanguageKey(String languagekey) {
        this.languagekey = languagekey;
        return this;
    }

    public String getLanguagekey() {
        if (this.languagekey != null) {
            return this.languagekey;
        }
        return this.getQualifiedName();
    }

    public ConfigCategory setComment(String comment) {
        this.comment = comment;
        return this;
    }

    public String getComment() {
        return this.comment;
    }

    public ConfigCategory setIsHotLoadable(boolean isHotLoadable) {
        this.isHotLoadable = isHotLoadable;
        return this;
    }

    public boolean isHotLoadable() {
        return this.isHotLoadable;
    }

    public ConfigCategory setPropertyOrder(List<String> propertyOrder) {
        this.propertyOrder = propertyOrder;
        for (String s : this.properties.keySet()) {
            if (propertyOrder.contains(s)) continue;
            propertyOrder.add(s);
        }
        return this;
    }

    public List<String> getPropertyOrder() {
        if (this.propertyOrder != null) {
            return ImmutableList.copyOf(this.propertyOrder);
        }
        return ImmutableList.copyOf(this.properties.keySet());
    }

    public boolean containsKey(String key) {
        return this.properties.containsKey(key);
    }

    public Property get(String key) {
        return this.properties.get(key);
    }

    private void write(BufferedWriter out, String ... data) throws IOException {
        this.write(out, true, data);
    }

    private void write(BufferedWriter out, boolean new_line, String ... data) throws IOException {
        for (int x = 0; x < data.length; ++x) {
            out.write(data[x]);
        }
        if (new_line) {
            out.write(Configuration.NEW_LINE);
        }
    }

    public void write(BufferedWriter out, int indent) throws IOException {
        String pad0 = this.getIndent(indent);
        String pad1 = this.getIndent(indent + 1);
        String pad2 = this.getIndent(indent + 2);
        if (this.comment != null && !this.comment.isEmpty()) {
            this.write(out, pad0, "##########################################################################################################");
            this.write(out, pad0, "# ", this.name);
            this.write(out, pad0, "#--------------------------------------------------------------------------------------------------------#");
            Splitter splitter = Splitter.onPattern((String)"\r?\n");
            for (String line : splitter.split((CharSequence)this.comment)) {
                this.write(out, pad0, "# ", line);
            }
            this.write(out, pad0, "##########################################################################################################", Configuration.NEW_LINE);
        }
        if (!Configuration.allowedProperties.matchesAllOf((CharSequence)this.name)) {
            this.name = '\"' + this.name + '\"';
        }
        this.write(out, pad0, this.name, " {");
        Property[] props = this.getOrderedValuesArray();
        for (int x = 0; x < props.length; ++x) {
            String propName;
            Property prop = props[x];
            if (prop.comment != null && !prop.comment.isEmpty()) {
                if (x != 0) {
                    out.newLine();
                }
                Splitter splitter = Splitter.onPattern((String)"\r?\n");
                for (String commentLine : splitter.split((CharSequence)prop.comment)) {
                    this.write(out, pad1, "# ", commentLine);
                }
            }
            if (!Configuration.allowedProperties.matchesAllOf((CharSequence)(propName = prop.getName()))) {
                propName = '\"' + propName + '\"';
            }
            if (prop.isList()) {
                char type = prop.getType().getID();
                this.write(out, pad1, String.valueOf(type), ":", propName, " <");
                for (String line : prop.getStringList()) {
                    this.write(out, pad2, line);
                }
                this.write(out, pad1, " >");
                continue;
            }
            if (prop.getType() == null) {
                this.write(out, pad1, propName, "=", prop.getString());
                continue;
            }
            char type = prop.getType().getID();
            this.write(out, pad1, String.valueOf(type), ":", propName, "=", prop.getString());
        }
        if (this.children.size() > 0) {
            out.newLine();
        }
        for (ConfigCategory child : this.children) {
            child.write(out, indent + 1);
        }
        this.write(out, pad0, "}", Configuration.NEW_LINE);
    }

    private String getIndent(int indent) {
        StringBuilder buf = new StringBuilder("");
        for (int x = 0; x < indent; ++x) {
            buf.append("    ");
        }
        return buf.toString();
    }

    public boolean hasChanged() {
        if (this.changed) {
            return true;
        }
        for (Property prop : this.properties.values()) {
            if (!prop.hasChanged()) continue;
            return true;
        }
        return false;
    }

    void resetChangedState() {
        this.changed = false;
        for (Property prop : this.properties.values()) {
            prop.resetChangedState();
        }
    }

    @Override
    public int size() {
        return this.properties.size();
    }

    @Override
    public boolean isEmpty() {
        return this.properties.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.properties.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.properties.containsValue(value);
    }

    @Override
    public Property get(Object key) {
        return this.properties.get(key);
    }

    @Override
    public Property put(String key, Property value) {
        this.changed = true;
        if (this.propertyOrder != null && !this.propertyOrder.contains(key)) {
            this.propertyOrder.add(key);
        }
        return this.properties.put(key, value);
    }

    @Override
    public Property remove(Object key) {
        this.changed = true;
        return this.properties.remove(key);
    }

    @Override
    public void putAll(Map<? extends String, ? extends Property> m) {
        this.changed = true;
        if (this.propertyOrder != null) {
            for (String string : m.keySet()) {
                if (this.propertyOrder.contains(string)) continue;
                this.propertyOrder.add(string);
            }
        }
        this.properties.putAll(m);
    }

    @Override
    public void clear() {
        this.changed = true;
        this.properties.clear();
    }

    @Override
    public Set<String> keySet() {
        return this.properties.keySet();
    }

    @Override
    public Collection<Property> values() {
        return this.properties.values();
    }

    @Override
    public Set<Map.Entry<String, Property>> entrySet() {
        return ImmutableSet.copyOf(this.properties.entrySet());
    }

    public Set<ConfigCategory> getChildren() {
        return ImmutableSet.copyOf(this.children);
    }

    public ConfigCategory removeChild(ConfigCategory child) {
        if (this.children.contains(child)) {
            this.children.remove(child);
            this.changed = true;
        }
        return this;
    }
}

