/*
 * Decompiled with CFR 0.152.
 */
package bspkrs.util.config;

import bspkrs.util.config.gui.GuiPropertyList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.regex.Pattern;

public class Property {
    private String name;
    private String value;
    private String defaultValue;
    public String comment;
    private String[] values;
    private String[] defaultValues;
    private String[] validValues;
    private String langKey;
    private String minValue;
    private String maxValue;
    private Class<? extends GuiPropertyList.IGuiConfigListEntry> customEntryClass = null;
    private boolean isHotLoadable;
    private Pattern stringValidationPattern;
    private final boolean wasRead;
    private final boolean isList;
    private boolean isListLengthFixed = false;
    private int maxListLength = -1;
    private final Type type;
    private boolean changed = false;

    public Property(String name, String value, Type type) {
        this(name, value, type, false, new String[0], name);
    }

    public Property(String name, String value, Type type, boolean read) {
        this(name, value, type, read, new String[0], name);
    }

    public Property(String name, String value, Type type, String[] validValues) {
        this(name, value, type, false, validValues, name);
    }

    public Property(String name, String value, Type type, String langKey) {
        this(name, value, type, false, new String[0], langKey);
    }

    public Property(String name, String value, Type type, boolean read, String langKey) {
        this(name, value, type, read, new String[0], langKey);
    }

    public Property(String name, String value, Type type, String[] validValues, String langKey) {
        this(name, value, type, false, validValues, langKey);
    }

    Property(String name, String value, Type type, boolean read, String[] validValues, String langKey) {
        this.setName(name);
        this.value = value;
        this.values = new String[0];
        this.defaultValue = value;
        this.defaultValues = new String[0];
        this.validValues = validValues;
        this.type = type;
        this.isHotLoadable = false;
        this.wasRead = read;
        this.isList = false;
        this.isListLengthFixed = false;
        this.maxListLength = -1;
        this.minValue = String.valueOf(Integer.MIN_VALUE);
        this.maxValue = String.valueOf(Integer.MAX_VALUE);
        this.langKey = langKey;
        this.comment = "";
    }

    public Property(String name, String[] values, Type type) {
        this(name, values, type, false);
    }

    Property(String name, String[] values, Type type, boolean read) {
        this(name, values, type, read, new String[0], name);
    }

    public Property(String name, String[] values, Type type, String langKey) {
        this(name, values, type, false, langKey);
    }

    Property(String name, String[] values, Type type, boolean read, String langKey) {
        this(name, values, type, read, new String[0], langKey);
    }

    Property(String name, String[] values, Type type, boolean read, String[] validValues, String langKey) {
        this.setName(name);
        this.type = type;
        this.value = "";
        this.values = Arrays.copyOf(values, values.length);
        this.defaultValue = "";
        for (String s : values) {
            this.defaultValue = this.defaultValue + ", [" + s + "]";
        }
        this.defaultValue = this.defaultValue.replaceFirst(", ", "");
        this.defaultValues = Arrays.copyOf(values, values.length);
        this.validValues = validValues;
        this.isHotLoadable = false;
        this.wasRead = read;
        this.isList = true;
        this.isListLengthFixed = false;
        this.maxListLength = -1;
        this.minValue = String.valueOf(Integer.MIN_VALUE);
        this.maxValue = String.valueOf(Integer.MAX_VALUE);
        this.langKey = langKey;
        this.comment = "";
    }

    public boolean isDefault() {
        if (this.isBooleanList()) {
            if (this.values.length == this.defaultValues.length) {
                for (int i = 0; i < this.values.length; ++i) {
                    if (Boolean.parseBoolean(this.values[i]) == Boolean.parseBoolean(this.defaultValues[i])) continue;
                    return false;
                }
                return true;
            }
            return false;
        }
        if (this.isIntList()) {
            if (this.values.length == this.defaultValues.length) {
                for (int i = 0; i < this.values.length; ++i) {
                    if (Integer.parseInt(this.values[i]) == Integer.parseInt(this.defaultValues[i])) continue;
                    return false;
                }
                return true;
            }
            return false;
        }
        if (this.isDoubleList()) {
            if (this.values.length == this.defaultValues.length) {
                for (int i = 0; i < this.values.length; ++i) {
                    if (Double.parseDouble(this.values[i]) == Double.parseDouble(this.defaultValues[i])) continue;
                    return false;
                }
                return true;
            }
            return false;
        }
        if (this.isList()) {
            if (this.values.length == this.defaultValues.length) {
                for (int i = 0; i < this.values.length; ++i) {
                    if (this.values[i].equals(this.defaultValues[i])) continue;
                    return false;
                }
                return true;
            }
            return false;
        }
        if (this.type.equals((Object)Type.BOOLEAN) && this.isBooleanValue()) {
            return Boolean.parseBoolean(this.value) == Boolean.parseBoolean(this.defaultValue);
        }
        if (this.type.equals((Object)Type.INTEGER) && this.isIntValue()) {
            return Integer.parseInt(this.value) == Integer.parseInt(this.defaultValue);
        }
        if (this.type.equals((Object)Type.DOUBLE) && this.isDoubleValue()) {
            return Double.parseDouble(this.value) == Double.parseDouble(this.defaultValue);
        }
        return this.value.equals(this.defaultValue);
    }

    public Property setToDefault() {
        this.value = this.defaultValue;
        this.values = Arrays.copyOf(this.defaultValues, this.defaultValues.length);
        return this;
    }

    public String getDefault() {
        return this.defaultValue;
    }

    public String[] getDefaults() {
        return Arrays.copyOf(this.defaultValues, this.defaultValues.length);
    }

    public Property setMaxListLength(int max) {
        this.maxListLength = max;
        if (this.maxListLength != -1) {
            if (this.values != null && this.values.length != this.maxListLength && (this.isListLengthFixed || this.values.length > this.maxListLength)) {
                this.values = Arrays.copyOf(this.values, this.maxListLength);
            }
            if (this.defaultValues != null && this.defaultValues.length != this.maxListLength && (this.isListLengthFixed || this.defaultValues.length > this.maxListLength)) {
                this.defaultValues = Arrays.copyOf(this.defaultValues, this.maxListLength);
            }
        }
        return this;
    }

    public int getMaxListLength() {
        return this.maxListLength;
    }

    public Property setIsListLengthFixed(boolean isListLengthFixed) {
        this.isListLengthFixed = isListLengthFixed;
        return this;
    }

    public boolean isListLengthFixed() {
        return this.isListLengthFixed;
    }

    public Property setIsHotLoadable(boolean isHotLoadable) {
        this.isHotLoadable = isHotLoadable;
        return this;
    }

    public boolean isHotLoadable() {
        return this.isHotLoadable;
    }

    public Property setCustomIGuiConfigListEntryClass(Class<? extends GuiPropertyList.IGuiConfigListEntry> clazz) {
        this.customEntryClass = clazz;
        return this;
    }

    public Class<? extends GuiPropertyList.IGuiConfigListEntry> getCustomIGuiConfigListEntryClass() {
        return this.customEntryClass;
    }

    public Property setValidStringPattern(Pattern validationPattern) {
        this.stringValidationPattern = validationPattern;
        return this;
    }

    public Pattern getValidStringPattern() {
        return this.stringValidationPattern;
    }

    public Property setPropLanguageKey(String langKey) {
        this.langKey = langKey;
        return this;
    }

    @Deprecated
    public void setLanguageKey(String langKey) {
        this.langKey = langKey;
    }

    public String getLanguageKey() {
        return this.langKey;
    }

    public Property setDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
        return this;
    }

    public Property setDefaultValues(String[] defaultValues) {
        this.defaultValue = "";
        for (String s : defaultValues) {
            this.defaultValue = this.defaultValue + ", [" + s + "]";
        }
        this.defaultValue = this.defaultValue.replaceFirst(", ", "");
        this.defaultValues = Arrays.copyOf(defaultValues, defaultValues.length);
        return this;
    }

    public Property setDefaultValue(int defaultValue) {
        this.setDefaultValue(Integer.toString(defaultValue));
        return this;
    }

    public Property setDefaultValues(int[] defaultValues) {
        String[] temp = new String[defaultValues.length];
        for (int i = 0; i < defaultValues.length; ++i) {
            temp[i] = Integer.toString(defaultValues[i]);
        }
        this.setDefaultValues(temp);
        return this;
    }

    public Property setDefaultValue(double defaultValue) {
        this.setDefaultValue(Double.toString(defaultValue));
        return this;
    }

    public Property setDefaultValues(double[] defaultValues) {
        String[] temp = new String[defaultValues.length];
        for (int i = 0; i < defaultValues.length; ++i) {
            temp[i] = Double.toString(defaultValues[i]);
        }
        this.setDefaultValues(temp);
        return this;
    }

    public Property setDefaultValue(boolean defaultValue) {
        this.setDefaultValue(Boolean.toString(defaultValue));
        return this;
    }

    public Property setDefaultValues(boolean[] defaultValues) {
        String[] temp = new String[defaultValues.length];
        for (int i = 0; i < defaultValues.length; ++i) {
            temp[i] = Boolean.toString(defaultValues[i]);
        }
        this.setDefaultValues(temp);
        return this;
    }

    public Property setMinValue(int minValue) {
        this.minValue = Integer.toString(minValue);
        return this;
    }

    public Property setMaxValue(int maxValue) {
        this.maxValue = Integer.toString(maxValue);
        return this;
    }

    public Property setMinValue(double minValue) {
        this.minValue = Double.toString(minValue);
        return this;
    }

    public Property setMaxValue(double maxValue) {
        this.maxValue = Double.toString(maxValue);
        return this;
    }

    public int getMinIntValue() {
        return Integer.parseInt(this.minValue);
    }

    public int getMaxIntValue() {
        return Integer.parseInt(this.maxValue);
    }

    public double getMinDoubleValue() {
        return Double.parseDouble(this.minValue);
    }

    public double getMaxDoubleValue() {
        return Double.parseDouble(this.maxValue);
    }

    public String getString() {
        return this.value;
    }

    public Property setValidValues(String[] validValues) {
        this.validValues = validValues;
        return this;
    }

    public String[] getValidValues() {
        return this.validValues;
    }

    public int getInt() {
        try {
            return Integer.parseInt(this.value);
        }
        catch (NumberFormatException e) {
            return Integer.parseInt(this.defaultValue);
        }
    }

    public int getInt(int _default) {
        try {
            return Integer.parseInt(this.value);
        }
        catch (NumberFormatException e) {
            return _default;
        }
    }

    public boolean isIntValue() {
        try {
            Integer.parseInt(this.value);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    public boolean getBoolean(boolean _default) {
        if (this.isBooleanValue()) {
            return Boolean.parseBoolean(this.value);
        }
        return _default;
    }

    public boolean getBoolean() {
        if (this.isBooleanValue()) {
            return Boolean.parseBoolean(this.value);
        }
        return Boolean.parseBoolean(this.defaultValue);
    }

    public boolean isBooleanValue() {
        return "true".equals(this.value.toLowerCase()) || "false".equals(this.value.toLowerCase());
    }

    public boolean isDoubleValue() {
        try {
            Double.parseDouble(this.value);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    public double getDouble(double _default) {
        try {
            return Double.parseDouble(this.value);
        }
        catch (NumberFormatException e) {
            return _default;
        }
    }

    public double getDouble() {
        try {
            return Double.parseDouble(this.value);
        }
        catch (NumberFormatException e) {
            return Double.parseDouble(this.defaultValue);
        }
    }

    public String[] getStringList() {
        return this.values;
    }

    public int[] getIntList() {
        ArrayList<Integer> nums = new ArrayList<Integer>();
        for (String value : this.values) {
            try {
                nums.add(Integer.parseInt(value));
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        int[] primitives = new int[nums.size()];
        for (int i = 0; i < nums.size(); ++i) {
            primitives[i] = (Integer)nums.get(i);
        }
        return primitives;
    }

    public boolean isIntList() {
        if (this.isList && this.type.equals((Object)Type.INTEGER)) {
            for (String value : this.values) {
                try {
                    Integer.parseInt(value);
                }
                catch (NumberFormatException e) {
                    return false;
                }
            }
        }
        return this.isList;
    }

    public boolean[] getBooleanList() {
        ArrayList<Boolean> tmp = new ArrayList<Boolean>();
        for (String value : this.values) {
            try {
                tmp.add(Boolean.parseBoolean(value));
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        boolean[] primitives = new boolean[tmp.size()];
        for (int i = 0; i < tmp.size(); ++i) {
            primitives[i] = (Boolean)tmp.get(i);
        }
        return primitives;
    }

    public boolean isBooleanList() {
        if (this.isList && this.type.equals((Object)Type.BOOLEAN)) {
            for (String value : this.values) {
                if ("true".equalsIgnoreCase(value) || "false".equalsIgnoreCase(value)) continue;
                return false;
            }
        }
        return this.isList;
    }

    public double[] getDoubleList() {
        ArrayList<Double> tmp = new ArrayList<Double>();
        for (String value : this.values) {
            try {
                tmp.add(Double.parseDouble(value));
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        double[] primitives = new double[tmp.size()];
        for (int i = 0; i < tmp.size(); ++i) {
            primitives[i] = (Double)tmp.get(i);
        }
        return primitives;
    }

    public boolean isDoubleList() {
        if (this.isList && this.type.equals((Object)Type.DOUBLE)) {
            for (String value : this.values) {
                try {
                    Double.parseDouble(value);
                }
                catch (NumberFormatException e) {
                    return false;
                }
            }
        }
        return this.isList;
    }

    public String getName() {
        return this.name;
    }

    public Property setName(String name) {
        this.name = name;
        return this;
    }

    public boolean wasRead() {
        return this.wasRead;
    }

    public Type getType() {
        return this.type;
    }

    public boolean isList() {
        return this.isList;
    }

    public boolean hasChanged() {
        return this.changed;
    }

    void resetChangedState() {
        this.changed = false;
    }

    public Property setValue(String value) {
        this.value = value;
        this.changed = true;
        return this;
    }

    public void set(String value) {
        this.setValue(value);
    }

    public Property setValues(String[] values) {
        this.values = Arrays.copyOf(values, values.length);
        this.changed = true;
        return this;
    }

    @Deprecated
    public void set(String[] values) {
        this.setValues(values);
    }

    public Property setValue(int value) {
        this.setValue(Integer.toString(value));
        return this;
    }

    @Deprecated
    public void set(int value) {
        this.setValue(value);
    }

    public Property setValue(boolean value) {
        this.setValue(Boolean.toString(value));
        return this;
    }

    @Deprecated
    public void set(boolean value) {
        this.setValue(value);
    }

    public Property setValue(double value) {
        this.setValue(Double.toString(value));
        return this;
    }

    @Deprecated
    public void set(double value) {
        this.setValue(value);
    }

    public Property setValues(boolean[] values) {
        this.values = new String[values.length];
        for (int i = 0; i < values.length; ++i) {
            this.values[i] = String.valueOf(values[i]);
        }
        this.changed = true;
        return this;
    }

    @Deprecated
    public void set(boolean[] values) {
        this.setValues(values);
    }

    public Property setValues(int[] values) {
        this.values = new String[values.length];
        for (int i = 0; i < values.length; ++i) {
            this.values[i] = String.valueOf(values[i]);
        }
        this.changed = true;
        return this;
    }

    @Deprecated
    public void set(int[] values) {
        this.setValues(values);
    }

    public Property setValues(double[] values) {
        this.values = new String[values.length];
        for (int i = 0; i < values.length; ++i) {
            this.values[i] = String.valueOf(values[i]);
        }
        this.changed = true;
        return this;
    }

    @Deprecated
    public void set(double[] values) {
        this.setValues(values);
    }

    public static enum Type {
        STRING,
        INTEGER,
        BOOLEAN,
        DOUBLE,
        COLOR,
        ENTITY_LIST('M'),
        BLOCK_LIST('T'),
        ITEMSTACK_LIST('O'),
        DIMENSION_LIST('W'),
        BIOME_LIST('R'),
        MOD_ID('P');

        private char id;
        private static Type[] values;

        private Type() {
            this.id = this.name().charAt(0);
        }

        private Type(char id) {
            this.id = id;
        }

        public static Type tryParse(char id) {
            for (int x = 0; x < values.length; ++x) {
                if (values[x].getID() != id) continue;
                return values[x];
            }
            return STRING;
        }

        public char getID() {
            return this.id;
        }

        static {
            values = new Type[]{STRING, INTEGER, BOOLEAN, DOUBLE, COLOR, ENTITY_LIST, BLOCK_LIST, ITEMSTACK_LIST, DIMENSION_LIST, BIOME_LIST, MOD_ID};
        }
    }
}

