/*
 * Decompiled with CFR 0.152.
 */
package bspkrs.util.config.gui;

import bspkrs.client.util.HUDUtils;
import bspkrs.util.ReflectionHelper;
import bspkrs.util.config.gui.ConfigGuiType;
import bspkrs.util.config.gui.GuiButtonExt;
import bspkrs.util.config.gui.GuiConfig;
import bspkrs.util.config.gui.GuiEditList;
import bspkrs.util.config.gui.GuiPropertyList;
import bspkrs.util.config.gui.HoverChecker;
import bspkrs.util.config.gui.IConfigProperty;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiListExtended;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.EnumChatFormatting;

public class GuiEditListEntries
extends GuiListExtended {
    private GuiEditList parentGuiEditList;
    private Minecraft mc;
    private IConfigProperty prop;
    private List<IGuiEditListEntry> listEntries;
    private boolean isDefault;
    private boolean isChanged;
    private boolean canAddMoreEntries;
    private final int controlWidth;
    private final String[] beforeValues;
    private String[] currentValues;

    public GuiEditListEntries(GuiEditList parent, Minecraft mc, IConfigProperty prop, String[] beforeValues, String[] currentValues) {
        super(mc, parent.field_146294_l, parent.field_146295_m, parent.titleLine2 != null ? (parent.titleLine3 != null ? 43 : 33) : 23, parent.field_146295_m - 32, 20);
        this.parentGuiEditList = parent;
        this.mc = mc;
        this.prop = prop;
        this.beforeValues = beforeValues;
        this.currentValues = currentValues;
        this.func_148130_a(false);
        this.isChanged = !Arrays.deepEquals(beforeValues, currentValues);
        this.isDefault = Arrays.deepEquals(currentValues, prop.getDefaults());
        this.canAddMoreEntries = !prop.isListLengthFixed() && (prop.getMaxListLength() == -1 || currentValues.length < prop.getMaxListLength());
        this.listEntries = new ArrayList<IGuiEditListEntry>();
        this.controlWidth = parent.field_146294_l / 2 - (prop.isListLengthFixed() ? 0 : 48);
        if (prop.isList() && prop.getType().equals((Object)ConfigGuiType.BOOLEAN)) {
            for (String value : currentValues) {
                this.listEntries.add(new EditListBooleanEntry(Boolean.valueOf(value)));
            }
        } else if (prop.isList() && prop.getType().equals((Object)ConfigGuiType.INTEGER)) {
            for (String value : currentValues) {
                this.listEntries.add(new EditListIntegerEntry(Integer.parseInt(value)));
            }
        } else if (prop.isList() && prop.getType().equals((Object)ConfigGuiType.DOUBLE)) {
            for (String value : currentValues) {
                this.listEntries.add(new EditListDoubleEntry(Double.parseDouble(value)));
            }
        } else if (prop.isList()) {
            for (String value : currentValues) {
                this.listEntries.add(new EditListStringEntry(value));
            }
        }
        if (!prop.isListLengthFixed()) {
            this.listEntries.add(new EditListBaseEntry());
        }
    }

    protected int func_148137_d() {
        return this.field_148155_a - this.field_148155_a / 4;
    }

    public int func_148139_c() {
        return this.parentGuiEditList.field_146294_l;
    }

    public IGuiEditListEntry getListEntry(int index) {
        return this.listEntries.get(index);
    }

    protected int func_148127_b() {
        return this.listEntries.size();
    }

    private void addNewEntryAtIndex(int index) {
        if (this.prop.isList() && this.prop.getType().equals((Object)ConfigGuiType.BOOLEAN)) {
            this.listEntries.add(index, new EditListBooleanEntry(true));
        } else if (this.prop.isList() && this.prop.getType().equals((Object)ConfigGuiType.INTEGER)) {
            this.listEntries.add(index, new EditListIntegerEntry(0));
        } else if (this.prop.isList() && this.prop.getType().equals((Object)ConfigGuiType.DOUBLE)) {
            this.listEntries.add(index, new EditListDoubleEntry(0.0));
        } else if (this.prop.isList()) {
            this.listEntries.add(index, new EditListStringEntry(""));
        }
        this.canAddMoreEntries = !this.prop.isListLengthFixed() && (this.prop.getMaxListLength() == -1 || this.listEntries.size() - 1 < this.prop.getMaxListLength());
        this.keyTyped('\u0000', 207);
    }

    private void removeEntryAtIndex(int index) {
        this.listEntries.remove(index);
        this.canAddMoreEntries = !this.prop.isListLengthFixed() && (this.prop.getMaxListLength() == -1 || this.listEntries.size() - 1 < this.prop.getMaxListLength());
        this.keyTyped('\u0000', 207);
    }

    protected boolean isChanged() {
        return this.isChanged;
    }

    protected boolean isDefault() {
        return this.isDefault;
    }

    private void recalculateState() {
        int i;
        int listLength;
        this.isDefault = true;
        this.isChanged = false;
        int n = listLength = this.prop.isListLengthFixed() ? this.listEntries.size() : this.listEntries.size() - 1;
        if (listLength != this.prop.getDefaults().length) {
            this.isDefault = false;
        }
        if (listLength != this.beforeValues.length) {
            this.isChanged = true;
        }
        if (this.isDefault) {
            for (i = 0; i < listLength; ++i) {
                if (this.prop.getDefaults()[i].equals(this.listEntries.get(i).getValue())) continue;
                this.isDefault = false;
            }
        }
        if (!this.isChanged) {
            for (i = 0; i < listLength; ++i) {
                if (this.beforeValues[i].equals(this.listEntries.get(i).getValue())) continue;
                this.isChanged = true;
            }
        }
    }

    protected void keyTyped(char eventChar, int eventKey) {
        for (IGuiEditListEntry entry : this.listEntries) {
            entry.keyTyped(eventChar, eventKey);
        }
        this.recalculateState();
    }

    protected void updateScreen() {
        for (IGuiEditListEntry entry : this.listEntries) {
            entry.updateCursorCounter();
        }
    }

    protected void mouseClicked(int x, int y, int mouseEvent) {
        for (IGuiEditListEntry entry : this.listEntries) {
            entry.mouseClicked(x, y, mouseEvent);
        }
    }

    protected boolean isListSavable() {
        for (IGuiEditListEntry entry : this.listEntries) {
            if (entry.isValueSavable()) continue;
            return false;
        }
        return true;
    }

    protected void saveListChanges() {
        int listLength;
        int n = listLength = this.prop.isListLengthFixed() ? this.listEntries.size() : this.listEntries.size() - 1;
        if (this.parentGuiEditList.slotIndex != -1 && this.parentGuiEditList.parentScreen != null && this.parentGuiEditList.parentScreen instanceof GuiConfig && ((GuiConfig)this.parentGuiEditList.parentScreen).propertyList.getListEntry(this.parentGuiEditList.slotIndex) instanceof GuiPropertyList.EditListPropEntry) {
            GuiPropertyList.EditListPropEntry entry = (GuiPropertyList.EditListPropEntry)((GuiConfig)this.parentGuiEditList.parentScreen).propertyList.getListEntry(this.parentGuiEditList.slotIndex);
            String[] as = new String[listLength];
            for (int i = 0; i < listLength; ++i) {
                as[i] = this.listEntries.get(i).getValue();
            }
            entry.setListFromChildScreen(as);
        } else if (this.prop.isList() && this.prop.getType().equals((Object)ConfigGuiType.BOOLEAN)) {
            boolean[] abol = new boolean[listLength];
            for (int i = 0; i < listLength; ++i) {
                abol[i] = Boolean.parseBoolean(this.listEntries.get(i).getValue());
            }
            this.prop.set(abol);
        } else if (this.prop.isList() && this.prop.getType().equals((Object)ConfigGuiType.INTEGER)) {
            int[] ai = new int[listLength];
            for (int i = 0; i < listLength; ++i) {
                ai[i] = Integer.parseInt(this.listEntries.get(i).getValue());
            }
            this.prop.set(ai);
        } else if (this.prop.isList() && this.prop.getType().equals((Object)ConfigGuiType.DOUBLE)) {
            double[] ad = new double[listLength];
            for (int i = 0; i < listLength; ++i) {
                ad[i] = Double.parseDouble(this.listEntries.get(i).getValue());
            }
            this.prop.set(ad);
        } else if (this.prop.isList()) {
            String[] as = new String[listLength];
            for (int i = 0; i < listLength; ++i) {
                as[i] = this.listEntries.get(i).getValue();
            }
            this.prop.set(as);
        }
    }

    protected void drawScreenPost(int mouseX, int mouseY, float f) {
        for (IGuiEditListEntry entry : this.listEntries) {
            entry.drawToolTip(mouseX, mouseY);
        }
    }

    public static interface IGuiEditListEntry
    extends GuiListExtended.IGuiListEntry {
        public void keyTyped(char var1, int var2);

        public void updateCursorCounter();

        public void mouseClicked(int var1, int var2, int var3);

        public void drawToolTip(int var1, int var2);

        public boolean isValueSavable();

        public String getValue();
    }

    public class EditListBaseEntry
    implements IGuiEditListEntry {
        protected final GuiButtonExt btnAddNewEntryAbove = new GuiButtonExt(0, 0, 0, 18, 18, "+");
        private final HoverChecker addNewEntryAboveHoverChecker;
        protected final GuiButtonExt btnRemoveEntry;
        private final HoverChecker removeEntryHoverChecker;
        private List addNewToolTip;
        private List removeToolTip;
        protected boolean isValidValue = true;
        protected boolean isValidated = false;

        public EditListBaseEntry() {
            this.btnAddNewEntryAbove.packedFGColour = HUDUtils.getColorCode('2', true);
            this.btnAddNewEntryAbove.field_146124_l = ((GuiEditListEntries)GuiEditListEntries.this).parentGuiEditList.enabled;
            this.btnRemoveEntry = new GuiButtonExt(0, 0, 0, 18, 18, "x");
            this.btnRemoveEntry.packedFGColour = HUDUtils.getColorCode('c', true);
            this.btnRemoveEntry.field_146124_l = ((GuiEditListEntries)GuiEditListEntries.this).parentGuiEditList.enabled;
            this.addNewEntryAboveHoverChecker = new HoverChecker(this.btnAddNewEntryAbove, 800);
            this.removeEntryHoverChecker = new HoverChecker(this.btnRemoveEntry, 800);
            this.addNewToolTip = new ArrayList();
            this.removeToolTip = new ArrayList();
            this.addNewToolTip.add(I18n.func_135052_a((String)"bspkrs.configgui.tooltip.addNewEntryAbove", (Object[])new Object[0]));
            this.removeToolTip.add(I18n.func_135052_a((String)"bspkrs.configgui.tooltip.removeEntry", (Object[])new Object[0]));
        }

        public void func_148279_a(int slotIndex, int x, int y, int listWidth, int slotHeight, Tessellator tessellator, int mouseX, int mouseY, boolean isSelected) {
            if (this.getValue() != null && this.isValidated) {
                ((GuiEditListEntries)GuiEditListEntries.this).mc.field_71466_p.func_78276_b(this.isValidValue ? EnumChatFormatting.GREEN + "\u2714" : EnumChatFormatting.RED + "\u2715", listWidth / 4 - ((GuiEditListEntries)GuiEditListEntries.this).mc.field_71466_p.func_78256_a("\u2714") - 2, y + slotHeight / 2 - ((GuiEditListEntries)GuiEditListEntries.this).mc.field_71466_p.field_78288_b / 2, 0xFFFFFF);
            }
            int half = listWidth / 2;
            if (GuiEditListEntries.this.canAddMoreEntries) {
                this.btnAddNewEntryAbove.field_146125_m = true;
                this.btnAddNewEntryAbove.field_146128_h = half + (half / 2 - 44);
                this.btnAddNewEntryAbove.field_146129_i = y;
                this.btnAddNewEntryAbove.func_146112_a(GuiEditListEntries.this.mc, mouseX, mouseY);
            } else {
                this.btnAddNewEntryAbove.field_146125_m = false;
            }
            if (!GuiEditListEntries.this.prop.isListLengthFixed() && slotIndex != GuiEditListEntries.this.listEntries.size() - 1) {
                this.btnRemoveEntry.field_146125_m = true;
                this.btnRemoveEntry.field_146128_h = half + (half / 2 - 22);
                this.btnRemoveEntry.field_146129_i = y;
                this.btnRemoveEntry.func_146112_a(GuiEditListEntries.this.mc, mouseX, mouseY);
            } else {
                this.btnRemoveEntry.field_146125_m = false;
            }
        }

        @Override
        public void drawToolTip(int mouseX, int mouseY) {
            boolean canHover;
            boolean bl = canHover = mouseY < GuiEditListEntries.this.field_148154_c && mouseY > GuiEditListEntries.this.field_148153_b;
            if (this.btnAddNewEntryAbove.field_146125_m && this.addNewEntryAboveHoverChecker.checkHover(mouseX, mouseY, canHover)) {
                GuiEditListEntries.this.parentGuiEditList.drawToolTip(this.addNewToolTip, mouseX, mouseY);
            }
            if (this.btnRemoveEntry.field_146125_m && this.removeEntryHoverChecker.checkHover(mouseX, mouseY, canHover)) {
                GuiEditListEntries.this.parentGuiEditList.drawToolTip(this.removeToolTip, mouseX, mouseY);
            }
        }

        public boolean func_148278_a(int index, int x, int y, int mouseEvent, int relativeX, int relativeY) {
            if (this.btnAddNewEntryAbove.func_146116_c(GuiEditListEntries.this.mc, x, y)) {
                this.btnAddNewEntryAbove.func_146113_a(GuiEditListEntries.this.mc.func_147118_V());
                GuiEditListEntries.this.addNewEntryAtIndex(index);
                GuiEditListEntries.this.recalculateState();
                return true;
            }
            if (this.btnRemoveEntry.func_146116_c(GuiEditListEntries.this.mc, x, y)) {
                this.btnRemoveEntry.func_146113_a(GuiEditListEntries.this.mc.func_147118_V());
                GuiEditListEntries.this.removeEntryAtIndex(index);
                GuiEditListEntries.this.recalculateState();
                return true;
            }
            return false;
        }

        public void func_148277_b(int index, int x, int y, int mouseEvent, int relativeX, int relativeY) {
            this.btnAddNewEntryAbove.func_146118_a(x, y);
            this.btnRemoveEntry.func_146118_a(x, y);
        }

        @Override
        public void keyTyped(char eventChar, int eventKey) {
        }

        @Override
        public void updateCursorCounter() {
        }

        @Override
        public void mouseClicked(int x, int y, int mouseEvent) {
        }

        @Override
        public boolean isValueSavable() {
            return this.isValidValue;
        }

        @Override
        public String getValue() {
            return null;
        }
    }

    public class EditListBooleanEntry
    extends EditListBaseEntry {
        protected final GuiButtonExt btnValue;
        private boolean value;

        public EditListBooleanEntry(boolean value) {
            this.value = value;
            this.btnValue = new GuiButtonExt(0, 0, 0, GuiEditListEntries.this.controlWidth, 18, I18n.func_135052_a((String)String.valueOf(value), (Object[])new Object[0]));
            this.btnValue.field_146124_l = ((GuiEditListEntries)GuiEditListEntries.this).parentGuiEditList.enabled;
            this.isValidated = false;
        }

        @Override
        public void func_148279_a(int slotIndex, int x, int y, int listWidth, int slotHeight, Tessellator tessellator, int mouseX, int mouseY, boolean isSelected) {
            super.func_148279_a(slotIndex, x, y, listWidth, slotHeight, tessellator, mouseX, mouseY, isSelected);
            this.btnValue.field_146128_h = listWidth / 4;
            this.btnValue.field_146129_i = y;
            String trans = I18n.func_135052_a((String)String.valueOf(this.value), (Object[])new Object[0]);
            this.btnValue.field_146126_j = !trans.equals(String.valueOf(this.value)) ? trans : String.valueOf(this.value);
            this.btnValue.packedFGColour = this.value ? HUDUtils.getColorCode('2', true) : HUDUtils.getColorCode('4', true);
            this.btnValue.func_146112_a(GuiEditListEntries.this.mc, mouseX, mouseY);
        }

        @Override
        public boolean func_148278_a(int index, int x, int y, int mouseEvent, int relativeX, int relativeY) {
            if (this.btnValue.func_146116_c(GuiEditListEntries.this.mc, x, y)) {
                this.btnValue.func_146113_a(GuiEditListEntries.this.mc.func_147118_V());
                this.value = !this.value;
                GuiEditListEntries.this.recalculateState();
                return true;
            }
            return super.func_148278_a(index, x, y, mouseEvent, relativeX, relativeY);
        }

        @Override
        public void func_148277_b(int index, int x, int y, int mouseEvent, int relativeX, int relativeY) {
            this.btnValue.func_146118_a(x, y);
            super.func_148277_b(index, x, y, mouseEvent, relativeX, relativeY);
        }

        @Override
        public String getValue() {
            return String.valueOf(this.value);
        }
    }

    public class EditListStringEntry
    extends EditListBaseEntry {
        protected final GuiTextField textFieldValue;

        public EditListStringEntry(String value) {
            this.textFieldValue = new GuiTextField(((GuiEditListEntries)GuiEditListEntries.this).mc.field_71466_p, GuiEditListEntries.this.field_148155_a / 4 + 1, 0, GuiEditListEntries.this.controlWidth - 3, 16);
            this.textFieldValue.func_146203_f(10000);
            this.textFieldValue.func_146180_a(value);
            this.isValidated = GuiEditListEntries.this.prop.getValidStringPattern() != null;
        }

        @Override
        public void func_148279_a(int slotIndex, int x, int y, int listWidth, int slotHeight, Tessellator tessellator, int mouseX, int mouseY, boolean isSelected) {
            super.func_148279_a(slotIndex, x, y, listWidth, slotHeight, tessellator, mouseX, mouseY, isSelected);
            if (GuiEditListEntries.this.prop.isListLengthFixed() || slotIndex != GuiEditListEntries.this.listEntries.size() - 1) {
                this.textFieldValue.func_146189_e(true);
                try {
                    if (ReflectionHelper.getIntValue(GuiTextField.class, "field_146210_g", "yPosition", this.textFieldValue, -1) != y + 1) {
                        ReflectionHelper.setIntValue(GuiTextField.class, "field_146210_g", "yPosition", this.textFieldValue, y + 1);
                    }
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
                this.textFieldValue.func_146194_f();
            } else {
                this.textFieldValue.func_146189_e(false);
            }
        }

        @Override
        public void keyTyped(char eventChar, int eventKey) {
            if (((GuiEditListEntries)GuiEditListEntries.this).parentGuiEditList.enabled || eventKey == 203 || eventKey == 205 || eventKey == 199 || eventKey == 207) {
                this.textFieldValue.func_146201_a(((GuiEditListEntries)GuiEditListEntries.this).parentGuiEditList.enabled ? eventChar : (char)'\u0000', eventKey);
                if (GuiEditListEntries.this.prop.getValidStringPattern() != null) {
                    this.isValidValue = GuiEditListEntries.this.prop.getValidStringPattern().matcher(this.textFieldValue.func_146179_b().trim()).matches();
                }
            }
        }

        @Override
        public void updateCursorCounter() {
            this.textFieldValue.func_146178_a();
        }

        @Override
        public void mouseClicked(int x, int y, int mouseEvent) {
            this.textFieldValue.func_146192_a(x, y, mouseEvent);
        }

        @Override
        public String getValue() {
            return this.textFieldValue.func_146179_b().trim();
        }
    }

    public class EditListIntegerEntry
    extends EditListStringEntry {
        public EditListIntegerEntry(int value) {
            super(String.valueOf(value));
            this.isValidated = true;
        }

        @Override
        public void keyTyped(char eventChar, int eventKey) {
            block7: {
                if (((GuiEditListEntries)GuiEditListEntries.this).parentGuiEditList.enabled || eventKey == 203 || eventKey == 205 || eventKey == 199 || eventKey == 207) {
                    String validChars = "0123456789";
                    String before = this.textFieldValue.func_146179_b();
                    if (validChars.contains(String.valueOf(eventChar)) || !before.startsWith("-") && this.textFieldValue.func_146198_h() == 0 && eventChar == '-' || eventKey == 14 || eventKey == 211 || eventKey == 203 || eventKey == 205 || eventKey == 199 || eventKey == 207) {
                        this.textFieldValue.func_146201_a(((GuiEditListEntries)GuiEditListEntries.this).parentGuiEditList.enabled ? eventChar : (char)'\u0000', eventKey);
                    }
                    if (!this.textFieldValue.func_146179_b().trim().isEmpty() && !this.textFieldValue.func_146179_b().trim().equals("-")) {
                        try {
                            long value = Long.parseLong(this.textFieldValue.func_146179_b().trim());
                            if (value < (long)GuiEditListEntries.this.prop.getMinIntValue() || value > (long)GuiEditListEntries.this.prop.getMaxIntValue()) {
                                this.isValidValue = false;
                                break block7;
                            }
                            this.isValidValue = true;
                        }
                        catch (Throwable e) {
                            this.isValidValue = false;
                        }
                    } else {
                        this.isValidValue = false;
                    }
                }
            }
        }

        @Override
        public String getValue() {
            return this.textFieldValue.func_146179_b().trim();
        }
    }

    public class EditListDoubleEntry
    extends EditListStringEntry {
        public EditListDoubleEntry(double value) {
            super(String.valueOf(value));
            this.isValidated = true;
        }

        @Override
        public void keyTyped(char eventChar, int eventKey) {
            block7: {
                if (((GuiEditListEntries)GuiEditListEntries.this).parentGuiEditList.enabled || eventKey == 203 || eventKey == 205 || eventKey == 199 || eventKey == 207) {
                    String validChars = "0123456789";
                    String before = this.textFieldValue.func_146179_b();
                    if (validChars.contains(String.valueOf(eventChar)) || !before.startsWith("-") && this.textFieldValue.func_146198_h() == 0 && eventChar == '-' || !before.contains(".") && eventChar == '.' || eventKey == 14 || eventKey == 211 || eventKey == 203 || eventKey == 205 || eventKey == 199 || eventKey == 207) {
                        this.textFieldValue.func_146201_a(((GuiEditListEntries)GuiEditListEntries.this).parentGuiEditList.enabled ? eventChar : (char)'\u0000', eventKey);
                    }
                    if (!this.textFieldValue.func_146179_b().trim().isEmpty() && !this.textFieldValue.func_146179_b().trim().equals("-")) {
                        try {
                            double value = Double.parseDouble(this.textFieldValue.func_146179_b().trim());
                            if (value < GuiEditListEntries.this.prop.getMinDoubleValue() || value > GuiEditListEntries.this.prop.getMaxDoubleValue()) {
                                this.isValidValue = false;
                                break block7;
                            }
                            this.isValidValue = true;
                        }
                        catch (Throwable e) {
                            this.isValidValue = false;
                        }
                    } else {
                        this.isValidValue = false;
                    }
                }
            }
        }

        @Override
        public String getValue() {
            return this.textFieldValue.func_146179_b().trim();
        }
    }
}

