/*
 * Decompiled with CFR 0.152.
 */
package bspkrs.util.config.gui;

import bspkrs.client.util.HUDUtils;
import bspkrs.util.ReflectionHelper;
import bspkrs.util.config.gui.ConfigGuiType;
import bspkrs.util.config.gui.GuiButtonExt;
import bspkrs.util.config.gui.GuiConfig;
import bspkrs.util.config.gui.GuiEditList;
import bspkrs.util.config.gui.GuiSelectString;
import bspkrs.util.config.gui.HoverChecker;
import bspkrs.util.config.gui.IConfigProperty;
import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.ModContainer;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiListExtended;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiSlot;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.EnumChatFormatting;

@SideOnly(value=Side.CLIENT)
public class GuiPropertyList
extends GuiListExtended {
    public final GuiConfig parentGuiConfig;
    public final Minecraft field_148161_k;
    public List<IGuiConfigListEntry> listEntries;
    public int maxLabelTextWidth = 0;
    public int maxEntryRightBound = 0;
    public int labelX;
    public int controlX;
    public int controlWidth;
    public int resetX;
    public int scrollBarX;

    public GuiPropertyList(GuiConfig parent, Minecraft mc) {
        super(mc, parent.field_146294_l, parent.field_146295_m, parent.titleLine2 != null ? 33 : 23, parent.field_146295_m - 32, 20);
        this.parentGuiConfig = parent;
        this.func_148130_a(false);
        this.field_148161_k = mc;
        this.listEntries = new ArrayList<IGuiConfigListEntry>();
        boolean i = false;
        Object s = null;
        for (IConfigProperty prop : parent.properties) {
            int l;
            if (prop == null || !prop.isProperty() || (l = mc.field_71466_p.func_78256_a(I18n.func_135052_a((String)prop.getLanguageKey(), (Object[])new Object[0]))) <= this.maxLabelTextWidth) continue;
            this.maxLabelTextWidth = l;
        }
        int viewWidth = this.maxLabelTextWidth + 8 + this.field_148155_a / 2;
        this.labelX = this.field_148155_a / 2 - viewWidth / 2;
        this.controlX = this.labelX + this.maxLabelTextWidth + 8;
        this.resetX = this.field_148155_a / 2 + viewWidth / 2 - 45;
        this.controlWidth = this.resetX - this.controlX - 5;
        this.scrollBarX = this.field_148155_a;
        for (IConfigProperty prop : parent.properties) {
            if (prop == null) continue;
            if (prop.hasCustomIGuiConfigListEntry()) {
                try {
                    this.listEntries.add(prop.getCustomIGuiConfigListEntryClass().getConstructor(GuiConfig.class, GuiPropertyList.class, IConfigProperty.class).newInstance(new Object[]{this.parentGuiConfig, this, prop}));
                }
                catch (Throwable e) {
                    FMLLog.severe((String)"There was a critical error instantiating the custom IGuiConfigListEntry for property %s.", (Object[])new Object[]{prop.getName()});
                    e.printStackTrace();
                }
                continue;
            }
            if (prop.isProperty()) {
                if (prop.isList()) {
                    this.listEntries.add(new EditListPropEntry(this.parentGuiConfig, this, prop));
                    continue;
                }
                if (prop.getType().equals((Object)ConfigGuiType.BOOLEAN)) {
                    this.listEntries.add(new BooleanPropEntry(this.parentGuiConfig, this, prop));
                    continue;
                }
                if (prop.getType().equals((Object)ConfigGuiType.INTEGER)) {
                    this.listEntries.add(new IntegerPropEntry(this.parentGuiConfig, this, prop));
                    continue;
                }
                if (prop.getType().equals((Object)ConfigGuiType.DOUBLE)) {
                    this.listEntries.add(new DoublePropEntry(this.parentGuiConfig, this, prop));
                    continue;
                }
                if (prop.getType().equals((Object)ConfigGuiType.COLOR)) {
                    if (prop.getValidValues() != null && prop.getValidValues().length > 0) {
                        this.listEntries.add(new ColorPropEntry(this.parentGuiConfig, this, prop));
                        continue;
                    }
                    this.listEntries.add(new StringPropEntry(this.parentGuiConfig, this, prop));
                    continue;
                }
                if (prop.getType().equals((Object)ConfigGuiType.BLOCK_LIST)) {
                    this.listEntries.add(new StringPropEntry(this.parentGuiConfig, this, prop));
                    continue;
                }
                if (prop.getType().equals((Object)ConfigGuiType.ITEMSTACK_LIST)) {
                    this.listEntries.add(new StringPropEntry(this.parentGuiConfig, this, prop));
                    continue;
                }
                if (prop.getType().equals((Object)ConfigGuiType.ENTITY_LIST)) {
                    this.listEntries.add(new StringPropEntry(this.parentGuiConfig, this, prop));
                    continue;
                }
                if (prop.getType().equals((Object)ConfigGuiType.BIOME_LIST)) {
                    this.listEntries.add(new StringPropEntry(this.parentGuiConfig, this, prop));
                    continue;
                }
                if (prop.getType().equals((Object)ConfigGuiType.DIMENSION_LIST)) {
                    this.listEntries.add(new StringPropEntry(this.parentGuiConfig, this, prop));
                    continue;
                }
                if (prop.getType().equals((Object)ConfigGuiType.MOD_ID)) {
                    TreeMap<String, String> values = new TreeMap<String, String>();
                    for (ModContainer mod : Loader.instance().getActiveModList()) {
                        values.put(mod.getModId(), mod.getName());
                    }
                    values.put("minecraft", "Minecraft");
                    this.listEntries.add(new SelectValuePropEntry(this.parentGuiConfig, this, prop, values));
                    continue;
                }
                if (!prop.getType().equals((Object)ConfigGuiType.STRING)) continue;
                if (prop.getValidValues() != null && prop.getValidValues().length > 0) {
                    this.listEntries.add(new SelectStringPropEntry(this.parentGuiConfig, this, prop));
                    continue;
                }
                this.listEntries.add(new StringPropEntry(this.parentGuiConfig, this, prop));
                continue;
            }
            if (!prop.getType().equals((Object)ConfigGuiType.CONFIG_CATEGORY)) continue;
            this.listEntries.add(new GuiConfigCategoryListEntry(this.parentGuiConfig, this, prop));
        }
    }

    protected void initGui() {
        this.field_148155_a = this.parentGuiConfig.field_146294_l;
        try {
            ReflectionHelper.setIntValue(GuiSlot.class, "field_148158_l", "height", (Object)this, this.parentGuiConfig.field_146295_m);
        }
        catch (Throwable e) {
            // empty catch block
        }
        this.maxLabelTextWidth = 0;
        for (IGuiConfigListEntry entry : this.listEntries) {
            if (entry.getLabelWidth() <= this.maxLabelTextWidth) continue;
            this.maxLabelTextWidth = entry.getLabelWidth();
        }
        this.field_148153_b = this.parentGuiConfig.titleLine2 != null ? 33 : 23;
        this.field_148154_c = this.parentGuiConfig.field_146295_m - 32;
        this.field_148152_e = 0;
        this.field_148151_d = this.field_148155_a;
        int viewWidth = this.maxLabelTextWidth + 8 + this.field_148155_a / 2;
        this.labelX = this.field_148155_a / 2 - viewWidth / 2;
        this.controlX = this.labelX + this.maxLabelTextWidth + 8;
        this.resetX = this.field_148155_a / 2 + viewWidth / 2 - 45;
        this.maxEntryRightBound = 0;
        for (IGuiConfigListEntry entry : this.listEntries) {
            if (entry.getEntryRightBound() <= this.maxEntryRightBound) continue;
            this.maxEntryRightBound = entry.getEntryRightBound();
        }
        this.scrollBarX = this.maxEntryRightBound + 5;
        this.controlWidth = this.maxEntryRightBound - this.controlX - 45;
    }

    public int func_148127_b() {
        return this.listEntries.size();
    }

    public IGuiConfigListEntry getListEntry(int index) {
        return this.listEntries.get(index);
    }

    public int func_148137_d() {
        return this.scrollBarX;
    }

    public int func_148139_c() {
        return this.parentGuiConfig.field_146294_l;
    }

    public void keyTyped(char eventChar, int eventKey) {
        for (IGuiConfigListEntry entry : this.listEntries) {
            entry.keyTyped(eventChar, eventKey);
        }
    }

    public void updateScreen() {
        for (IGuiConfigListEntry entry : this.listEntries) {
            entry.updateCursorCounter();
        }
    }

    public void mouseClicked(int mouseX, int mouseY, int mouseEvent) {
        for (IGuiConfigListEntry entry : this.listEntries) {
            entry.mouseClicked(mouseX, mouseY, mouseEvent);
        }
    }

    public void saveProperties() {
        for (IGuiConfigListEntry entry : this.listEntries) {
            entry.saveProperty();
        }
    }

    public boolean areAllPropsDefault(boolean includeSubCategoryProps) {
        for (IGuiConfigListEntry entry : this.listEntries) {
            if (!includeSubCategoryProps && entry instanceof GuiConfigCategoryListEntry || entry.isDefault()) continue;
            return false;
        }
        return true;
    }

    public void setAllPropsDefault(boolean includeSubCategoryProps) {
        for (IGuiConfigListEntry entry : this.listEntries) {
            if (!includeSubCategoryProps && entry instanceof GuiConfigCategoryListEntry) continue;
            entry.setToDefault();
        }
    }

    public boolean areAnyPropsChanged(boolean includeSubCategoryProps) {
        for (IGuiConfigListEntry entry : this.listEntries) {
            if (!includeSubCategoryProps && entry instanceof GuiConfigCategoryListEntry || !entry.isChanged()) continue;
            return true;
        }
        return false;
    }

    public boolean areAnyPropsEnabled(boolean includeSubCategoryProps) {
        for (IGuiConfigListEntry entry : this.listEntries) {
            if (!includeSubCategoryProps && entry instanceof GuiConfigCategoryListEntry || !entry.enabled()) continue;
            return true;
        }
        return false;
    }

    public void undoAllChanges(boolean includeSubCategoryProps) {
        for (IGuiConfigListEntry entry : this.listEntries) {
            if (!includeSubCategoryProps && entry instanceof GuiConfigCategoryListEntry) continue;
            entry.undoChanges();
        }
    }

    public void drawScreenPost(int mouseX, int mouseY, float partialTicks) {
        for (IGuiConfigListEntry entry : this.listEntries) {
            entry.drawToolTip(mouseX, mouseY);
        }
    }

    public static interface IGuiConfigListEntry
    extends GuiListExtended.IGuiListEntry {
        public boolean enabled();

        public void keyTyped(char var1, int var2);

        public void updateCursorCounter();

        public void mouseClicked(int var1, int var2, int var3);

        public boolean isDefault();

        public void setToDefault();

        public void undoChanges();

        public boolean isChanged();

        public void saveProperty();

        public void drawToolTip(int var1, int var2);

        public int getLabelWidth();

        public int getEntryRightBound();
    }

    public static abstract class GuiConfigListEntryBase
    implements IGuiConfigListEntry {
        protected final GuiConfig parentGuiConfig;
        protected final GuiPropertyList parentPropertyList;
        protected final IConfigProperty prop;
        protected final Minecraft mc;
        protected final String propName;
        protected final GuiButtonExt btnUndoChanges;
        protected final GuiButtonExt btnDefault;
        protected List toolTip;
        protected List undoToolTip;
        protected List defaultToolTip;
        protected boolean isValidValue = true;
        protected HoverChecker tooltipHoverChecker;
        protected HoverChecker undoHoverChecker;
        protected HoverChecker defaultHoverChecker;
        protected boolean drawLabel;

        public GuiConfigListEntryBase(GuiConfig parentGuiConfig, GuiPropertyList parentPropertyList, IConfigProperty prop) {
            this.parentGuiConfig = parentGuiConfig;
            this.parentPropertyList = parentPropertyList;
            this.prop = prop;
            this.mc = Minecraft.func_71410_x();
            String trans = I18n.func_135052_a((String)prop.getLanguageKey(), (Object[])new Object[0]);
            this.propName = !trans.equals(prop.getLanguageKey()) ? trans : prop.getName();
            this.btnUndoChanges = new GuiButtonExt(0, 0, 0, 18, 18, "\u21a9");
            this.btnDefault = new GuiButtonExt(0, 0, 0, 18, 18, "\u2604");
            this.undoHoverChecker = new HoverChecker(this.btnUndoChanges, 800);
            this.defaultHoverChecker = new HoverChecker(this.btnDefault, 800);
            this.undoToolTip = Arrays.asList(I18n.func_135052_a((String)"bspkrs.configgui.tooltip.undoChanges", (Object[])new Object[0]));
            this.defaultToolTip = Arrays.asList(I18n.func_135052_a((String)"bspkrs.configgui.tooltip.resetToDefault", (Object[])new Object[0]));
            this.drawLabel = true;
            String comment = prop.getType().equals((Object)ConfigGuiType.INTEGER) ? I18n.func_135052_a((String)(prop.getLanguageKey() + ".tooltip"), (Object[])new Object[]{"\n" + EnumChatFormatting.AQUA, prop.getDefault(), prop.getMinIntValue(), prop.getMaxIntValue()}) : I18n.func_135052_a((String)(prop.getLanguageKey() + ".tooltip"), (Object[])new Object[]{"\n" + EnumChatFormatting.AQUA, prop.getDefault(), prop.getMinDoubleValue(), prop.getMaxDoubleValue()});
            this.toolTip = !comment.equals(prop.getLanguageKey() + ".tooltip") ? this.mc.field_71466_p.func_78271_c(EnumChatFormatting.GREEN + this.propName + "\n" + EnumChatFormatting.YELLOW + comment, 300) : (prop.getComment() != null && !prop.getComment().trim().isEmpty() ? this.mc.field_71466_p.func_78271_c(EnumChatFormatting.GREEN + this.propName + "\n" + EnumChatFormatting.YELLOW + prop.getComment(), 300) : this.mc.field_71466_p.func_78271_c(EnumChatFormatting.GREEN + this.propName + "\n" + EnumChatFormatting.RED + "No tooltip defined.", 300));
        }

        public void func_148279_a(int slotIndex, int x, int y, int listWidth, int slotHeight, Tessellator tessellator, int mouseX, int mouseY, boolean isSelected) {
            boolean isChanged = this.isChanged();
            if (this.drawLabel) {
                String label = (!this.isValidValue ? EnumChatFormatting.RED.toString() : (isChanged ? EnumChatFormatting.WHITE.toString() : EnumChatFormatting.GRAY.toString())) + (isChanged ? EnumChatFormatting.ITALIC.toString() : "") + this.propName;
                this.mc.field_71466_p.func_78276_b(label, this.parentGuiConfig.propertyList.labelX, y + slotHeight / 2 - this.mc.field_71466_p.field_78288_b / 2, 0xFFFFFF);
            }
            this.btnUndoChanges.field_146128_h = this.parentPropertyList.scrollBarX - 44;
            this.btnUndoChanges.field_146129_i = y;
            this.btnUndoChanges.field_146124_l = this.enabled() && isChanged;
            this.btnUndoChanges.field_146126_j = "\u21a9";
            this.btnUndoChanges.func_146112_a(this.mc, mouseX, mouseY);
            this.btnDefault.field_146128_h = this.parentPropertyList.scrollBarX - 22;
            this.btnDefault.field_146129_i = y;
            this.btnDefault.field_146124_l = this.enabled() && !this.isDefault();
            this.btnDefault.field_146126_j = "\u2604";
            this.btnDefault.func_146112_a(this.mc, mouseX, mouseY);
            if (this.tooltipHoverChecker == null) {
                this.tooltipHoverChecker = new HoverChecker(y, y + slotHeight, x, this.parentGuiConfig.propertyList.controlX - 8, 800);
            } else {
                this.tooltipHoverChecker.updateBounds(y, y + slotHeight, x, this.parentGuiConfig.propertyList.controlX - 8);
            }
        }

        @Override
        public void drawToolTip(int mouseX, int mouseY) {
            boolean canHover;
            boolean bl = canHover = mouseY < this.parentGuiConfig.propertyList.field_148154_c && mouseY > this.parentGuiConfig.propertyList.field_148153_b;
            if (this.toolTip != null && this.tooltipHoverChecker != null && this.tooltipHoverChecker.checkHover(mouseX, mouseY, canHover)) {
                this.parentGuiConfig.drawToolTip(this.toolTip, mouseX, mouseY);
            }
            if (this.undoHoverChecker.checkHover(mouseX, mouseY, canHover)) {
                this.parentGuiConfig.drawToolTip(this.undoToolTip, mouseX, mouseY);
            }
            if (this.defaultHoverChecker.checkHover(mouseX, mouseY, canHover)) {
                this.parentGuiConfig.drawToolTip(this.defaultToolTip, mouseX, mouseY);
            }
        }

        public boolean func_148278_a(int index, int x, int y, int mouseEvent, int relativeX, int relativeY) {
            if (this.btnDefault.func_146116_c(this.mc, x, y)) {
                this.btnDefault.func_146113_a(this.mc.func_147118_V());
                this.setToDefault();
                return true;
            }
            if (this.btnUndoChanges.func_146116_c(this.mc, x, y)) {
                this.btnUndoChanges.func_146113_a(this.mc.func_147118_V());
                this.undoChanges();
                return true;
            }
            return false;
        }

        public void func_148277_b(int index, int x, int y, int mouseEvent, int relativeX, int relativeY) {
            this.btnDefault.func_146118_a(x, y);
        }

        @Override
        public abstract boolean isDefault();

        @Override
        public abstract void setToDefault();

        @Override
        public abstract void keyTyped(char var1, int var2);

        @Override
        public abstract void updateCursorCounter();

        @Override
        public abstract void mouseClicked(int var1, int var2, int var3);

        @Override
        public abstract boolean isChanged();

        @Override
        public abstract void undoChanges();

        @Override
        public abstract void saveProperty();

        @Override
        public boolean enabled() {
            return this.parentGuiConfig.allowNonHotLoadConfigChanges || this.parentGuiConfig.areAllPropsHotLoadable || this.prop.isHotLoadable();
        }

        @Override
        public int getLabelWidth() {
            return this.mc.field_71466_p.func_78256_a(this.propName);
        }

        @Override
        public int getEntryRightBound() {
            return this.parentPropertyList.resetX + 40;
        }
    }

    public static class GuiConfigCategoryListEntry
    extends GuiConfigListEntryBase {
        protected GuiConfig subGuiConfig;
        protected final GuiButtonExt btnSelectCategory;

        public GuiConfigCategoryListEntry(GuiConfig parentGuiConfig, GuiPropertyList parentPropertyList, IConfigProperty prop) {
            super(parentGuiConfig, parentPropertyList, prop);
            this.subGuiConfig = new GuiConfig((GuiScreen)this.parentGuiConfig, this.prop.getConfigPropertiesList(false), this.prop.isHotLoadable(), this.parentGuiConfig.modID, this.parentGuiConfig.allowNonHotLoadConfigChanges, this.parentGuiConfig.title, (this.parentGuiConfig.titleLine2 == null ? "" : this.parentGuiConfig.titleLine2) + " > " + this.propName);
            this.btnSelectCategory = new GuiButtonExt(0, 0, 0, 300, 18, I18n.func_135052_a((String)this.propName, (Object[])new Object[0]));
            this.tooltipHoverChecker = new HoverChecker(this.btnSelectCategory, 800);
            this.drawLabel = false;
        }

        @Override
        public void func_148279_a(int slotIndex, int x, int y, int listWidth, int slotHeight, Tessellator tessellator, int mouseX, int mouseY, boolean isSelected) {
            this.btnSelectCategory.field_146128_h = listWidth / 2 - 150;
            this.btnSelectCategory.field_146129_i = y;
            this.btnSelectCategory.func_146112_a(this.mc, mouseX, mouseY);
            super.func_148279_a(slotIndex, x, y, listWidth, slotHeight, tessellator, mouseX, mouseY, isSelected);
        }

        @Override
        public void drawToolTip(int mouseX, int mouseY) {
            boolean canHover;
            boolean bl = canHover = mouseY < this.parentGuiConfig.propertyList.field_148154_c && mouseY > this.parentGuiConfig.propertyList.field_148153_b;
            if (this.tooltipHoverChecker.checkHover(mouseX, mouseY, canHover)) {
                this.parentGuiConfig.drawToolTip(this.toolTip, mouseX, mouseY);
            }
            super.drawToolTip(mouseX, mouseY);
        }

        @Override
        public boolean func_148278_a(int index, int x, int y, int mouseEvent, int relativeX, int relativeY) {
            if (this.btnSelectCategory.func_146116_c(this.mc, x, y)) {
                this.btnSelectCategory.func_146113_a(this.mc.func_147118_V());
                Minecraft.func_71410_x().func_147108_a((GuiScreen)this.subGuiConfig);
                return true;
            }
            return super.func_148278_a(index, x, y, mouseEvent, relativeX, relativeY);
        }

        @Override
        public void func_148277_b(int index, int x, int y, int mouseEvent, int relativeX, int relativeY) {
            this.btnSelectCategory.func_146118_a(x, y);
        }

        @Override
        public boolean isDefault() {
            if (this.subGuiConfig.propertyList != null) {
                return this.subGuiConfig.propertyList.areAllPropsDefault(true);
            }
            return true;
        }

        @Override
        public void setToDefault() {
            this.subGuiConfig.propertyList.setAllPropsDefault(true);
        }

        @Override
        public void keyTyped(char eventChar, int eventKey) {
        }

        @Override
        public void updateCursorCounter() {
        }

        @Override
        public void mouseClicked(int x, int y, int mouseEvent) {
        }

        @Override
        public void saveProperty() {
            if (this.subGuiConfig.propertyList != null) {
                this.subGuiConfig.propertyList.saveProperties();
            }
        }

        @Override
        public boolean isChanged() {
            if (this.subGuiConfig.propertyList != null) {
                return this.subGuiConfig.propertyList.areAnyPropsChanged(true);
            }
            return false;
        }

        @Override
        public void undoChanges() {
            if (this.subGuiConfig.propertyList != null) {
                this.subGuiConfig.propertyList.undoAllChanges(true);
            }
        }

        @Override
        public boolean enabled() {
            return this.parentGuiConfig.allowNonHotLoadConfigChanges || this.parentGuiConfig.areAllPropsHotLoadable || this.prop.isHotLoadable();
        }

        @Override
        public int getLabelWidth() {
            return 0;
        }

        @Override
        public int getEntryRightBound() {
            return this.parentPropertyList.field_148155_a / 2 + 155 + 22 + 18;
        }
    }

    public static class StringPropEntry
    extends GuiConfigListEntryBase {
        protected final GuiTextField textFieldValue;
        private final String beforeValue;

        private StringPropEntry(GuiConfig parentGuiConfig, GuiPropertyList parentPropertyList, IConfigProperty prop) {
            super(parentGuiConfig, parentPropertyList, prop);
            this.beforeValue = prop.getString();
            this.textFieldValue = new GuiTextField(this.mc.field_71466_p, this.parentPropertyList.controlX + 1, 0, this.parentPropertyList.controlWidth - 3, 16);
            this.textFieldValue.func_146203_f(10000);
            this.textFieldValue.func_146180_a(prop.getString());
        }

        @Override
        public void func_148279_a(int slotIndex, int x, int y, int listWidth, int slotHeight, Tessellator tessellator, int mouseX, int mouseY, boolean isSelected) {
            super.func_148279_a(slotIndex, x, y, listWidth, slotHeight, tessellator, mouseX, mouseY, isSelected);
            try {
                if (ReflectionHelper.getIntValue(GuiTextField.class, "field_146209_f", "xPosition", this.textFieldValue, -1) != this.parentPropertyList.controlX + 2) {
                    ReflectionHelper.setIntValue(GuiTextField.class, "field_146209_f", "xPosition", this.textFieldValue, this.parentPropertyList.controlX + 2);
                }
                if (ReflectionHelper.getIntValue(GuiTextField.class, "field_146210_g", "yPosition", this.textFieldValue, -1) != y + 1) {
                    ReflectionHelper.setIntValue(GuiTextField.class, "field_146210_g", "yPosition", this.textFieldValue, y + 1);
                }
                if (ReflectionHelper.getIntValue(GuiTextField.class, "field_146218_h", "width", this.textFieldValue, -1) != this.parentPropertyList.controlWidth - 4) {
                    ReflectionHelper.setIntValue(GuiTextField.class, "field_146218_h", "width", this.textFieldValue, this.parentPropertyList.controlWidth - 4);
                }
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
            this.textFieldValue.func_146194_f();
        }

        @Override
        public void keyTyped(char eventChar, int eventKey) {
            if (this.enabled() || eventKey == 203 || eventKey == 205 || eventKey == 199 || eventKey == 207) {
                this.textFieldValue.func_146201_a(this.enabled() ? eventChar : (char)'\u0000', eventKey);
                if (this.prop.getValidStringPattern() != null) {
                    this.isValidValue = this.prop.getValidStringPattern().matcher(this.textFieldValue.func_146179_b().trim()).matches();
                }
            }
        }

        @Override
        public void updateCursorCounter() {
            this.textFieldValue.func_146178_a();
        }

        @Override
        public void mouseClicked(int x, int y, int mouseEvent) {
            this.textFieldValue.func_146192_a(x, y, mouseEvent);
        }

        @Override
        public boolean isDefault() {
            if (this.prop.getDefault() != null) {
                return this.prop.getDefault().equals(this.textFieldValue.func_146179_b());
            }
            return true;
        }

        @Override
        public void setToDefault() {
            if (this.enabled()) {
                this.textFieldValue.func_146180_a(this.prop.getDefault());
                this.keyTyped('\u0000', 199);
            }
        }

        @Override
        public boolean isChanged() {
            return !this.beforeValue.equals(this.textFieldValue.func_146179_b());
        }

        @Override
        public void undoChanges() {
            if (this.enabled()) {
                this.textFieldValue.func_146180_a(this.beforeValue);
            }
        }

        @Override
        public void saveProperty() {
            if (this.enabled()) {
                if (this.isChanged() && this.isValidValue) {
                    this.prop.set(this.textFieldValue.func_146179_b());
                } else if (this.isChanged() && !this.isValidValue) {
                    this.prop.setToDefault();
                }
            }
        }

        @Override
        public boolean enabled() {
            return this.parentGuiConfig.allowNonHotLoadConfigChanges || this.parentGuiConfig.areAllPropsHotLoadable || this.prop.isHotLoadable();
        }
    }

    public static class DoublePropEntry
    extends StringPropEntry {
        private final double beforeValue;

        private DoublePropEntry(GuiConfig parentGuiConfig, GuiPropertyList parentPropertyList, IConfigProperty prop) {
            super(parentGuiConfig, parentPropertyList, prop);
            this.beforeValue = prop.getDouble();
        }

        @Override
        public void keyTyped(char eventChar, int eventKey) {
            block7: {
                if (this.enabled() || eventKey == 203 || eventKey == 205 || eventKey == 199 || eventKey == 207) {
                    String validChars = "0123456789";
                    String before = this.textFieldValue.func_146179_b();
                    if (validChars.contains(String.valueOf(eventChar)) || !before.startsWith("-") && this.textFieldValue.func_146198_h() == 0 && eventChar == '-' || !before.contains(".") && eventChar == '.' || eventKey == 14 || eventKey == 211 || eventKey == 203 || eventKey == 205 || eventKey == 199 || eventKey == 207) {
                        this.textFieldValue.func_146201_a(this.enabled() ? eventChar : (char)'\u0000', eventKey);
                    }
                    if (!this.textFieldValue.func_146179_b().trim().isEmpty() && !this.textFieldValue.func_146179_b().trim().equals("-")) {
                        try {
                            double value = Double.parseDouble(this.textFieldValue.func_146179_b().trim());
                            if (value < this.prop.getMinDoubleValue() || value > this.prop.getMaxDoubleValue()) {
                                this.isValidValue = false;
                                break block7;
                            }
                            this.isValidValue = true;
                        }
                        catch (Throwable e) {
                            this.isValidValue = false;
                        }
                    } else {
                        this.isValidValue = false;
                    }
                }
            }
        }

        @Override
        public boolean isChanged() {
            try {
                return this.beforeValue != Double.parseDouble(this.textFieldValue.func_146179_b().trim());
            }
            catch (Throwable e) {
                return true;
            }
        }

        @Override
        public void undoChanges() {
            if (this.enabled()) {
                this.textFieldValue.func_146180_a(String.valueOf(this.beforeValue));
            }
        }

        @Override
        public void saveProperty() {
            if (this.enabled()) {
                if (this.isChanged() && this.isValidValue) {
                    try {
                        double value = Double.parseDouble(this.textFieldValue.func_146179_b().trim());
                        this.prop.set(value);
                    }
                    catch (Throwable e) {
                        this.prop.setToDefault();
                    }
                } else if (this.isChanged() && !this.isValidValue) {
                    try {
                        double value = Double.parseDouble(this.textFieldValue.func_146179_b().trim());
                        if (value < this.prop.getMinDoubleValue()) {
                            this.prop.set(this.prop.getMinDoubleValue());
                        } else {
                            this.prop.set(this.prop.getMaxDoubleValue());
                        }
                    }
                    catch (Throwable e) {
                        this.prop.setToDefault();
                    }
                }
            }
        }
    }

    public static class IntegerPropEntry
    extends StringPropEntry {
        private final int beforeValue;

        private IntegerPropEntry(GuiConfig parentGuiConfig, GuiPropertyList parentPropertyList, IConfigProperty prop) {
            super(parentGuiConfig, parentPropertyList, prop);
            this.beforeValue = prop.getInt();
        }

        @Override
        public void keyTyped(char eventChar, int eventKey) {
            block7: {
                if (this.enabled() || eventKey == 203 || eventKey == 205 || eventKey == 199 || eventKey == 207) {
                    String validChars = "0123456789";
                    String before = this.textFieldValue.func_146179_b();
                    if (validChars.contains(String.valueOf(eventChar)) || !before.startsWith("-") && this.textFieldValue.func_146198_h() == 0 && eventChar == '-' || eventKey == 14 || eventKey == 211 || eventKey == 203 || eventKey == 205 || eventKey == 199 || eventKey == 207) {
                        this.textFieldValue.func_146201_a(this.enabled() ? eventChar : (char)'\u0000', eventKey);
                    }
                    if (!this.textFieldValue.func_146179_b().trim().isEmpty() && !this.textFieldValue.func_146179_b().trim().equals("-")) {
                        try {
                            long value = Long.parseLong(this.textFieldValue.func_146179_b().trim());
                            if (value < (long)this.prop.getMinIntValue() || value > (long)this.prop.getMaxIntValue()) {
                                this.isValidValue = false;
                                break block7;
                            }
                            this.isValidValue = true;
                        }
                        catch (Throwable e) {
                            this.isValidValue = false;
                        }
                    } else {
                        this.isValidValue = false;
                    }
                }
            }
        }

        @Override
        public boolean isChanged() {
            try {
                return this.beforeValue != Integer.parseInt(this.textFieldValue.func_146179_b().trim());
            }
            catch (Throwable e) {
                return true;
            }
        }

        @Override
        public void undoChanges() {
            if (this.enabled()) {
                this.textFieldValue.func_146180_a(String.valueOf(this.beforeValue));
            }
        }

        @Override
        public void saveProperty() {
            if (this.enabled()) {
                if (this.isChanged() && this.isValidValue) {
                    try {
                        int value = Integer.parseInt(this.textFieldValue.func_146179_b().trim());
                        this.prop.set(value);
                    }
                    catch (Throwable e) {
                        this.prop.setToDefault();
                    }
                } else if (this.isChanged() && !this.isValidValue) {
                    try {
                        int value = Integer.parseInt(this.textFieldValue.func_146179_b().trim());
                        if (value < this.prop.getMinIntValue()) {
                            this.prop.set(this.prop.getMinIntValue());
                        } else {
                            this.prop.set(this.prop.getMaxIntValue());
                        }
                    }
                    catch (Throwable e) {
                        this.prop.setToDefault();
                    }
                }
            }
        }
    }

    public static abstract class ButtonPropEntry
    extends GuiConfigListEntryBase {
        protected final GuiButtonExt btnValue;

        public ButtonPropEntry(GuiConfig parentGuiConfig, GuiPropertyList parentPropertyList, IConfigProperty prop) {
            super(parentGuiConfig, parentPropertyList, prop);
            this.btnValue = new GuiButtonExt(0, this.parentPropertyList.controlX, 0, this.parentPropertyList.controlWidth, 18, I18n.func_135052_a((String)prop.getString(), (Object[])new Object[0]));
        }

        public abstract void updateValueButtonText();

        public abstract void valueButtonPressed(int var1);

        @Override
        public void func_148279_a(int slotIndex, int x, int y, int listWidth, int slotHeight, Tessellator tessellator, int mouseX, int mouseY, boolean isSelected) {
            super.func_148279_a(slotIndex, x, y, listWidth, slotHeight, tessellator, mouseX, mouseY, isSelected);
            try {
                ReflectionHelper.setIntValue(GuiButton.class, "field_146120_f", "width", (Object)this.btnValue, this.parentPropertyList.controlWidth);
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
            this.btnValue.field_146128_h = this.parentGuiConfig.propertyList.controlX;
            this.btnValue.field_146129_i = y;
            this.btnValue.func_146112_a(this.mc, mouseX, mouseY);
        }

        @Override
        public boolean func_148278_a(int index, int x, int y, int mouseEvent, int relativeX, int relativeY) {
            if (this.btnValue.func_146116_c(this.mc, x, y)) {
                this.btnValue.func_146113_a(this.mc.func_147118_V());
                this.valueButtonPressed(index);
                this.updateValueButtonText();
                return true;
            }
            return super.func_148278_a(index, x, y, mouseEvent, relativeX, relativeY);
        }

        @Override
        public void func_148277_b(int index, int x, int y, int mouseEvent, int relativeX, int relativeY) {
            super.func_148277_b(index, x, y, mouseEvent, relativeX, relativeY);
            this.btnValue.func_146118_a(x, y);
        }

        @Override
        public void keyTyped(char eventChar, int eventKey) {
        }

        @Override
        public void updateCursorCounter() {
        }

        @Override
        public void mouseClicked(int x, int y, int mouseEvent) {
        }
    }

    public static class EditListPropEntry
    extends ButtonPropEntry {
        private final String[] beforeValues;
        private String[] currentValues;

        public EditListPropEntry(GuiConfig parentGuiConfig, GuiPropertyList parentPropertyList, IConfigProperty prop) {
            super(parentGuiConfig, parentPropertyList, prop);
            this.beforeValues = prop.getStringList();
            this.currentValues = prop.getStringList();
            this.updateValueButtonText();
        }

        @Override
        public void updateValueButtonText() {
            this.btnValue.field_146126_j = "";
            for (String s : this.currentValues) {
                this.btnValue.field_146126_j = this.btnValue.field_146126_j + ", [" + s + "]";
            }
            this.btnValue.field_146126_j = this.btnValue.field_146126_j.replaceFirst(", ", "");
        }

        @Override
        public void valueButtonPressed(int slotIndex) {
            this.mc.func_147108_a((GuiScreen)new GuiEditList(this.parentGuiConfig, this.prop, slotIndex, this.currentValues, this.enabled()));
        }

        public void setListFromChildScreen(String[] newList) {
            if (this.enabled() && !Arrays.deepEquals(this.currentValues, newList)) {
                this.currentValues = newList;
                this.updateValueButtonText();
            }
        }

        @Override
        public boolean isDefault() {
            return Arrays.deepEquals(this.prop.getDefaults(), this.currentValues);
        }

        @Override
        public void setToDefault() {
            if (this.enabled()) {
                this.currentValues = this.prop.getDefaults();
                this.updateValueButtonText();
            }
        }

        @Override
        public boolean isChanged() {
            return !Arrays.deepEquals(this.beforeValues, this.currentValues);
        }

        @Override
        public void undoChanges() {
            if (this.enabled()) {
                this.currentValues = this.beforeValues;
                this.updateValueButtonText();
            }
        }

        @Override
        public void saveProperty() {
            if (this.enabled() && this.isChanged()) {
                this.prop.set(this.currentValues);
            }
        }
    }

    public static class SelectValuePropEntry
    extends ButtonPropEntry {
        private final String beforeValue;
        private String currentValue;
        private Map<String, String> selectableValues;

        public SelectValuePropEntry(GuiConfig parentGuiConfig, GuiPropertyList parentPropertyList, IConfigProperty prop, Map<String, String> selectableValues) {
            super(parentGuiConfig, parentPropertyList, prop);
            this.beforeValue = prop.getString();
            this.currentValue = prop.getString();
            this.selectableValues = selectableValues;
            this.updateValueButtonText();
        }

        @Override
        public void updateValueButtonText() {
            this.btnValue.field_146126_j = this.currentValue;
        }

        @Override
        public void valueButtonPressed(int slotIndex) {
            this.mc.func_147108_a((GuiScreen)new GuiSelectString(this.parentGuiConfig, this.prop, slotIndex, this.selectableValues, this.currentValue, this.enabled()));
        }

        public void setValueFromChildScreen(String newValue) {
            if (this.enabled() && !this.currentValue.equals(newValue)) {
                this.currentValue = newValue;
                this.updateValueButtonText();
            }
        }

        @Override
        public boolean isDefault() {
            if (this.prop.getDefault() != null) {
                return this.prop.getDefault().equals(this.currentValue);
            }
            return true;
        }

        @Override
        public void setToDefault() {
            if (this.enabled()) {
                this.currentValue = this.prop.getDefault();
                this.updateValueButtonText();
            }
        }

        @Override
        public boolean isChanged() {
            return !this.beforeValue.equals(this.currentValue);
        }

        @Override
        public void undoChanges() {
            if (this.enabled()) {
                this.currentValue = this.beforeValue;
                this.updateValueButtonText();
            }
        }

        @Override
        public void saveProperty() {
            if (this.enabled() && this.isChanged()) {
                this.prop.set(this.currentValue);
            }
        }
    }

    public static class ColorPropEntry
    extends SelectStringPropEntry {
        ColorPropEntry(GuiConfig parentGuiConfig, GuiPropertyList parentPropertyList, IConfigProperty prop) {
            super(parentGuiConfig, parentPropertyList, prop);
            this.btnValue.field_146124_l = this.enabled();
            this.updateValueButtonText();
        }

        @Override
        public void func_148279_a(int slotIndex, int x, int y, int listWidth, int slotHeight, Tessellator tessellator, int mouseX, int mouseY, boolean isSelected) {
            this.btnValue.packedFGColour = HUDUtils.getColorCode(this.prop.getValidValues()[this.currentIndex].charAt(0), true);
            super.func_148279_a(slotIndex, x, y, listWidth, slotHeight, tessellator, mouseX, mouseY, isSelected);
        }

        @Override
        public void updateValueButtonText() {
            this.btnValue.field_146126_j = I18n.func_135052_a((String)this.prop.getValidValues()[this.currentIndex], (Object[])new Object[0]) + " - " + I18n.func_135052_a((String)"bspkrs.configgui.sampletext", (Object[])new Object[0]);
        }
    }

    public static class SelectStringPropEntry
    extends ButtonPropEntry {
        protected final int beforeIndex;
        protected final int defaultIndex;
        protected int currentIndex;

        private SelectStringPropEntry(GuiConfig parentGuiConfig, GuiPropertyList parentPropertyList, IConfigProperty prop) {
            super(parentGuiConfig, parentPropertyList, prop);
            this.beforeIndex = this.getIndex(prop.getString());
            this.defaultIndex = this.getIndex(prop.getDefault());
            this.currentIndex = this.beforeIndex;
            this.btnValue.field_146124_l = this.enabled();
            this.updateValueButtonText();
        }

        private int getIndex(String s) {
            for (int i = 0; i < this.prop.getValidValues().length; ++i) {
                if (!this.prop.getValidValues()[i].equalsIgnoreCase(s)) continue;
                return i;
            }
            return 0;
        }

        @Override
        public void updateValueButtonText() {
            this.btnValue.field_146126_j = I18n.func_135052_a((String)this.prop.getValidValues()[this.currentIndex], (Object[])new Object[0]);
        }

        @Override
        public void valueButtonPressed(int slotIndex) {
            if (this.enabled()) {
                if (++this.currentIndex >= this.prop.getValidValues().length) {
                    this.currentIndex = 0;
                }
                this.updateValueButtonText();
            }
        }

        @Override
        public boolean isDefault() {
            return this.currentIndex == this.defaultIndex;
        }

        @Override
        public void setToDefault() {
            if (this.enabled()) {
                this.currentIndex = this.defaultIndex;
                this.updateValueButtonText();
            }
        }

        @Override
        public boolean isChanged() {
            return this.currentIndex != this.beforeIndex;
        }

        @Override
        public void undoChanges() {
            if (this.enabled()) {
                this.currentIndex = this.beforeIndex;
                this.updateValueButtonText();
            }
        }

        @Override
        public void saveProperty() {
            if (this.enabled() && this.isChanged()) {
                this.prop.set(this.prop.getValidValues()[this.currentIndex]);
            }
        }
    }

    public static class BooleanPropEntry
    extends ButtonPropEntry {
        protected final boolean beforeValue;
        protected boolean currentValue;

        private BooleanPropEntry(GuiConfig parentGuiConfig, GuiPropertyList parentPropertyList, IConfigProperty prop) {
            super(parentGuiConfig, parentPropertyList, prop);
            this.currentValue = this.beforeValue = prop.getBoolean();
            this.btnValue.field_146124_l = this.enabled();
            this.updateValueButtonText();
        }

        @Override
        public void updateValueButtonText() {
            this.btnValue.field_146126_j = I18n.func_135052_a((String)String.valueOf(this.currentValue), (Object[])new Object[0]);
            this.btnValue.packedFGColour = this.currentValue ? HUDUtils.getColorCode('2', true) : HUDUtils.getColorCode('4', true);
        }

        @Override
        public void valueButtonPressed(int slotIndex) {
            if (this.enabled()) {
                this.currentValue = !this.currentValue;
            }
        }

        @Override
        public boolean isDefault() {
            return this.currentValue == Boolean.valueOf(this.prop.getDefault());
        }

        @Override
        public void setToDefault() {
            if (this.enabled()) {
                this.currentValue = Boolean.valueOf(this.prop.getDefault());
                this.updateValueButtonText();
            }
        }

        @Override
        public boolean isChanged() {
            return this.currentValue != this.beforeValue;
        }

        @Override
        public void undoChanges() {
            if (this.enabled()) {
                this.currentValue = this.beforeValue;
                this.updateValueButtonText();
            }
        }

        @Override
        public void saveProperty() {
            if (this.enabled() && this.isChanged()) {
                this.prop.set(this.currentValue);
            }
        }
    }
}

