/*
 * Decompiled with CFR 0.152.
 */
package bspkrs.util.config.gui;

import bspkrs.util.config.gui.GuiConfig;
import bspkrs.util.config.gui.GuiPropertyList;
import bspkrs.util.config.gui.GuiSelectString;
import bspkrs.util.config.gui.IConfigProperty;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiListExtended;
import net.minecraft.client.renderer.Tessellator;

public class GuiSelectStringEntries
extends GuiListExtended {
    private GuiSelectString parentGuiSelectString;
    private Minecraft mc;
    private IConfigProperty prop;
    private List<IGuiSelectStringListEntry> listEntries;
    private boolean isDefault;
    private boolean isChanged;
    private final Map<String, String> selectableValues;
    private final String beforeValue;
    public String currentValue;
    private int selectedIndex;
    private int maxEntryWidth = 0;

    public GuiSelectStringEntries(GuiSelectString parent, Minecraft mc, IConfigProperty prop, Map<String, String> selectableValues, String beforeValue, String currentValue) {
        super(mc, parent.field_146294_l, parent.field_146295_m, parent.titleLine2 != null ? (parent.titleLine3 != null ? 43 : 33) : 23, parent.field_146295_m - 32, 11);
        this.parentGuiSelectString = parent;
        this.mc = mc;
        this.prop = prop;
        this.selectableValues = selectableValues;
        this.beforeValue = beforeValue;
        this.currentValue = currentValue;
        this.func_148130_a(true);
        this.isChanged = beforeValue.equals(currentValue);
        this.isDefault = currentValue.equals(prop.getDefault());
        this.listEntries = new ArrayList<IGuiSelectStringListEntry>();
        int index = 0;
        ArrayList<Map.Entry<String, String>> sortedList = new ArrayList<Map.Entry<String, String>>(selectableValues.entrySet());
        Collections.sort(sortedList, new EntryComparator());
        for (Map.Entry entry : sortedList) {
            this.listEntries.add(new ListEntry(entry));
            if (mc.field_71466_p.func_78256_a((String)entry.getValue()) > this.maxEntryWidth) {
                this.maxEntryWidth = mc.field_71466_p.func_78256_a((String)entry.getValue());
            }
            if (this.currentValue.equals(entry.getKey())) {
                this.selectedIndex = index;
            }
            ++index;
        }
    }

    protected void func_148144_a(int index, boolean doubleClick, int mouseX, int mouseY) {
        this.selectedIndex = index;
        this.currentValue = this.listEntries.get(index).getValue();
    }

    protected boolean func_148131_a(int index) {
        return index == this.selectedIndex;
    }

    protected int func_148137_d() {
        return this.field_148155_a / 2 + this.maxEntryWidth / 2 + 5;
    }

    public int func_148139_c() {
        return this.maxEntryWidth + 5;
    }

    public IGuiSelectStringListEntry getListEntry(int index) {
        return this.listEntries.get(index);
    }

    protected int func_148127_b() {
        return this.listEntries.size();
    }

    protected boolean isChanged() {
        return !this.beforeValue.equals(this.currentValue);
    }

    protected boolean isDefault() {
        return this.currentValue.equals(this.prop.getDefault());
    }

    protected void saveChanges() {
        if (this.parentGuiSelectString.slotIndex != -1 && this.parentGuiSelectString.parentScreen != null && this.parentGuiSelectString.parentScreen instanceof GuiConfig && ((GuiConfig)this.parentGuiSelectString.parentScreen).propertyList.getListEntry(this.parentGuiSelectString.slotIndex) instanceof GuiPropertyList.SelectValuePropEntry) {
            GuiPropertyList.SelectValuePropEntry entry = (GuiPropertyList.SelectValuePropEntry)((GuiConfig)this.parentGuiSelectString.parentScreen).propertyList.getListEntry(this.parentGuiSelectString.slotIndex);
            entry.setValueFromChildScreen(this.currentValue);
        } else {
            this.prop.set(this.currentValue);
        }
    }

    public static interface IGuiSelectStringListEntry
    extends GuiListExtended.IGuiListEntry {
        public String getValue();
    }

    public class ListEntry
    implements IGuiSelectStringListEntry {
        protected final Map.Entry<String, String> value;

        public ListEntry(Map.Entry<String, String> value) {
            this.value = value;
        }

        public void func_148279_a(int slotIndex, int x, int y, int listWidth, int slotHeight, Tessellator tessellator, int mouseX, int mouseY, boolean isSelected) {
            ((GuiSelectStringEntries)GuiSelectStringEntries.this).mc.field_71466_p.func_78276_b(this.value.getValue(), x + 1, y, slotIndex == GuiSelectStringEntries.this.selectedIndex ? 0xFFFFFF : 0xE0E0E0);
        }

        public boolean func_148278_a(int index, int x, int y, int mouseEvent, int relativeX, int relativeY) {
            return false;
        }

        public void func_148277_b(int index, int x, int y, int mouseEvent, int relativeX, int relativeY) {
        }

        @Override
        public String getValue() {
            return this.value.getKey();
        }
    }

    public static class EntryComparator
    implements Comparator<Map.Entry<String, String>> {
        @Override
        public int compare(Map.Entry<String, String> o1, Map.Entry<String, String> o2) {
            int compare = o1.getValue().toLowerCase().compareTo(o2.getValue().toLowerCase());
            if (compare == 0) {
                compare = o1.getKey().toLowerCase().compareTo(o2.getKey().toLowerCase());
            }
            return compare;
        }
    }
}

