/*
 * Decompiled with CFR 0.152.
 */
package bspkrs.bspkrscore.fml;

import bspkrs.bspkrscore.fml.CommonProxy;
import bspkrs.bspkrscore.fml.ConfigElement;
import bspkrs.bspkrscore.fml.NetworkHandler;
import bspkrs.bspkrscore.fml.Reference;
import bspkrs.util.CommonUtils;
import bspkrs.util.UniqueNameListGenerator;
import java.io.File;
import java.util.ArrayList;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.ModMetadata;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@Mod(modid="bspkrscore", name="bspkrsCore", version="1.8.9.2", useMetadata=true, guiFactory="bspkrs.bspkrscore.fml.gui.ModGuiFactoryHandler", updateJSON="http://bspk.rs/Minecraft/bspkrscore.json", acceptedMinecraftVersions="[1.8.9]")
public class bspkrsCoreMod {
    private final boolean allowUpdateCheckDefault = true;
    public boolean allowUpdateCheck = true;
    private final boolean allowDebugOutputDefault = false;
    public boolean allowDebugOutput = false;
    private final int updateTimeoutMillisecondsDefault = 3000;
    public int updateTimeoutMilliseconds = 3000;
    private final boolean generateUniqueNamesFileDefault = true;
    public boolean generateUniqueNamesFile = true;
    @Mod.Metadata(value="bspkrscore")
    public static ModMetadata metadata;
    @Mod.Instance(value="bspkrscore")
    public static bspkrsCoreMod instance;
    @SidedProxy(clientSide="bspkrs.bspkrscore.fml.ClientProxy", serverSide="bspkrs.bspkrscore.fml.CommonProxy")
    public static CommonProxy proxy;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        File file = event.getSuggestedConfigurationFile();
        if (!CommonUtils.isObfuscatedEnv()) {
            // empty if block
        }
        Reference.config = new Configuration(file);
        this.syncConfig();
    }

    public void syncConfig() {
        String ctgyGen = "general";
        Reference.config.load();
        Reference.config.setCategoryComment(ctgyGen, "ATTENTION: Editing this file manually is no longer necessary. \nOn the Mods list screen select the entry for bspkrsCore, then click the Config button to modify these settings.");
        ArrayList<String> orderedKeys = new ArrayList<String>(ConfigElement.values().length);
        this.allowUpdateCheck = Reference.config.getBoolean(ConfigElement.ALLOW_UPDATE_CHECK.key(), ctgyGen, true, ConfigElement.ALLOW_UPDATE_CHECK.desc(), ConfigElement.ALLOW_UPDATE_CHECK.languageKey());
        orderedKeys.add(ConfigElement.ALLOW_UPDATE_CHECK.key());
        this.updateTimeoutMilliseconds = Reference.config.getInt(ConfigElement.UPDATE_TIMEOUT_MILLISECONDS.key(), ctgyGen, 3000, 100, 30000, ConfigElement.UPDATE_TIMEOUT_MILLISECONDS.desc(), ConfigElement.UPDATE_TIMEOUT_MILLISECONDS.languageKey());
        orderedKeys.add(ConfigElement.UPDATE_TIMEOUT_MILLISECONDS.key());
        this.allowDebugOutput = Reference.config.getBoolean(ConfigElement.ALLOW_DEBUG_OUTPUT.key(), ctgyGen, this.allowDebugOutput, ConfigElement.ALLOW_DEBUG_OUTPUT.desc(), ConfigElement.ALLOW_DEBUG_OUTPUT.languageKey());
        orderedKeys.add(ConfigElement.ALLOW_DEBUG_OUTPUT.key());
        this.generateUniqueNamesFile = Reference.config.getBoolean(ConfigElement.GENERATE_UNIQUE_NAMES_FILE.key(), ctgyGen, true, ConfigElement.GENERATE_UNIQUE_NAMES_FILE.desc(), ConfigElement.GENERATE_UNIQUE_NAMES_FILE.languageKey());
        orderedKeys.add(ConfigElement.GENERATE_UNIQUE_NAMES_FILE.key());
        Reference.config.setCategoryPropertyOrder(ctgyGen, orderedKeys);
        if (Reference.config.hasCategory(ctgyGen + ".example_properties")) {
            Reference.config.removeCategory(Reference.config.getCategory(ctgyGen + ".example_properties"));
        }
        Reference.config.save();
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        if (event.getSide().isClient()) {
            MinecraftForge.EVENT_BUS.register((Object)new NetworkHandler());
        }
        MinecraftForge.EVENT_BUS.register((Object)instance);
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        if (this.generateUniqueNamesFile) {
            UniqueNameListGenerator.instance().run();
        }
    }

    @Mod.EventHandler
    public void serverStarting(FMLServerStartingEvent event) {
    }

    @SubscribeEvent
    public void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (event.modID.equals("bspkrscore")) {
            Reference.config.save();
            this.syncConfig();
        }
    }
}

