/*
 * Decompiled with CFR 0.152.
 */
package bspkrs.util;

import bspkrs.bspkrscore.fml.bspkrsCoreMod;
import java.io.File;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Random;
import java.util.Scanner;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiMainMenu;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.Logger;

public final class CommonUtils {
    public static boolean isStringAllLettersOrDigits(CharSequence s) {
        for (int i = 0; i < s.length(); ++i) {
            if (Character.isLetterOrDigit(s.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isStringAllLettersOrDigitsOr(CharSequence s, String chrs) {
        for (int i = 0; i < s.length(); ++i) {
            if (Character.isLetterOrDigit(s.charAt(i)) || chrs.contains(s.subSequence(i, i + 1))) continue;
            return false;
        }
        return true;
    }

    public static boolean isItemInList(int id, int md, String list) {
        if (list.trim().length() != 0) {
            String[] items;
            for (String item : items = list.split(";")) {
                String[] values = item.split(",");
                if (CommonUtils.parseInt(values[0]) != id) continue;
                if (values.length == 1) {
                    return true;
                }
                if (values.length != 2 || CommonUtils.parseInt(values[1]) != md) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isIDInList(String id, int md, String list) {
        String[] itemArray = list.split(";");
        for (int i = 0; i < itemArray.length; ++i) {
            String[] values = itemArray[i].split(",");
            if (values.length > 1 && values[0].trim().equals(id) && CommonUtils.parseInt(values[1], -1) == md) {
                return true;
            }
            if (!values[0].trim().equals(id)) continue;
            return true;
        }
        return false;
    }

    public static boolean isIDInList(int id, int md, String list) {
        String[] itemArray = list.split(";");
        for (int i = 0; i < itemArray.length; ++i) {
            String[] values = itemArray[i].split(",");
            int tempID = CommonUtils.parseInt(values[0], Integer.MAX_VALUE);
            if (tempID == Integer.MAX_VALUE) continue;
            if (values.length > 1 && tempID == id && CommonUtils.parseInt(values[1], -1) == md) {
                return true;
            }
            if (tempID != id) continue;
            return true;
        }
        return false;
    }

    public static boolean isIDInList(int id, String list) {
        return CommonUtils.isIDInList(id, -1, list);
    }

    public static int[][][] stringToGroups(String string) {
        String[] groups;
        ArrayList<int[][]> groupList = new ArrayList<int[][]>();
        for (String group : groups = string.split(";")) {
            groupList.add(CommonUtils.stringToGroup(group));
        }
        int[][][] res = new int[groupList.size()][][];
        for (int i = 0; i < groupList.size(); ++i) {
            res[i] = (int[][])groupList.get(i);
        }
        return res;
    }

    public static int[][] stringToGroup(String string) {
        String[] blocks;
        ArrayList<int[]> blockList = new ArrayList<int[]>();
        for (String block : blocks = string.split(">")) {
            blockList.add(CommonUtils.stringToBlock(block));
        }
        int[][] res = new int[blockList.size()][];
        for (int i = 0; i < blockList.size(); ++i) {
            res[i] = (int[])blockList.get(i);
        }
        return res;
    }

    public static int[] stringToBlock(String string) {
        int[] values = new int[]{0, -1};
        String[] src = string.split(",");
        if (src.length < 1) {
            return values;
        }
        values[0] = CommonUtils.parseInt(src[0]);
        if (src.length < 2) {
            return values;
        }
        values[1] = CommonUtils.parseInt(src[1]);
        return values;
    }

    public static boolean isBlockInGroups(int[] block, int[][][] groups) {
        for (int[][] group : groups) {
            if (CommonUtils.indexOfBlock(block, group) <= -1) continue;
            return true;
        }
        return false;
    }

    public static int indexOfBlock(int[] block, int[][] group) {
        for (int i = 0; i < group.length; ++i) {
            if (block[0] != group[i][0] || group[i][1] != -1 && block[1] != group[i][1]) continue;
            return i;
        }
        return -1;
    }

    public static int[][] getRelatedBlocks(int[] block, int[][][] groups) {
        ArrayList<int[]> blockList = new ArrayList<int[]>();
        for (int[][] group : groups) {
            if (CommonUtils.indexOfBlock(block, group) <= -1) continue;
            for (int i = 0; i < groups.length; ++i) {
                if (blockList.contains(group[i])) continue;
                blockList.add(i, group[i]);
            }
        }
        int[][] secondary = new int[blockList.size()][];
        for (int i = 0; i < blockList.size(); ++i) {
            secondary[i] = (int[])blockList.get(i);
        }
        return secondary;
    }

    public static int smallerBlockIndex(int[] block, int[][][] groups) {
        int min = Integer.MAX_VALUE;
        for (int[][] group : groups) {
            int i = CommonUtils.indexOfBlock(block, group);
            if (i <= -1 || i >= min) continue;
            min = i;
        }
        if (min == Integer.MAX_VALUE) {
            min = -1;
        }
        return min;
    }

    public static boolean isMetadataNull(int id, int[][][] groups) {
        int[][][] nArray = groups;
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            int[][] group;
            for (int[] block : group = nArray[i]) {
                if (block[0] != id || block[1] != -1) continue;
                return true;
            }
        }
        return false;
    }

    public static int sqr(int value) {
        return value * value;
    }

    public static float sqr(float value) {
        return value * value;
    }

    public static int parseInt(String string) {
        return CommonUtils.parseInt(string, 0);
    }

    public static int parseInt(String string, int defaultValue) {
        try {
            return Integer.parseInt(string.trim());
        }
        catch (NumberFormatException ex) {
            return defaultValue;
        }
    }

    public void playAtPitch(int i, World world, EntityPlayer entityplayer) {
        float f = (float)Math.pow(2.0, (double)(i - 12) / 12.0);
        world.func_72956_a((Entity)entityplayer, "note.pling", 0.5f, f);
    }

    public static boolean moveBlock(World world, BlockPos src, BlockPos tgt, boolean allowBlockReplacement) {
        return CommonUtils.moveBlock(world, src, tgt, allowBlockReplacement, 3);
    }

    public static boolean moveBlock(World world, BlockPos src, BlockPos tgt, boolean allowBlockReplacement, int notifyFlag) {
        if (!world.field_72995_K && !world.func_175623_d(src) && (world.func_175623_d(tgt) || allowBlockReplacement)) {
            IBlockState state = world.func_180495_p(src);
            world.func_180501_a(tgt, state, notifyFlag);
            TileEntity te = world.func_175625_s(src);
            if (te != null) {
                NBTTagCompound nbt = new NBTTagCompound();
                te.func_145841_b(nbt);
                nbt.func_74768_a("x", tgt.func_177958_n());
                nbt.func_74768_a("y", tgt.func_177956_o());
                nbt.func_74768_a("z", tgt.func_177952_p());
                te = world.func_175625_s(tgt);
                if (te != null) {
                    te.func_145839_a(nbt);
                }
                world.func_175713_t(src);
            }
            world.func_175698_g(src);
            return true;
        }
        return false;
    }

    public static int getHighestGroundBlock(World world, BlockPos pos) {
        while (pos.func_177956_o() > 0 && (world.func_175623_d(pos) || !world.func_175677_d(pos, true) || world.func_180495_p(pos).func_177230_c().isWood((IBlockAccess)world, pos))) {
            pos = pos.func_177977_b();
        }
        return pos.func_177956_o();
    }

    public static int getFirstNonAirBlockFromTop(World world, BlockPos pos) {
        int y;
        int x = pos.func_177958_n();
        int z = pos.func_177952_p();
        for (y = world.func_72940_L(); world.func_175623_d(new BlockPos(x, y - 1, z)) && y > 0; --y) {
        }
        return y;
    }

    public static int getSphericalDistance(BlockPos startPos, BlockPos endPos) {
        return (int)Math.round(Math.sqrt(CommonUtils.sqr(endPos.func_177958_n() - startPos.func_177958_n()) + CommonUtils.sqr(endPos.func_177952_p() - startPos.func_177952_p()) + CommonUtils.sqr(endPos.func_177956_o() - startPos.func_177956_o())));
    }

    public static int getCubicDistance(BlockPos startPos, BlockPos endPos) {
        return Math.abs(endPos.func_177958_n() - startPos.func_177958_n()) + Math.abs(endPos.func_177956_o() - startPos.func_177956_o()) + Math.abs(endPos.func_177952_p() - startPos.func_177952_p());
    }

    public static int getHorSquaredDistance(BlockPos pos, BlockPos pos2) {
        return Math.abs(pos2.func_177958_n() - pos.func_177958_n()) + Math.abs(pos2.func_177952_p() - pos.func_177952_p());
    }

    public static int getVerDistance(BlockPos startPos, BlockPos endPos) {
        return Math.abs(endPos.func_177956_o() - startPos.func_177956_o());
    }

    public static double getDistanceRatioToCenter(int point1, int point2, int pos) {
        double radius = (double)Math.abs(point2 - point1) / 2.0;
        double dar = Math.abs((double)Math.abs(pos - point1) - radius);
        return radius != 0.0 ? dar / radius : 0.0;
    }

    public static void setHugeMushroom(World world, Random random, BlockPos pos, IBlockState state) {
        int x = pos.func_177958_n();
        int y = pos.func_177956_o();
        int z = pos.func_177952_p();
        int w = 3;
        int cw = 4;
        int h = 4;
        CommonUtils.fillWithBlocks(world, new BlockPos(x - w + 1, y, z - w), new BlockPos(x + w - 1, y + h - 1, z - w), state.func_177230_c().func_176203_a(10));
        CommonUtils.fillWithBlocks(world, new BlockPos(x - w + 1, y, z + w), new BlockPos(x + w - 1, y + h - 1, z + w), state.func_177230_c().func_176203_a(10));
        CommonUtils.fillWithBlocks(world, new BlockPos(x - w, y, z - w + 1), new BlockPos(x - w, y + h - 1, z + w - 1), state.func_177230_c().func_176203_a(10));
        CommonUtils.fillWithBlocks(world, new BlockPos(x + w, y, z - w + 1), new BlockPos(x + w, y + h - 1, z + w - 1), state.func_177230_c().func_176203_a(10));
        CommonUtils.fillWithBlocksRounded(world, new BlockPos(x - cw, y + h, z - cw), new BlockPos(x + cw, y + h, z + cw), state.func_177230_c().func_176203_a(14));
    }

    public static void fillWithBlocks(World world, BlockPos pos1, BlockPos pos2, IBlockState state) {
        for (int x = pos1.func_177958_n(); x <= pos2.func_177958_n(); ++x) {
            for (int y = pos1.func_177956_o(); y <= pos2.func_177956_o(); ++y) {
                for (int z = pos1.func_177952_p(); z <= pos2.func_177952_p(); ++z) {
                    world.func_180501_a(new BlockPos(x, y, z), state, 3);
                }
            }
        }
    }

    public static void fillWithBlocksRounded(World world, BlockPos pos1, BlockPos pos2, IBlockState state) {
        for (int x = pos1.func_177958_n(); x <= pos2.func_177958_n(); ++x) {
            for (int y = pos1.func_177956_o(); y <= pos2.func_177956_o(); ++y) {
                for (int z = pos1.func_177952_p(); z <= pos2.func_177952_p(); ++z) {
                    double zd;
                    double yd;
                    double xd = CommonUtils.getDistanceRatioToCenter(pos1.func_177958_n(), pos2.func_177958_n(), x);
                    if (!(xd * xd + (yd = CommonUtils.getDistanceRatioToCenter(pos1.func_177956_o(), pos2.func_177956_o(), y)) * yd + (zd = CommonUtils.getDistanceRatioToCenter(pos1.func_177952_p(), pos2.func_177952_p(), z)) * zd <= 1.5)) continue;
                    world.func_180501_a(new BlockPos(x, y, z), state, 3);
                }
            }
        }
    }

    public static boolean isGamePaused(Minecraft mc) {
        return mc.field_71462_r != null && (mc.field_71462_r.func_73868_f() || mc.field_71462_r instanceof GuiMainMenu);
    }

    public static String getMCTimeString(long worldTime, long fmt) {
        long HH = (int)((worldTime / 1000L + 6L) % 24L);
        int MM = (int)((double)(worldTime % 1000L) / 1000.0 * 60.0);
        boolean am = HH < 12L;
        String hour = "";
        hour = fmt == 24L ? (HH < 10L ? "0" : "") + String.valueOf(HH) : String.valueOf(HH == 0L ? 12L : (HH %= fmt));
        String min = (MM < 10 ? "0" : "") + String.valueOf(MM);
        return hour + ":" + min + (fmt == 12L ? (am ? "AM" : "PM") : "");
    }

    public static String ticksToTimeString(long ticks) {
        long secs = ticks / 20L;
        long mins = secs / 60L;
        long hrs = mins / 60L;
        long days = hrs / 24L;
        String time = "";
        if (days > 0L) {
            time = days + ":";
        }
        if (hrs > 0L) {
            time = time + (hrs % 24L < 10L && days > 0L ? "0" : "") + hrs % 24L + ":";
        }
        time = mins > 0L ? time + (mins % 60L < 10L && hrs > 0L ? "0" : "") + mins % 60L + ":" : time + "0:";
        time = time + (secs % 60L < 10L ? "0" : "") + secs % 60L;
        return time;
    }

    public static String stringArrayToString(String[] sa) {
        return CommonUtils.stringArrayToString(sa, "#");
    }

    public static String stringArrayToString(String[] sa, String separator) {
        String ret = "";
        for (String s : sa) {
            ret = ret + separator + " " + s;
        }
        return ret.replaceFirst(separator + " ", "");
    }

    public static String[] loadTextFromURL(URL url, Logger logger) {
        return CommonUtils.loadTextFromURL(url, logger, new String[]{""}, 0);
    }

    public static String[] loadTextFromURL(URL url, Logger logger, int timeoutMS) {
        return CommonUtils.loadTextFromURL(url, logger, new String[]{""}, timeoutMS);
    }

    public static String[] loadTextFromURL(URL url, Logger logger, String defaultValue) {
        return CommonUtils.loadTextFromURL(url, logger, new String[]{defaultValue}, 0);
    }

    public static String[] loadTextFromURL(URL url, Logger logger, String defaultValue, int timeoutMS) {
        return CommonUtils.loadTextFromURL(url, logger, new String[]{defaultValue}, timeoutMS);
    }

    public static String[] loadTextFromURL(URL url, Logger logger, String[] defaultValue) {
        return CommonUtils.loadTextFromURL(url, logger, defaultValue, 0);
    }

    public static String[] loadTextFromURL(URL url, Logger logger, String[] defaultValue, int timeoutMS) {
        ArrayList<String> arraylist = new ArrayList<String>();
        Scanner scanner = null;
        try {
            URLConnection uc = url.openConnection();
            uc.setReadTimeout(timeoutMS);
            uc.setConnectTimeout(timeoutMS);
            uc.setRequestProperty("User-Agent", "Mozilla/5.0 (Windows; U; Windows NT 6.1; en-US;     rv:1.9.2.13) Gecko/20101203 Firefox/3.6.13 (.NET CLR 3.5.30729)");
            scanner = new Scanner(uc.getInputStream(), "UTF-8");
        }
        catch (Throwable e) {
            logger.log(Level.WARN, String.format("Error retrieving remote string value at URL %s! Defaulting to %s", url.toString(), CommonUtils.stringArrayToString(defaultValue)));
            if (bspkrsCoreMod.instance.allowDebugOutput) {
                e.printStackTrace();
            }
            if (scanner != null) {
                scanner.close();
            }
            return defaultValue;
        }
        while (scanner.hasNextLine()) {
            arraylist.add(scanner.nextLine());
        }
        scanner.close();
        return arraylist.toArray(new String[arraylist.size()]);
    }

    public static String getLogFileName() {
        try {
            Minecraft.func_71410_x();
            return "ForgeModLoader-client-0.log";
        }
        catch (Throwable e) {
            return "ForgeModLoader-server-0.log";
        }
    }

    public static String getMinecraftDir() {
        try {
            return Minecraft.func_71410_x().field_71412_D.getAbsolutePath();
        }
        catch (NoClassDefFoundError e) {
            return MinecraftServer.func_71276_C().func_71209_f("").getAbsolutePath();
        }
    }

    public static String getConfigDir() {
        File configDir = new File(CommonUtils.getMinecraftDir(), "config");
        return configDir.getAbsolutePath();
    }

    public static boolean isObfuscatedEnv() {
        try {
            Blocks.class.getField("air");
            return false;
        }
        catch (Throwable e) {
            return true;
        }
    }

    public static MovingObjectPosition getPlayerLookingSpot(EntityPlayer player, boolean restrict) {
        float scale = 1.0f;
        float pitch = player.field_70127_C + (player.field_70125_A - player.field_70127_C) * scale;
        float yaw = player.field_70126_B + (player.field_70177_z - player.field_70126_B) * scale;
        double x = player.field_70169_q + (player.field_70165_t - player.field_70169_q) * (double)scale;
        double y = player.field_70167_r + (player.field_70163_u - player.field_70167_r) * (double)scale + 1.62;
        double z = player.field_70166_s + (player.field_70161_v - player.field_70166_s) * (double)scale;
        Vec3 vector1 = new Vec3(x, y, z);
        float cosYaw = MathHelper.func_76134_b((float)(-yaw * ((float)Math.PI / 180) - (float)Math.PI));
        float sinYaw = MathHelper.func_76126_a((float)(-yaw * ((float)Math.PI / 180) - (float)Math.PI));
        float cosPitch = -MathHelper.func_76134_b((float)(-pitch * ((float)Math.PI / 180)));
        float sinPitch = MathHelper.func_76126_a((float)(-pitch * ((float)Math.PI / 180)));
        float pitchAdjustedSinYaw = sinYaw * cosPitch;
        float pitchAdjustedCosYaw = cosYaw * cosPitch;
        double distance = 500.0;
        if (player instanceof EntityPlayerMP && restrict) {
            distance = ((EntityPlayerMP)player).field_71134_c.getBlockReachDistance();
        }
        Vec3 vector2 = vector1.func_72441_c((double)pitchAdjustedSinYaw * distance, (double)sinPitch * distance, (double)pitchAdjustedCosYaw * distance);
        return player.field_70170_p.func_72933_a(vector1, vector2);
    }

    public static void spawnExplosionParticleAtEntity(Entity entity) {
        for (int i = 0; i < 20; ++i) {
            double d0 = entity.field_70170_p.field_73012_v.nextGaussian() * 0.02;
            double d1 = entity.field_70170_p.field_73012_v.nextGaussian() * 0.02;
            double d2 = entity.field_70170_p.field_73012_v.nextGaussian() * 0.02;
            double d3 = 10.0;
            entity.field_70170_p.func_175688_a(EnumParticleTypes.EXPLOSION_NORMAL, entity.field_70165_t + (double)(entity.field_70170_p.field_73012_v.nextFloat() * entity.field_70130_N * 2.0f) - (double)entity.field_70130_N - d0 * d3, entity.field_70163_u + (double)(entity.field_70170_p.field_73012_v.nextFloat() * entity.field_70131_O) - d1 * d3, entity.field_70161_v + (double)(entity.field_70170_p.field_73012_v.nextFloat() * entity.field_70130_N * 2.0f) - (double)entity.field_70130_N - d2 * d3, d0, d1, d2, new int[0]);
        }
    }
}

