/*
 * Decompiled with CFR 0.152.
 */
package com.jtorleonstudios.bettervillage.compat;

import com.jtorleonstudios.bettervillage.Main;
import com.jtorleonstudios.bettervillage.compat.CompatMetaData;
import com.jtorleonstudios.bettervillage.compat.CompatResourcesListener;
import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.data.worldgen.ProcessorLists;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.level.levelgen.structure.pools.StructurePoolElement;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public interface ICompatProcessor {
    public static void apply(@NotNull MinecraftServer server) {
        RegistryAccess.Frozen manager = server.m_206579_();
        Registry pools = manager.m_175515_(Registry.f_122884_);
        StructureTemplatePool plainsPool = (StructureTemplatePool)pools.m_7745_(new ResourceLocation("minecraft:village/plains/houses"));
        ArrayList<Pair<StructurePoolElement, Integer>> plainsStructurePoolElementCounts = ICompatProcessor.getPoolElementCounts(plainsPool);
        ObjectArrayList<StructurePoolElement> plainsStructurePoolElement = ICompatProcessor.getPoolElements(plainsPool);
        StructureTemplatePool desertPool = (StructureTemplatePool)pools.m_7745_(new ResourceLocation("minecraft:village/desert/houses"));
        ArrayList<Pair<StructurePoolElement, Integer>> desertStructurePoolElementCounts = ICompatProcessor.getPoolElementCounts(desertPool);
        ObjectArrayList<StructurePoolElement> desertStructurePoolElement = ICompatProcessor.getPoolElements(desertPool);
        StructureTemplatePool snowyPool = (StructureTemplatePool)pools.m_7745_(new ResourceLocation("minecraft:village/snowy/houses"));
        ArrayList<Pair<StructurePoolElement, Integer>> snowyStructurePoolElementCounts = ICompatProcessor.getPoolElementCounts(snowyPool);
        ObjectArrayList<StructurePoolElement> snowyStructurePoolElement = ICompatProcessor.getPoolElements(snowyPool);
        StructureTemplatePool savannaPool = (StructureTemplatePool)pools.m_7745_(new ResourceLocation("minecraft:village/savanna/houses"));
        ArrayList<Pair<StructurePoolElement, Integer>> savannaStructurePoolElementCounts = ICompatProcessor.getPoolElementCounts(savannaPool);
        ObjectArrayList<StructurePoolElement> savannaStructurePoolElement = ICompatProcessor.getPoolElements(savannaPool);
        StructureTemplatePool taigaPool = (StructureTemplatePool)pools.m_7745_(new ResourceLocation("minecraft:village/taiga/houses"));
        ArrayList<Pair<StructurePoolElement, Integer>> taigaStructurePoolElementCounts = ICompatProcessor.getPoolElementCounts(taigaPool);
        ObjectArrayList<StructurePoolElement> taigaStructurePoolElement = ICompatProcessor.getPoolElements(taigaPool);
        CompatResourcesListener.COMPAT_META_DATA_LIST.forEach(v -> {
            if (v.requireApplyCompat()) {
                ICompatProcessor.poolReplacementProcess(plainsPool, plainsStructurePoolElementCounts, (List<StructurePoolElement>)plainsStructurePoolElement, v, v.getPoolPlains());
                ICompatProcessor.poolReplacementProcess(desertPool, desertStructurePoolElementCounts, (List<StructurePoolElement>)desertStructurePoolElement, v, v.getPoolDesert());
                ICompatProcessor.poolReplacementProcess(savannaPool, savannaStructurePoolElementCounts, (List<StructurePoolElement>)savannaStructurePoolElement, v, v.getPoolSavanna());
                ICompatProcessor.poolReplacementProcess(snowyPool, snowyStructurePoolElementCounts, (List<StructurePoolElement>)snowyStructurePoolElement, v, v.getPoolSnowy());
                ICompatProcessor.poolReplacementProcess(taigaPool, taigaStructurePoolElementCounts, (List<StructurePoolElement>)taigaStructurePoolElement, v, v.getPoolTaiga());
            }
        });
        ICompatProcessor.setPool(plainsPool, plainsStructurePoolElementCounts, plainsStructurePoolElement);
        ICompatProcessor.setPool(desertPool, desertStructurePoolElementCounts, desertStructurePoolElement);
        ICompatProcessor.setPool(snowyPool, snowyStructurePoolElementCounts, snowyStructurePoolElement);
        ICompatProcessor.setPool(savannaPool, savannaStructurePoolElementCounts, savannaStructurePoolElement);
        ICompatProcessor.setPool(taigaPool, taigaStructurePoolElementCounts, taigaStructurePoolElement);
    }

    private static void poolReplacementProcess(StructureTemplatePool pool, List<Pair<StructurePoolElement, Integer>> elementCounts, List<StructurePoolElement> element, CompatMetaData compatMetaData, String[] sourcePoolCompat) {
        if (pool != null && !elementCounts.isEmpty()) {
            for (String structurePathId : sourcePoolCompat) {
                int countRemovedStructuredWeight = 0;
                elementCounts.removeIf(currentPair -> ((StructurePoolElement)currentPair.getFirst()).toString().contains(structurePathId));
                Iterator<StructurePoolElement> iteratorElement = element.iterator();
                while (iteratorElement.hasNext()) {
                    StructurePoolElement currentElement = iteratorElement.next();
                    if (!currentElement.toString().contains(structurePathId)) continue;
                    iteratorElement.remove();
                    ++countRemovedStructuredWeight;
                }
                if (compatMetaData.isReplaceStructures() && countRemovedStructuredWeight > 0) {
                    StructurePoolElement piece = (StructurePoolElement)StructurePoolElement.m_210512_((String)("bettervillage_" + structurePathId), (Holder)ProcessorLists.f_127198_).apply(StructureTemplatePool.Projection.RIGID);
                    for (int i = 0; i < countRemovedStructuredWeight; ++i) {
                        element.add(piece);
                    }
                    elementCounts.add((Pair<StructurePoolElement, Integer>)new Pair((Object)piece, (Object)countRemovedStructuredWeight));
                    Main.LOGGER.info(String.format("Replaced structure of %s mod for compatibility between Better Villages and %<s. (Structure weight defined by the mod %<s is set to %d, you can change the weight in the configuration of the concerned mod)", compatMetaData.getModName(), countRemovedStructuredWeight));
                    continue;
                }
                Main.LOGGER.info(String.format("Deleted structure of %s mod for compatibility between Better Villages and %<s. (Better Villages include the structures by default)", compatMetaData.getModName()));
            }
        }
    }

    private static void setPool(StructureTemplatePool pool, List<Pair<StructurePoolElement, Integer>> poolElementCounts, ObjectArrayList<StructurePoolElement> poolElement) {
        if (pool != null && !poolElementCounts.isEmpty() && !poolElement.isEmpty()) {
            pool.f_210560_ = poolElement;
            pool.f_210559_ = poolElementCounts;
        }
    }

    private static ObjectArrayList<StructurePoolElement> getPoolElements(StructureTemplatePool pool) {
        return pool == null ? new ObjectArrayList() : pool.f_210560_;
    }

    @Contract(value="_ -> new")
    @NotNull
    private static ArrayList<Pair<StructurePoolElement, Integer>> getPoolElementCounts(StructureTemplatePool pool) {
        return pool == null ? new ArrayList<Pair<StructurePoolElement, Integer>>() : new ArrayList(pool.f_210559_);
    }
}

