/*
 * Decompiled with CFR 0.152.
 */
package com.jtorleonstudios.bettervillage.compat;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import com.jtorleonstudios.bettervillage.Main;
import java.util.Arrays;
import java.util.Objects;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.fml.ModList;

public final class CompatMetaData {
    private static final String CURSE_URL_BETTER_VILLAGES = "https://www.curseforge.com/minecraft/mc-mods/better-village-forge";
    private static final Gson GSON = new Gson();
    private final String modId;
    private final String modName;
    private final boolean enabled;
    private final boolean replaceStructures;
    private final String[] poolPlains;
    private final String[] poolDesert;
    private final String[] poolSnowy;
    private final String[] poolSavanna;
    private final String[] poolTaiga;

    private CompatMetaData(String modId, String modName, boolean enabled, boolean replaceStructures, String[] poolPlains, String[] poolDesert, String[] poolSnowy, String[] poolSavanna, String[] poolTaiga) {
        this.modId = modId;
        this.modName = modName;
        this.enabled = enabled;
        this.replaceStructures = replaceStructures;
        this.poolPlains = poolPlains;
        this.poolDesert = poolDesert;
        this.poolSnowy = poolSnowy;
        this.poolSavanna = poolSavanna;
        this.poolTaiga = poolTaiga;
    }

    public boolean isLoadedModForCompat() {
        return ModList.get().isLoaded(this.modId);
    }

    public boolean requireApplyCompat() {
        return this.isLoadedModForCompat() && this.enabled;
    }

    public void debugInformationForEndUser() {
        if (this.isLoadedModForCompat()) {
            if (this.enabled) {
                Main.LOGGER.info(this.modName + " compatibility is enabled for Better Villages.");
            } else {
                Main.LOGGER.error(String.format("%s compatibility is not enabled for Better Village and %<s is present in your mod list.%n     - Please install the datapack for better compatibility between Better Villages and %<s.%n     - You can find the datapack URL in the `compatibility` section of the Better Villages description.%n     - URL=%s", this.modName, CURSE_URL_BETTER_VILLAGES));
            }
        }
    }

    public static CompatMetaData deserialize(ResourceLocation identifier, JsonObject jsonObject) {
        if (jsonObject == null) {
            throw new NullPointerException("A JSON file is invalid file: " + identifier.toString() + ". Please undo your last changes in this files. Or reinstall the mods. If the error continues, please open an issue on Github with all info. Thanks you.");
        }
        return new CompatMetaData(CompatMetaData.getOrThrowString(identifier, jsonObject, "mod_id"), CompatMetaData.getOrThrowString(identifier, jsonObject, "mod_name"), CompatMetaData.getOrThrowBoolean(identifier, jsonObject, "enabled"), CompatMetaData.getOrThrowBoolean(identifier, jsonObject, "replace_structures"), CompatMetaData.getOrThrowStringArray(identifier, jsonObject, "pool_plains"), CompatMetaData.getOrThrowStringArray(identifier, jsonObject, "pool_desert"), CompatMetaData.getOrThrowStringArray(identifier, jsonObject, "pool_snowy"), CompatMetaData.getOrThrowStringArray(identifier, jsonObject, "pool_savanna"), CompatMetaData.getOrThrowStringArray(identifier, jsonObject, "pool_taiga"));
    }

    private static String getOrThrowString(ResourceLocation identifier, JsonObject jsonObject, String memberName) {
        if (!jsonObject.has(memberName)) {
            throw new NullPointerException("A JSON file is invalid file: " + identifier.toString() + ", missing field: \"" + memberName + "\"");
        }
        JsonElement tryGetElement = jsonObject.get(memberName);
        if (tryGetElement == null) {
            throw new NullPointerException("A JSON file is invalid file: " + identifier.toString() + ", null field: \"" + memberName + "\"");
        }
        try {
            return tryGetElement.getAsString();
        }
        catch (ClassCastException e0) {
            throw new ClassCastException("A JSON file is invalid file: " + identifier.toString() + ", bad type field: \"" + memberName + "\", expected String");
        }
        catch (IllegalStateException e0) {
            throw new IllegalStateException("A JSON file is invalid file: " + identifier.toString() + ", bad type field: \"" + memberName + "\"");
        }
    }

    private static boolean getOrThrowBoolean(ResourceLocation identifier, JsonObject jsonObject, String memberName) {
        if (!jsonObject.has(memberName)) {
            throw new NullPointerException("A JSON file is invalid file: " + identifier.toString() + ", missing field: \"" + memberName + "\"");
        }
        JsonElement tryGetElement = jsonObject.get(memberName);
        if (tryGetElement == null) {
            throw new NullPointerException("A JSON file is invalid file: " + identifier.toString() + ", null field: \"" + memberName + "\"");
        }
        try {
            return tryGetElement.getAsBoolean();
        }
        catch (ClassCastException e0) {
            throw new ClassCastException("A JSON file is invalid file: " + identifier.toString() + ", bad type field: \"" + memberName + "\", expected Boolean");
        }
        catch (IllegalStateException e0) {
            throw new IllegalStateException("A JSON file is invalid file: " + identifier.toString() + ", bad type field: \"" + memberName + "\"");
        }
    }

    private static String[] getOrThrowStringArray(ResourceLocation identifier, JsonObject jsonObject, String memberName) {
        if (!jsonObject.has(memberName)) {
            throw new NullPointerException("A JSON file is invalid file: " + identifier.toString() + ", missing field: \"" + memberName + "\"");
        }
        JsonElement tryGetElement = jsonObject.get(memberName);
        if (tryGetElement == null) {
            throw new NullPointerException("A JSON file is invalid file: " + identifier.toString() + ", null field: \"" + memberName + "\"");
        }
        try {
            try {
                return (String[])GSON.fromJson(tryGetElement, String[].class);
            }
            catch (JsonSyntaxException e) {
                Main.LOGGER.error((Object)e);
                throw new ClassCastException("A JSON file is invalid file: " + identifier.toString() + ", bad type field: \"" + memberName + "\", expected String primitive array");
            }
        }
        catch (ClassCastException e) {
            Main.LOGGER.error((Object)e);
            throw new ClassCastException("A JSON file is invalid file: " + identifier.toString() + ", bad type field: \"" + memberName + "\", expected String array");
        }
        catch (IllegalStateException e) {
            Main.LOGGER.error((Object)e);
            throw new IllegalStateException("A JSON file is invalid file: " + identifier.toString() + ", bad type field: \"" + memberName + "\"");
        }
    }

    public String getModId() {
        return this.modId;
    }

    public String getModName() {
        return this.modName;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public boolean isReplaceStructures() {
        return this.replaceStructures;
    }

    public String[] getPoolPlains() {
        return this.poolPlains;
    }

    public String[] getPoolDesert() {
        return this.poolDesert;
    }

    public String[] getPoolSnowy() {
        return this.poolSnowy;
    }

    public String[] getPoolSavanna() {
        return this.poolSavanna;
    }

    public String[] getPoolTaiga() {
        return this.poolTaiga;
    }

    public String toString() {
        return "CompatMetaData{modId='" + this.modId + "', modName='" + this.modName + "', enabled=" + this.enabled + ", replaceStructures=" + this.replaceStructures + ", poolPlains=" + Arrays.toString(this.poolPlains) + ", poolDesert=" + Arrays.toString(this.poolDesert) + ", poolSnowy=" + Arrays.toString(this.poolSnowy) + ", poolSavanna=" + Arrays.toString(this.poolSavanna) + ", poolTaiga=" + Arrays.toString(this.poolTaiga) + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CompatMetaData that = (CompatMetaData)o;
        return this.enabled == that.enabled && this.replaceStructures == that.replaceStructures && Objects.equals(this.modId, that.modId) && Objects.equals(this.modName, that.modName) && Arrays.equals(this.poolPlains, that.poolPlains) && Arrays.equals(this.poolDesert, that.poolDesert) && Arrays.equals(this.poolSnowy, that.poolSnowy) && Arrays.equals(this.poolSavanna, that.poolSavanna) && Arrays.equals(this.poolTaiga, that.poolTaiga);
    }

    public int hashCode() {
        int result = Objects.hash(this.modId, this.modName, this.enabled, this.replaceStructures);
        result = 31 * result + Arrays.hashCode(this.poolPlains);
        result = 31 * result + Arrays.hashCode(this.poolDesert);
        result = 31 * result + Arrays.hashCode(this.poolSnowy);
        result = 31 * result + Arrays.hashCode(this.poolSavanna);
        result = 31 * result + Arrays.hashCode(this.poolTaiga);
        return result;
    }
}

