/*
 * Decompiled with CFR 0.152.
 */
package baguchan.hunterillager.structure;

import baguchan.hunterillager.entity.HunterIllagerEntity;
import baguchan.hunterillager.init.HunterEntityRegistry;
import baguchan.hunterillager.init.HunterStructureRegister;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.StructureFeatureManager;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.StructurePieceAccessor;
import net.minecraft.world.level.levelgen.structure.TemplateStructurePiece;
import net.minecraft.world.level.levelgen.structure.templatesystem.BlockIgnoreProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.ProtectedBlockProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureManager;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessor;

public class HunterHousePieces {
    private static final ResourceLocation hunterbase_Template = new ResourceLocation("hunterillager", "illager_woodhut");
    private static final Map<ResourceLocation, BlockPos> structurePos = ImmutableMap.of((Object)hunterbase_Template, (Object)BlockPos.f_121853_);
    static final BlockPos PIVOT = new BlockPos(9, 0, 9);

    public static void addStructure(StructureManager p_162435_, BlockPos p_162436_, Rotation p_162437_, StructurePieceAccessor p_162438_, Random p_162439_) {
        p_162438_.m_142679_((StructurePiece)new Piece(p_162435_, hunterbase_Template, p_162436_, p_162437_, 0));
    }

    public static class Piece
    extends TemplateStructurePiece {
        public Piece(StructureManager p_71244_, ResourceLocation p_71245_, BlockPos p_71246_, Rotation p_71247_, int p_71248_) {
            super(HunterStructureRegister.HUNTER_HOUSE_STRUCTURE_PIECE, 0, p_71244_, p_71245_, p_71245_.toString(), Piece.makeSettings(p_71247_), Piece.makePosition(p_71245_, p_71246_, p_71248_));
        }

        public Piece(ServerLevel p_162441_, CompoundTag p_162442_) {
            super(HunterStructureRegister.HUNTER_HOUSE_STRUCTURE_PIECE, p_162442_, p_162441_, p_162451_ -> Piece.makeSettings(Rotation.valueOf((String)p_162442_.m_128461_("Rot"))));
        }

        private static StructurePlaceSettings makeSettings(Rotation p_163156_) {
            BlockIgnoreProcessor blockignoreprocessor = BlockIgnoreProcessor.f_74046_;
            StructurePlaceSettings structureplacesettings = new StructurePlaceSettings().m_74379_(p_163156_).m_74377_(Mirror.NONE).m_74385_(PIVOT).m_74383_((StructureProcessor)blockignoreprocessor).m_74383_((StructureProcessor)new ProtectedBlockProcessor(BlockTags.f_144287_.m_6979_()));
            return structureplacesettings;
        }

        private static BlockPos makePosition(ResourceLocation p_162453_, BlockPos p_162454_, int p_162455_) {
            return p_162454_.m_141952_((Vec3i)structurePos.get(p_162453_)).m_6625_(p_162455_);
        }

        protected void m_142347_(ServerLevel p_162444_, CompoundTag p_162445_) {
            super.m_142347_(p_162444_, p_162445_);
            p_162445_.m_128359_("Rot", this.f_73657_.m_74404_().name());
        }

        public boolean m_7832_(WorldGenLevel worldIn, StructureFeatureManager p_230383_2_, ChunkGenerator p_230383_3_, Random p_230383_4_, BoundingBox p_230383_5_, ChunkPos p_230383_6_, BlockPos p_230383_7_) {
            BlockPos blockpos1 = this.f_73658_.m_141952_((Vec3i)this.f_73657_.m_74407_());
            int i = worldIn.m_6924_(Heightmap.Types.WORLD_SURFACE_WG, blockpos1.m_123341_(), blockpos1.m_123343_());
            BlockPos blockpos2 = this.f_73658_;
            this.f_73658_ = this.f_73658_.m_142082_(0, i - 90 - 2, 0);
            boolean flag = super.m_7832_(worldIn, p_230383_2_, p_230383_3_, p_230383_4_, p_230383_5_, p_230383_6_, p_230383_7_);
            this.f_73658_ = blockpos2;
            return flag;
        }

        protected void m_7756_(String function, BlockPos pos, ServerLevelAccessor worldIn, Random p_71263_, BoundingBox p_71264_) {
            if ("hunter".equals(function)) {
                worldIn.m_7731_(pos, Blocks.f_50016_.m_49966_(), 3);
                HunterIllagerEntity hunterIllager = (HunterIllagerEntity)HunterEntityRegistry.HUNTERILLAGER.m_20615_((Level)worldIn.m_6018_());
                hunterIllager.m_21530_();
                hunterIllager.m_6034_((double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5);
                hunterIllager.setHomeTarget(pos);
                hunterIllager.m_6518_(worldIn, worldIn.m_6436_(hunterIllager.m_142538_()), MobSpawnType.STRUCTURE, null, null);
                worldIn.m_7967_((Entity)hunterIllager);
            }
        }
    }
}

