/*
 * Decompiled with CFR 0.152.
 */
package baguchan.hunterillager.client.model;

import baguchan.hunterillager.entity.Hunter;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.model.AnimationUtils;
import net.minecraft.client.model.ArmedModel;
import net.minecraft.client.model.HeadedModel;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.monster.AbstractIllager;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;

public class HunterModel<T extends Hunter>
extends HierarchicalModel<T>
implements ArmedModel,
HeadedModel {
    private final ModelPart waist;
    private final ModelPart LeftLeg;
    private final ModelPart RightLeg;
    private final ModelPart RightArm;
    private final ModelPart LeftArm;
    private final ModelPart bone;
    private final ModelPart root;
    private final ModelPart head;
    private final ModelPart cape;
    public HumanoidModel.ArmPose leftArmPose = HumanoidModel.ArmPose.EMPTY;
    public HumanoidModel.ArmPose rightArmPose = HumanoidModel.ArmPose.EMPTY;

    public HunterModel(ModelPart root) {
        this.root = root;
        this.waist = root.m_171324_("waist");
        this.cape = this.waist.m_171324_("Body").m_171324_("cape");
        this.LeftLeg = root.m_171324_("LeftLeg");
        this.RightLeg = root.m_171324_("RightLeg");
        this.RightArm = root.m_171324_("RightArm");
        this.LeftArm = root.m_171324_("LeftArm");
        this.bone = root.m_171324_("bone");
        this.head = this.bone.m_171324_("head");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition waist = partdefinition.m_171599_("waist", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)12.0f, (float)0.0f));
        PartDefinition Body = waist.m_171599_("Body", CubeListBuilder.m_171558_().m_171514_(0, 18).m_171488_(-4.0f, -24.25f, -3.0f, 8.0f, 12.0f, 6.0f, new CubeDeformation(0.0f)).m_171514_(28, 13).m_171488_(-4.0f, -24.0f, -2.75f, 8.0f, 14.0f, 5.0f, new CubeDeformation(0.5f)), PartPose.m_171419_((float)0.0f, (float)12.0f, (float)0.0f));
        PartDefinition cape = Body.m_171599_("cape", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)-5.0f, (float)-22.0f, (float)0.0f));
        PartDefinition cube_r1 = cape.m_171599_("cube_r1", CubeListBuilder.m_171558_().m_171514_(28, 32).m_171488_(0.5f, -1.0f, 3.0f, 9.0f, 15.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)0.0f, (float)0.3054f, (float)0.0f, (float)0.0f));
        PartDefinition LeftLeg = partdefinition.m_171599_("LeftLeg", CubeListBuilder.m_171558_().m_171514_(49, 0).m_171488_(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)2.0f, (float)12.0f, (float)0.0f));
        PartDefinition RightLeg = partdefinition.m_171599_("RightLeg", CubeListBuilder.m_171558_().m_171514_(44, 44).m_171488_(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-2.0f, (float)12.0f, (float)0.0f));
        PartDefinition RightArm = partdefinition.m_171599_("RightArm", CubeListBuilder.m_171558_().m_171514_(16, 44).m_171488_(-3.0f, -2.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-5.0f, (float)2.0f, (float)0.0f));
        PartDefinition shoulderplate_r1 = RightArm.m_171599_("shoulderplate_r1", CubeListBuilder.m_171558_().m_171514_(48, 32).m_171488_(-4.0f, -2.75f, -2.5f, 5.0f, 3.0f, 5.0f, new CubeDeformation(0.0f)).m_171514_(19, 0).m_171488_(-6.0f, 0.25f, -2.5f, 2.0f, 0.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.2618f));
        PartDefinition LeftArm = partdefinition.m_171599_("LeftArm", CubeListBuilder.m_171558_().m_171514_(0, 36).m_171488_(-1.0f, -2.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)5.0f, (float)2.0f, (float)0.0f));
        PartDefinition shoulderplate_r2 = LeftArm.m_171599_("shoulderplate_r2", CubeListBuilder.m_171558_().m_171514_(24, 0).m_171488_(-1.0f, -2.75f, -2.5f, 5.0f, 3.0f, 5.0f, new CubeDeformation(0.0f)).m_171514_(17, 18).m_171488_(4.0f, 0.25f, -2.5f, 2.0f, 0.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.2618f));
        PartDefinition bone = partdefinition.m_171599_("bone", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition head = bone.m_171599_("head", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition head2 = head.m_171599_("head2", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-4.0f, -34.0f, -4.0f, 8.0f, 10.0f, 8.0f, new CubeDeformation(0.0f)).m_171514_(48, 40).m_171488_(-5.0f, -30.0f, -4.0f, 10.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)24.0f, (float)0.0f));
        PartDefinition nose = head.m_171599_("nose", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-1.0f, -1.0f, -6.0f, 2.0f, 4.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-2.0f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)128, (int)128);
    }

    public void setupAnim(T entityIn, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.m_142109_().m_171331_().forEach(ModelPart::m_233569_);
        this.head.f_104204_ = netHeadYaw * ((float)Math.PI / 180);
        this.head.f_104203_ = headPitch * ((float)Math.PI / 180);
        if (this.f_102609_) {
            this.RightArm.f_104203_ = -0.62831855f;
            this.RightArm.f_104204_ = 0.0f;
            this.RightArm.f_104205_ = 0.0f;
            this.LeftArm.f_104203_ = -0.62831855f;
            this.LeftArm.f_104204_ = 0.0f;
            this.LeftArm.f_104205_ = 0.0f;
            this.RightLeg.f_104203_ = -1.4137167f;
            this.RightLeg.f_104204_ = 0.31415927f;
            this.RightLeg.f_104205_ = 0.07853982f;
            this.LeftLeg.f_104203_ = -1.4137167f;
            this.LeftLeg.f_104204_ = -0.31415927f;
            this.LeftLeg.f_104205_ = -0.07853982f;
        } else {
            this.RightArm.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f + (float)Math.PI)) * 2.0f * limbSwingAmount * 0.5f;
            this.RightArm.f_104204_ = 0.0f;
            this.RightArm.f_104205_ = 0.0f;
            this.LeftArm.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f)) * 2.0f * limbSwingAmount * 0.5f;
            this.LeftArm.f_104204_ = 0.0f;
            this.LeftArm.f_104205_ = 0.0f;
            this.RightLeg.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f)) * 1.4f * limbSwingAmount * 0.5f;
            this.RightLeg.f_104204_ = 0.0f;
            this.RightLeg.f_104205_ = 0.0f;
            this.LeftLeg.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f + (float)Math.PI)) * 1.4f * limbSwingAmount * 0.5f;
            this.LeftLeg.f_104204_ = 0.0f;
            this.LeftLeg.f_104205_ = 0.0f;
        }
        AbstractIllager.IllagerArmPose abstractillager$illagerarmpose = ((Hunter)((Object)entityIn)).m_6768_();
        if (abstractillager$illagerarmpose == AbstractIllager.IllagerArmPose.ATTACKING) {
            AnimationUtils.m_102091_((ModelPart)this.RightArm, (ModelPart)this.LeftArm, entityIn, (float)this.f_102608_, (float)ageInTicks);
        } else if (abstractillager$illagerarmpose == AbstractIllager.IllagerArmPose.BOW_AND_ARROW) {
            this.RightArm.f_104204_ = -0.1f + this.head.f_104204_;
            this.RightArm.f_104203_ = -1.5707964f + this.head.f_104203_;
            this.LeftArm.f_104203_ = -0.9424779f + this.head.f_104203_;
            this.LeftArm.f_104204_ = this.head.f_104204_ - 0.4f;
            this.LeftArm.f_104205_ = 1.5707964f;
        } else if (abstractillager$illagerarmpose == AbstractIllager.IllagerArmPose.CROSSBOW_HOLD) {
            AnimationUtils.m_102097_((ModelPart)this.RightArm, (ModelPart)this.LeftArm, (ModelPart)this.head, (boolean)true);
        } else if (abstractillager$illagerarmpose == AbstractIllager.IllagerArmPose.CROSSBOW_CHARGE) {
            AnimationUtils.m_102086_((ModelPart)this.RightArm, (ModelPart)this.LeftArm, entityIn, (boolean)true);
        } else if (abstractillager$illagerarmpose == AbstractIllager.IllagerArmPose.CELEBRATING) {
            this.RightArm.f_104202_ = 0.0f;
            this.RightArm.f_104200_ = -5.0f;
            this.RightArm.f_104203_ = Mth.m_14089_((float)(ageInTicks * 0.6662f)) * 0.05f;
            this.RightArm.f_104205_ = 2.670354f;
            this.RightArm.f_104204_ = 0.0f;
            this.LeftArm.f_104202_ = 0.0f;
            this.LeftArm.f_104200_ = 5.0f;
            this.LeftArm.f_104203_ = Mth.m_14089_((float)(ageInTicks * 0.6662f)) * 0.05f;
            this.LeftArm.f_104205_ = -2.3561945f;
            this.LeftArm.f_104204_ = 0.0f;
        } else {
            boolean flag2;
            boolean bl = flag2 = entityIn.m_5737_() == HumanoidArm.RIGHT;
            if (entityIn.m_6117_()) {
                boolean flag3;
                boolean bl2 = flag3 = entityIn.m_7655_() == InteractionHand.MAIN_HAND;
                if (flag3 == flag2) {
                    this.poseRightArm(entityIn);
                } else {
                    this.poseLeftArm(entityIn);
                }
            } else {
                boolean flag4;
                boolean bl3 = flag4 = flag2 ? this.leftArmPose.m_102897_() : this.rightArmPose.m_102897_();
                if (flag2 != flag4) {
                    this.poseLeftArm(entityIn);
                    this.poseRightArm(entityIn);
                } else {
                    this.poseRightArm(entityIn);
                    this.poseLeftArm(entityIn);
                }
            }
        }
        this.cape.f_104203_ = 0.17453294f * limbSwingAmount * 1.75f;
    }

    public void prepareMobModel(T entity, float p_103794_, float p_103795_, float p_103796_) {
        this.rightArmPose = HumanoidModel.ArmPose.EMPTY;
        this.leftArmPose = HumanoidModel.ArmPose.EMPTY;
        ItemStack itemstack = entity.m_21120_(InteractionHand.MAIN_HAND);
        if (itemstack.m_150930_(Items.f_220219_) && entity.m_6117_()) {
            if (entity.m_5737_() == HumanoidArm.RIGHT) {
                this.rightArmPose = HumanoidModel.ArmPose.TOOT_HORN;
            } else {
                this.leftArmPose = HumanoidModel.ArmPose.TOOT_HORN;
            }
        }
        super.m_6839_(entity, p_103794_, p_103795_, p_103796_);
    }

    private void poseRightArm(T p_102876_) {
        switch (this.rightArmPose) {
            case SPYGLASS: {
                this.RightArm.f_104203_ = Mth.m_14036_((float)(this.head.f_104203_ - 1.9198622f - (p_102876_.m_6047_() ? 0.2617994f : 0.0f)), (float)-2.4f, (float)3.3f);
                this.RightArm.f_104204_ = this.head.f_104204_ - 0.2617994f;
                break;
            }
            case TOOT_HORN: {
                this.RightArm.f_104203_ = Mth.m_14036_((float)this.head.f_104203_, (float)-1.2f, (float)1.2f) - 1.4835298f;
                this.RightArm.f_104204_ = this.head.f_104204_ - 0.5235988f;
            }
        }
    }

    private void poseLeftArm(T p_102879_) {
        switch (this.leftArmPose) {
            case SPYGLASS: {
                this.LeftArm.f_104203_ = Mth.m_14036_((float)(this.head.f_104203_ - 1.9198622f - (p_102879_.m_6047_() ? 0.2617994f : 0.0f)), (float)-2.4f, (float)3.3f);
                this.LeftArm.f_104204_ = this.head.f_104204_ + 0.2617994f;
                break;
            }
            case TOOT_HORN: {
                this.LeftArm.f_104203_ = Mth.m_14036_((float)this.head.f_104203_, (float)-1.2f, (float)1.2f) - 1.4835298f;
                this.LeftArm.f_104204_ = this.head.f_104204_ + 0.5235988f;
            }
        }
    }

    private ModelPart getArm(HumanoidArm p_102923_) {
        return p_102923_ == HumanoidArm.LEFT ? this.LeftArm : this.RightArm;
    }

    public ModelPart m_5585_() {
        return this.head;
    }

    public void m_6002_(HumanoidArm p_102925_, PoseStack p_102926_) {
        this.getArm(p_102925_).m_104299_(p_102926_);
    }

    public void copyPropertiesTo(HunterModel<T> p_102873_) {
        super.m_102624_(p_102873_);
        p_102873_.leftArmPose = this.leftArmPose;
        p_102873_.rightArmPose = this.rightArmPose;
    }

    public ModelPart m_142109_() {
        return this.root;
    }
}

