/*
 * Decompiled with CFR 0.152.
 */
package baguchan.hunterillager.entity.projectile;

import baguchan.hunterillager.entity.Hunter;
import baguchan.hunterillager.init.HunterDamageSource;
import baguchan.hunterillager.init.HunterEnchantments;
import baguchan.hunterillager.init.HunterEntityRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ThrowableItemProjectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class BoomerangEntity
extends ThrowableItemProjectile {
    private static final EntityDataAccessor<Byte> LOYALTY_LEVEL = SynchedEntityData.m_135353_(BoomerangEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    private static final EntityDataAccessor<Byte> PIERCING_LEVEL = SynchedEntityData.m_135353_(BoomerangEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    private static final EntityDataAccessor<Byte> BOUNCE_LEVEL = SynchedEntityData.m_135353_(BoomerangEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    private static final EntityDataAccessor<Boolean> RETURNING = SynchedEntityData.m_135353_(BoomerangEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<ItemStack> BOOMERANG = SynchedEntityData.m_135353_(BoomerangEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135033_);
    private int totalHits;
    private int flyTick;

    public BoomerangEntity(EntityType<? extends BoomerangEntity> entityEntityType, Level world) {
        super(entityEntityType, world);
    }

    public BoomerangEntity(EntityType<? extends BoomerangEntity> type, Level world, LivingEntity shootingEntity, ItemStack boomerang) {
        super(type, shootingEntity, world);
        this.m_5602_((Entity)shootingEntity);
        this.setBoomerang(boomerang);
        this.f_19804_.m_135381_(LOYALTY_LEVEL, (Object)((byte)EnchantmentHelper.m_44928_((ItemStack)boomerang)));
        this.f_19804_.m_135381_(PIERCING_LEVEL, (Object)((byte)EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44961_, (ItemStack)boomerang)));
        this.f_19804_.m_135381_(BOUNCE_LEVEL, (Object)((byte)EnchantmentHelper.m_44843_((Enchantment)((Enchantment)HunterEnchantments.BOUNCE.get()), (ItemStack)boomerang)));
        this.totalHits = 0;
    }

    public BoomerangEntity(Level world, LivingEntity entity, ItemStack boomerang) {
        this((EntityType<? extends BoomerangEntity>)((EntityType)HunterEntityRegistry.BOOMERANG.get()), world, entity, boomerang);
    }

    private void onHitFluid(BlockHitResult result) {
        double velocity = this.getVelocity();
        double horizontal = this.m_20184_().f_82480_ * this.m_20184_().f_82480_;
        if (result.m_6662_() == HitResult.Type.BLOCK && result.m_82436_() && velocity >= (double)0.65f && horizontal < (double)0.175f && !this.f_19853_.m_8055_(result.m_82425_()).m_60795_() && this.f_19853_.m_6425_(result.m_82425_()).m_205070_(FluidTags.f_13131_)) {
            this.m_20334_(this.m_20184_().f_82479_, Mth.m_14008_((double)(this.m_20184_().f_82480_ + (double)0.1f), (double)-0.1f, (double)0.3f), this.m_20184_().f_82481_);
            this.f_19812_ = true;
        }
    }

    protected void m_5790_(EntityHitResult result) {
        Entity shooter;
        super.m_5790_(result);
        boolean returnToOwner = false;
        byte loyaltyLevel = (Byte)this.f_19804_.m_135370_(LOYALTY_LEVEL);
        byte piercingLevel = (Byte)this.f_19804_.m_135370_(PIERCING_LEVEL);
        Entity entity = this.m_37282_();
        if (!(result.m_82443_() == this.m_37282_() || this.isReturning() && loyaltyLevel > 0)) {
            shooter = this.m_37282_();
            int sharpness = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44977_, (ItemStack)this.getBoomerang());
            int damage = (int)(3.0 * Math.sqrt(this.m_20184_().f_82479_ * this.m_20184_().f_82479_ + this.m_20184_().f_82480_ * this.m_20184_().f_82480_ * 0.5 + this.m_20184_().f_82481_ * this.m_20184_().f_82481_) + (double)Math.min(1, sharpness) + (double)Math.max(0, sharpness - 1) * 0.5 + (double)(0.5f * (float)piercingLevel));
            if (damage != 0) {
                result.m_82443_().m_6469_(HunterDamageSource.boomerangAttack((Entity)this, shooter), (float)damage);
            }
            if (shooter instanceof LivingEntity) {
                this.getBoomerang().m_41622_(1, (LivingEntity)shooter, p_222182_1_ -> {});
            }
            double speed = this.getSpeed();
            if (piercingLevel < 1 && this.totalHits >= this.getBounceLevel() || this.totalHits >= piercingLevel + this.getBounceLevel() && speed > (double)0.4f) {
                returnToOwner = true;
            } else if (piercingLevel < 1 && this.totalHits < this.getBounceLevel() || this.totalHits < piercingLevel + this.getBounceLevel() && speed <= (double)0.4f) {
                Vec3 motion = this.m_20184_();
                double motionX = motion.f_82479_;
                double motionY = motion.f_82480_;
                double motionZ = motion.f_82481_;
                motionX = -motionX;
                motionZ = -motionZ;
                this.m_20334_(motionX, motionY, motionZ);
            }
            ++this.totalHits;
        }
        if (returnToOwner && !this.isReturning()) {
            if (this.m_37282_() != null && this.shouldReturnToThrower() && EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44955_, (ItemStack)this.getBoomerang()) > 0) {
                shooter = this.m_37282_();
                this.f_19853_.m_5594_(null, shooter.m_20183_(), SoundEvents.f_12516_, SoundSource.PLAYERS, 1.0f, 1.0f);
                Vec3 motion = this.m_20184_();
                double motionX = motion.f_82479_;
                double motionY = motion.f_82480_;
                double motionZ = motion.f_82481_;
                motionX = -motionX;
                motionZ = -motionZ;
                this.m_20334_(motionX, motionY, motionZ);
                if (loyaltyLevel > 0 && !this.isReturning() && entity != null) {
                    this.f_19853_.m_5594_(null, entity.m_20183_(), SoundEvents.f_12516_, SoundSource.PLAYERS, 1.0f, 1.0f);
                    this.setReturning(true);
                }
            } else {
                Vec3 motion = this.m_20184_();
                double motionX = motion.f_82479_;
                double motionY = motion.f_82480_;
                double motionZ = motion.f_82481_;
                motionX = -motionX;
                motionZ = -motionZ;
                this.m_20334_(motionX, motionY, motionZ);
                if (loyaltyLevel > 0 && !this.isReturning() && entity != null) {
                    this.f_19853_.m_5594_(null, entity.m_20183_(), SoundEvents.f_12516_, SoundSource.PLAYERS, 1.0f, 1.0f);
                    this.setReturning(true);
                }
            }
        }
    }

    protected void m_8060_(BlockHitResult result) {
        super.m_8060_(result);
        BlockPos pos = result.m_82425_();
        BlockState state = this.f_19853_.m_8055_(pos);
        SoundType soundType = state.getSoundType((LevelReader)this.f_19853_, pos, (Entity)this);
        if (!this.isReturning()) {
            this.f_19853_.m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), soundType.m_56778_(), SoundSource.BLOCKS, soundType.m_56773_() * 0.45f, soundType.m_56774_());
        }
        ++this.totalHits;
        BlockState blockstate = this.f_19853_.m_8055_(result.m_82425_());
        byte loyaltyLevel = (Byte)this.f_19804_.m_135370_(LOYALTY_LEVEL);
        byte piercingLevel = (Byte)this.f_19804_.m_135370_(PIERCING_LEVEL);
        Entity entity = this.m_37282_();
        if (!this.isReturning() && !blockstate.m_60812_((BlockGetter)this.f_19853_, result.m_82425_()).m_83281_()) {
            Direction face = result.m_82434_();
            Vec3 motion = this.m_20184_();
            double motionX = motion.f_82479_;
            double motionY = motion.f_82480_;
            double motionZ = motion.f_82481_;
            if (face == Direction.EAST) {
                motionX = -motionX;
            } else if (face == Direction.SOUTH) {
                motionZ = -motionZ;
            } else if (face == Direction.WEST) {
                motionX = -motionX;
            } else if (face == Direction.NORTH) {
                motionZ = -motionZ;
            } else if (face == Direction.UP) {
                motionY = -motionY;
            } else if (face == Direction.DOWN) {
                motionY = -motionY;
            }
            this.m_20334_(motionX, motionY, motionZ);
            if (loyaltyLevel > 0 && !this.isReturning() && this.totalHits >= this.getBounceLevel() && entity != null) {
                this.f_19853_.m_5594_(null, entity.m_20183_(), SoundEvents.f_12516_, SoundSource.PLAYERS, 1.0f, 1.0f);
                this.setReturning(true);
            }
        }
        this.m_20101_();
    }

    protected void m_6532_(HitResult result) {
        super.m_6532_(result);
        byte loyaltyLevel = (Byte)this.f_19804_.m_135370_(LOYALTY_LEVEL);
        if (loyaltyLevel < 1 && this.totalHits >= this.getBounceLevel()) {
            this.drop(this.m_20185_(), this.m_20186_(), this.m_20189_());
        }
    }

    public int getFlyTick() {
        return this.flyTick;
    }

    private boolean shouldReturnToThrower() {
        Entity entity = this.m_37282_();
        if (entity != null && entity.m_6084_()) {
            return !(entity instanceof Player) || !entity.m_5833_() || entity instanceof Hunter;
        }
        return false;
    }

    public void m_6123_(Player entityIn) {
        super.m_6123_(entityIn);
        if (this.flyTick >= 6 && entityIn == this.m_37282_()) {
            this.drop(this.m_37282_().m_20185_(), this.m_37282_().m_20186_(), this.m_37282_().m_20189_());
        }
    }

    public void drop(double x, double y, double z) {
        if (this.m_37282_() instanceof Hunter || this.m_37282_() instanceof Player && !((Player)this.m_37282_()).m_7500_()) {
            this.f_19853_.m_7967_((Entity)new ItemEntity(this.f_19853_, x, y, z, this.getBoomerang().m_41620_(1)));
            this.m_146870_();
        } else {
            this.m_146870_();
        }
    }

    public void m_8119_() {
        super.m_8119_();
        Vec3 vec3 = this.m_20184_();
        if (this.f_19860_ == 0.0f && this.f_19859_ == 0.0f) {
            double d0 = vec3.m_165924_();
            this.m_146922_((float)(Mth.m_14136_((double)vec3.f_82479_, (double)vec3.f_82481_) * 57.2957763671875));
            this.m_146926_((float)(Mth.m_14136_((double)vec3.f_82480_, (double)d0) * 57.2957763671875));
            this.f_19859_ = this.m_146908_();
            this.f_19860_ = this.m_146909_();
        }
        ++this.flyTick;
        Vec3 vec3d1 = this.m_20182_();
        Vec3 vec3d2 = new Vec3(this.m_20185_() + this.m_20184_().f_82479_, this.m_20186_() + this.m_20184_().f_82480_, this.m_20189_() + this.m_20184_().f_82481_);
        BlockHitResult fluidHitResult = this.f_19853_.m_45547_(new ClipContext(vec3d1, vec3d2, ClipContext.Block.COLLIDER, ClipContext.Fluid.ANY, (Entity)this));
        this.onHitFluid(fluidHitResult);
        double moveX = vec3.f_82479_;
        double moveY = vec3.f_82480_;
        double moveZ = vec3.f_82481_;
        double d4 = vec3.m_165924_();
        this.m_146922_((float)(Mth.m_14136_((double)moveX, (double)moveZ) * 57.2957763671875));
        this.m_146926_((float)(Mth.m_14136_((double)moveY, (double)d4) * 57.2957763671875));
        this.m_146926_(BoomerangEntity.m_37273_((float)this.f_19860_, (float)this.m_146909_()));
        this.m_146922_(BoomerangEntity.m_37273_((float)this.f_19859_, (float)this.m_146908_()));
        byte loyaltyLevel = (Byte)this.f_19804_.m_135370_(LOYALTY_LEVEL);
        Entity entity = this.m_37282_();
        if (loyaltyLevel > 0 && !this.isReturning()) {
            if (this.flyTick >= 80 && entity != null) {
                this.f_19853_.m_5594_(null, entity.m_20183_(), SoundEvents.f_12516_, SoundSource.PLAYERS, 1.0f, 1.0f);
                this.setReturning(true);
            }
            if (this.flyTick < 80) {
                this.m_20256_(vec3.m_82490_((double)1.01f));
            }
        }
        if (loyaltyLevel > 0 && entity != null && !this.shouldReturnToThrower() && this.isReturning()) {
            this.drop(this.m_20185_(), this.m_20186_(), this.m_20189_());
        } else if (loyaltyLevel > 0 && entity != null && this.isReturning()) {
            this.f_19794_ = true;
            Vec3 vec3d3 = new Vec3(entity.m_20185_() - this.m_20185_(), entity.m_20188_() - this.m_20186_(), entity.m_20189_() - this.m_20189_());
            double d0 = 0.05 * (double)loyaltyLevel;
            this.m_20256_(this.m_20184_().m_82490_(0.95).m_82549_(vec3d3.m_82541_().m_82490_(d0)));
        }
        this.m_20101_();
    }

    protected float m_7139_() {
        if (this.getLoyaltyLevel() > 0 && !this.isReturning()) {
            if (this.m_20069_()) {
                return 0.01f;
            }
            return 0.0f;
        }
        return this.getLoyaltyLevel() > 0 && this.isReturning() ? 0.0f : 0.03f;
    }

    public boolean m_6783_(double p_70112_1_) {
        double d0 = this.m_20191_().m_82309_() * 5.0;
        if (Double.isNaN(d0)) {
            d0 = 1.0;
        }
        return p_70112_1_ < (d0 *= 64.0) * d0;
    }

    protected Item m_7881_() {
        return this.getBoomerang().m_41720_();
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(LOYALTY_LEVEL, (Object)0);
        this.f_19804_.m_135372_(PIERCING_LEVEL, (Object)0);
        this.f_19804_.m_135372_(BOUNCE_LEVEL, (Object)0);
        this.f_19804_.m_135372_(RETURNING, (Object)false);
        this.f_19804_.m_135372_(BOOMERANG, (Object)ItemStack.f_41583_);
    }

    public void m_7380_(CompoundTag nbt) {
        super.m_7380_(nbt);
        nbt.m_128365_("boomerang", (Tag)this.getBoomerang().m_41739_(new CompoundTag()));
        nbt.m_128405_("totalHits", this.totalHits);
        nbt.m_128379_("returning", this.isReturning());
    }

    public void m_7378_(CompoundTag nbt) {
        super.m_7378_(nbt);
        this.setBoomerang(ItemStack.m_41712_((CompoundTag)nbt.m_128469_("boomerang")));
        this.totalHits = nbt.m_128451_("totalHits");
        this.setReturning(nbt.m_128471_("returning"));
        this.f_19804_.m_135381_(LOYALTY_LEVEL, (Object)((byte)EnchantmentHelper.m_44928_((ItemStack)this.getBoomerang())));
        this.f_19804_.m_135381_(PIERCING_LEVEL, (Object)((byte)EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44961_, (ItemStack)this.getBoomerang())));
        this.f_19804_.m_135381_(BOUNCE_LEVEL, (Object)((byte)EnchantmentHelper.m_44843_((Enchantment)((Enchantment)HunterEnchantments.BOUNCE.get()), (ItemStack)this.getBoomerang())));
    }

    private int getLoyaltyLevel() {
        return ((Byte)this.f_19804_.m_135370_(LOYALTY_LEVEL)).byteValue();
    }

    private int getBounceLevel() {
        byte loyaltyLevel = (Byte)this.f_19804_.m_135370_(LOYALTY_LEVEL);
        byte bounceLevel = (Byte)this.f_19804_.m_135370_(BOUNCE_LEVEL);
        if (loyaltyLevel > 0) {
            return 0 + bounceLevel * 8;
        }
        return 8 + bounceLevel * 8;
    }

    public boolean isReturning() {
        return (Boolean)this.f_19804_.m_135370_(RETURNING);
    }

    public ItemStack getBoomerang() {
        return (ItemStack)this.f_19804_.m_135370_(BOOMERANG);
    }

    public double getSpeed() {
        return Math.sqrt(this.m_20184_().f_82479_ * this.m_20184_().f_82479_ + this.m_20184_().f_82480_ * this.m_20184_().f_82480_ + this.m_20184_().f_82481_ * this.m_20184_().f_82481_);
    }

    public double getVelocity() {
        return Math.sqrt(this.m_20184_().f_82479_ * this.m_20184_().f_82479_ + this.m_20184_().f_82481_ * this.m_20184_().f_82481_);
    }

    public int getPiercingLevel() {
        return ((Byte)this.f_19804_.m_135370_(PIERCING_LEVEL)).byteValue();
    }

    public void setReturning(boolean returning) {
        this.f_19804_.m_135381_(RETURNING, (Object)returning);
    }

    public void setBoomerang(ItemStack stack) {
        this.f_19804_.m_135381_(BOOMERANG, (Object)stack);
    }
}

