/*
 * Decompiled with CFR 0.152.
 */
package baguchan.hunterillager.entity;

import baguchan.hunterillager.entity.ai.BoomeranAttackGoal;
import baguchan.hunterillager.entity.ai.DoSleepingGoal;
import baguchan.hunterillager.entity.ai.DodgeGoal;
import baguchan.hunterillager.entity.ai.DodgeMoveControl;
import baguchan.hunterillager.entity.ai.SleepOnBedGoal;
import baguchan.hunterillager.entity.ai.WakeUpGoal;
import baguchan.hunterillager.entity.projectile.BoomerangEntity;
import baguchan.hunterillager.init.HunterItems;
import baguchan.hunterillager.init.HunterSounds;
import baguchan.hunterillager.utils.HunterConfigUtils;
import com.google.common.collect.Maps;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import net.minecraft.class_1266;
import net.minecraft.class_1267;
import net.minecraft.class_1268;
import net.minecraft.class_1277;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1301;
import net.minecraft.class_1304;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1310;
import net.minecraft.class_1314;
import net.minecraft.class_1315;
import net.minecraft.class_1347;
import net.minecraft.class_1352;
import net.minecraft.class_1358;
import net.minecraft.class_1361;
import net.minecraft.class_1366;
import net.minecraft.class_1380;
import net.minecraft.class_1394;
import net.minecraft.class_1399;
import net.minecraft.class_1400;
import net.minecraft.class_1409;
import net.minecraft.class_1429;
import net.minecraft.class_1439;
import net.minecraft.class_1542;
import net.minecraft.class_1543;
import net.minecraft.class_1588;
import net.minecraft.class_1603;
import net.minecraft.class_1657;
import net.minecraft.class_1665;
import net.minecraft.class_1675;
import net.minecraft.class_1676;
import net.minecraft.class_1746;
import net.minecraft.class_1753;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1890;
import net.minecraft.class_1893;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2512;
import net.minecraft.class_2520;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3532;
import net.minecraft.class_3730;
import net.minecraft.class_3763;
import net.minecraft.class_3765;
import net.minecraft.class_3988;
import net.minecraft.class_4255;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5425;
import net.minecraft.class_6053;
import org.jetbrains.annotations.Nullable;

public class Hunter
extends class_1543
implements class_1603 {
    public static final Predicate<class_1309> TARGET_ENTITY_SELECTOR = p_213616_0_ -> !p_213616_0_.method_6109() && HunterConfigUtils.isWhitelistedEntity(p_213616_0_.method_5864());
    private static final Predicate<? super class_1542> ALLOWED_ITEMS = p_213616_0_ -> p_213616_0_.method_6983().method_7909().method_19264() != null && HunterConfigUtils.isWhitelistedItem(p_213616_0_.method_6983().method_7909());
    private final class_1277 inventory = new class_1277(5);
    @Nullable
    private class_2338 homeTarget;
    private int cooldown;

    public Hunter(class_1299<? extends Hunter> p_i48556_1_, class_1937 p_i48556_2_) {
        super(p_i48556_1_, p_i48556_2_);
        ((class_1409)this.method_5942()).method_6363(true);
        this.field_6207 = new DodgeMoveControl((class_1308)this);
        this.method_5952(true);
    }

    protected void method_5959() {
        super.method_5959();
        this.field_6201.method_6277(0, (class_1352)new WakeUpGoal((class_1314)this));
        this.field_6201.method_6277(0, (class_1352)new DoSleepingGoal((class_1314)this));
        this.field_6201.method_6277(0, (class_1352)new class_1347((class_1308)this));
        this.field_6201.method_6277(0, (class_1352)new DodgeGoal(this, class_1676.class));
        this.field_6201.method_6277(1, (class_1352)new class_4255((class_1308)this, true));
        this.field_6201.method_6277(2, (class_1352)new class_1543.class_4258((class_1543)this, (class_3763)this));
        this.field_6201.method_6277(3, (class_1352)new class_3763.class_4223((class_3763)this, (class_1543)this, 10.0f));
        this.field_6201.method_6277(4, (class_1352)new class_1380((class_1588)this, (double)1.1f, 50, 16.0f));
        this.field_6201.method_6277(4, (class_1352)new BoomeranAttackGoal(this, 50, 16.0f));
        this.field_6201.method_6277(4, (class_1352)new class_1366((class_1314)this, 1.15f, true){

            public boolean method_6264() {
                return !this.field_6503.method_24520(item -> item.method_7909() instanceof class_1753) && super.method_6264();
            }

            public boolean method_6266() {
                return !this.field_6503.method_24520(item -> item.method_7909() instanceof class_1753) && super.method_6266();
            }
        });
        this.field_6201.method_6277(5, (class_1352)new SleepOnBedGoal((class_1314)this, 1.0, 8));
        this.field_6201.method_6277(6, (class_1352)new MoveToGoal(this, 26.0, 1.2));
        this.field_6201.method_6277(7, (class_1352)new GetFoodGoal(this, this));
        this.field_6185.method_6277(1, (class_1352)new class_1399((class_1314)this, new Class[]{class_3763.class}).method_6318(new Class[]{class_1543.class}));
        this.field_6185.method_6277(2, (class_1352)new class_1400((class_1308)this, class_1657.class, true));
        this.field_6185.method_6277(3, (class_1352)new class_1400((class_1308)this, class_3988.class, true));
        this.field_6185.method_6277(3, (class_1352)new class_1400((class_1308)this, class_1439.class, true));
        this.field_6185.method_6277(4, (class_1352)new class_1400((class_1308)this, class_6053.class, true));
        this.field_6185.method_6277(5, (class_1352)new class_1400((class_1308)this, class_1429.class, 10, true, false, TARGET_ENTITY_SELECTOR){

            public boolean method_6264() {
                return Hunter.this.cooldown <= 0 && super.method_6264();
            }
        });
        this.field_6201.method_6277(8, (class_1352)new class_1394((class_1314)this, 0.8));
        this.field_6201.method_6277(9, (class_1352)new class_1358((class_1308)this, class_1657.class, 3.0f, 1.0f));
        this.field_6201.method_6277(10, (class_1352)new class_1361((class_1308)this, class_1308.class, 8.0f));
    }

    public class_1799 method_18866(class_1937 p_21067_, class_1799 p_21068_) {
        if (p_21068_.method_19267()) {
            this.method_6025(p_21068_.method_7909().method_19264().method_19230());
        }
        return super.method_18866(p_21067_, p_21068_);
    }

    public void method_6007() {
        if (!this.field_6002.field_9236 && this.method_5805()) {
            class_1799 mainhand = this.method_5998(class_1268.field_5808);
            if (!this.method_6115() && this.method_6079().method_7960() && (mainhand.method_7909() == class_1802.field_8102 && this.method_5968() == null || mainhand.method_7909() != class_1802.field_8102)) {
                class_1799 stack = class_1799.field_8037;
                if (this.method_6032() < this.method_6063() && this.field_5974.method_43057() < 0.005f) {
                    stack = this.findFood();
                } else if (this.method_6032() >= this.method_6063() && this.field_5974.method_43057() < 0.001f) {
                    stack = this.findBoomerang();
                }
                if (!stack.method_7960()) {
                    this.method_5673(class_1304.field_6171, stack);
                    if (stack.method_19267()) {
                        this.method_6019(class_1268.field_5810);
                    }
                }
            }
        }
        super.method_6007();
    }

    private class_1799 findFood() {
        for (int i = 0; i < this.inventory.method_5439(); ++i) {
            class_1799 itemstack = this.inventory.method_5438(i);
            if (itemstack.method_7960() || itemstack.method_7909().method_19264() == null || !HunterConfigUtils.isWhitelistedItem(itemstack.method_7909())) continue;
            return itemstack.method_7971(1);
        }
        return class_1799.field_8037;
    }

    private class_1799 findBoomerang() {
        for (int i = 0; i < this.inventory.method_5439(); ++i) {
            class_1799 itemstack = this.inventory.method_5438(i);
            if (itemstack.method_7960() || !itemstack.method_31574(HunterItems.BOOMERANG)) continue;
            return itemstack.method_7971(1);
        }
        return class_1799.field_8037;
    }

    public static class_5132.class_5133 createAttributes() {
        return class_1588.method_26918().method_26868(class_5134.field_23719, (double)0.3f).method_26868(class_5134.field_23717, 20.0).method_26868(class_5134.field_23716, 26.0).method_26868(class_5134.field_23724, 1.0).method_26868(class_5134.field_23721, 3.0);
    }

    public void method_5652(class_2487 p_213281_1_) {
        super.method_5652(p_213281_1_);
        if (this.homeTarget != null) {
            p_213281_1_.method_10566("HomeTarget", (class_2520)class_2512.method_10692((class_2338)this.homeTarget));
        }
        class_2499 listnbt = new class_2499();
        for (int i = 0; i < this.inventory.method_5439(); ++i) {
            class_1799 itemstack = this.inventory.method_5438(i);
            if (itemstack.method_7960()) continue;
            listnbt.add((Object)itemstack.method_7953(new class_2487()));
        }
        p_213281_1_.method_10566("Inventory", (class_2520)listnbt);
        p_213281_1_.method_10569("HuntingCooldown", this.cooldown);
    }

    public void method_5749(class_2487 p_70037_1_) {
        super.method_5749(p_70037_1_);
        if (p_70037_1_.method_10545("HomeTarget")) {
            this.homeTarget = class_2512.method_10691((class_2487)p_70037_1_.method_10562("HomeTarget"));
        }
        class_2499 listnbt = p_70037_1_.method_10554("Inventory", 10);
        for (int i = 0; i < listnbt.size(); ++i) {
            class_1799 itemstack = class_1799.method_7915((class_2487)listnbt.method_10602(i));
            if (itemstack.method_7960()) continue;
            this.inventory.method_5491(itemstack);
        }
        this.cooldown = p_70037_1_.method_10550("HuntingCooldown");
        this.method_5952(true);
    }

    public void method_16484(int p_213660_1_, boolean p_213660_2_) {
        boolean flag;
        class_1799 offHandStack = new class_1799((class_1935)HunterItems.BOOMERANG);
        class_3765 raid = this.method_16478();
        int i = 1;
        if (p_213660_1_ > raid.method_20016(class_1267.field_5802)) {
            i = 2;
        }
        class_1799 itemstack = raid.method_16493() < 2 || p_213660_1_ <= raid.method_20016(class_1267.field_5802) ? (this.field_5974.method_43056() ? new class_1799((class_1935)class_1802.field_8102) : new class_1799((class_1935)class_1802.field_8528)) : (this.field_5974.method_43056() ? new class_1799((class_1935)class_1802.field_8102) : new class_1799((class_1935)class_1802.field_8371));
        this.inventory.method_5491(new class_1799((class_1935)class_1802.field_8389, 5));
        boolean bl = flag = this.field_5974.method_43057() <= raid.method_20025();
        if (flag) {
            if (itemstack.method_7909() == class_1802.field_8102) {
                map = Maps.newHashMap();
                map.put(class_1893.field_9103, i);
                class_1890.method_8214((Map)map, (class_1799)itemstack);
            } else {
                map = Maps.newHashMap();
                map.put(class_1893.field_9118, i);
                class_1890.method_8214((Map)map, (class_1799)itemstack);
            }
            this.inventory.method_5491(new class_1799((class_1935)class_1802.field_8176, 2));
            HashMap map2 = Maps.newHashMap();
            map2.put(class_1893.field_9118, i);
            class_1890.method_8214((Map)map2, (class_1799)offHandStack);
        }
        if (this.field_5974.method_43057() < 0.25f && !itemstack.method_31574(class_1802.field_8102)) {
            HashMap map3 = Maps.newHashMap();
            map3.put(class_1893.field_9120, i);
            class_1890.method_8214((Map)map3, (class_1799)offHandStack);
            this.method_6122(class_1268.field_5810, offHandStack);
        }
        this.method_6122(class_1268.field_5808, itemstack);
    }

    protected void method_6070() {
        List list;
        if (!this.field_6002.method_8608() && !(list = this.field_6002.method_8333((class_1297)this, this.method_5829(), class_1301.field_6154)).isEmpty()) {
            for (int l = 0; l < list.size(); ++l) {
                BoomerangEntity boomerang;
                class_1297 entity = (class_1297)list.get(l);
                if (!(entity instanceof BoomerangEntity) || (boomerang = (BoomerangEntity)entity).getFlyTick() <= 4 || this != boomerang.method_24921()) continue;
                boomerang.drop(this.method_23317(), this.method_23318(), this.method_23321());
            }
        }
        super.method_6070();
    }

    protected void method_5949(class_1542 p_175445_1_) {
        class_1799 itemstack = p_175445_1_.method_6983();
        if (itemstack.method_7909() instanceof class_1746) {
            super.method_5949(p_175445_1_);
        } else {
            class_1792 item = itemstack.method_7909();
            if (this.wantsFood(itemstack)) {
                this.method_29499(p_175445_1_);
                this.method_6103((class_1297)p_175445_1_, itemstack.method_7947());
                class_1799 itemstack1 = this.inventory.method_5491(itemstack);
                if (itemstack1.method_7960()) {
                    p_175445_1_.method_31472();
                } else {
                    itemstack.method_7939(itemstack1.method_7947());
                }
            } else if (item == HunterItems.BOOMERANG) {
                this.method_29499(p_175445_1_);
                this.method_6103((class_1297)p_175445_1_, itemstack.method_7947());
                class_1799 itemstack1 = this.inventory.method_5491(itemstack);
                if (itemstack1.method_7960()) {
                    p_175445_1_.method_31472();
                } else {
                    itemstack.method_7939(itemstack1.method_7947());
                }
            }
        }
    }

    private boolean wantsFood(class_1799 p_213672_1_) {
        return p_213672_1_.method_7909().method_19264() != null && HunterConfigUtils.isWhitelistedItem(p_213672_1_.method_7909());
    }

    @Nullable
    public class_1315 method_5943(class_5425 p_37856_, class_1266 p_37857_, class_3730 p_37858_, @Nullable class_1315 p_37859_, @Nullable class_2487 p_37860_) {
        class_1315 ilivingentitydata = super.method_5943(p_37856_, p_37857_, p_37858_, p_37859_, p_37860_);
        ((class_1409)this.method_5942()).method_6363(true);
        this.method_5952(true);
        this.populateDefaultEquipmentSlots(p_37857_);
        this.method_5984(this.field_5974, p_37857_);
        return ilivingentitydata;
    }

    protected void method_16078() {
        super.method_16078();
        if (this.inventory != null) {
            for (int i = 0; i < this.inventory.method_5439(); ++i) {
                class_1799 itemstack = this.inventory.method_5438(i);
                if (itemstack.method_7960() || class_1890.method_8221((class_1799)itemstack)) continue;
                this.method_5775(itemstack);
            }
        }
    }

    protected void populateDefaultEquipmentSlots(class_1266 p_180481_1_) {
        if (this.method_16478() == null) {
            if (this.field_5974.method_43057() < 0.5f) {
                this.inventory.method_5491(new class_1799((class_1935)class_1802.field_8389, 2 + this.field_5974.method_43048(2)));
            } else {
                this.inventory.method_5491(new class_1799((class_1935)class_1802.field_8046, 2 + this.field_5974.method_43048(2)));
            }
            if (this.field_5974.method_43057() < 0.5f) {
                this.method_5673(class_1304.field_6173, new class_1799((class_1935)class_1802.field_8102));
            } else {
                this.method_5673(class_1304.field_6173, new class_1799((class_1935)class_1802.field_8091));
                if (this.field_5974.method_43056()) {
                    class_1799 offHandStack = new class_1799((class_1935)HunterItems.BOOMERANG);
                    HashMap map3 = Maps.newHashMap();
                    map3.put(class_1893.field_9120, 1);
                    class_1890.method_8214((Map)map3, (class_1799)offHandStack);
                    this.method_6122(class_1268.field_5810, offHandStack);
                }
            }
        }
    }

    public boolean method_5722(class_1297 p_184191_1_) {
        if (super.method_5722(p_184191_1_)) {
            return true;
        }
        if (p_184191_1_ instanceof class_1309 && ((class_1309)p_184191_1_).method_6046() == class_1310.field_6291) {
            return this.method_5781() == null && p_184191_1_.method_5781() == null;
        }
        return false;
    }

    public class_3414 method_20033() {
        return HunterSounds.HUNTER_ILLAGER_CHEER;
    }

    protected class_3414 method_5994() {
        return HunterSounds.HUNTER_ILLAGER_IDLE;
    }

    protected class_3414 method_6002() {
        return HunterSounds.HUNTER_ILLAGER_DEATH;
    }

    protected class_3414 method_6011(class_1282 p_184601_1_) {
        return HunterSounds.HUNTER_ILLAGER_HURT;
    }

    public class_1543.class_1544 method_6990() {
        if (this.method_6510()) {
            return this.method_24518(class_1802.field_8102) || this.method_24518(HunterItems.BOOMERANG) ? class_1543.class_1544.field_7208 : class_1543.class_1544.field_7211;
        }
        return this.method_20034() ? class_1543.class_1544.field_19012 : class_1543.class_1544.field_7207;
    }

    public boolean method_5874(class_3218 p_216988_, class_1309 p_216989_) {
        this.method_5783(HunterSounds.HUNTER_ILLAGER_LAUGH, this.method_6107(), this.method_6017());
        this.cooldown = 300;
        return super.method_5874(p_216988_, p_216989_);
    }

    public void setHomeTarget(@Nullable class_2338 p_213726_1_) {
        this.homeTarget = p_213726_1_;
    }

    @Nullable
    private class_2338 getHomeTarget() {
        return this.homeTarget;
    }

    public void method_7105(class_1309 livingEntity, float f) {
        class_1799 itemStack = this.method_18808(this.method_5998(class_1675.method_18812((class_1309)this, (class_1792)class_1802.field_8102)));
        class_1665 abstractArrow = class_1675.method_18813((class_1309)this, (class_1799)itemStack, (float)f);
        double d = livingEntity.method_23317() - this.method_23317();
        double e = livingEntity.method_23323(0.3333333333333333) - abstractArrow.method_23318();
        double g = livingEntity.method_23321() - this.method_23321();
        double h = Math.sqrt(d * d + g * g);
        abstractArrow.method_7485(d, e + h * (double)0.2f, g, 1.6f, (float)(14 - this.field_6002.method_8407().method_5461() * 4));
        this.method_5783(class_3417.field_14633, 1.0f, 1.0f / (this.method_6051().method_43057() * 0.4f + 0.8f));
        this.field_6002.method_8649((class_1297)abstractArrow);
    }

    protected class_1665 getArrow(class_1799 p_32156_, float p_32157_) {
        return class_1675.method_18813((class_1309)this, (class_1799)p_32156_, (float)p_32157_);
    }

    public void performBoomeranAttack(class_1309 p_82196_1_, float p_82196_2_) {
        BoomerangEntity boomerang = new BoomerangEntity(this.field_6002, (class_1309)this, this.method_6079().method_7971(1));
        double d0 = p_82196_1_.method_23317() - this.method_23317();
        double d1 = p_82196_1_.method_23323(0.3333333333333333) - boomerang.method_23318();
        double d2 = p_82196_1_.method_23321() - this.method_23321();
        double d3 = class_3532.method_15355((float)((float)(d0 * d0 + d2 * d2)));
        boomerang.method_7485(d0, d1 + d3 * (double)0.2f, d2, 1.6f, 14 - this.field_6002.method_8407().method_5461() * 4);
        this.method_5783(class_3417.field_14633, 1.0f, 1.0f / (this.method_6051().method_43057() * 0.4f + 0.8f));
        this.field_6002.method_8649((class_1297)boomerang);
    }

    class MoveToGoal
    extends class_1352 {
        final Hunter hunter;
        final double stopDistance;
        final double speedModifier;

        MoveToGoal(Hunter p_i50459_2_, double p_i50459_3_, double p_i50459_5_) {
            this.hunter = p_i50459_2_;
            this.stopDistance = p_i50459_3_;
            this.speedModifier = p_i50459_5_;
            this.method_6265(EnumSet.of(class_1352.class_4134.field_18405));
        }

        public void method_6270() {
            Hunter.this.field_6189.method_6340();
        }

        public boolean method_6264() {
            class_2338 blockpos = this.hunter.getHomeTarget();
            double distance = this.hunter.field_6002.method_8530() ? this.stopDistance : this.stopDistance / 3.0;
            return blockpos != null && this.isTooFarAway(blockpos, distance);
        }

        public void method_6268() {
            class_2338 blockpos = this.hunter.getHomeTarget();
            if (blockpos != null && Hunter.this.field_6189.method_6357()) {
                if (this.isTooFarAway(blockpos, 10.0)) {
                    class_243 vector3d = new class_243((double)blockpos.method_10263() - this.hunter.method_23317(), (double)blockpos.method_10264() - this.hunter.method_23318(), (double)blockpos.method_10260() - this.hunter.method_23321()).method_1029();
                    class_243 vector3d1 = vector3d.method_1021(10.0).method_1031(this.hunter.method_23317(), this.hunter.method_23318(), this.hunter.method_23321());
                    Hunter.this.field_6189.method_6337(vector3d1.field_1352, vector3d1.field_1351, vector3d1.field_1350, this.speedModifier);
                } else {
                    Hunter.this.field_6189.method_6337((double)blockpos.method_10263(), (double)blockpos.method_10264(), (double)blockpos.method_10260(), this.speedModifier);
                }
            }
        }

        private boolean isTooFarAway(class_2338 p_220846_1_, double p_220846_2_) {
            return !p_220846_1_.method_19771((class_2382)this.hunter.method_24515(), p_220846_2_);
        }
    }

    public static class GetFoodGoal<T extends Hunter>
    extends class_1352 {
        private final T mob;
        final /* synthetic */ Hunter this$0;

        public GetFoodGoal(T p_i50572_2_) {
            this.this$0 = this$0;
            this.mob = p_i50572_2_;
            this.method_6265(EnumSet.of(class_1352.class_4134.field_18405));
        }

        public boolean method_6264() {
            if (!this.mob.method_16482()) {
                List list = ((Hunter)((Object)this.mob)).field_6002.method_8390(class_1542.class, this.mob.method_5829().method_1009(16.0, 8.0, 16.0), ALLOWED_ITEMS);
                if (!list.isEmpty() && this.mob.method_6057((class_1297)list.get(0))) {
                    return this.mob.method_5942().method_6335((class_1297)list.get(0), (double)1.1f);
                }
                return false;
            }
            return false;
        }

        public void method_6268() {
            List list;
            if (this.mob.method_5942().method_6355().method_19771((class_2382)this.mob.method_24515(), 1.414) && !(list = ((Hunter)((Object)this.mob)).field_6002.method_8390(class_1542.class, this.mob.method_5829().method_1009(4.0, 4.0, 4.0), ALLOWED_ITEMS)).isEmpty()) {
                ((Hunter)((Object)this.mob)).method_5949((class_1542)list.get(0));
            }
        }
    }
}

