/*
 * Decompiled with CFR 0.152.
 */
package baguchan.hunterillager.entity.projectile;

import baguchan.hunterillager.entity.Hunter;
import baguchan.hunterillager.init.HunterDamageSource;
import baguchan.hunterillager.init.HunterEntityRegistry;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1887;
import net.minecraft.class_1890;
import net.minecraft.class_1893;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2498;
import net.minecraft.class_2520;
import net.minecraft.class_2680;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3486;
import net.minecraft.class_3532;
import net.minecraft.class_3857;
import net.minecraft.class_3959;
import net.minecraft.class_3965;
import net.minecraft.class_3966;

public class BoomerangEntity
extends class_3857 {
    private static final class_2940<Byte> LOYALTY_LEVEL = class_2945.method_12791(BoomerangEntity.class, (class_2941)class_2943.field_13319);
    private static final class_2940<Byte> PIERCING_LEVEL = class_2945.method_12791(BoomerangEntity.class, (class_2941)class_2943.field_13319);
    private static final class_2940<Byte> BOUNCE_LEVEL = class_2945.method_12791(BoomerangEntity.class, (class_2941)class_2943.field_13319);
    private static final class_2940<Boolean> RETURNING = class_2945.method_12791(BoomerangEntity.class, (class_2941)class_2943.field_13323);
    private static final class_2940<class_1799> BOOMERANG = class_2945.method_12791(BoomerangEntity.class, (class_2941)class_2943.field_13322);
    private int totalHits;
    private int flyTick;

    public BoomerangEntity(class_1299<? extends BoomerangEntity> entityEntityType, class_1937 world) {
        super(entityEntityType, world);
    }

    public BoomerangEntity(class_1299<? extends BoomerangEntity> type, class_1937 world, class_1309 shootingEntity, class_1799 boomerang) {
        super(type, shootingEntity, world);
        this.method_7432((class_1297)shootingEntity);
        this.setBoomerang(boomerang);
        this.field_6011.method_12778(LOYALTY_LEVEL, (Object)((byte)class_1890.method_8206((class_1799)boomerang)));
        this.field_6011.method_12778(PIERCING_LEVEL, (Object)((byte)class_1890.method_8225((class_1887)class_1893.field_9132, (class_1799)boomerang)));
        this.totalHits = 0;
    }

    public BoomerangEntity(class_1937 world, class_1309 entity, class_1799 boomerang) {
        this(HunterEntityRegistry.BOOMERANG, world, entity, boomerang);
    }

    private void onHitFluid(class_3965 result) {
        double velocity = this.getVelocity();
        double horizontal = this.method_18798().field_1351 * this.method_18798().field_1351;
        if (result.method_17783() == class_239.class_240.field_1332 && result.method_17781() && velocity >= (double)0.65f && horizontal < (double)0.175f && !this.field_6002.method_8320(result.method_17777()).method_26215() && this.field_6002.method_8316(result.method_17777()).method_15767(class_3486.field_15517)) {
            this.method_18800(this.method_18798().field_1352, class_3532.method_15350((double)(this.method_18798().field_1351 + (double)0.1f), (double)-0.1f, (double)0.3f), this.method_18798().field_1350);
            this.field_6007 = true;
        }
    }

    protected void method_7454(class_3966 result) {
        class_1297 shooter;
        super.method_7454(result);
        boolean returnToOwner = false;
        byte loyaltyLevel = (Byte)this.field_6011.method_12789(LOYALTY_LEVEL);
        byte piercingLevel = (Byte)this.field_6011.method_12789(PIERCING_LEVEL);
        class_1297 entity = this.method_24921();
        if (!(result.method_17782() == this.method_24921() || this.isReturning() && loyaltyLevel > 0)) {
            shooter = this.method_24921();
            int sharpness = class_1890.method_8225((class_1887)class_1893.field_9118, (class_1799)this.getBoomerang());
            int damage = (int)(3.0 * Math.sqrt(this.method_18798().field_1352 * this.method_18798().field_1352 + this.method_18798().field_1351 * this.method_18798().field_1351 * 0.5 + this.method_18798().field_1350 * this.method_18798().field_1350) + (double)Math.min(1, sharpness) + (double)Math.max(0, sharpness - 1) * 0.5 + (double)(0.5f * (float)piercingLevel));
            if (damage != 0) {
                result.method_17782().method_5643(HunterDamageSource.boomerangAttack((class_1297)this, shooter), (float)damage);
            }
            if (shooter instanceof class_1309) {
                this.getBoomerang().method_7956(1, (class_1309)shooter, p_222182_1_ -> {});
            }
            double speed = this.getSpeed();
            if (piercingLevel < 1 && this.totalHits >= this.getBounceLevel() || this.totalHits >= piercingLevel + this.getBounceLevel() && speed > (double)0.4f) {
                returnToOwner = true;
            } else if (piercingLevel < 1 && this.totalHits < this.getBounceLevel() || this.totalHits < piercingLevel + this.getBounceLevel() && speed <= (double)0.4f) {
                class_243 motion = this.method_18798();
                double motionX = motion.field_1352;
                double motionY = motion.field_1351;
                double motionZ = motion.field_1350;
                motionX = -motionX;
                motionZ = -motionZ;
                this.method_18800(motionX, motionY, motionZ);
            }
            ++this.totalHits;
        }
        if (returnToOwner && !this.isReturning()) {
            if (this.method_24921() != null && this.shouldReturnToThrower() && class_1890.method_8225((class_1887)class_1893.field_9120, (class_1799)this.getBoomerang()) > 0) {
                shooter = this.method_24921();
                this.field_6002.method_8396(null, shooter.method_24515(), class_3417.field_14698, class_3419.field_15248, 1.0f, 1.0f);
                class_243 motion = this.method_18798();
                double motionX = motion.field_1352;
                double motionY = motion.field_1351;
                double motionZ = motion.field_1350;
                motionX = -motionX;
                motionZ = -motionZ;
                this.method_18800(motionX, motionY, motionZ);
                if (loyaltyLevel > 0 && !this.isReturning() && entity != null) {
                    this.field_6002.method_8396(null, entity.method_24515(), class_3417.field_14698, class_3419.field_15248, 1.0f, 1.0f);
                    this.setReturning(true);
                }
            } else {
                class_243 motion = this.method_18798();
                double motionX = motion.field_1352;
                double motionY = motion.field_1351;
                double motionZ = motion.field_1350;
                motionX = -motionX;
                motionZ = -motionZ;
                this.method_18800(motionX, motionY, motionZ);
                if (loyaltyLevel > 0 && !this.isReturning() && entity != null) {
                    this.field_6002.method_8396(null, entity.method_24515(), class_3417.field_14698, class_3419.field_15248, 1.0f, 1.0f);
                    this.setReturning(true);
                }
            }
        }
    }

    protected void method_24920(class_3965 result) {
        super.method_24920(result);
        class_2338 pos = result.method_17777();
        class_2680 state = this.field_6002.method_8320(pos);
        class_2498 soundType = state.method_26231();
        if (!this.isReturning()) {
            this.field_6002.method_43128(null, this.method_23317(), this.method_23318(), this.method_23321(), soundType.method_10596(), class_3419.field_15245, soundType.method_10597() * 0.45f, soundType.method_10599());
        }
        ++this.totalHits;
        class_2680 blockstate = this.field_6002.method_8320(result.method_17777());
        byte loyaltyLevel = (Byte)this.field_6011.method_12789(LOYALTY_LEVEL);
        byte piercingLevel = (Byte)this.field_6011.method_12789(PIERCING_LEVEL);
        class_1297 entity = this.method_24921();
        if (!this.isReturning() && !blockstate.method_26220((class_1922)this.field_6002, result.method_17777()).method_1110()) {
            class_2350 face = result.method_17780();
            class_243 motion = this.method_18798();
            double motionX = motion.field_1352;
            double motionY = motion.field_1351;
            double motionZ = motion.field_1350;
            if (face == class_2350.field_11034) {
                motionX = -motionX;
            } else if (face == class_2350.field_11035) {
                motionZ = -motionZ;
            } else if (face == class_2350.field_11039) {
                motionX = -motionX;
            } else if (face == class_2350.field_11043) {
                motionZ = -motionZ;
            } else if (face == class_2350.field_11036) {
                motionY = -motionY;
            } else if (face == class_2350.field_11033) {
                motionY = -motionY;
            }
            this.method_18800(motionX, motionY, motionZ);
            if (loyaltyLevel > 0 && !this.isReturning() && this.totalHits >= this.getBounceLevel() && entity != null) {
                this.field_6002.method_8396(null, entity.method_24515(), class_3417.field_14698, class_3419.field_15248, 1.0f, 1.0f);
                this.setReturning(true);
            }
        }
        this.method_5852();
    }

    protected void method_7488(class_239 result) {
        super.method_7488(result);
        byte loyaltyLevel = (Byte)this.field_6011.method_12789(LOYALTY_LEVEL);
        if (loyaltyLevel < 1 && this.totalHits >= this.getBounceLevel()) {
            this.drop(this.method_23317(), this.method_23318(), this.method_23321());
        }
    }

    public int getFlyTick() {
        return this.flyTick;
    }

    private boolean shouldReturnToThrower() {
        class_1297 entity = this.method_24921();
        if (entity != null && entity.method_5805()) {
            return !(entity instanceof class_1657) || !entity.method_7325() || entity instanceof Hunter;
        }
        return false;
    }

    public void method_5694(class_1657 entityIn) {
        super.method_5694(entityIn);
        if (this.flyTick >= 6 && entityIn == this.method_24921()) {
            this.drop(this.method_24921().method_23317(), this.method_24921().method_23318(), this.method_24921().method_23321());
        }
    }

    public void drop(double x, double y, double z) {
        if (this.method_24921() instanceof Hunter || this.method_24921() instanceof class_1657 && !((class_1657)this.method_24921()).method_7337()) {
            this.field_6002.method_8649((class_1297)new class_1542(this.field_6002, x, y, z, this.getBoomerang().method_7971(1)));
            this.method_31472();
        } else {
            this.method_31472();
        }
    }

    public void method_5773() {
        super.method_5773();
        class_243 vec3 = this.method_18798();
        if (this.field_6004 == 0.0f && this.field_5982 == 0.0f) {
            double d0 = vec3.method_37267();
            this.method_36456((float)(class_3532.method_15349((double)vec3.field_1352, (double)vec3.field_1350) * 57.2957763671875));
            this.method_36457((float)(class_3532.method_15349((double)vec3.field_1351, (double)d0) * 57.2957763671875));
            this.field_5982 = this.method_36454();
            this.field_6004 = this.method_36455();
        }
        ++this.flyTick;
        class_243 vec3d1 = this.method_19538();
        class_243 vec3d2 = new class_243(this.method_23317() + this.method_18798().field_1352, this.method_23318() + this.method_18798().field_1351, this.method_23321() + this.method_18798().field_1350);
        class_3965 fluidHitResult = this.field_6002.method_17742(new class_3959(vec3d1, vec3d2, class_3959.class_3960.field_17558, class_3959.class_242.field_1347, (class_1297)this));
        this.onHitFluid(fluidHitResult);
        double moveX = vec3.field_1352;
        double moveY = vec3.field_1351;
        double moveZ = vec3.field_1350;
        double d4 = vec3.method_37267();
        this.method_36456((float)(class_3532.method_15349((double)moveX, (double)moveZ) * 57.2957763671875));
        this.method_36457((float)(class_3532.method_15349((double)moveY, (double)d4) * 57.2957763671875));
        this.method_36457(BoomerangEntity.method_26960((float)this.field_6004, (float)this.method_36455()));
        this.method_36456(BoomerangEntity.method_26960((float)this.field_5982, (float)this.method_36454()));
        byte loyaltyLevel = (Byte)this.field_6011.method_12789(LOYALTY_LEVEL);
        class_1297 entity = this.method_24921();
        if (loyaltyLevel > 0 && !this.isReturning()) {
            if (this.flyTick >= 80 && entity != null) {
                this.field_6002.method_8396(null, entity.method_24515(), class_3417.field_14698, class_3419.field_15248, 1.0f, 1.0f);
                this.setReturning(true);
            }
            if (this.flyTick < 80) {
                this.method_18799(vec3.method_1021((double)1.01f));
            }
        }
        if (loyaltyLevel > 0 && entity != null && !this.shouldReturnToThrower() && this.isReturning()) {
            this.drop(this.method_23317(), this.method_23318(), this.method_23321());
        } else if (loyaltyLevel > 0 && entity != null && this.isReturning()) {
            this.field_5960 = true;
            class_243 vec3d3 = new class_243(entity.method_23317() - this.method_23317(), entity.method_23320() - this.method_23318(), entity.method_23321() - this.method_23321());
            double d0 = 0.05 * (double)loyaltyLevel;
            this.method_18799(this.method_18798().method_1021(0.95).method_1019(vec3d3.method_1029().method_1021(d0)));
        }
        this.method_5852();
    }

    protected float method_7490() {
        if (this.getLoyaltyLevel() > 0 && !this.isReturning()) {
            if (this.method_5799()) {
                return 0.01f;
            }
            return 0.0f;
        }
        return this.getLoyaltyLevel() > 0 && this.isReturning() ? 0.0f : 0.03f;
    }

    public boolean method_5640(double p_70112_1_) {
        double d0 = this.method_5829().method_995() * 5.0;
        if (Double.isNaN(d0)) {
            d0 = 1.0;
        }
        return p_70112_1_ < (d0 *= 64.0) * d0;
    }

    protected class_1792 method_16942() {
        return this.getBoomerang().method_7909();
    }

    protected void method_5693() {
        super.method_5693();
        this.field_6011.method_12784(LOYALTY_LEVEL, (Object)0);
        this.field_6011.method_12784(PIERCING_LEVEL, (Object)0);
        this.field_6011.method_12784(BOUNCE_LEVEL, (Object)0);
        this.field_6011.method_12784(RETURNING, (Object)false);
        this.field_6011.method_12784(BOOMERANG, (Object)class_1799.field_8037);
    }

    public void method_5652(class_2487 nbt) {
        super.method_5652(nbt);
        nbt.method_10566("boomerang", (class_2520)this.getBoomerang().method_7953(new class_2487()));
        nbt.method_10569("totalHits", this.totalHits);
        nbt.method_10556("returning", this.isReturning());
    }

    public void method_5749(class_2487 nbt) {
        super.method_5749(nbt);
        this.setBoomerang(class_1799.method_7915((class_2487)nbt.method_10562("boomerang")));
        this.totalHits = nbt.method_10550("totalHits");
        this.setReturning(nbt.method_10577("returning"));
        this.field_6011.method_12778(LOYALTY_LEVEL, (Object)((byte)class_1890.method_8206((class_1799)this.getBoomerang())));
        this.field_6011.method_12778(PIERCING_LEVEL, (Object)((byte)class_1890.method_8225((class_1887)class_1893.field_9132, (class_1799)this.getBoomerang())));
    }

    private int getLoyaltyLevel() {
        return ((Byte)this.field_6011.method_12789(LOYALTY_LEVEL)).byteValue();
    }

    private int getBounceLevel() {
        byte loyaltyLevel = (Byte)this.field_6011.method_12789(LOYALTY_LEVEL);
        byte bounceLevel = (Byte)this.field_6011.method_12789(BOUNCE_LEVEL);
        if (loyaltyLevel > 0) {
            return 0 + bounceLevel * 8;
        }
        return 8 + bounceLevel * 8;
    }

    public boolean isReturning() {
        return (Boolean)this.field_6011.method_12789(RETURNING);
    }

    public class_1799 getBoomerang() {
        return (class_1799)this.field_6011.method_12789(BOOMERANG);
    }

    public double getSpeed() {
        return Math.sqrt(this.method_18798().field_1352 * this.method_18798().field_1352 + this.method_18798().field_1351 * this.method_18798().field_1351 + this.method_18798().field_1350 * this.method_18798().field_1350);
    }

    public double getVelocity() {
        return Math.sqrt(this.method_18798().field_1352 * this.method_18798().field_1352 + this.method_18798().field_1350 * this.method_18798().field_1350);
    }

    public int getPiercingLevel() {
        return ((Byte)this.field_6011.method_12789(PIERCING_LEVEL)).byteValue();
    }

    public void setReturning(boolean returning) {
        this.field_6011.method_12778(RETURNING, (Object)returning);
    }

    public void setBoomerang(class_1799 stack) {
        this.field_6011.method_12778(BOOMERANG, (Object)stack);
    }
}

