/*
 * Decompiled with CFR 0.152.
 */
package baguchan.hunterillager.mixin;

import baguchan.hunterillager.item.QuiverItem;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ArrowItem;
import net.minecraft.item.CrossbowItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.ShootableItem;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.ActionResult;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.world.World;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={CrossbowItem.class})
public abstract class MixinCrossBowItem
extends ShootableItem {
    @Shadow
    private boolean field_220034_c = false;
    @Shadow
    private boolean field_220035_d = false;

    public MixinCrossBowItem(Item.Properties builder) {
        super(builder);
    }

    @Inject(method={"onPlayerStoppedUsing"}, at={@At(value="HEAD")}, cancellable=true)
    public void onPlayerStoppedUsing(ItemStack stack, World worldIn, LivingEntity entityLiving, int timeLeft, CallbackInfo callbackInfo) {
        int i = this.func_77626_a(stack) - timeLeft;
        float f = MixinCrossBowItem.getCharge(i, stack);
        if (f >= 1.0f && !CrossbowItem.func_220012_d((ItemStack)stack) && MixinCrossBowItem.hasAmmo(entityLiving, stack)) {
            CrossbowItem.func_220011_a((ItemStack)stack, (boolean)true);
            SoundCategory soundcategory = entityLiving instanceof PlayerEntity ? SoundCategory.PLAYERS : SoundCategory.HOSTILE;
            worldIn.func_184148_a((PlayerEntity)null, entityLiving.func_226277_ct_(), entityLiving.func_226278_cu_(), entityLiving.func_226281_cx_(), SoundEvents.field_219610_bB, soundcategory, 1.0f, 1.0f / (field_77697_d.nextFloat() * 0.5f + 1.0f) + 0.2f);
            callbackInfo.cancel();
        }
    }

    @Inject(method={"onItemRightClick"}, at={@At(value="HEAD")}, cancellable=true)
    public void onItemRightClick(World worldIn, PlayerEntity playerIn, Hand handIn, CallbackInfoReturnable<ActionResult<ItemStack>> callbackInfo) {
        ItemStack itemstack = playerIn.func_184586_b(handIn);
        if (CrossbowItem.func_220012_d((ItemStack)itemstack)) {
            CrossbowItem.func_220014_a((World)worldIn, (LivingEntity)playerIn, (Hand)handIn, (ItemStack)itemstack, (float)MixinCrossBowItem.func_220013_l(itemstack), (float)1.0f);
            CrossbowItem.func_220011_a((ItemStack)itemstack, (boolean)false);
            callbackInfo.setReturnValue((Object)ActionResult.func_226249_b_((Object)itemstack));
        } else if (!playerIn.func_213356_f(itemstack).func_190926_b()) {
            ItemStack ammo = playerIn.func_213356_f(itemstack);
            if ((!(ammo.func_77973_b() instanceof QuiverItem) || ammo.func_77973_b() instanceof QuiverItem && ((QuiverItem)ammo.func_77973_b()).hasArrow(ammo, playerIn)) && !CrossbowItem.func_220012_d((ItemStack)itemstack)) {
                this.field_220034_c = false;
                this.field_220035_d = false;
                playerIn.func_184598_c(handIn);
            }
            callbackInfo.setReturnValue((Object)ActionResult.func_226249_b_((Object)itemstack));
        } else {
            callbackInfo.setReturnValue((Object)ActionResult.func_226251_d_((Object)itemstack));
        }
    }

    @Shadow
    private static float func_220013_l(ItemStack p_220013_0_) {
        return 0.0f;
    }

    private static boolean hasAmmo(LivingEntity entityIn, ItemStack stack) {
        int i = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_222192_G, (ItemStack)stack);
        int j = i == 0 ? 1 : 3;
        boolean flag = entityIn instanceof PlayerEntity && ((PlayerEntity)entityIn).field_71075_bZ.field_75098_d;
        ItemStack itemstack = entityIn.func_213356_f(stack);
        ItemStack itemstack1 = itemstack.func_77946_l();
        for (int k = 0; k < j; ++k) {
            if (k > 0) {
                itemstack = itemstack1.func_77946_l();
            }
            if (itemstack.func_190926_b() && flag) {
                itemstack = new ItemStack((IItemProvider)Items.field_151032_g);
                itemstack1 = itemstack.func_77946_l();
            }
            if (MixinCrossBowItem.func_220023_a(entityIn, stack, itemstack, k > 0, flag)) continue;
            return false;
        }
        return true;
    }

    private static boolean func_220023_a(LivingEntity p_220023_0_, ItemStack stack, ItemStack p_220023_2_, boolean p_220023_3_, boolean p_220023_4_) {
        ItemStack itemstack;
        boolean flag;
        if (p_220023_2_.func_190926_b()) {
            return false;
        }
        boolean bl = flag = p_220023_4_ && p_220023_2_.func_77973_b() instanceof ArrowItem;
        if (!(flag || p_220023_4_ || p_220023_3_)) {
            if (p_220023_2_.func_77973_b() instanceof QuiverItem) {
                itemstack = QuiverItem.getProjectileFromQuivers(p_220023_2_).func_77946_l();
                QuiverItem.consumeProjectiles(p_220023_2_);
            } else {
                itemstack = p_220023_2_.func_77979_a(1);
                if (p_220023_2_.func_190926_b() && p_220023_0_ instanceof PlayerEntity) {
                    ((PlayerEntity)p_220023_0_).field_71071_by.func_184437_d(p_220023_2_);
                }
            }
        } else {
            itemstack = p_220023_2_.func_77946_l();
        }
        MixinCrossBowItem.addChargedProjectile(stack, itemstack);
        return true;
    }

    private static void addChargedProjectile(ItemStack crossbow, ItemStack projectile) {
        CompoundNBT compoundnbt = crossbow.func_196082_o();
        ListNBT listnbt = compoundnbt.func_150297_b("ChargedProjectiles", 9) ? compoundnbt.func_150295_c("ChargedProjectiles", 10) : new ListNBT();
        CompoundNBT compoundnbt1 = new CompoundNBT();
        projectile.func_77955_b(compoundnbt1);
        listnbt.add((Object)compoundnbt1);
        compoundnbt.func_218657_a("ChargedProjectiles", (INBT)listnbt);
    }

    private static float getCharge(int useTime, ItemStack stack) {
        float f = (float)useTime / (float)CrossbowItem.func_220026_e((ItemStack)stack);
        if (f > 1.0f) {
            f = 1.0f;
        }
        return f;
    }
}

