/*
 * Decompiled with CFR 0.152.
 */
package baguchan.hunters_return.entity;

import bagu_chan.bagus_lib.entity.goal.AnimatedAttackGoal;
import baguchan.hunters_return.HunterConfig;
import baguchan.hunters_return.entity.ai.BoomeranAttackGoal;
import baguchan.hunters_return.entity.ai.CallAllyGoal;
import baguchan.hunters_return.entity.ai.DoSleepingGoal;
import baguchan.hunters_return.entity.ai.DodgeGoal;
import baguchan.hunters_return.entity.ai.DodgeMoveControl;
import baguchan.hunters_return.entity.ai.SleepOnBedGoal;
import baguchan.hunters_return.entity.ai.WakeUpGoal;
import baguchan.hunters_return.entity.projectile.BoomerangEntity;
import baguchan.hunters_return.init.HunterItems;
import baguchan.hunters_return.init.HunterSounds;
import baguchan.hunters_return.utils.HunterConfigUtils;
import com.google.common.collect.Maps;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.InteractGoal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.OpenDoorGoal;
import net.minecraft.world.entity.ai.goal.RangedBowAttackGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.animal.goat.Goat;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.AbstractIllager;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.entity.raid.Raid;
import net.minecraft.world.entity.raid.Raider;
import net.minecraft.world.item.BannerItem;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.InstrumentItem;
import net.minecraft.world.item.Instruments;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.registries.ForgeRegistries;

public class Hunter
extends AbstractIllager
implements RangedAttackMob {
    public static final Predicate<LivingEntity> TARGET_ENTITY_SELECTOR = p_213616_0_ -> !p_213616_0_.m_6162_() && HunterConfigUtils.isWhitelistedEntity(p_213616_0_.m_6095_());
    private static final Predicate<? super ItemEntity> ALLOWED_ITEMS = p_213616_0_ -> p_213616_0_.m_32055_().m_41720_().m_41473_() != null && HunterConfigUtils.isWhitelistedItem(p_213616_0_.m_32055_().m_41720_());
    private final SimpleContainer inventory = new SimpleContainer(5);
    @Nullable
    private BlockPos homeTarget;
    private int cooldown;
    private final int attackAnimationLength = 20;
    private final int shootAnimationLength = 20;
    private final int attackAnimationActionPoint = 8;
    private int attackAnimationTick;
    private int shootAnimationTick;
    private int thrownAnimationTick;
    public final AnimationState attackAnimationState = new AnimationState();
    public final AnimationState shootAnimationState = new AnimationState();
    public final AnimationState chargeAnimationState = new AnimationState();
    public final AnimationState thrownAnimationState = new AnimationState();

    public Hunter(EntityType<? extends Hunter> p_i48556_1_, Level p_i48556_2_) {
        super(p_i48556_1_, p_i48556_2_);
        ((GroundPathNavigation)this.m_21573_()).m_26477_(true);
        this.f_21342_ = new DodgeMoveControl((Mob)this);
        this.m_21553_(true);
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(0, (Goal)new WakeUpGoal((PathfinderMob)this));
        this.f_21345_.m_25352_(0, (Goal)new DoSleepingGoal((PathfinderMob)this));
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(0, (Goal)new CallAllyGoal(this));
        this.f_21345_.m_25352_(0, (Goal)new DodgeGoal(this, Projectile.class));
        this.f_21345_.m_25352_(1, (Goal)new OpenDoorGoal((Mob)this, true));
        this.f_21345_.m_25352_(2, (Goal)new AbstractIllager.RaiderOpenDoorGoal((AbstractIllager)this, (Raider)this));
        this.f_21345_.m_25352_(3, (Goal)new Raider.HoldGroundAttackGoal((Raider)this, (AbstractIllager)this, 10.0f));
        this.f_21345_.m_25352_(4, (Goal)new RangedBowAttackGoal((Monster)this, (double)1.1f, 50, 16.0f));
        this.f_21345_.m_25352_(4, (Goal)new BoomeranAttackGoal(this, 50, 16.0f));
        this.f_21345_.m_25352_(4, (Goal)new AnimatedAttackGoal((PathfinderMob)this, 1.15f, 12, 20){

            public boolean m_8036_() {
                return !this.f_25540_.m_21093_(item -> item.m_41720_() instanceof BowItem) && super.m_8036_();
            }

            public boolean m_8045_() {
                return !this.f_25540_.m_21093_(item -> item.m_41720_() instanceof BowItem) && super.m_8045_();
            }
        });
        this.f_21345_.m_25352_(5, (Goal)new SleepOnBedGoal((PathfinderMob)this, 1.0, 12));
        this.f_21345_.m_25352_(6, (Goal)new GetFoodGoal(this, this));
        this.f_21345_.m_25352_(7, (Goal)new MoveToGoal(this, 45.0, 1.2));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[]{Raider.class}).m_26044_(new Class[]{AbstractIllager.class}));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, AbstractVillager.class, true));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, IronGolem.class, true));
        this.f_21346_.m_25352_(4, (Goal)new NearestAttackableTargetGoal((Mob)this, Goat.class, true));
        this.f_21346_.m_25352_(5, (Goal)new NearestAttackableTargetGoal((Mob)this, Animal.class, 10, true, false, TARGET_ENTITY_SELECTOR){

            public boolean m_8036_() {
                return Hunter.this.cooldown <= 0 && super.m_8036_();
            }
        });
        this.f_21345_.m_25352_(8, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 0.8));
        this.f_21345_.m_25352_(9, (Goal)new InteractGoal((Mob)this, Player.class, 3.0f, 1.0f));
        this.f_21345_.m_25352_(10, (Goal)new LookAtPlayerGoal((Mob)this, Mob.class, 8.0f));
    }

    /*
     * Enabled aggressive block sorting
     */
    public void m_6075_() {
        super.m_6075_();
        if (!this.m_9236_().f_46443_) return;
        Objects.requireNonNull(this);
        if (this.attackAnimationTick < 20) {
            ++this.attackAnimationTick;
            if (this.thrownAnimationState.m_216984_()) {
                this.thrownAnimationState.m_216973_();
            }
        }
        Objects.requireNonNull(this);
        if (this.attackAnimationTick >= 20) {
            this.attackAnimationState.m_216973_();
        }
        Objects.requireNonNull(this);
        if (this.shootAnimationTick < 20) {
            ++this.shootAnimationTick;
        }
        Objects.requireNonNull(this);
        if (this.shootAnimationTick >= 20) {
            this.shootAnimationState.m_216973_();
        }
        Objects.requireNonNull(this);
        if (this.thrownAnimationTick < 20) {
            ++this.thrownAnimationTick;
        }
        Objects.requireNonNull(this);
        if (this.thrownAnimationTick >= 20) {
            this.thrownAnimationState.m_216973_();
        }
        if (this.m_21055_(Items.f_42411_) && this.m_5912_()) {
            Objects.requireNonNull(this);
            if (this.shootAnimationTick >= 20) {
                if (this.chargeAnimationState.m_216984_()) return;
                this.chargeAnimationState.m_216977_(this.f_19797_);
                return;
            }
        }
        this.chargeAnimationState.m_216973_();
    }

    public void m_7822_(byte p_219360_) {
        if (p_219360_ == 4) {
            this.attackAnimationTick = 0;
            this.attackAnimationState.m_216977_(this.f_19797_);
        } else if (p_219360_ == 61) {
            this.shootAnimationTick = 0;
            this.shootAnimationState.m_216977_(this.f_19797_);
        } else if (p_219360_ == 62) {
            this.thrownAnimationTick = 0;
            this.thrownAnimationState.m_216977_(this.f_19797_);
        } else {
            super.m_7822_(p_219360_);
        }
    }

    public ItemStack m_5584_(Level p_21067_, ItemStack p_21068_) {
        if (p_21068_.m_41614_()) {
            this.m_5634_(p_21068_.m_41720_().m_41473_().m_38744_());
        }
        return super.m_5584_(p_21067_, p_21068_);
    }

    public void m_8107_() {
        if (!this.m_9236_().f_46443_ && this.m_6084_()) {
            ItemStack mainhand = this.m_21120_(InteractionHand.MAIN_HAND);
            if (!this.m_6117_() && this.m_21206_().m_41619_() && (mainhand.m_41720_() == Items.f_42411_ && this.m_5448_() == null || mainhand.m_41720_() != Items.f_42411_)) {
                ItemStack stack = ItemStack.f_41583_;
                if (this.m_21223_() < this.m_21233_() && this.f_19796_.m_188501_() < 0.005f) {
                    stack = this.findFood();
                } else if (this.m_21223_() >= this.m_21233_() && this.f_19796_.m_188501_() < 0.01f) {
                    stack = this.findBoomerang();
                }
                if (!stack.m_41619_()) {
                    this.m_8061_(EquipmentSlot.OFFHAND, stack);
                    if (stack.m_41614_()) {
                        this.m_6672_(InteractionHand.OFF_HAND);
                    }
                }
            }
        }
        super.m_8107_();
    }

    private ItemStack findFood() {
        for (int i = 0; i < this.inventory.m_6643_(); ++i) {
            ItemStack itemstack = this.inventory.m_8020_(i);
            if (itemstack.m_41619_() || itemstack.m_41720_().m_41473_() == null || !HunterConfigUtils.isWhitelistedItem(itemstack.m_41720_())) continue;
            return itemstack.m_41620_(1);
        }
        return ItemStack.f_41583_;
    }

    private ItemStack findBoomerang() {
        for (int i = 0; i < this.inventory.m_6643_(); ++i) {
            ItemStack itemstack = this.inventory.m_8020_(i);
            if (itemstack.m_41619_() || !itemstack.m_150930_((Item)HunterItems.BOOMERANG.get())) continue;
            return itemstack.m_41620_(1);
        }
        return ItemStack.f_41583_;
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22279_, (double)0.3f).m_22268_(Attributes.f_22277_, 20.0).m_22268_(Attributes.f_22276_, 26.0).m_22268_(Attributes.f_22284_, 1.0).m_22268_(Attributes.f_22281_, 3.0);
    }

    public void m_7380_(CompoundTag p_213281_1_) {
        super.m_7380_(p_213281_1_);
        if (this.homeTarget != null) {
            p_213281_1_.m_128365_("HomeTarget", (Tag)NbtUtils.m_129224_((BlockPos)this.homeTarget));
        }
        ListTag listnbt = new ListTag();
        for (int i = 0; i < this.inventory.m_6643_(); ++i) {
            ItemStack itemstack = this.inventory.m_8020_(i);
            if (itemstack.m_41619_()) continue;
            listnbt.add((Object)itemstack.m_41739_(new CompoundTag()));
        }
        p_213281_1_.m_128365_("Inventory", (Tag)listnbt);
        p_213281_1_.m_128405_("HuntingCooldown", this.cooldown);
    }

    public void m_7378_(CompoundTag p_70037_1_) {
        super.m_7378_(p_70037_1_);
        if (p_70037_1_.m_128441_("HomeTarget")) {
            this.homeTarget = NbtUtils.m_129239_((CompoundTag)p_70037_1_.m_128469_("HomeTarget"));
        }
        ListTag listnbt = p_70037_1_.m_128437_("Inventory", 10);
        for (int i = 0; i < listnbt.size(); ++i) {
            ItemStack itemstack = ItemStack.m_41712_((CompoundTag)listnbt.m_128728_(i));
            if (itemstack.m_41619_()) continue;
            this.inventory.m_19173_(itemstack);
        }
        this.cooldown = p_70037_1_.m_128451_("HuntingCooldown");
        this.m_21553_(true);
    }

    public void m_7895_(int p_213660_1_, boolean p_213660_2_) {
        boolean flag;
        ItemStack offHandStack = new ItemStack((ItemLike)HunterItems.BOOMERANG.get());
        Raid raid = this.m_37885_();
        int i = 1;
        if (p_213660_1_ > raid.m_37724_(Difficulty.NORMAL)) {
            i = 2;
        }
        ItemStack itemstack = raid.m_37773_() < 2 || p_213660_1_ <= raid.m_37724_(Difficulty.NORMAL) ? (this.f_19796_.m_188499_() ? new ItemStack((ItemLike)Items.f_42411_) : new ItemStack((ItemLike)Items.f_42425_)) : (this.f_19796_.m_188499_() ? new ItemStack((ItemLike)Items.f_42411_) : new ItemStack((ItemLike)Items.f_42383_));
        this.inventory.m_19173_(new ItemStack((ItemLike)Items.f_42485_, 5));
        boolean bl = flag = this.f_19796_.m_188501_() <= raid.m_37783_();
        if (flag) {
            if (itemstack.m_41720_() == Items.f_42411_) {
                map = Maps.newHashMap();
                map.put(Enchantments.f_44988_, i);
                EnchantmentHelper.m_44865_((Map)map, (ItemStack)itemstack);
            } else {
                map = Maps.newHashMap();
                map.put(Enchantments.f_44977_, i);
                EnchantmentHelper.m_44865_((Map)map, (ItemStack)itemstack);
            }
            this.inventory.m_19173_(new ItemStack((ItemLike)Items.f_42580_, 2));
            HashMap map2 = Maps.newHashMap();
            map2.put(Enchantments.f_44977_, i);
            EnchantmentHelper.m_44865_((Map)map2, (ItemStack)offHandStack);
        }
        if (this.f_19796_.m_188501_() < 0.25f && !itemstack.m_150930_(Items.f_42411_)) {
            HashMap map3 = Maps.newHashMap();
            map3.put(Enchantments.f_44955_, i);
            EnchantmentHelper.m_44865_((Map)map3, (ItemStack)offHandStack);
            this.m_21008_(InteractionHand.OFF_HAND, offHandStack);
        }
        if (itemstack.m_150930_(Items.f_42411_) && raid.m_37773_() > 2 && this.f_19796_.m_188501_() < 0.25f) {
            this.m_21008_(InteractionHand.OFF_HAND, this.createHorn());
        }
        if (this.f_19796_.m_188501_() < 0.25f) {
            this.m_8061_(EquipmentSlot.HEAD, new ItemStack((ItemLike)Items.f_42407_));
        }
        this.m_21008_(InteractionHand.MAIN_HAND, itemstack);
    }

    protected void m_7581_(ItemEntity p_175445_1_) {
        ItemStack itemstack = p_175445_1_.m_32055_();
        if (itemstack.m_41720_() instanceof BannerItem) {
            super.m_7581_(p_175445_1_);
        } else {
            Item item = itemstack.m_41720_();
            if (this.wantsFood(itemstack)) {
                this.m_21053_(p_175445_1_);
                this.m_7938_((Entity)p_175445_1_, itemstack.m_41613_());
                ItemStack itemstack1 = this.inventory.m_19173_(itemstack);
                if (itemstack1.m_41619_()) {
                    p_175445_1_.m_146870_();
                } else {
                    itemstack.m_41764_(itemstack1.m_41613_());
                }
            } else if (item == HunterItems.BOOMERANG.get()) {
                this.m_21053_(p_175445_1_);
                this.m_7938_((Entity)p_175445_1_, itemstack.m_41613_());
                ItemStack itemstack1 = this.inventory.m_19173_(itemstack);
                if (itemstack1.m_41619_()) {
                    p_175445_1_.m_146870_();
                } else {
                    itemstack.m_41764_(itemstack1.m_41613_());
                }
            }
        }
    }

    private boolean wantsFood(ItemStack p_213672_1_) {
        return p_213672_1_.m_41720_().m_41473_() != null && HunterConfigUtils.isWhitelistedItem(p_213672_1_.m_41720_());
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor p_37856_, DifficultyInstance p_37857_, MobSpawnType p_37858_, @Nullable SpawnGroupData p_37859_, @Nullable CompoundTag p_37860_) {
        RandomSource randomsource = p_37856_.m_213780_();
        SpawnGroupData ilivingentitydata = super.m_6518_(p_37856_, p_37857_, p_37858_, p_37859_, p_37860_);
        ((GroundPathNavigation)this.m_21573_()).m_26477_(true);
        this.m_21553_(true);
        for (int i = 0; i < 2; ++i) {
            Item item;
            if (((List)HunterConfig.COMMON.foodInInventoryWhitelist.get()).isEmpty() || (item = (Item)ForgeRegistries.ITEMS.getValue(ResourceLocation.m_135820_((String)((String)((List)HunterConfig.COMMON.foodInInventoryWhitelist.get()).get(this.f_19796_.m_188503_(((List)HunterConfig.COMMON.foodInInventoryWhitelist.get()).size())))))) == null) continue;
            this.inventory.m_19173_(new ItemStack((ItemLike)item, 2 + this.f_19796_.m_188503_(3)));
        }
        if (p_37858_ != MobSpawnType.STRUCTURE) {
            this.m_213945_(randomsource, p_37857_);
        } else {
            this.setHomeTarget(this.m_20183_());
        }
        this.m_213946_(randomsource, p_37857_);
        return ilivingentitydata;
    }

    protected void m_5907_() {
        super.m_5907_();
        if (this.inventory != null) {
            for (int i = 0; i < this.inventory.m_6643_(); ++i) {
                ItemStack itemstack = this.inventory.m_8020_(i);
                if (itemstack.m_41619_() || EnchantmentHelper.m_44924_((ItemStack)itemstack)) continue;
                this.m_19983_(itemstack);
            }
        }
    }

    protected void m_213945_(RandomSource p_217055_, DifficultyInstance p_217056_) {
        if (this.m_37885_() == null) {
            if (this.f_19796_.m_188501_() < 0.1f) {
                this.m_8061_(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)Items.f_42411_));
                this.m_8061_(EquipmentSlot.OFFHAND, this.createHorn());
            } else {
                this.m_8061_(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)Items.f_42420_));
                if (this.f_19796_.m_188499_()) {
                    ItemStack offHandStack = new ItemStack((ItemLike)HunterItems.BOOMERANG.get());
                    HashMap map3 = Maps.newHashMap();
                    map3.put(Enchantments.f_44955_, 1);
                    EnchantmentHelper.m_44865_((Map)map3, (ItemStack)offHandStack);
                    this.m_21008_(InteractionHand.OFF_HAND, offHandStack);
                }
            }
            if (this.f_19796_.m_188501_() < 0.25f) {
                this.m_8061_(EquipmentSlot.HEAD, new ItemStack((ItemLike)Items.f_42407_));
            }
        }
    }

    public ItemStack createHorn() {
        Optional holderset = BuiltInRegistries.f_256896_.m_203636_(Instruments.f_220144_);
        if (holderset.isPresent()) {
            return InstrumentItem.m_220107_((Item)Items.f_220219_, (Holder)((Holder)holderset.get()));
        }
        return ItemStack.f_41583_;
    }

    public boolean m_7307_(Entity p_184191_1_) {
        if (super.m_7307_(p_184191_1_)) {
            return true;
        }
        if (p_184191_1_ instanceof LivingEntity && ((LivingEntity)p_184191_1_).m_6336_() == MobType.f_21643_) {
            return this.m_5647_() == null && p_184191_1_.m_5647_() == null;
        }
        return false;
    }

    public SoundEvent m_7930_() {
        return (SoundEvent)HunterSounds.HUNTER_ILLAGER_CHEER.get();
    }

    protected SoundEvent m_7515_() {
        return (SoundEvent)HunterSounds.HUNTER_ILLAGER_IDLE.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)HunterSounds.HUNTER_ILLAGER_DEATH.get();
    }

    protected SoundEvent m_7975_(DamageSource p_184601_1_) {
        return (SoundEvent)HunterSounds.HUNTER_ILLAGER_HURT.get();
    }

    @OnlyIn(value=Dist.CLIENT)
    public AbstractIllager.IllagerArmPose m_6768_() {
        if (this.m_5912_()) {
            return this.m_21055_(Items.f_42411_) || this.m_21055_((Item)HunterItems.BOOMERANG.get()) ? AbstractIllager.IllagerArmPose.BOW_AND_ARROW : AbstractIllager.IllagerArmPose.ATTACKING;
        }
        return this.m_37888_() ? AbstractIllager.IllagerArmPose.CELEBRATING : AbstractIllager.IllagerArmPose.CROSSED;
    }

    public boolean m_214076_(ServerLevel p_216988_, LivingEntity p_216989_) {
        this.m_5496_((SoundEvent)HunterSounds.HUNTER_ILLAGER_LAUGH.get(), this.m_6121_(), this.m_6100_());
        this.cooldown = 300;
        return super.m_214076_(p_216988_, p_216989_);
    }

    public void setHomeTarget(@Nullable BlockPos p_213726_1_) {
        this.homeTarget = p_213726_1_;
    }

    @Nullable
    private BlockPos getHomeTarget() {
        return this.homeTarget;
    }

    public void m_6504_(LivingEntity p_32141_, float p_32142_) {
        ItemStack itemstack = this.m_6298_(this.m_21120_(ProjectileUtil.getWeaponHoldingHand((LivingEntity)this, item -> item instanceof BowItem)));
        AbstractArrow abstractarrow = this.getArrow(itemstack, p_32142_);
        if (this.m_21205_().m_41720_() instanceof BowItem) {
            abstractarrow = ((BowItem)this.m_21205_().m_41720_()).customArrow(abstractarrow);
        }
        double d0 = p_32141_.m_20185_() - this.m_20185_();
        double d1 = p_32141_.m_20227_(0.3333333333333333) - abstractarrow.m_20186_();
        double d2 = p_32141_.m_20189_() - this.m_20189_();
        double d3 = Math.sqrt(d0 * d0 + d2 * d2);
        abstractarrow.m_6686_(d0, d1 + d3 * (double)0.2f, d2, 1.6f, (float)(14 - this.m_9236_().m_46791_().m_19028_() * 4));
        this.m_5496_(SoundEvents.f_12382_, 1.0f, 1.0f / (this.m_217043_().m_188501_() * 0.4f + 0.8f));
        this.m_9236_().m_7967_((Entity)abstractarrow);
        this.m_9236_().m_7605_((Entity)this, (byte)61);
    }

    protected AbstractArrow getArrow(ItemStack p_32156_, float p_32157_) {
        return ProjectileUtil.m_37300_((LivingEntity)this, (ItemStack)p_32156_, (float)p_32157_);
    }

    public void performBoomerangAttack(LivingEntity p_82196_1_) {
        BoomerangEntity boomerang = new BoomerangEntity(this.m_9236_(), (LivingEntity)this, this.m_21206_().m_41620_(1));
        double d0 = p_82196_1_.m_20185_() - this.m_20185_();
        double d1 = p_82196_1_.m_20227_(0.3333333333333333) - boomerang.m_20186_();
        double d2 = p_82196_1_.m_20189_() - this.m_20189_();
        double d3 = Mth.m_14116_((float)((float)(d0 * d0 + d2 * d2)));
        boomerang.m_6686_(d0, d1 + d3 * (double)0.2f, d2, 1.6f, 14 - this.m_9236_().m_46791_().m_19028_() * 4);
        this.m_5496_(SoundEvents.f_12382_, 1.0f, 1.0f / (this.m_217043_().m_188501_() * 0.4f + 0.8f));
        this.m_9236_().m_7967_((Entity)boomerang);
        this.m_9236_().m_7605_((Entity)this, (byte)62);
    }

    public static class GetFoodGoal<T extends Hunter>
    extends Goal {
        private final T mob;
        final /* synthetic */ Hunter this$0;

        public GetFoodGoal(T p_i50572_2_) {
            this.this$0 = this$0;
            this.mob = p_i50572_2_;
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean m_8036_() {
            if (!this.mob.m_37886_()) {
                List list = this.mob.m_9236_().m_6443_(ItemEntity.class, this.mob.m_20191_().m_82377_(16.0, 8.0, 16.0), ALLOWED_ITEMS);
                if (!list.isEmpty() && this.mob.m_142582_((Entity)list.get(0))) {
                    return this.mob.m_21573_().m_5624_((Entity)list.get(0), (double)1.1f);
                }
                return false;
            }
            return false;
        }

        public void m_8037_() {
            List list;
            if (this.mob.m_21573_().m_26567_().m_123314_((Vec3i)this.mob.m_20183_(), 1.414) && !(list = this.mob.m_9236_().m_6443_(ItemEntity.class, this.mob.m_20191_().m_82377_(4.0, 4.0, 4.0), ALLOWED_ITEMS)).isEmpty()) {
                ((Hunter)((Object)this.mob)).m_7581_((ItemEntity)list.get(0));
            }
        }
    }

    class MoveToGoal
    extends Goal {
        final Hunter hunter;
        final double stopDistance;
        final double speedModifier;

        MoveToGoal(Hunter p_i50459_2_, double p_i50459_3_, double p_i50459_5_) {
            this.hunter = p_i50459_2_;
            this.stopDistance = p_i50459_3_;
            this.speedModifier = p_i50459_5_;
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
        }

        public void m_8041_() {
            Hunter.this.f_21344_.m_26573_();
        }

        public boolean m_8036_() {
            BlockPos blockpos = this.hunter.getHomeTarget();
            double distance = this.hunter.m_9236_().m_46461_() ? this.stopDistance : this.stopDistance / 1.5;
            return blockpos != null && this.isTooFarAway(blockpos, distance);
        }

        public void m_8037_() {
            BlockPos blockpos = this.hunter.getHomeTarget();
            if (blockpos != null && Hunter.this.f_21344_.m_26571_()) {
                if (this.isTooFarAway(blockpos, 10.0)) {
                    Vec3 vector3d = new Vec3((double)blockpos.m_123341_() - this.hunter.m_20185_(), (double)blockpos.m_123342_() - this.hunter.m_20186_(), (double)blockpos.m_123343_() - this.hunter.m_20189_()).m_82541_();
                    Vec3 vector3d1 = vector3d.m_82490_(10.0).m_82520_(this.hunter.m_20185_(), this.hunter.m_20186_(), this.hunter.m_20189_());
                    Hunter.this.f_21344_.m_26519_(vector3d1.f_82479_, vector3d1.f_82480_, vector3d1.f_82481_, this.speedModifier);
                } else {
                    Hunter.this.f_21344_.m_26519_((double)blockpos.m_123341_(), (double)blockpos.m_123342_(), (double)blockpos.m_123343_(), this.speedModifier);
                }
            }
        }

        private boolean isTooFarAway(BlockPos p_220846_1_, double p_220846_2_) {
            return !p_220846_1_.m_123314_((Vec3i)this.hunter.m_20183_(), p_220846_2_);
        }
    }
}

