/*
 * Decompiled with CFR 0.152.
 */
package bagu_chan.bagus_lib.message;

import bagu_chan.bagus_lib.api.IBaguData;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.event.network.CustomPayloadEvent;
import net.minecraftforge.fml.LogicalSide;

public class UpdateDataMessage {
    private final CompoundTag tag;
    private int entityId;

    public UpdateDataMessage(CompoundTag tag, Entity entity) {
        this.tag = tag;
        this.entityId = entity.m_19879_();
    }

    public UpdateDataMessage(CompoundTag tag, int entityId) {
        this.tag = tag;
        this.entityId = entityId;
    }

    public static void writeToPacket(UpdateDataMessage packet, FriendlyByteBuf buf) {
        buf.m_130079_((Tag)packet.tag);
        buf.writeInt(packet.entityId);
    }

    public static UpdateDataMessage readFromPacket(FriendlyByteBuf buf) {
        return new UpdateDataMessage(buf.m_130260_(), buf.readInt());
    }

    public void handle(CustomPayloadEvent.Context context) {
        if (context.getDirection().getReceptionSide() == LogicalSide.SERVER) {
            context.enqueueWork(() -> {
                ServerPlayer player = context.getSender();
                if (player != null && player instanceof IBaguData) {
                    IBaguData data = (IBaguData)player;
                    data.setData(this.tag);
                }
            });
        }
        context.setPacketHandled(true);
    }
}

