/*
 * Decompiled with CFR 0.152.
 */
package bagu_chan.bagus_lib.message;

import bagu_chan.bagus_lib.api.IBaguData;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.neoforged.fml.LogicalSide;
import net.neoforged.neoforge.network.NetworkEvent;

public class UpdateDataMessage {
    private final CompoundTag tag;
    private int entityId;

    public UpdateDataMessage(CompoundTag tag, Entity entity) {
        this.tag = tag;
        this.entityId = entity.getId();
    }

    public UpdateDataMessage(CompoundTag tag, int entityId) {
        this.tag = tag;
        this.entityId = entityId;
    }

    public static void writeToPacket(UpdateDataMessage packet, FriendlyByteBuf buf) {
        buf.writeNbt((Tag)packet.tag);
        buf.writeInt(packet.entityId);
    }

    public static UpdateDataMessage readFromPacket(FriendlyByteBuf buf) {
        return new UpdateDataMessage(buf.readNbt(), buf.readInt());
    }

    public void handle(NetworkEvent.Context context) {
        if (context.getDirection().getReceptionSide() == LogicalSide.SERVER) {
            context.enqueueWork(() -> {
                ServerPlayer player = context.getSender();
                if (player != null && player instanceof IBaguData) {
                    IBaguData data = (IBaguData)player;
                    data.setData(this.tag);
                }
            });
        }
        context.setPacketHandled(true);
    }
}

