/*
 * Decompiled with CFR 0.152.
 */
package baguchan.hunters_return.client.render;

import baguchan.hunters_return.entity.projectile.BoomerangEntity;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemDisplayContext;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class BoomerangRender
extends EntityRenderer<BoomerangEntity> {
    private ItemRenderer itemRenderer = Minecraft.getInstance().getItemRenderer();

    public BoomerangRender(EntityRendererProvider.Context renderManager) {
        super(renderManager);
    }

    public void render(BoomerangEntity entityIn, float entityYaw, float partialTicks, PoseStack stackIn, MultiBufferSource bufferIn, int packedLightIn) {
        stackIn.pushPose();
        stackIn.translate(0.1f, 0.0f, 0.1f);
        stackIn.mulPose(Axis.YP.rotationDegrees(Mth.lerp((float)partialTicks, (float)entityIn.yRotO, (float)entityIn.getYRot())));
        stackIn.mulPose(Axis.XP.rotationDegrees(Mth.lerp((float)partialTicks, (float)entityIn.xRotO, (float)entityIn.getXRot())));
        stackIn.mulPose(Axis.XP.rotationDegrees(90.0f));
        if (!entityIn.isInGround()) {
            stackIn.mulPose(Axis.ZP.rotationDegrees(((float)entityIn.tickCount + partialTicks + (float)entityIn.getPiercingLevel() * 0.85f) * ((float)entityIn.getSpeed() * 80.0f)));
        }
        BakedModel bakedmodel = this.itemRenderer.getModel(entityIn.getBoomerang(), entityIn.level(), (LivingEntity)null, entityIn.getId());
        this.itemRenderer.render(entityIn.getBoomerang(), ItemDisplayContext.GROUND, false, stackIn, bufferIn, packedLightIn, OverlayTexture.NO_OVERLAY, bakedmodel);
        stackIn.popPose();
        super.render((Entity)entityIn, entityYaw, partialTicks, stackIn, bufferIn, packedLightIn);
    }

    public ResourceLocation getTextureLocation(BoomerangEntity p_115034_) {
        return TextureAtlas.LOCATION_BLOCKS;
    }
}

