/*
 * Decompiled with CFR 0.152.
 */
package baguchan.hunters_return.entity.ai;

import baguchan.hunters_return.entity.Hunter;
import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.monster.AbstractIllager;
import net.minecraft.world.item.Instrument;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.gameevent.GameEvent;

public class CallAllyGoal
extends Goal {
    public Hunter hunter;
    @Nullable
    protected List<? extends AbstractIllager> toCall;
    protected final TargetingConditions lookAtContext;
    private int cooldownTime;
    private int callTime;

    public CallAllyGoal(Hunter hunterEntity) {
        this.hunter = hunterEntity;
        this.lookAtContext = TargetingConditions.forNonCombat().ignoreLineOfSight().range(30.0);
        this.setFlags(EnumSet.of(Goal.Flag.MOVE));
    }

    public boolean canUse() {
        if (!this.hunter.isHolding(item -> item.getItem() == Items.GOAT_HORN)) {
            return false;
        }
        if (--this.cooldownTime < 0 && this.hunter.getTarget() != null) {
            this.toCall = this.hunter.level().getEntitiesOfClass(AbstractIllager.class, this.hunter.getBoundingBox().inflate(30.0, 30.0, 30.0), p_148124_ -> this.hunter != p_148124_ && this.hunter.isAlliedTo((Entity)p_148124_) && p_148124_.getTarget() == null);
            this.cooldownTime = 600;
            return !this.toCall.isEmpty();
        }
        return false;
    }

    public boolean canContinueToUse() {
        return this.callTime > 0;
    }

    public void tick() {
        super.tick();
        --this.callTime;
    }

    public void start() {
        Optional<? extends Holder<Instrument>> optional;
        super.start();
        this.callTime = 20;
        if (this.hunter.getOffhandItem().is(Items.GOAT_HORN)) {
            this.hunter.startUsingItem(InteractionHand.OFF_HAND);
        } else if (this.hunter.getMainHandItem().is(Items.GOAT_HORN)) {
            this.hunter.startUsingItem(InteractionHand.MAIN_HAND);
        }
        if (!this.toCall.isEmpty()) {
            this.toCall.forEach(abstractIllager -> abstractIllager.setTarget(this.hunter.getTarget()));
        }
        if ((optional = this.getInstrument(this.hunter.getUseItem())).isPresent()) {
            Instrument instrument = (Instrument)optional.get().value();
            SoundEvent soundevent = (SoundEvent)instrument.soundEvent().value();
            float f = instrument.range() / 16.0f;
            this.hunter.level().playSound((Entity)this.hunter, this.hunter.blockPosition(), soundevent, SoundSource.RECORDS, f, 1.0f);
            this.hunter.gameEvent(GameEvent.INSTRUMENT_PLAY, (Entity)this.hunter);
        }
    }

    private Optional<? extends Holder<Instrument>> getInstrument(ItemStack p_220135_) {
        ResourceLocation resourcelocation;
        CompoundTag compoundtag = p_220135_.getTag();
        if (compoundtag != null && (resourcelocation = ResourceLocation.tryParse((String)compoundtag.getString("instrument"))) != null) {
            return BuiltInRegistries.INSTRUMENT.getHolder(ResourceKey.create((ResourceKey)Registries.INSTRUMENT, (ResourceLocation)resourcelocation));
        }
        return Optional.empty();
    }

    public void stop() {
        super.stop();
        this.hunter.stopUsingItem();
    }
}

