/*
 * Decompiled with CFR 0.152.
 */
package baguchan.hunters_return.init;

import baguchan.hunters_return.entity.Hunter;
import baguchan.hunters_return.entity.projectile.BoomerangEntity;
import java.util.function.Supplier;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.Mod;
import net.neoforged.neoforge.event.entity.EntityAttributeCreationEvent;
import net.neoforged.neoforge.registries.DeferredRegister;

@Mod.EventBusSubscriber(modid="hunters_return", bus=Mod.EventBusSubscriber.Bus.MOD)
public class HunterEntityRegistry {
    public static final DeferredRegister<EntityType<?>> ENTITIES_REGISTRY = DeferredRegister.create((Registry)BuiltInRegistries.ENTITY_TYPE, (String)"hunters_return");
    public static final Supplier<EntityType<Hunter>> HUNTERILLAGER = ENTITIES_REGISTRY.register("hunter", () -> EntityType.Builder.of(Hunter::new, (MobCategory)MobCategory.MONSTER).sized(0.6f, 1.95f).clientTrackingRange(8).build(HunterEntityRegistry.prefix("hunter")));
    public static final Supplier<EntityType<BoomerangEntity>> BOOMERANG = ENTITIES_REGISTRY.register("boomerang", () -> EntityType.Builder.of(BoomerangEntity::new, (MobCategory)MobCategory.MISC).sized(0.3f, 0.3f).clientTrackingRange(4).updateInterval(20).build(HunterEntityRegistry.prefix("boomerang")));

    @SubscribeEvent
    public static void registerEntityAttribute(EntityAttributeCreationEvent event) {
        event.put(HUNTERILLAGER.get(), Hunter.createAttributes().build());
    }

    private static String prefix(String path) {
        return "hunters_return." + path;
    }
}

