/*
 * Decompiled with CFR 0.152.
 */
package baguchan.hunters_return.entity.projectile;

import baguchan.hunters_return.init.HunterDamageSource;
import baguchan.hunters_return.init.HunterEnchantments;
import baguchan.hunters_return.init.HunterEntityRegistry;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.TheEndGatewayBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.event.EventHooks;
import net.neoforged.neoforge.fluids.FluidType;

public class BoomerangEntity
extends Projectile {
    private static final EntityDataAccessor<Byte> LOYALTY_LEVEL = SynchedEntityData.defineId(BoomerangEntity.class, (EntityDataSerializer)EntityDataSerializers.BYTE);
    private static final EntityDataAccessor<Byte> PIERCING_LEVEL = SynchedEntityData.defineId(BoomerangEntity.class, (EntityDataSerializer)EntityDataSerializers.BYTE);
    private static final EntityDataAccessor<Byte> BOUNCE_LEVEL = SynchedEntityData.defineId(BoomerangEntity.class, (EntityDataSerializer)EntityDataSerializers.BYTE);
    private static final EntityDataAccessor<Boolean> RETURNING = SynchedEntityData.defineId(BoomerangEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<ItemStack> BOOMERANG = SynchedEntityData.defineId(BoomerangEntity.class, (EntityDataSerializer)EntityDataSerializers.ITEM_STACK);
    private int totalHits;
    private int flyTick;
    public boolean inGround;
    protected int inGroundTime;
    @Nullable
    private BlockState lastState;

    public BoomerangEntity(EntityType<? extends BoomerangEntity> entityEntityType, Level world) {
        super(entityEntityType, world);
    }

    public BoomerangEntity(EntityType<? extends BoomerangEntity> type, Level world, LivingEntity shootingEntity, ItemStack boomerang) {
        super(type, world);
        this.setPos(shootingEntity.getX(), shootingEntity.getEyeY() - (double)0.1f, shootingEntity.getZ());
        this.setOwner((Entity)shootingEntity);
        this.setBoomerang(boomerang);
        this.entityData.set(LOYALTY_LEVEL, (Object)((byte)EnchantmentHelper.getLoyalty((ItemStack)boomerang)));
        this.entityData.set(PIERCING_LEVEL, (Object)((byte)EnchantmentHelper.getItemEnchantmentLevel((Enchantment)Enchantments.PIERCING, (ItemStack)boomerang)));
        this.entityData.set(BOUNCE_LEVEL, (Object)((byte)EnchantmentHelper.getItemEnchantmentLevel((Enchantment)HunterEnchantments.BOUNCE.get(), (ItemStack)boomerang)));
        this.totalHits = 0;
    }

    public BoomerangEntity(Level world, LivingEntity entity, ItemStack boomerang) {
        this(HunterEntityRegistry.BOOMERANG.get(), world, entity, boomerang);
    }

    private void onHitFluid(BlockHitResult result) {
        double velocity = this.getVelocity();
        double horizontal = this.getDeltaMovement().y * this.getDeltaMovement().y;
        if (result.getType() == HitResult.Type.BLOCK && result.isInside() && velocity >= (double)0.65f && horizontal < (double)0.175f && !this.level().getBlockState(result.getBlockPos()).isAir() && this.level().getFluidState(result.getBlockPos()).is(FluidTags.WATER)) {
            this.setDeltaMovement(this.getDeltaMovement().x, Mth.clamp((double)(this.getDeltaMovement().y + (double)0.1f), (double)-0.1f, (double)0.3f), this.getDeltaMovement().z);
            this.hasImpulse = true;
        }
    }

    public DamageSource boomerangAttack(@Nullable Entity p_270857_) {
        return this.damageSources().source(HunterDamageSource.BOOMERANG, (Entity)this, p_270857_);
    }

    protected void onHitEntity(EntityHitResult result) {
        super.onHitEntity(result);
        boolean returnToOwner = false;
        byte loyaltyLevel = (Byte)this.entityData.get(LOYALTY_LEVEL);
        byte piercingLevel = (Byte)this.entityData.get(PIERCING_LEVEL);
        Entity shooter = this.getOwner();
        if (!(result.getEntity() == shooter || this.isReturning() && loyaltyLevel > 0)) {
            int sharpness = EnchantmentHelper.getItemEnchantmentLevel((Enchantment)Enchantments.SHARPNESS, (ItemStack)this.getBoomerang());
            int damage = (int)(3.0 * Math.sqrt(this.getDeltaMovement().length()) + (double)Math.min(1, sharpness) + (double)Math.max(0, sharpness - 1) * 0.5 + (double)(0.5f * (float)piercingLevel));
            if (this.isOnFire()) {
                result.getEntity().setSecondsOnFire(5);
            }
            if (damage > 0) {
                result.getEntity().hurt(this.boomerangAttack(shooter), (float)damage);
            }
            if (shooter instanceof LivingEntity) {
                this.getBoomerang().hurtAndBreak(1, (LivingEntity)shooter, p_222182_1_ -> {});
            }
            double speed = this.getSpeed();
            if (piercingLevel < 1 && this.totalHits >= this.getBounceLevel() || this.totalHits >= piercingLevel + this.getBounceLevel() && speed > (double)0.4f) {
                returnToOwner = true;
            } else if (piercingLevel < 1 && this.totalHits < this.getBounceLevel() || this.totalHits < piercingLevel + this.getBounceLevel() && speed <= (double)0.4f) {
                Vec3 motion = this.getDeltaMovement();
                double motionX = motion.x;
                double motionY = motion.y;
                double motionZ = motion.z;
                motionX = -motionX;
                motionZ = -motionZ;
                this.setDeltaMovement(motionX, motionY, motionZ);
                this.setDeltaMovement(this.getDeltaMovement().scale((double)(0.91f + (float)this.getBounceLevel() * 0.01f)));
            }
            ++this.totalHits;
        }
        if (returnToOwner && !this.isReturning()) {
            if (this.getOwner() != null && this.shouldReturnToThrower() && EnchantmentHelper.getItemEnchantmentLevel((Enchantment)Enchantments.LOYALTY, (ItemStack)this.getBoomerang()) > 0) {
                this.level().playSound(null, shooter.blockPosition(), SoundEvents.TRIDENT_RETURN, SoundSource.PLAYERS, 1.0f, 1.0f);
                Vec3 motion = this.getDeltaMovement();
                double motionX = motion.x;
                double motionY = motion.y;
                motionZ = motion.z;
                motionX = -motionX;
                motionZ = -motionZ;
                this.setDeltaMovement(motionX, motionY, motionZ);
                if (loyaltyLevel > 0 && !this.isReturning() && shooter != null) {
                    this.level().playSound(null, shooter.blockPosition(), SoundEvents.TRIDENT_RETURN, SoundSource.PLAYERS, 1.0f, 1.0f);
                    this.setReturning(true);
                }
            } else {
                Vec3 motion = this.getDeltaMovement();
                double motionX = motion.x;
                double motionY = motion.y;
                motionZ = motion.z;
                motionX = -motionX;
                motionZ = -motionZ;
                this.setDeltaMovement(motionX, motionY, motionZ);
                if (loyaltyLevel > 0 && !this.isReturning() && shooter != null) {
                    this.level().playSound(null, shooter.blockPosition(), SoundEvents.TRIDENT_RETURN, SoundSource.PLAYERS, 1.0f, 1.0f);
                    this.setReturning(true);
                }
            }
        }
    }

    protected void onHitBlock(BlockHitResult result) {
        super.onHitBlock(result);
        BlockPos pos = result.getBlockPos();
        BlockState state = this.level().getBlockState(pos);
        SoundType soundType = state.getSoundType((LevelReader)this.level(), pos, (Entity)this);
        byte loyaltyLevel = (Byte)this.entityData.get(LOYALTY_LEVEL);
        Entity entity = this.getOwner();
        Vec3 movement = this.getDeltaMovement();
        if (!this.isReturning()) {
            if (movement.length() < (double)0.2f && movement.y <= 0.0) {
                if (loyaltyLevel > 0) {
                    if (!this.isReturning() && entity != null) {
                        this.level().playSound(null, entity.blockPosition(), SoundEvents.TRIDENT_RETURN, SoundSource.PLAYERS, 1.0f, 1.0f);
                        this.setReturning(true);
                    }
                } else {
                    this.inGround = true;
                    this.lastState = this.level().getBlockState(result.getBlockPos());
                    Vec3 vec3 = result.getLocation().subtract(this.getX(), this.getY(), this.getZ());
                    this.setDeltaMovement(vec3);
                    Vec3 vec31 = vec3.normalize().scale((double)0.05f);
                    this.setPosRaw(this.getX() - vec31.x, this.getY() - vec31.y, this.getZ() - vec31.z);
                }
            } else {
                Vec3i direction = result.getDirection().getNormal();
                switch (result.getDirection()) {
                    case UP: 
                    case SOUTH: 
                    case EAST: {
                        direction = direction.multiply(-1);
                        break;
                    }
                }
                direction = new Vec3i(direction.getX() == 0 ? 1 : direction.getX(), direction.getY() == 0 ? 1 : direction.getY(), direction.getZ() == 0 ? 1 : direction.getZ());
                this.setDeltaMovement(movement.multiply(new Vec3((double)direction.getX(), (double)direction.getY(), (double)direction.getZ())).scale((double)(0.91f + (float)this.getBounceLevel() * 0.01f)));
                this.playSound(SoundEvents.WOOD_STEP, 0.5f, 1.0f);
                if (!this.isReturning()) {
                    this.level().playSound(null, this.getX(), this.getY(), this.getZ(), soundType.getHitSound(), SoundSource.BLOCKS, soundType.getVolume(), soundType.getPitch());
                }
            }
        }
    }

    public int getFlyTick() {
        return this.flyTick;
    }

    private boolean shouldReturnToThrower() {
        Entity entity = this.getOwner();
        if (entity != null && entity.isAlive()) {
            return !entity.isSpectator();
        }
        return false;
    }

    private boolean shouldDropToThrower() {
        Entity entity = this.getOwner();
        if (entity != null && entity.isAlive()) {
            return !entity.isSpectator() && !(entity instanceof Player) && this.distanceToSqr(entity) < 3.0;
        }
        return false;
    }

    public void playerTouch(Player entityIn) {
        super.playerTouch(entityIn);
        if (this.flyTick >= 10 && entityIn == this.getOwner() && !this.level().isClientSide && (!entityIn.isCreative() && this.tryPickup(entityIn) || entityIn.isCreative())) {
            this.playSound(SoundEvents.ITEM_PICKUP);
            entityIn.take((Entity)this, 1);
            this.discard();
        }
    }

    protected boolean tryPickup(Player p_150121_) {
        return p_150121_.getInventory().add(this.getBoomerang());
    }

    public void drop(double x, double y, double z) {
        if (!this.level().isClientSide()) {
            if (!(this.getOwner() instanceof Player) || this.getOwner() instanceof Player && !((Player)this.getOwner()).isCreative()) {
                this.level().addFreshEntity((Entity)new ItemEntity(this.level(), x, y, z, this.getBoomerang().split(1)));
                this.discard();
            } else {
                this.discard();
            }
        }
    }

    public void move(MoverType p_36749_, Vec3 p_36750_) {
        super.move(p_36749_, p_36750_);
        if (p_36749_ != MoverType.SELF && this.shouldFall()) {
            this.startFalling();
        }
    }

    public void shoot(double p_36775_, double p_36776_, double p_36777_, float p_36778_, float p_36779_) {
        super.shoot(p_36775_, p_36776_, p_36777_, p_36778_, p_36779_);
        this.inGroundTime = 0;
    }

    public void lerpTo(double p_36728_, double p_36729_, double p_36730_, float p_36731_, float p_36732_, int p_36733_, boolean p_36734_) {
        this.setPos(p_36728_, p_36729_, p_36730_);
        this.setRot(p_36731_, p_36732_);
    }

    public void lerpMotion(double p_36786_, double p_36787_, double p_36788_) {
        super.lerpMotion(p_36786_, p_36787_, p_36788_);
        this.inGroundTime = 0;
    }

    public void tick() {
        VoxelShape voxelshape;
        super.tick();
        Vec3 vec3 = this.getDeltaMovement();
        if (this.xRotO == 0.0f && this.yRotO == 0.0f) {
            double d0 = vec3.horizontalDistance();
            this.setYRot((float)(Mth.atan2((double)vec3.x, (double)vec3.z) * 57.2957763671875));
            this.setXRot((float)(Mth.atan2((double)vec3.y, (double)d0) * 57.2957763671875));
            this.yRotO = this.getYRot();
            this.xRotO = this.getXRot();
        }
        BlockPos blockpos2 = this.blockPosition();
        BlockState blockstate2 = this.level().getBlockState(blockpos2);
        if (this.getDeltaMovement().length() < (double)0.2f && this.getDeltaMovement().y <= 0.0 && !blockstate2.isAir() && !(voxelshape = blockstate2.getCollisionShape((BlockGetter)this.level(), blockpos2)).isEmpty()) {
            Vec3 vec31 = this.position().add(this.getDeltaMovement());
            for (AABB aabb : voxelshape.toAabbs()) {
                if (!aabb.move(blockpos2).contains(vec31)) continue;
                this.setInGround(true);
                break;
            }
        }
        if (this.isInWaterOrRain() || blockstate2.is(Blocks.POWDER_SNOW) || this.isInFluidType((fluidType, height) -> this.canFluidExtinguish((FluidType)fluidType))) {
            this.clearFire();
        }
        if (this.isInGround()) {
            if (this.lastState != blockstate2 && this.shouldFall()) {
                this.startFalling();
            } else if (!this.level().isClientSide) {
                this.tickDespawn();
            }
            ++this.inGroundTime;
        } else {
            float f;
            this.inGroundTime = 0;
            Vec3 vec3d1 = this.position();
            Vec3 vec3d2 = new Vec3(this.getX() + this.getDeltaMovement().x, this.getY() + this.getDeltaMovement().y, this.getZ() + this.getDeltaMovement().z);
            BlockHitResult fluidHitResult = this.level().clip(new ClipContext(vec3d1, vec3d2, ClipContext.Block.COLLIDER, ClipContext.Fluid.ANY, (Entity)this));
            this.onHitFluid(fluidHitResult);
            HitResult hitresult = ProjectileUtil.getHitResultOnMoveVector((Entity)this, x$0 -> this.canHitEntity((Entity)x$0));
            boolean flag = false;
            if (hitresult.getType() == HitResult.Type.BLOCK) {
                BlockPos blockpos = ((BlockHitResult)hitresult).getBlockPos();
                BlockState blockstate = this.level().getBlockState(blockpos);
                if (blockstate.is(Blocks.NETHER_PORTAL)) {
                    this.handleInsidePortal(blockpos);
                    flag = true;
                } else if (blockstate.is(Blocks.END_GATEWAY)) {
                    BlockEntity blockentity = this.level().getBlockEntity(blockpos);
                    if (blockentity instanceof TheEndGatewayBlockEntity && TheEndGatewayBlockEntity.canEntityTeleport((Entity)this)) {
                        TheEndGatewayBlockEntity.teleportEntity((Level)this.level(), (BlockPos)blockpos, (BlockState)blockstate, (Entity)this, (TheEndGatewayBlockEntity)((TheEndGatewayBlockEntity)blockentity));
                    }
                    flag = true;
                }
            }
            if (hitresult.getType() != HitResult.Type.MISS && !flag && !EventHooks.onProjectileImpact((Projectile)this, (HitResult)hitresult)) {
                this.onHit(hitresult);
                this.hasImpulse = true;
            }
            this.updateRotation();
            Vec3 vec32 = this.getDeltaMovement();
            ++this.flyTick;
            byte loyaltyLevel = (Byte)this.entityData.get(LOYALTY_LEVEL);
            Entity entity = this.getOwner();
            if (loyaltyLevel > 0 && !this.isReturning() && this.flyTick >= 80 && entity != null) {
                this.level().playSound(null, entity.blockPosition(), SoundEvents.TRIDENT_RETURN, SoundSource.PLAYERS, 1.0f, 1.0f);
                this.setReturning(true);
            }
            if (loyaltyLevel > 0 && entity != null && !this.shouldReturnToThrower() && this.isReturning()) {
                this.drop(this.getX(), this.getY(), this.getZ());
            } else if (loyaltyLevel > 0 && entity != null && this.isReturning()) {
                this.noPhysics = true;
                Vec3 vec3d3 = new Vec3(entity.getX() - this.getX(), entity.getEyeY() - this.getY(), entity.getZ() - this.getZ());
                double d0 = 0.05 * (double)loyaltyLevel;
                this.setDeltaMovement(this.getDeltaMovement().scale(0.95).add(vec3d3.normalize().scale(d0)));
            }
            Vec3 vec33 = this.getDeltaMovement();
            double d2 = this.getX() + vec33.x;
            double d0 = this.getY() + vec33.y;
            double d1 = this.getZ() + vec33.z;
            if (this.isInWater()) {
                this.level().addParticle((ParticleOptions)ParticleTypes.BUBBLE, d2 - vec32.x * 0.25, d0 - vec32.y * 0.25, d1 - vec32.z * 0.25, vec32.x, vec32.y, vec32.z);
                f = 0.8f;
            } else {
                f = 0.99f;
            }
            this.setDeltaMovement(vec33.scale(loyaltyLevel > 0 && this.isReturning() ? 1.0 : (double)f).add(0.0, (double)(-this.getGravity()), 0.0));
            this.move(MoverType.SELF, this.getDeltaMovement());
            this.checkInsideBlocks();
            if (!this.level().isClientSide() && loyaltyLevel > 0) {
                List list = this.level().getEntities(EntityTypeTest.forClass(ItemEntity.class), this.getBoundingBox().inflate((double)0.1f), Entity::isAlive);
                if (this.getPassengers().isEmpty() && list != null && !list.isEmpty()) {
                    ((ItemEntity)list.get(0)).startRiding((Entity)this);
                }
            }
        }
        if (this.shouldDropToThrower()) {
            this.drop(this.getX(), this.getY(), this.getZ());
        }
    }

    protected void tickDespawn() {
        ++this.inGroundTime;
        if (this.inGroundTime >= 1200) {
            this.discard();
        }
    }

    private boolean shouldFall() {
        return this.isInGround() && this.level().noCollision(new AABB(this.position(), this.position()).inflate(0.06));
    }

    private void startFalling() {
        this.setInGround(false);
        Vec3 vec3 = this.getDeltaMovement();
        this.setDeltaMovement(vec3.multiply((double)(this.random.nextFloat() * 0.2f), (double)(this.random.nextFloat() * 0.2f), (double)(this.random.nextFloat() * 0.2f)));
        this.inGroundTime = 0;
    }

    protected float getGravity() {
        if (this.getLoyaltyLevel() > 0 && !this.isReturning()) {
            if (this.isInWater()) {
                return 0.01f;
            }
            return 0.0f;
        }
        return this.getLoyaltyLevel() > 0 && this.isReturning() ? 0.0f : 0.03f;
    }

    public boolean shouldRenderAtSqrDistance(double p_70112_1_) {
        double d0 = this.getBoundingBox().getSize() * 5.0;
        if (Double.isNaN(d0)) {
            d0 = 1.0;
        }
        return p_70112_1_ < (d0 *= 64.0) * d0;
    }

    protected void defineSynchedData() {
        this.entityData.define(LOYALTY_LEVEL, (Object)0);
        this.entityData.define(PIERCING_LEVEL, (Object)0);
        this.entityData.define(BOUNCE_LEVEL, (Object)0);
        this.entityData.define(RETURNING, (Object)false);
        this.entityData.define(BOOMERANG, (Object)ItemStack.EMPTY);
    }

    public void addAdditionalSaveData(CompoundTag nbt) {
        super.addAdditionalSaveData(nbt);
        nbt.put("boomerang", (Tag)this.getBoomerang().save(new CompoundTag()));
        nbt.putInt("totalHits", this.totalHits);
        nbt.putInt("InGroundTime", this.inGroundTime);
        nbt.putInt("FlyTick", this.flyTick);
        nbt.putBoolean("returning", this.isReturning());
        if (this.lastState != null) {
            nbt.put("inBlockState", (Tag)NbtUtils.writeBlockState((BlockState)this.lastState));
        }
        nbt.putBoolean("inGround", this.isInGround());
    }

    public void readAdditionalSaveData(CompoundTag nbt) {
        super.readAdditionalSaveData(nbt);
        this.setBoomerang(ItemStack.of((CompoundTag)nbt.getCompound("boomerang")));
        this.totalHits = nbt.getInt("totalHits");
        this.inGroundTime = nbt.getInt("InGroundTime");
        if (nbt.contains("inBlockState", 10)) {
            this.lastState = NbtUtils.readBlockState((HolderGetter)this.level().holderLookup(Registries.BLOCK), (CompoundTag)nbt.getCompound("inBlockState"));
        }
        this.setInGround(nbt.getBoolean("inGround"));
        this.flyTick = nbt.getInt("FlyTick");
        this.setReturning(nbt.getBoolean("returning"));
        this.entityData.set(LOYALTY_LEVEL, (Object)((byte)EnchantmentHelper.getLoyalty((ItemStack)this.getBoomerang())));
        this.entityData.set(PIERCING_LEVEL, (Object)((byte)EnchantmentHelper.getItemEnchantmentLevel((Enchantment)Enchantments.PIERCING, (ItemStack)this.getBoomerang())));
        this.entityData.set(BOUNCE_LEVEL, (Object)((byte)EnchantmentHelper.getItemEnchantmentLevel((Enchantment)HunterEnchantments.BOUNCE.get(), (ItemStack)this.getBoomerang())));
    }

    private int getLoyaltyLevel() {
        return ((Byte)this.entityData.get(LOYALTY_LEVEL)).byteValue();
    }

    public int getInGroundTime() {
        return this.inGroundTime;
    }

    private int getBounceLevel() {
        byte loyaltyLevel = (Byte)this.entityData.get(LOYALTY_LEVEL);
        byte bounceLevel = (Byte)this.entityData.get(BOUNCE_LEVEL);
        if (loyaltyLevel > 0) {
            return bounceLevel * 2;
        }
        return bounceLevel;
    }

    public boolean isReturning() {
        return (Boolean)this.entityData.get(RETURNING);
    }

    public ItemStack getBoomerang() {
        return (ItemStack)this.entityData.get(BOOMERANG);
    }

    public double getSpeed() {
        return Math.sqrt(this.getDeltaMovement().x * this.getDeltaMovement().x + this.getDeltaMovement().y * this.getDeltaMovement().y + this.getDeltaMovement().z * this.getDeltaMovement().z);
    }

    public double getVelocity() {
        return Math.sqrt(this.getDeltaMovement().x * this.getDeltaMovement().x + this.getDeltaMovement().z * this.getDeltaMovement().z);
    }

    public int getPiercingLevel() {
        return ((Byte)this.entityData.get(PIERCING_LEVEL)).byteValue();
    }

    public void setReturning(boolean returning) {
        this.entityData.set(RETURNING, (Object)returning);
    }

    public void setInGround(boolean flag) {
        this.inGround = flag;
    }

    public boolean isInGround() {
        return this.inGround;
    }

    public void setBoomerang(ItemStack stack) {
        this.entityData.set(BOOMERANG, (Object)stack);
    }
}

