/*
 * Decompiled with CFR 0.152.
 */
package baguchan.hunters_return.entity;

import bagu_chan.bagus_lib.entity.goal.AnimatedAttackGoal;
import baguchan.hunters_return.HunterConfig;
import baguchan.hunters_return.entity.ai.BoomeranAttackGoal;
import baguchan.hunters_return.entity.ai.CallAllyGoal;
import baguchan.hunters_return.entity.ai.DoSleepingGoal;
import baguchan.hunters_return.entity.ai.DodgeGoal;
import baguchan.hunters_return.entity.ai.DodgeMoveControl;
import baguchan.hunters_return.entity.ai.SleepOnBedGoal;
import baguchan.hunters_return.entity.ai.WakeUpGoal;
import baguchan.hunters_return.entity.projectile.BoomerangEntity;
import baguchan.hunters_return.init.HunterItems;
import baguchan.hunters_return.init.HunterSounds;
import baguchan.hunters_return.utils.HunterConfigUtils;
import com.google.common.collect.Maps;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.InteractGoal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.OpenDoorGoal;
import net.minecraft.world.entity.ai.goal.RangedBowAttackGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.animal.goat.Goat;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.AbstractIllager;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.entity.raid.Raid;
import net.minecraft.world.entity.raid.Raider;
import net.minecraft.world.item.BannerItem;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.InstrumentItem;
import net.minecraft.world.item.Instruments;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.common.IExtensibleEnum;

public class Hunter
extends AbstractIllager
implements RangedAttackMob {
    private static final EntityDataAccessor<String> HUNTER_TYPE = SynchedEntityData.defineId(Hunter.class, (EntityDataSerializer)EntityDataSerializers.STRING);
    public static final Predicate<LivingEntity> TARGET_ENTITY_SELECTOR = p_213616_0_ -> !p_213616_0_.isBaby() && HunterConfigUtils.isWhitelistedEntity(p_213616_0_.getType());
    private static final Predicate<? super ItemEntity> ALLOWED_ITEMS = p_213616_0_ -> p_213616_0_.getItem().getItem().getFoodProperties() != null && HunterConfigUtils.isWhitelistedItem(p_213616_0_.getItem().getItem());
    private final SimpleContainer inventory = new SimpleContainer(5);
    @Nullable
    private BlockPos homeTarget;
    private int cooldown;
    private final int attackAnimationLength = 20;
    private final int shootAnimationLength = 20;
    private final int attackAnimationActionPoint = 8;
    private int attackAnimationTick;
    private int shootAnimationTick;
    private int thrownAnimationTick;
    public final AnimationState attackAnimationState = new AnimationState();
    public final AnimationState shootAnimationState = new AnimationState();
    public final AnimationState chargeAnimationState = new AnimationState();
    public final AnimationState thrownAnimationState = new AnimationState();

    public Hunter(EntityType<? extends Hunter> p_i48556_1_, Level p_i48556_2_) {
        super(p_i48556_1_, p_i48556_2_);
        ((GroundPathNavigation)this.getNavigation()).setCanOpenDoors(true);
        this.moveControl = new DodgeMoveControl((Mob)this);
        this.setCanPickUpLoot(true);
    }

    protected void defineSynchedData() {
        super.defineSynchedData();
        this.entityData.define(HUNTER_TYPE, (Object)HunterType.NORMAL.name());
    }

    public void setHunterType(HunterType type) {
        this.entityData.set(HUNTER_TYPE, (Object)type.name());
    }

    public HunterType getHunterType() {
        return HunterType.get((String)this.entityData.get(HUNTER_TYPE));
    }

    public boolean canFreeze() {
        if (this.getHunterType() == HunterType.COLD) {
            return false;
        }
        return super.canFreeze();
    }

    protected void registerGoals() {
        super.registerGoals();
        this.goalSelector.addGoal(0, (Goal)new WakeUpGoal((PathfinderMob)this));
        this.goalSelector.addGoal(0, (Goal)new DoSleepingGoal((PathfinderMob)this));
        this.goalSelector.addGoal(0, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(0, (Goal)new CallAllyGoal(this));
        this.goalSelector.addGoal(0, (Goal)new DodgeGoal(this, Projectile.class));
        this.goalSelector.addGoal(1, (Goal)new OpenDoorGoal((Mob)this, true));
        this.goalSelector.addGoal(2, (Goal)new AbstractIllager.RaiderOpenDoorGoal((AbstractIllager)this, (Raider)this));
        this.goalSelector.addGoal(3, (Goal)new Raider.HoldGroundAttackGoal((Raider)this, (AbstractIllager)this, 10.0f));
        this.goalSelector.addGoal(4, (Goal)new RangedBowAttackGoal((Monster)this, (double)1.1f, 50, 16.0f));
        this.goalSelector.addGoal(4, (Goal)new BoomeranAttackGoal(this, 50, 16.0f));
        this.goalSelector.addGoal(4, (Goal)new AnimatedAttackGoal((PathfinderMob)this, 1.15f, 12, 20){

            public boolean canUse() {
                return !this.mob.isHolding(item -> item.getItem() instanceof BowItem) && super.canUse();
            }

            public boolean canContinueToUse() {
                return !this.mob.isHolding(item -> item.getItem() instanceof BowItem) && super.canContinueToUse();
            }
        });
        this.goalSelector.addGoal(5, (Goal)new SleepOnBedGoal((PathfinderMob)this, 1.0, 12));
        this.goalSelector.addGoal(6, (Goal)new GetFoodGoal(this, this));
        this.goalSelector.addGoal(7, (Goal)new MoveToGoal(this, 45.0, 1.2));
        this.targetSelector.addGoal(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[]{Raider.class}).setAlertOthers(new Class[]{AbstractIllager.class}));
        this.targetSelector.addGoal(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
        this.targetSelector.addGoal(3, (Goal)new NearestAttackableTargetGoal((Mob)this, AbstractVillager.class, true));
        this.targetSelector.addGoal(3, (Goal)new NearestAttackableTargetGoal((Mob)this, IronGolem.class, true));
        this.targetSelector.addGoal(4, (Goal)new NearestAttackableTargetGoal((Mob)this, Goat.class, true));
        this.targetSelector.addGoal(5, (Goal)new NearestAttackableTargetGoal((Mob)this, Animal.class, 10, true, false, TARGET_ENTITY_SELECTOR){

            public boolean canUse() {
                return Hunter.this.cooldown <= 0 && super.canUse();
            }
        });
        this.goalSelector.addGoal(8, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 0.8));
        this.goalSelector.addGoal(9, (Goal)new InteractGoal((Mob)this, Player.class, 3.0f, 1.0f));
        this.goalSelector.addGoal(10, (Goal)new LookAtPlayerGoal((Mob)this, Mob.class, 8.0f));
    }

    /*
     * Enabled aggressive block sorting
     */
    public void baseTick() {
        super.baseTick();
        if (!this.level().isClientSide) return;
        Objects.requireNonNull(this);
        if (this.attackAnimationTick < 20) {
            ++this.attackAnimationTick;
            if (this.thrownAnimationState.isStarted()) {
                this.thrownAnimationState.stop();
            }
        }
        Objects.requireNonNull(this);
        if (this.attackAnimationTick >= 20) {
            this.attackAnimationState.stop();
        }
        Objects.requireNonNull(this);
        if (this.shootAnimationTick < 20) {
            ++this.shootAnimationTick;
        }
        Objects.requireNonNull(this);
        if (this.shootAnimationTick >= 20) {
            this.shootAnimationState.stop();
        }
        Objects.requireNonNull(this);
        if (this.thrownAnimationTick < 20) {
            ++this.thrownAnimationTick;
        }
        Objects.requireNonNull(this);
        if (this.thrownAnimationTick >= 20) {
            this.thrownAnimationState.stop();
        }
        if (this.isHolding(Items.BOW) && this.isAggressive()) {
            Objects.requireNonNull(this);
            if (this.shootAnimationTick >= 20) {
                if (this.chargeAnimationState.isStarted()) return;
                this.chargeAnimationState.start(this.tickCount);
                return;
            }
        }
        this.chargeAnimationState.stop();
    }

    public void handleEntityEvent(byte p_219360_) {
        if (p_219360_ == 4) {
            this.attackAnimationTick = 0;
            this.attackAnimationState.start(this.tickCount);
        } else if (p_219360_ == 61) {
            this.shootAnimationTick = 0;
            this.shootAnimationState.start(this.tickCount);
        } else if (p_219360_ == 62) {
            this.thrownAnimationTick = 0;
            this.thrownAnimationState.start(this.tickCount);
        } else {
            super.handleEntityEvent(p_219360_);
        }
    }

    public ItemStack eat(Level p_21067_, ItemStack p_21068_) {
        if (p_21068_.isEdible()) {
            this.heal(p_21068_.getItem().getFoodProperties().getNutrition());
        }
        return super.eat(p_21067_, p_21068_);
    }

    public void aiStep() {
        if (!this.level().isClientSide && this.isAlive()) {
            ItemStack mainhand = this.getItemInHand(InteractionHand.MAIN_HAND);
            if (!this.isUsingItem() && this.getOffhandItem().isEmpty() && (mainhand.getItem() == Items.BOW && this.getTarget() == null || mainhand.getItem() != Items.BOW)) {
                ItemStack stack = ItemStack.EMPTY;
                if (this.getHealth() < this.getMaxHealth() && this.random.nextFloat() < 0.005f) {
                    stack = this.findFood();
                } else if (this.getHealth() >= this.getMaxHealth() && this.random.nextFloat() < 0.01f) {
                    stack = this.findBoomerang();
                }
                if (!stack.isEmpty()) {
                    this.setItemSlot(EquipmentSlot.OFFHAND, stack);
                    if (stack.isEdible()) {
                        this.startUsingItem(InteractionHand.OFF_HAND);
                    }
                }
            }
        }
        super.aiStep();
    }

    private ItemStack findFood() {
        for (int i = 0; i < this.inventory.getContainerSize(); ++i) {
            ItemStack itemstack = this.inventory.getItem(i);
            if (itemstack.isEmpty() || itemstack.getItem().getFoodProperties() == null || !HunterConfigUtils.isWhitelistedItem(itemstack.getItem())) continue;
            return itemstack.split(1);
        }
        return ItemStack.EMPTY;
    }

    private ItemStack findBoomerang() {
        for (int i = 0; i < this.inventory.getContainerSize(); ++i) {
            ItemStack itemstack = this.inventory.getItem(i);
            if (itemstack.isEmpty() || !itemstack.is(HunterItems.BOOMERANG.get())) continue;
            return itemstack.split(1);
        }
        return ItemStack.EMPTY;
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.createMonsterAttributes().add(Attributes.MOVEMENT_SPEED, (double)0.3f).add(Attributes.FOLLOW_RANGE, 20.0).add(Attributes.MAX_HEALTH, 26.0).add(Attributes.ARMOR, 1.0).add(Attributes.ATTACK_DAMAGE, 3.0);
    }

    public void addAdditionalSaveData(CompoundTag p_213281_1_) {
        super.addAdditionalSaveData(p_213281_1_);
        if (this.homeTarget != null) {
            p_213281_1_.put("HomeTarget", (Tag)NbtUtils.writeBlockPos((BlockPos)this.homeTarget));
        }
        ListTag listnbt = new ListTag();
        for (int i = 0; i < this.inventory.getContainerSize(); ++i) {
            ItemStack itemstack = this.inventory.getItem(i);
            if (itemstack.isEmpty()) continue;
            listnbt.add((Object)itemstack.save(new CompoundTag()));
        }
        p_213281_1_.put("Inventory", (Tag)listnbt);
        p_213281_1_.putInt("HuntingCooldown", this.cooldown);
        p_213281_1_.putString("HunterType", this.getHunterType().name());
    }

    public void readAdditionalSaveData(CompoundTag p_70037_1_) {
        super.readAdditionalSaveData(p_70037_1_);
        if (p_70037_1_.contains("HomeTarget")) {
            this.homeTarget = NbtUtils.readBlockPos((CompoundTag)p_70037_1_.getCompound("HomeTarget"));
        }
        ListTag listnbt = p_70037_1_.getList("Inventory", 10);
        for (int i = 0; i < listnbt.size(); ++i) {
            ItemStack itemstack = ItemStack.of((CompoundTag)listnbt.getCompound(i));
            if (itemstack.isEmpty()) continue;
            this.inventory.addItem(itemstack);
        }
        this.cooldown = p_70037_1_.getInt("HuntingCooldown");
        this.setHunterType(HunterType.get(p_70037_1_.getString("HunterType")));
        this.setCanPickUpLoot(true);
    }

    public void applyRaidBuffs(int p_213660_1_, boolean p_213660_2_) {
        boolean flag;
        ItemStack offHandStack = new ItemStack((ItemLike)HunterItems.BOOMERANG.get());
        Raid raid = this.getCurrentRaid();
        int i = 1;
        if (p_213660_1_ > raid.getNumGroups(Difficulty.NORMAL)) {
            i = 2;
        }
        ItemStack itemstack = raid.getBadOmenLevel() < 2 || p_213660_1_ <= raid.getNumGroups(Difficulty.NORMAL) ? (this.random.nextBoolean() ? new ItemStack((ItemLike)Items.BOW) : new ItemStack((ItemLike)Items.STONE_SWORD)) : (this.random.nextBoolean() ? new ItemStack((ItemLike)Items.BOW) : new ItemStack((ItemLike)Items.IRON_SWORD));
        this.inventory.addItem(new ItemStack((ItemLike)Items.PORKCHOP, 5));
        boolean bl = flag = this.random.nextFloat() <= raid.getEnchantOdds();
        if (flag) {
            if (itemstack.getItem() == Items.BOW) {
                map = Maps.newHashMap();
                map.put(Enchantments.POWER_ARROWS, i);
                EnchantmentHelper.setEnchantments((Map)map, (ItemStack)itemstack);
            } else {
                map = Maps.newHashMap();
                map.put(Enchantments.SHARPNESS, i);
                EnchantmentHelper.setEnchantments((Map)map, (ItemStack)itemstack);
            }
            this.inventory.addItem(new ItemStack((ItemLike)Items.COOKED_BEEF, 2));
            HashMap map2 = Maps.newHashMap();
            map2.put(Enchantments.SHARPNESS, i);
            EnchantmentHelper.setEnchantments((Map)map2, (ItemStack)offHandStack);
        }
        if (this.random.nextFloat() < 0.25f && !itemstack.is(Items.BOW)) {
            HashMap map3 = Maps.newHashMap();
            map3.put(Enchantments.LOYALTY, i);
            EnchantmentHelper.setEnchantments((Map)map3, (ItemStack)offHandStack);
            this.setItemInHand(InteractionHand.OFF_HAND, offHandStack);
        }
        if (itemstack.is(Items.BOW) && raid.getBadOmenLevel() > 2 && this.random.nextFloat() < 0.25f) {
            this.setItemInHand(InteractionHand.OFF_HAND, this.createHorn());
        }
        if (this.random.nextFloat() < 0.25f) {
            this.setItemSlot(EquipmentSlot.HEAD, new ItemStack((ItemLike)Items.LEATHER_HELMET));
        }
        this.setItemInHand(InteractionHand.MAIN_HAND, itemstack);
    }

    protected void pickUpItem(ItemEntity p_175445_1_) {
        ItemStack itemstack = p_175445_1_.getItem();
        if (itemstack.getItem() instanceof BannerItem) {
            super.pickUpItem(p_175445_1_);
        } else {
            Item item = itemstack.getItem();
            if (this.wantsFood(itemstack)) {
                this.onItemPickup(p_175445_1_);
                this.take((Entity)p_175445_1_, itemstack.getCount());
                ItemStack itemstack1 = this.inventory.addItem(itemstack);
                if (itemstack1.isEmpty()) {
                    p_175445_1_.discard();
                } else {
                    itemstack.setCount(itemstack1.getCount());
                }
            } else if (item == HunterItems.BOOMERANG.get()) {
                this.onItemPickup(p_175445_1_);
                this.take((Entity)p_175445_1_, itemstack.getCount());
                ItemStack itemstack1 = this.inventory.addItem(itemstack);
                if (itemstack1.isEmpty()) {
                    p_175445_1_.discard();
                } else {
                    itemstack.setCount(itemstack1.getCount());
                }
            }
        }
    }

    private boolean wantsFood(ItemStack p_213672_1_) {
        return p_213672_1_.getItem().getFoodProperties() != null && HunterConfigUtils.isWhitelistedItem(p_213672_1_.getItem());
    }

    @Nullable
    public SpawnGroupData finalizeSpawn(ServerLevelAccessor p_37856_, DifficultyInstance p_37857_, MobSpawnType p_37858_, @Nullable SpawnGroupData p_37859_, @Nullable CompoundTag p_37860_) {
        RandomSource randomsource = p_37856_.getRandom();
        SpawnGroupData ilivingentitydata = super.finalizeSpawn(p_37856_, p_37857_, p_37858_, p_37859_, p_37860_);
        ((GroundPathNavigation)this.getNavigation()).setCanOpenDoors(true);
        this.setCanPickUpLoot(true);
        for (int i = 0; i < 2; ++i) {
            Item item;
            if (((List)HunterConfig.COMMON.foodInInventoryWhitelist.get()).isEmpty() || (item = (Item)BuiltInRegistries.ITEM.get(ResourceLocation.tryParse((String)((String)((List)HunterConfig.COMMON.foodInInventoryWhitelist.get()).get(this.random.nextInt(((List)HunterConfig.COMMON.foodInInventoryWhitelist.get()).size())))))) == Items.AIR) continue;
            this.inventory.addItem(new ItemStack((ItemLike)item, 2 + this.random.nextInt(3)));
        }
        if (((Biome)p_37856_.getBiome(this.blockPosition()).value()).coldEnoughToSnow(this.blockPosition())) {
            this.setHunterType(HunterType.COLD);
        }
        if (p_37858_ == MobSpawnType.STRUCTURE) {
            this.setHomeTarget(this.blockPosition());
        }
        this.populateDefaultEquipmentSlots(randomsource, p_37857_);
        this.populateDefaultEquipmentEnchantments(randomsource, p_37857_);
        return ilivingentitydata;
    }

    protected void dropEquipment() {
        super.dropEquipment();
        if (this.inventory != null) {
            for (int i = 0; i < this.inventory.getContainerSize(); ++i) {
                ItemStack itemstack = this.inventory.getItem(i);
                if (itemstack.isEmpty() || EnchantmentHelper.hasVanishingCurse((ItemStack)itemstack)) continue;
                this.spawnAtLocation(itemstack);
            }
        }
    }

    protected void populateDefaultEquipmentSlots(RandomSource p_217055_, DifficultyInstance p_217056_) {
        if (this.getCurrentRaid() == null) {
            if (this.getMainHandItem().isEmpty()) {
                if (this.random.nextFloat() < 0.1f) {
                    this.setItemSlot(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)Items.BOW));
                    this.setItemSlot(EquipmentSlot.OFFHAND, this.createHorn());
                } else {
                    this.setItemSlot(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)Items.WOODEN_SWORD));
                    if (this.random.nextBoolean()) {
                        ItemStack offHandStack = new ItemStack((ItemLike)HunterItems.BOOMERANG.get());
                        HashMap map3 = Maps.newHashMap();
                        map3.put(Enchantments.LOYALTY, 1);
                        EnchantmentHelper.setEnchantments((Map)map3, (ItemStack)offHandStack);
                        this.setItemInHand(InteractionHand.OFF_HAND, offHandStack);
                    }
                }
            }
            if (this.random.nextFloat() < 0.25f) {
                this.setItemSlot(EquipmentSlot.HEAD, new ItemStack((ItemLike)Items.LEATHER_HELMET));
            }
            if (this.random.nextFloat() < 0.25f) {
                this.setItemSlot(EquipmentSlot.CHEST, new ItemStack((ItemLike)Items.LEATHER_CHESTPLATE));
            }
        }
    }

    public ItemStack createHorn() {
        Optional holderset = BuiltInRegistries.INSTRUMENT.getHolder(Instruments.CALL_GOAT_HORN);
        if (holderset.isPresent()) {
            return InstrumentItem.create((Item)Items.GOAT_HORN, (Holder)((Holder)holderset.get()));
        }
        return ItemStack.EMPTY;
    }

    public boolean isAlliedTo(Entity p_184191_1_) {
        if (super.isAlliedTo(p_184191_1_)) {
            return true;
        }
        if (p_184191_1_ instanceof LivingEntity && ((LivingEntity)p_184191_1_).getMobType() == MobType.ILLAGER) {
            return this.getTeam() == null && p_184191_1_.getTeam() == null;
        }
        return false;
    }

    public SoundEvent getCelebrateSound() {
        return HunterSounds.HUNTER_ILLAGER_CHEER.get();
    }

    protected SoundEvent getAmbientSound() {
        return HunterSounds.HUNTER_ILLAGER_IDLE.get();
    }

    protected SoundEvent getDeathSound() {
        return HunterSounds.HUNTER_ILLAGER_DEATH.get();
    }

    protected SoundEvent getHurtSound(DamageSource p_184601_1_) {
        return HunterSounds.HUNTER_ILLAGER_HURT.get();
    }

    @OnlyIn(value=Dist.CLIENT)
    public AbstractIllager.IllagerArmPose getArmPose() {
        if (this.isAggressive()) {
            return this.isHolding(Items.BOW) || this.isHolding(HunterItems.BOOMERANG.get()) ? AbstractIllager.IllagerArmPose.BOW_AND_ARROW : AbstractIllager.IllagerArmPose.ATTACKING;
        }
        return this.isCelebrating() ? AbstractIllager.IllagerArmPose.CELEBRATING : AbstractIllager.IllagerArmPose.CROSSED;
    }

    public boolean killedEntity(ServerLevel p_216988_, LivingEntity p_216989_) {
        this.playSound(HunterSounds.HUNTER_ILLAGER_LAUGH.get(), this.getSoundVolume(), this.getVoicePitch());
        this.cooldown = 300;
        return super.killedEntity(p_216988_, p_216989_);
    }

    public void setHomeTarget(@Nullable BlockPos p_213726_1_) {
        this.homeTarget = p_213726_1_;
    }

    @Nullable
    private BlockPos getHomeTarget() {
        return this.homeTarget;
    }

    public void performRangedAttack(LivingEntity p_32141_, float p_32142_) {
        ItemStack itemstack = this.getProjectile(this.getItemInHand(ProjectileUtil.getWeaponHoldingHand((LivingEntity)this, item -> item instanceof BowItem)));
        AbstractArrow abstractarrow = this.getArrow(itemstack, p_32142_);
        double d0 = p_32141_.getX() - this.getX();
        double d1 = p_32141_.getY(0.3333333333333333) - abstractarrow.getY();
        double d2 = p_32141_.getZ() - this.getZ();
        double d3 = Math.sqrt(d0 * d0 + d2 * d2);
        abstractarrow.shoot(d0, d1 + d3 * (double)0.2f, d2, 1.6f, (float)(14 - this.level().getDifficulty().getId() * 4));
        this.playSound(SoundEvents.SKELETON_SHOOT, 1.0f, 1.0f / (this.getRandom().nextFloat() * 0.4f + 0.8f));
        this.level().addFreshEntity((Entity)abstractarrow);
        this.level().broadcastEntityEvent((Entity)this, (byte)61);
    }

    protected AbstractArrow getArrow(ItemStack p_32156_, float p_32157_) {
        return ProjectileUtil.getMobArrow((LivingEntity)this, (ItemStack)p_32156_, (float)p_32157_);
    }

    public void performBoomerangAttack(LivingEntity p_82196_1_) {
        BoomerangEntity boomerang = new BoomerangEntity(this.level(), (LivingEntity)this, this.getOffhandItem().split(1));
        double d0 = p_82196_1_.getX() - this.getX();
        double d1 = p_82196_1_.getY(0.3333333333333333) - boomerang.getY();
        double d2 = p_82196_1_.getZ() - this.getZ();
        double d3 = Mth.sqrt((float)((float)(d0 * d0 + d2 * d2)));
        boomerang.shoot(d0, d1 + d3 * (double)0.2f, d2, 1.6f, 14 - this.level().getDifficulty().getId() * 4);
        this.playSound(SoundEvents.SKELETON_SHOOT, 1.0f, 1.0f / (this.getRandom().nextFloat() * 0.4f + 0.8f));
        this.level().addFreshEntity((Entity)boomerang);
        this.level().broadcastEntityEvent((Entity)this, (byte)62);
    }

    public static enum HunterType implements IExtensibleEnum
    {
        NORMAL,
        COLD;


        public static HunterType get(String nameIn) {
            for (HunterType role : HunterType.values()) {
                if (!role.name().equals(nameIn)) continue;
                return role;
            }
            return NORMAL;
        }

        public static HunterType create(String name) {
            throw new IllegalStateException("Enum not extended");
        }
    }

    public static class GetFoodGoal<T extends Hunter>
    extends Goal {
        private final T mob;
        final /* synthetic */ Hunter this$0;

        public GetFoodGoal(T p_i50572_2_) {
            this.this$0 = this$0;
            this.mob = p_i50572_2_;
            this.setFlags(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean canUse() {
            if (!this.mob.hasActiveRaid()) {
                List list = this.mob.level().getEntitiesOfClass(ItemEntity.class, this.mob.getBoundingBox().inflate(16.0, 8.0, 16.0), ALLOWED_ITEMS);
                if (!list.isEmpty() && this.mob.hasLineOfSight((Entity)list.get(0))) {
                    return this.mob.getNavigation().moveTo((Entity)list.get(0), (double)1.1f);
                }
                return false;
            }
            return false;
        }

        public void tick() {
            List list;
            if (this.mob.getNavigation().getTargetPos().closerThan((Vec3i)this.mob.blockPosition(), 1.414) && !(list = this.mob.level().getEntitiesOfClass(ItemEntity.class, this.mob.getBoundingBox().inflate(4.0, 4.0, 4.0), ALLOWED_ITEMS)).isEmpty()) {
                ((Hunter)((Object)this.mob)).pickUpItem((ItemEntity)list.get(0));
            }
        }
    }

    class MoveToGoal
    extends Goal {
        final Hunter hunter;
        final double stopDistance;
        final double speedModifier;

        MoveToGoal(Hunter p_i50459_2_, double p_i50459_3_, double p_i50459_5_) {
            this.hunter = p_i50459_2_;
            this.stopDistance = p_i50459_3_;
            this.speedModifier = p_i50459_5_;
            this.setFlags(EnumSet.of(Goal.Flag.MOVE));
        }

        public void stop() {
            Hunter.this.navigation.stop();
        }

        public boolean canUse() {
            BlockPos blockpos = this.hunter.getHomeTarget();
            double distance = this.hunter.level().isDay() ? this.stopDistance : this.stopDistance / 1.5;
            return blockpos != null && this.isTooFarAway(blockpos, distance);
        }

        public void tick() {
            BlockPos blockpos = this.hunter.getHomeTarget();
            if (blockpos != null && Hunter.this.navigation.isDone()) {
                if (this.isTooFarAway(blockpos, 10.0)) {
                    Vec3 vector3d = new Vec3((double)blockpos.getX() - this.hunter.getX(), (double)blockpos.getY() - this.hunter.getY(), (double)blockpos.getZ() - this.hunter.getZ()).normalize();
                    Vec3 vector3d1 = vector3d.scale(10.0).add(this.hunter.getX(), this.hunter.getY(), this.hunter.getZ());
                    Hunter.this.navigation.moveTo(vector3d1.x, vector3d1.y, vector3d1.z, this.speedModifier);
                } else {
                    Hunter.this.navigation.moveTo((double)blockpos.getX(), (double)blockpos.getY(), (double)blockpos.getZ(), this.speedModifier);
                }
            }
        }

        private boolean isTooFarAway(BlockPos p_220846_1_, double p_220846_2_) {
            return !p_220846_1_.closerThan((Vec3i)this.hunter.blockPosition(), p_220846_2_);
        }
    }
}

